/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.showcommands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;

@DTFJPlugin(version=".*", runtime=false)
public class ShowLoggingCommand
extends BaseJdmpviewCommand {
    public ShowLoggingCommand() {
        this.addCommand("show logging", "", "shows the current logging options");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length > 0) {
            out.print("\"show logging\" does not take any parameters, ignoring ");
            for (String arg : args) {
                out.print(arg + " ");
            }
            out.print("\n");
        }
        this.doCommand();
    }

    public void doCommand() {
        this.out.print("Logging is currently turned ");
        String value = (String)this.ctx.getProperties().get("set_logging");
        if (value == null) {
            this.out.println("off");
        } else {
            this.out.println(value);
        }
        value = (String)this.ctx.getProperties().get("current_logging_file");
        if (value == null) {
            this.out.println("Log file is not set");
        } else {
            this.out.println("Log file set to " + value);
        }
        this.out.print("Overwrite is currently turned ");
        value = (String)this.ctx.getProperties().get("set_logging_overwrite");
        if (value == null) {
            this.out.println("off");
        } else {
            this.out.println(value);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("displays the current values of logging settings\n\nparameters: none\n");
    }
}

