/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.AbstractCertificateRequestStore;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadFileTypeException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadMagicNumberException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadRecordFlagException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadVersionNumberException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.Buffer;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BufferFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeader;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeaderFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeaderHashGeneratorFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileType;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequence;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequenceFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.MagicNumberValidatorFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.QueryableRequestDatabase;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.QueryableRequestDatabaseFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RecordFlag;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabase;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabaseFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabaseHashGeneratorFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecord;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordDataHashGenerator;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordDataHashGeneratorFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordEncoding;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordEncodingFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.VersionNumber;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.FileModificationTracker;
import com.ibm.gsk.ikeyman.io.LockedFileOutputStream;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.sequence.Sequence;
import com.ibm.gsk.ikeyman.sequence.SequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceIterator;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.FilePermissions;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcsutil.PKCSException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CMSCertificateRequestFile
extends AbstractCertificateRequestStore {
    private static final IntableByteSequence ZERO = IntableByteSequenceFactory.newIntableByteSequence(ByteSequenceFactory.newConstantByteSequence((byte)0, 4));
    private static final IntableByteSequence ZERO_MD5_HASH = IntableByteSequenceFactory.newIntableByteSequence(ByteSequenceFactory.newConstantByteSequence((byte)0, 16));
    private static final int FIXED_RECORD_LENGTH = 5000;
    private static final IntableByteSequence FIXED_RECORD_LENGTH_SEQUENCE = IntableByteSequenceFactory.newIntableByteSequence(5000);
    private static final ByteSequence UNUSED_FILE_LABEL = ByteSequenceFactory.newConstantByteSequence((byte)0, 24);
    public static final String EXTENSION = ".rdb";
    private final File file;
    private QueryableRequestDatabase requestDatabase;
    private String storePassword;
    private List aliases;
    private final FileModificationTracker tracker;

    protected CMSCertificateRequestFile(File file, String string) throws KeyManagerException {
        this.file = file;
        this.storePassword = string;
        this.tracker = new FileModificationTracker(file.getAbsolutePath());
        this.load();
    }

    protected CMSCertificateRequestFile(File file, String string, QueryableRequestDatabase queryableRequestDatabase) throws KeyManagerException {
        this.file = file;
        this.storePassword = string;
        this.tracker = new FileModificationTracker(file.getAbsolutePath());
        this.requestDatabase = queryableRequestDatabase;
        this.rebuildAliasesList();
    }

    private void load() throws KeyManagerException {
        FileInputStream fileInputStream;
        this.tracker.loaded();
        try {
            fileInputStream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.aliases = new ArrayList();
            return;
        }
        try {
            this.requestDatabase = QueryableRequestDatabaseFactory.newQueryableRequestDatabase(RequestDatabaseFactory.newRequestDatabase(fileInputStream));
            fileInputStream.close();
            this.rebuildAliasesList();
        }
        catch (BadMagicNumberException badMagicNumberException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_REQUEST_FILE, badMagicNumberException, new String[]{"Bad Magic Number"});
        }
        catch (BadVersionNumberException badVersionNumberException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_REQUEST_FILE, badVersionNumberException, new String[]{"Bad Version Number"});
        }
        catch (BadFileTypeException badFileTypeException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_REQUEST_FILE, badFileTypeException, new String[]{"Bad File Type"});
        }
        catch (BadRecordFlagException badRecordFlagException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_REQUEST_FILE, badRecordFlagException, new String[]{"Bad Record Flag"});
        }
        catch (NullPointerException nullPointerException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NULL_POINTER, (Throwable)nullPointerException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
    }

    private void rebuildAliasesList() throws KeyManagerException {
        if (this.requestDatabase == null) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.RDB_UNINITIALISED, new String[0]);
        }
        try {
            this.aliases = new ArrayList();
            Sequence sequence = this.requestDatabase.getRecords();
            for (RequestRecord requestRecord : sequence) {
                Buffer buffer = requestRecord.getLabel();
                byte[] byArray = new byte[buffer.getHeader().toInt()];
                buffer.getContent().getInputStream().read(byArray);
                this.aliases.add(new String(byArray, "UTF-8"));
            }
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
    }

    public List getItems() throws KeyManagerException {
        ArrayList<CertificateRequestKeyItem> arrayList = new ArrayList<CertificateRequestKeyItem>();
        for (String string : this.aliases) {
            arrayList.add(this.getItem(string));
        }
        return arrayList;
    }

    public CertificateRequestKeyItem getItem(String string) throws KeyManagerException {
        if (this.contains(string)) {
            RequestRecord requestRecord = this.requestDatabase.getRecordByLabel(string);
            return CMSCertificateRequestFile.getCertRequest(string, requestRecord, this.storePassword);
        }
        throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_REQUEST_FOR_LABEL, new String[]{string});
    }

    public void delete(String string) throws KeyManagerException {
        if (!this.contains(string)) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_REQUEST_FOR_LABEL, new String[]{string});
        }
        RequestRecord requestRecord = this.requestDatabase.getRecordByLabel(string);
        Sequence sequence = this.requestDatabase.getRecords();
        int n = sequence.indexOf(requestRecord);
        ByteSequence byteSequence = null;
        try {
            Sequence sequence2 = sequence.getSubSequence(0, n).append(sequence.getSubSequence(n + 1, sequence.length()));
            byteSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(this.requestDatabase.getHeader().getMajorVersionNumber()).append(this.requestDatabase.getHeader().getMinorVersionNumber()).append(ZERO).append(FileType.X509KYP).append(FIXED_RECORD_LENGTH_SEQUENCE).append(IntableByteSequenceFactory.newIntableByteSequence(sequence2.length())).append(UNUSED_FILE_LABEL).append(this.requestDatabase.getHeader().getPasswordHeaderHash()).append(this.requestDatabase.getHeader().getPasswordDatabaseHash());
            for (RequestRecord requestRecord2 : sequence2) {
                byteSequence = byteSequence.append(requestRecord2);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NULL_POINTER, (Throwable)nullPointerException);
        }
        try {
            this.requestDatabase = QueryableRequestDatabaseFactory.newQueryableRequestDatabase(RequestDatabaseFactory.newRequestDatabase(byteSequence.getInputStream()));
            this.updateHeaderHashes();
        }
        catch (BadMagicNumberException badMagicNumberException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_REQUEST_FILE, badMagicNumberException, new String[]{"Bad Magic Number"});
        }
        catch (BadVersionNumberException badVersionNumberException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_REQUEST_FILE, badVersionNumberException, new String[]{"Bad Version Number"});
        }
        catch (BadFileTypeException badFileTypeException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_REQUEST_FILE, badFileTypeException, new String[]{"Bad File Type"});
        }
        catch (BadRecordFlagException badRecordFlagException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_REQUEST_FILE, badRecordFlagException, new String[]{"Bad Record Flag"});
        }
        catch (NullPointerException nullPointerException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NULL_POINTER, (Throwable)nullPointerException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        this.rebuildAliasesList();
    }

    private static CertificateRequestKeyItem getCertRequest(String string, RequestRecord requestRecord, String string2) throws KeyManagerException {
        try {
            RequestRecordEncoding requestRecordEncoding = requestRecord.getEncoding();
            CertificationRequest certificationRequest = requestRecordEncoding.getCertificationRequest();
            PrivateKey privateKey = requestRecordEncoding.getPrivateKey(string2.toCharArray());
            return EntryFactory.loadCertificateRequestItem(string, certificationRequest, privateKey);
        }
        catch (Exception exception) {
            Debug.throwing(exception);
            return EntryFactory.newUnloadableCertificateRequestItem(string);
        }
    }

    public void save() throws KeyManagerException {
        try {
            boolean bl = this.file.exists();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new LockedFileOutputStream(this.file));
            ByteSequenceIterator byteSequenceIterator = this.requestDatabase.getIterator();
            while (byteSequenceIterator.hasNextByte()) {
                bufferedOutputStream.write(byteSequenceIterator.getNextByte());
            }
            if (!bl) {
                FilePermissions.setFilePermissions(this.file);
            }
            bufferedOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_FILE_CREATION_ERROR, fileNotFoundException, new String[]{this.file.getAbsolutePath()});
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("ByteSequenceIterator.getNextByte() threw invalid exception.", noSuchElementException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_STREAM_WRITE_ERROR, iOException, new String[]{this.file.getAbsolutePath()});
        }
    }

    public void add(CertificateRequestKeyItem certificateRequestKeyItem) throws KeyManagerException {
        try {
            int n = this.requestDatabase.getNextRecordID();
            CertificationRequest certificationRequest = certificateRequestKeyItem.getRequest();
            String string = certificateRequestKeyItem.getLabel();
            PrivateKey privateKey = certificateRequestKeyItem.getPrivateKey();
            RequestRecordDataHashGenerator requestRecordDataHashGenerator = RequestRecordDataHashGeneratorFactory.newRequestRecordDataHashGenerator();
            ByteSequence byteSequence = IntableByteSequenceFactory.newIntableByteSequence(string.length()).append(ByteSequenceFactory.newByteSequence(string.getBytes("UTF-8")));
            ArrayList<RequestRecord> arrayList = new ArrayList<RequestRecord>(1);
            ByteSequence byteSequence2 = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(n)).append(RequestRecordEncodingFactory.newRequestRecordEncoding(n, certificationRequest, privateKey, this.storePassword.toCharArray(), string)).append(BufferFactory.newBuffer(byteSequence.getInputStream())).append(requestRecordDataHashGenerator.generateSubjectPublicKeyInfoHash(certificationRequest));
            arrayList.add(RequestRecordFactory.newRequestRecord(byteSequence2.getInputStream(), 5000));
            Sequence sequence = SequenceFactory.newSequence(arrayList);
            Sequence sequence2 = this.requestDatabase.getRecords().append(sequence);
            ByteSequence byteSequence3 = MagicNumberValidatorFactory.MAGIC_NUMBER.append(this.requestDatabase.getHeader().getMajorVersionNumber()).append(this.requestDatabase.getHeader().getMinorVersionNumber()).append(ZERO).append(FileType.X509KYP).append(FIXED_RECORD_LENGTH_SEQUENCE).append(IntableByteSequenceFactory.newIntableByteSequence(sequence2.length())).append(UNUSED_FILE_LABEL).append(this.requestDatabase.getHeader().getPasswordHeaderHash()).append(this.requestDatabase.getHeader().getPasswordDatabaseHash());
            for (RequestRecord requestRecord : sequence2) {
                byteSequence3 = byteSequence3.append(requestRecord);
            }
            this.requestDatabase = QueryableRequestDatabaseFactory.newQueryableRequestDatabase(RequestDatabaseFactory.newRequestDatabase(byteSequence3.getInputStream()));
            this.updateHeaderHashes();
            this.rebuildAliasesList();
        }
        catch (NullPointerException nullPointerException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NULL_POINTER, (Throwable)nullPointerException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.UNSUPPORTED_ENCODING, (Throwable)unsupportedEncodingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.PUBLIC_KEY_COPY_ERROR, (Throwable)invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
        catch (PKCSException pKCSException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.PRIVATE_KEY_ENCRYPTION_ERROR, pKCSException, new String[]{certificateRequestKeyItem.getLabel()});
        }
    }

    private void updateHeaderHashes() throws NoSuchAlgorithmException, IOException {
        ByteSequence byteSequence5;
        ByteSequence byteSequence2;
        FileHeader fileHeader = this.requestDatabase.getHeader();
        ByteSequence byteSequence3 = FileHeaderHashGeneratorFactory.newFileHeaderHashGenerator(fileHeader).generateHash(fileHeader, this.storePassword);
        ByteSequence byteSequence4 = byteSequence2 = fileHeader.getSubSequence(0, fileHeader.length() - 2 * fileHeader.getPasswordHeaderHash().length()).append(byteSequence3).append(fileHeader.getPasswordDatabaseHash());
        for (ByteSequence byteSequence5 : this.requestDatabase.getRecords()) {
            byteSequence4 = byteSequence4.append(byteSequence5);
        }
        RequestDatabase requestDatabase = RequestDatabaseFactory.newRequestDatabase(byteSequence4.getInputStream());
        byteSequence5 = RequestDatabaseHashGeneratorFactory.newRequestDatabaseHashGenerator(fileHeader).generateHash(requestDatabase, this.storePassword);
        fileHeader = requestDatabase.getHeader();
        byteSequence4 = byteSequence2 = fileHeader.getSubSequence(0, fileHeader.length() - fileHeader.getPasswordDatabaseHash().length()).append(byteSequence5);
        for (RequestRecord requestRecord : requestDatabase.getRecords()) {
            byteSequence4 = byteSequence4.append(requestRecord);
        }
        this.requestDatabase = QueryableRequestDatabaseFactory.newQueryableRequestDatabase(RequestDatabaseFactory.newRequestDatabase(byteSequence4.getInputStream()));
    }

    public static CMSCertificateRequestFile loadRequestFile(FileName fileName, String string) throws KeyManagerException {
        File file = new File(fileName.changeExtension(EXTENSION).toString());
        if (!file.exists()) {
            return CMSCertificateRequestFile.createRequestFile(fileName, string);
        }
        return new CMSCertificateRequestFile(file, string);
    }

    public static CMSCertificateRequestFile createRequestFile(FileName fileName, String string) throws KeyManagerException {
        try {
            File file = new File(fileName.changeExtension(EXTENSION).toString());
            ByteSequence byteSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(VersionNumber.THREE).append(VersionNumber.ONE).append(ZERO).append(FileType.X509KYP).append(FIXED_RECORD_LENGTH_SEQUENCE).append(IntableByteSequenceFactory.newIntableByteSequence(0)).append(UNUSED_FILE_LABEL).append(ZERO_MD5_HASH).append(ZERO_MD5_HASH);
            FileHeader fileHeader = FileHeaderFactory.newFileHeader(byteSequence.getInputStream());
            ByteSequence byteSequence2 = FileHeaderHashGeneratorFactory.newFileHeaderHashGenerator(fileHeader).generateHash(fileHeader, string);
            ByteSequence byteSequence3 = byteSequence = byteSequence.getSubSequence(0, byteSequence.length() - 2 * ZERO_MD5_HASH.length()).append(byteSequence2).append(ZERO_MD5_HASH);
            RequestDatabase requestDatabase = RequestDatabaseFactory.newRequestDatabase(byteSequence3.getInputStream());
            ByteSequence byteSequence4 = RequestDatabaseHashGeneratorFactory.newRequestDatabaseHashGenerator(fileHeader).generateHash(requestDatabase, string);
            byteSequence3 = byteSequence = byteSequence.getSubSequence(0, byteSequence.length() - ZERO_MD5_HASH.length()).append(byteSequence4);
            QueryableRequestDatabase queryableRequestDatabase = QueryableRequestDatabaseFactory.newQueryableRequestDatabase(RequestDatabaseFactory.newRequestDatabase(byteSequence3.getInputStream()));
            return new CMSCertificateRequestFile(file, string, queryableRequestDatabase);
        }
        catch (BadMagicNumberException badMagicNumberException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_REQUEST_FILE, badMagicNumberException, new String[]{"Bad Magic Number"});
        }
        catch (BadVersionNumberException badVersionNumberException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_REQUEST_FILE, badVersionNumberException, new String[]{"Bad Version Number"});
        }
        catch (BadFileTypeException badFileTypeException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_REQUEST_FILE, badFileTypeException, new String[]{"Bad File Type"});
        }
        catch (BadRecordFlagException badRecordFlagException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_REQUEST_FILE, badRecordFlagException, new String[]{"Bad Record Flag"});
        }
        catch (NullPointerException nullPointerException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NULL_POINTER, (Throwable)nullPointerException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
    }

    public void delete() throws KeyManagerException {
        if (this.file.exists() && !this.file.delete()) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.FILE_DELETION_FAILED, new String[]{this.file.getAbsolutePath()});
        }
    }

    public List getAliases() {
        return this.aliases;
    }

    public void changePassword(CommandParameters commandParameters) throws KeyManagerException {
        String string;
        if (commandParameters.isParameterPresent(Constants$Parameter.NewPassword) && !this.storePassword.equals(string = commandParameters.getNewPassword())) {
            try {
                this.updateEncryptedRecords(this.storePassword.toCharArray(), string.toCharArray());
                this.storePassword = string;
                this.updateHeaderHashes();
            }
            catch (Exception exception) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.RDB_PASSWORD_CHANGE_ERROR, (Throwable)exception);
            }
        }
    }

    public void addAllMissingSigners(CommandParameters commandParameters) throws KeyManagerException {
    }

    private void updateEncryptedRecords(char[] cArray, char[] cArray2) throws IOException, PKCSException, CertificateEncodingException, CertificateException, NoSuchAlgorithmException {
        Object object;
        Sequence sequence = this.requestDatabase.getRecords();
        HashMap<Integer, RequestRecord> hashMap = new HashMap<Integer, RequestRecord>(sequence.length());
        for (Object object2 : sequence) {
            ByteSequence byteSequence = object2.getLabel();
            object = new byte[byteSequence.getHeader().toInt()];
            byteSequence.getContent().getInputStream().read((byte[])object);
            String string = new String((byte[])object, "UTF-8");
            RequestRecordEncoding requestRecordEncoding = object2.getEncoding();
            RequestRecordEncoding requestRecordEncoding2 = RequestRecordEncodingFactory.newRequestRecordEncoding(object2.getRecordId().toInt(), requestRecordEncoding.getCertificationRequest(), requestRecordEncoding.getPrivateKey(cArray), cArray2, string);
            ByteSequence byteSequence2 = object2.getRecordFlag().append(object2.getRecordId()).append(requestRecordEncoding2).append(object2.getLabel()).append(ZERO).append(object2.getSubjectPublicKeyInfoHash());
            hashMap.put(object2.getRecordId().toInt(), RequestRecordFactory.newRequestRecord(byteSequence2.getInputStream(), 5000));
        }
        Object object3 = this.requestDatabase.getHeader();
        for (ByteSequence byteSequence : this.requestDatabase.getRecords()) {
            object = (RequestRecord)hashMap.get(byteSequence.getRecordId().toInt());
            if (object != null) {
                object3 = object3.append((ByteSequence)object);
                continue;
            }
            object3 = object3.append(byteSequence);
        }
        this.requestDatabase = QueryableRequestDatabaseFactory.newQueryableRequestDatabase(RequestDatabaseFactory.newRequestDatabase(object3.getInputStream()));
    }

    public void refresh() throws KeyManagerException {
        this.load();
    }

    public boolean needsRefresh() {
        return this.tracker.needsRefresh();
    }

    public Collection getItems() throws KeyManagerException {
        return this.getItems();
    }

    public void add(Entry entry) throws KeyManagerException {
        this.add((CertificateRequestKeyItem)entry);
    }

    public Collection getAliases() {
        return this.getAliases();
    }

    public Entry getItem(String string) throws KeyManagerException {
        return this.getItem(string);
    }
}

