/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants$Actions;
import com.ibm.gsk.ikeyman.gui.GUIConstants$DialogMode;
import com.ibm.gsk.ikeyman.gui.GUIConstants$DialogResult;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicCheckbox;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicLabel;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;

public final class PasswordPromptDialog
extends CenteredDialog
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel passwordFieldPanel = null;
    private MnemonicLabel passwordLabel = null;
    private MnemonicLabel confirmPasswordLabel = null;
    private JPasswordField passwordField = null;
    private JPasswordField confirmPasswordField = null;
    private String password = null;
    private GUIConstants$DialogMode mode = null;
    private String prompt;
    private String fileName = null;
    private OKResetCancelButtonPanel buttonPanel = null;
    private JSeparator jSeparator = null;
    private JLabel fileNameLbl = null;
    private JPanel cmsOptionsPanel = null;
    private MnemonicCheckbox expirationTimeCheckbox = null;
    private MnemonicCheckbox stashPasswordCheckbox = null;
    private JFormattedTextField expirationTimeField = null;
    private MnemonicLabel daysLabel = null;
    private Constants$DatabaseType type;

    protected PasswordPromptDialog(Frame frame, Constants$DatabaseType constants$DatabaseType) {
        this(frame, constants$DatabaseType, GUIConstants$DialogMode.New);
    }

    protected PasswordPromptDialog(Frame frame, Constants$DatabaseType constants$DatabaseType, GUIConstants$DialogMode gUIConstants$DialogMode) {
        this(frame, constants$DatabaseType, gUIConstants$DialogMode, null);
    }

    public PasswordPromptDialog(Frame frame, Constants$DatabaseType constants$DatabaseType, GUIConstants$DialogMode gUIConstants$DialogMode, String string) {
        this(frame, constants$DatabaseType, gUIConstants$DialogMode, string, Messages.getStringWithMnemonics("Label.Password"));
    }

    public PasswordPromptDialog(Frame frame, Constants$DatabaseType constants$DatabaseType, GUIConstants$DialogMode gUIConstants$DialogMode, String string, String string2) {
        super(frame);
        this.type = constants$DatabaseType;
        this.mode = gUIConstants$DialogMode;
        this.prompt = string2;
        this.fileName = string;
        this.initialize();
    }

    private void initialize() {
        this.setSize(393, 313);
        this.setResizable(false);
        this.setModal(true);
        this.setTitle(Messages.getString("GUI.Title.Password"));
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.getButtonPanel().getOkBtn());
        this.pack();
        this.setName(ControlNames.PasswordPromptDialog.toString());
        this.centerToParent();
    }

    private ParameterMap getParameters(Constants$Parameter constants$Parameter) throws KeyManagerException {
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.put(constants$Parameter, this.password);
        if (this.expirationTimeCheckbox != null) {
            if (this.expirationTimeCheckbox.isSelected()) {
                try {
                    parameterMap.put(Constants$Parameter.Expire, this.expirationTimeField.getText());
                }
                catch (KeyManagerException keyManagerException) {
                    if (keyManagerException.getReason() == KeyManagerException$ExceptionReason.INVALID_NUMBER_FORMAT) {
                        keyManagerException.addDetail(Messages.getString("Message.PasswordExpiryTime"));
                    }
                    throw keyManagerException;
                }
            } else {
                parameterMap.put(Constants$Parameter.Expire, 0);
            }
        }
        if (this.stashPasswordCheckbox != null && this.stashPasswordCheckbox.isSelected()) {
            parameterMap.put(Constants$Parameter.StashPassword, true);
        }
        return parameterMap;
    }

    public static ParameterMap getPasswordData(Frame frame, Constants$DatabaseType constants$DatabaseType, Constants$Parameter constants$Parameter, GUIConstants$DialogMode gUIConstants$DialogMode) throws KeyManagerException, CancelledException {
        PasswordPromptDialog passwordPromptDialog = new PasswordPromptDialog(frame, constants$DatabaseType, gUIConstants$DialogMode);
        passwordPromptDialog.setVisible(true);
        return PasswordPromptDialog.getMap(passwordPromptDialog, constants$Parameter);
    }

    public static ParameterMap getPasswordData(Frame frame, Constants$DatabaseType constants$DatabaseType, Constants$Parameter constants$Parameter, GUIConstants$DialogMode gUIConstants$DialogMode, String string) throws KeyManagerException, CancelledException {
        PasswordPromptDialog passwordPromptDialog = new PasswordPromptDialog(frame, constants$DatabaseType, gUIConstants$DialogMode, string);
        passwordPromptDialog.setVisible(true);
        return PasswordPromptDialog.getMap(passwordPromptDialog, constants$Parameter);
    }

    public static ParameterMap getTargetPasswordData(Frame frame, Constants$DatabaseType constants$DatabaseType, Constants$Parameter constants$Parameter, GUIConstants$DialogMode gUIConstants$DialogMode) throws KeyManagerException, CancelledException {
        String string = gUIConstants$DialogMode == GUIConstants$DialogMode.New ? Messages.getStringWithMnemonics("Label.TargetPasswordNew") : Messages.getStringWithMnemonics("Label.TargetPasswordOpen");
        PasswordPromptDialog passwordPromptDialog = new PasswordPromptDialog(frame, constants$DatabaseType, gUIConstants$DialogMode, null, string);
        passwordPromptDialog.setVisible(true);
        return PasswordPromptDialog.getMap(passwordPromptDialog, constants$Parameter);
    }

    public static ParameterMap getSourcePasswordData(Frame frame, Constants$DatabaseType constants$DatabaseType, Constants$Parameter constants$Parameter, GUIConstants$DialogMode gUIConstants$DialogMode) throws KeyManagerException, CancelledException {
        PasswordPromptDialog passwordPromptDialog = new PasswordPromptDialog(frame, constants$DatabaseType, gUIConstants$DialogMode, null, Messages.getStringWithMnemonics("Label.SourcePassword"));
        passwordPromptDialog.setVisible(true);
        return PasswordPromptDialog.getMap(passwordPromptDialog, constants$Parameter);
    }

    private static ParameterMap getMap(PasswordPromptDialog passwordPromptDialog, Constants$Parameter constants$Parameter) throws KeyManagerException, CancelledException {
        try {
            if (passwordPromptDialog.getDialogResult() == GUIConstants$DialogResult.OK) {
                ParameterMap parameterMap = passwordPromptDialog.getParameters(constants$Parameter);
                return parameterMap;
            }
            throw new CancelledException();
        }
        finally {
            passwordPromptDialog.dispose();
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(10, 10, 10, 30);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 4;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(10, 0, 10, 0);
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 5;
            gridBagConstraints3.insets = new Insets(0, 0, 5, 0);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.ipadx = 197;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPasswordFieldPanel(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getJSeparator(), gridBagConstraints2);
            if (this.fileName != null) {
                GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
                gridBagConstraints5.gridy = 0;
                gridBagConstraints5.insets = new Insets(10, 5, 10, 5);
                gridBagConstraints5.gridx = 0;
                this.fileNameLbl = new JLabel();
                this.fileNameLbl.setText(Messages.getString("Label.FileName") + " " + this.fileName);
                this.jContentPane.add((Component)this.fileNameLbl, gridBagConstraints5);
            }
            if (this.mode == GUIConstants$DialogMode.New) {
                if (this.type.supportsPasswordOptions()) {
                    this.jContentPane.add((Component)this.getCmsOptionsPanel(false), gridBagConstraints);
                } else if (this.type.supportsPkcs12PasswordOptions()) {
                    this.jContentPane.add((Component)this.getCmsOptionsPanel(true), gridBagConstraints);
                }
            }
        }
        return this.jContentPane;
    }

    private JPanel getPasswordFieldPanel() {
        if (this.passwordFieldPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints.ipadx = 25;
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints2.ipadx = 25;
            gridBagConstraints2.anchor = 10;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridx = 0;
            this.confirmPasswordLabel = new MnemonicLabel();
            this.confirmPasswordLabel.setText(Messages.getStringWithMnemonics("Label.ConfirmPassword"));
            this.confirmPasswordLabel.setName(ControlNames.PasswordPromptDialogConfirmPasswordLabel.toString());
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints4.gridx = 0;
            this.passwordLabel = new MnemonicLabel();
            this.passwordLabel.setText(this.prompt);
            this.passwordLabel.setName(ControlNames.PasswordPromptDialogPasswordLabel.toString());
            this.passwordFieldPanel = new JPanel();
            this.passwordFieldPanel.setLayout(new GridBagLayout());
            this.passwordFieldPanel.add((Component)this.passwordLabel, gridBagConstraints4);
            this.passwordFieldPanel.add((Component)this.getPasswordField(), gridBagConstraints2);
            if (this.mode == GUIConstants$DialogMode.New) {
                this.passwordFieldPanel.add((Component)this.confirmPasswordLabel, gridBagConstraints3);
                this.passwordFieldPanel.add((Component)this.getConfirmPasswordField(), gridBagConstraints);
                this.confirmPasswordLabel.setLabelFor(this.getConfirmPasswordField());
            }
            this.passwordLabel.setLabelFor(this.getPasswordField());
        }
        return this.passwordFieldPanel;
    }

    private JPasswordField getPasswordField() {
        if (this.passwordField == null) {
            this.passwordField = new JPasswordField();
            this.passwordField.setToolTipText(Messages.getString("Tooltip.Password"));
            this.passwordField.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(this.prompt));
            this.passwordField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.Password"));
            this.passwordField.setName(ControlNames.PasswordPromptDialogPasswordField.toString());
        }
        return this.passwordField;
    }

    private JPasswordField getConfirmPasswordField() {
        if (this.confirmPasswordField == null) {
            this.confirmPasswordField = new JPasswordField();
            this.confirmPasswordField.setToolTipText(Messages.getString("Tooltip.PasswordConfirm"));
            this.confirmPasswordField.getAccessibleContext().setAccessibleName(Messages.getString("Label.ConfirmPassword"));
            this.confirmPasswordField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.PasswordConfirm"));
            this.confirmPasswordField.setName(ControlNames.PasswordPromptDialogConfirmPasswordField.toString());
        }
        return this.confirmPasswordField;
    }

    private boolean validateInput() {
        String string = new String(this.passwordField.getPassword());
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(this.getOwner(), Messages.getString("Message.EmptyPassword"), Messages.getString("GUI.Title.PasswordValidation"), 0);
            this.resetHandler();
            return false;
        }
        if (this.mode == GUIConstants$DialogMode.New) {
            String string2 = new String(this.confirmPasswordField.getPassword());
            if (!string.equals(string2)) {
                JOptionPane.showMessageDialog(this.getOwner(), Messages.getString("Message.PasswordConfirmationFailed"), Messages.getString("GUI.Title.PasswordValidation"), 0);
                this.resetHandler();
                return false;
            }
            if (this.expirationTimeCheckbox != null && this.expirationTimeCheckbox.isSelected() && this.expirationTimeField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.getOwner(), Messages.getString("Message.EmptyPasswordExpiration"), Messages.getString("GUI.Title.PasswordValidation"), 0);
                return false;
            }
            return true;
        }
        if (this.mode == GUIConstants$DialogMode.Open) {
            return true;
        }
        throw new RuntimeException("Invalid password prompt mode.");
    }

    protected void okHandler() {
        if (this.validateInput()) {
            this.setDialogResult(GUIConstants$DialogResult.OK);
            this.password = new String(this.passwordField.getPassword());
            this.setVisible(false);
        }
    }

    protected void resetHandler() {
        this.passwordField.setText("");
        if (this.confirmPasswordField != null) {
            this.confirmPasswordField.setText("");
        }
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(new GUIConstants$Actions[]{GUIConstants$Actions.OK, GUIConstants$Actions.Cancel, GUIConstants$Actions.Reset});
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    private JSeparator getJSeparator() {
        if (this.jSeparator == null) {
            this.jSeparator = new JSeparator();
        }
        return this.jSeparator;
    }

    private JPanel getCmsOptionsPanel(boolean bl) {
        if (this.cmsOptionsPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.ipadx = 40;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            this.daysLabel = new MnemonicLabel();
            this.daysLabel.setText(Messages.getStringWithMnemonics("Label.Days"));
            this.daysLabel.setEnabled(false);
            this.daysLabel.setName(ControlNames.PasswordPromptDialogDaysLabel.toString());
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints4.gridx = 0;
            this.cmsOptionsPanel = new JPanel();
            this.cmsOptionsPanel.setLayout(new GridBagLayout());
            if (!bl) {
                this.cmsOptionsPanel.add((Component)this.getExpirationTimeCheckbox(), gridBagConstraints4);
                this.cmsOptionsPanel.add((Component)this.getExpirationTimeField(), gridBagConstraints2);
                this.cmsOptionsPanel.add((Component)this.daysLabel, gridBagConstraints);
                this.daysLabel.setLabelFor(this.getExpirationTimeField());
            }
            this.cmsOptionsPanel.add((Component)this.getStashPasswordCheckbox(), gridBagConstraints3);
        }
        return this.cmsOptionsPanel;
    }

    private MnemonicCheckbox getExpirationTimeCheckbox() {
        if (this.expirationTimeCheckbox == null) {
            this.expirationTimeCheckbox = new MnemonicCheckbox();
            this.expirationTimeCheckbox.setText(Messages.getStringWithMnemonics("Label.ExpirationTime"));
            this.expirationTimeCheckbox.addItemListener(this);
            this.expirationTimeCheckbox.setName(ControlNames.PasswordPromptDialogExpirationTimeCheckbox.toString());
        }
        return this.expirationTimeCheckbox;
    }

    private MnemonicCheckbox getStashPasswordCheckbox() {
        if (this.stashPasswordCheckbox == null) {
            this.stashPasswordCheckbox = new MnemonicCheckbox();
            this.stashPasswordCheckbox.setSelected(KeymanSettings$Setting.DefaultPasswordStashingState.getBoolean());
            this.stashPasswordCheckbox.setText(Messages.getStringWithMnemonics("Label.StashPassword"));
            this.stashPasswordCheckbox.setName(ControlNames.PasswordPromptDialogStashPasswordCheckbox.toString());
        }
        return this.stashPasswordCheckbox;
    }

    private JFormattedTextField getExpirationTimeField() {
        if (this.expirationTimeField == null) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            numberFormat.setGroupingUsed(false);
            numberFormat.setMaximumIntegerDigits(KeymanSettings.VALID_PASSWORD_EXPIRY_RANGE.getMaximumDigits());
            this.expirationTimeField = new JFormattedTextField(numberFormat);
            this.expirationTimeField.setColumns(5);
            this.expirationTimeField.setText("60");
            this.expirationTimeField.setEnabled(false);
            this.expirationTimeField.setToolTipText(Messages.getString("Tooltip.PasswordExpireTime"));
            this.expirationTimeField.getAccessibleContext().setAccessibleName(Messages.getString("Label.Days"));
            this.expirationTimeField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.PasswordExpireTime"));
            this.expirationTimeField.setName(ControlNames.PasswordPromptDialogExpirationTimeField.toString());
        }
        return this.expirationTimeField;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.expirationTimeCheckbox)) {
            this.daysLabel.setEnabled(this.expirationTimeCheckbox.isSelected());
            this.expirationTimeField.setEnabled(this.expirationTimeCheckbox.isSelected());
        }
    }
}

