/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory$FileLessKeyStoreProxy;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;

class KeyStoreProxyCreatorFactory$PKCS11ImplDirectKeyStoreProxy
extends KeyStoreProxyCreatorFactory$FileLessKeyStoreProxy {
    private static final String KEYSTORE_NAME = "PKCS11IMPLKS";
    private static final String FILE_NAME_DIVIDER = ":";

    public KeyStoreProxyCreatorFactory$PKCS11ImplDirectKeyStoreProxy(DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect databaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect, boolean bl) throws KeyManagerException, CancelledException {
        super(null, databaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect, bl);
    }

    protected void load() throws KeyManagerException {
        if (this.create) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.INVALID_ARGUMENT, new String[]{"loadKeyStore:create"});
        }
        IBMPKCS11Impl iBMPKCS11Impl = new IBMPKCS11Impl();
        int n = ((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect)this.descriptor).getSlotNumber();
        try {
            iBMPKCS11Impl.Init(((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect)this.descriptor).getFileNameString() + FILE_NAME_DIVIDER + n, ((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect)this.descriptor).getPassword(true, this.create).toCharArray());
            if (Security.getProvider("IBMPKCS11Impl") != null) {
                Security.removeProvider("IBMPKCS11Impl");
            }
            Security.addProvider((Provider)iBMPKCS11Impl);
            this.keyStore = KeyStore.getInstance(KEYSTORE_NAME, (Provider)iBMPKCS11Impl);
            this.keyStore.load(null, null);
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_STORE_TYPE_NOT_FOUND, keyStoreException, new String[]{KEYSTORE_NAME});
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_LOAD_ERROR, (Throwable)certificateException);
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null) {
                if (iOException.getMessage().contains("Invalid slot number")) {
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_SLOT_NUMBER, (Throwable)iOException);
                }
                if (iOException.getMessage().contains("Pin is incorrect")) {
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_PIN, (Throwable)iOException);
                }
                throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR_MSG, iOException, new String[]{iOException.getMessage()});
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
    }

    public void close() throws KeyManagerException {
        try {
            IBMPKCS11Impl iBMPKCS11Impl = (IBMPKCS11Impl)Security.getProvider(((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect)this.descriptor).getProvider());
            if (iBMPKCS11Impl != null) {
                iBMPKCS11Impl.logout();
            }
        }
        catch (Exception exception) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEYSTORE_CLOSE_ERROR, (Throwable)exception);
        }
    }

    public void delete() throws KeyManagerException {
        throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.INVALID_OPERATION, new String[]{"PKCS11ImplDirectKeyStoreProxy.delete"});
    }

    public void save(DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect databaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect) throws KeyManagerException {
    }

    public KeyStore reload() throws KeyManagerException, CancelledException {
        this.close();
        return super.reload();
    }

    public void save(DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor) throws KeyManagerException {
        this.save((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect)databaseDescriptorFactory$DatabaseDescriptor);
    }
}

