/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.ext;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$AbstractPKCS11ImplDatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DescriptorType;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.text.MessageFormat;
import javax.security.auth.callback.CallbackHandler;

class DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirectImpl
extends DatabaseDescriptorFactory$AbstractPKCS11ImplDatabaseDescriptor
implements DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirect {
    private int slotNumber;

    public DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirectImpl(String string, String string2, int n, CallbackHandler callbackHandler, DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, DatabaseDescriptorFactory$DescriptorType databaseDescriptorFactory$DescriptorType) throws KeyManagerException {
        super(string, string2, callbackHandler, Constants$DatabaseType.PKCS11Direct, databaseDescriptorFactory$DatabaseDescriptor, databaseDescriptorFactory$DescriptorType);
        this.slotNumber = n;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public String getName() {
        return MessageFormat.format(Messages.getString("Label.Slot"), this.slotNumber);
    }

    public static DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirectImpl getDescriptor(CommandParameters commandParameters, CallbackHandler callbackHandler, DatabaseDescriptorFactory$DescriptorType databaseDescriptorFactory$DescriptorType) throws KeyManagerException {
        String string;
        String string2;
        if (commandParameters.getCrypto().trim().equals("")) {
            if (KeymanSettings$Setting.DefaultCryptoModule.getString().trim().equals("")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_CRYPTO_MODULE_SPECIFIED, new String[]{KeymanSettings$Setting.DefaultCryptoModule.getPropertyKey()});
            }
            string2 = KeymanSettings$Setting.DefaultCryptoModule.getString();
        } else {
            string2 = commandParameters.getCrypto();
        }
        int n = commandParameters.getRelativeSlotNumber();
        try {
            string = commandParameters.getCryptoPassword();
        }
        catch (KeyManagerException keyManagerException) {
            string = null;
        }
        DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor = null;
        if (commandParameters.isParameterPresent(Constants$Parameter.SecondaryDb)) {
            databaseDescriptorFactory$DatabaseDescriptor = DatabaseDescriptorFactory.getDatabaseDescriptor(commandParameters, callbackHandler, DatabaseDescriptorFactory$DescriptorType.Secondary);
        }
        return new DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirectImpl(string2, string, n, callbackHandler, databaseDescriptorFactory$DatabaseDescriptor, databaseDescriptorFactory$DescriptorType);
    }

    public ParameterMap getDatabaseParameters(boolean bl) throws KeyManagerException {
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.put(Constants$Parameter.Crypto, this.getFileNameString());
        parameterMap.put(Constants$Parameter.RelativeSlotNumber, this.slotNumber);
        if (bl) {
            parameterMap.put(Constants$Parameter.SecondPassword, this.getPassword());
            parameterMap.setTargetDescriptor(this);
        } else {
            parameterMap.put(Constants$Parameter.Password, this.getPassword());
            parameterMap.setSourceDescriptor(this);
        }
        return parameterMap;
    }

    public String toString() {
        return Messages.getString("Label.CryptoToken") + " " + this.slotNumber;
    }

    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirectImpl) {
            return ((DatabaseDescriptorFactory$PKCS11ImplDatabaseDescriptorDirectImpl)object).slotNumber == this.slotNumber;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + this.slotNumber;
    }
}

