/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle.ui;

import com.ibm.arcs.status.ui.AbstractStatusPublishingComposite;
import com.ibm.informix.bundle.Bundle;
import com.ibm.informix.bundle.BundleMember;
import com.ibm.informix.bundle.Feature;
import com.ibm.informix.bundle.FeatureGroup;
import com.ibm.informix.bundle.Package;
import com.ibm.informix.bundle.ui.BundleTreeColumn;
import com.ibm.informix.bundle.ui.BundleTreeListener;
import com.ibm.informix.bundle.ui.Messages;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class BundleTree
extends AbstractStatusPublishingComposite
implements SelectionListener {
    private final Tree tree;
    private final HashSet<BundleTreeListener> listeners;
    private final HashSet<BundleTreeListener> columnListeners;
    private final HashSet<BundleTreeColumn> columns;
    private final boolean showFiles;
    private static final int NAME_INDEX = 0;

    public BundleTree(Composite composite, int n, boolean bl) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.listeners = new HashSet();
        this.columnListeners = new HashSet();
        this.columns = new HashSet();
        this.showFiles = bl;
        this.tree = this.createBundleTree(n);
        TreeColumn treeColumn = new TreeColumn(this.tree, 16384, 0);
        treeColumn.setWidth(550);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.tree.setEnabled(bl);
    }

    private Tree createBundleTree(int n) {
        Tree tree = new Tree((Composite)this, n | 0x20);
        tree.setToolTipText(Messages.BundleTree_Tooltip);
        tree.setHeaderVisible(true);
        tree.addSelectionListener((SelectionListener)this);
        return tree;
    }

    private void createHeader(BundleTreeColumn bundleTreeColumn, int n) {
        TreeColumn treeColumn = new TreeColumn(this.tree, bundleTreeColumn.getStyle(), n);
        treeColumn.setWidth(bundleTreeColumn.getWidth());
    }

    public void addListener(BundleTreeListener bundleTreeListener) {
        if (bundleTreeListener instanceof BundleTreeColumn) {
            this.columnListeners.add(bundleTreeListener);
        } else {
            this.listeners.add(bundleTreeListener);
        }
    }

    private void notifyListeners(SelectionEvent selectionEvent) {
        this.notifyListeners(selectionEvent, this.columnListeners);
        this.notifyListeners(selectionEvent, this.listeners);
    }

    private void notifyListeners(SelectionEvent selectionEvent, Set<BundleTreeListener> set) {
        for (BundleTreeListener bundleTreeListener : set) {
            bundleTreeListener.itemSelected(selectionEvent);
        }
    }

    public synchronized int addColumn(BundleTreeColumn bundleTreeColumn) {
        this.columns.add(bundleTreeColumn);
        int n = this.tree.getColumnCount();
        this.createHeader(bundleTreeColumn, n);
        return n;
    }

    private void onCreate(TreeItem treeItem) {
        for (BundleTreeColumn bundleTreeColumn : this.columns) {
            bundleTreeColumn.onCreate(treeItem);
        }
    }

    public void populate(Bundle bundle) throws Exception {
        try {
            try {
                for (Package package_ : bundle.getPackages()) {
                    this.makeTreeItem((BundleMember)package_, null);
                }
                this.tree.setData((Object)bundle);
            }
            catch (Exception exception) {
                this.tree.removeAll();
                TreeItem treeItem = new TreeItem(this.tree, 0);
                treeItem.setText(exception.getMessage() == null ? Messages.BundleTree_ErrorOccured : exception.getMessage());
                exception.printStackTrace();
                throw exception;
            }
        }
        finally {
            this.endWait();
        }
    }

    public void unload() {
        this.startWait();
        this.tree.removeAll();
        this.tree.setData(null);
    }

    private void startWait() {
        TreeColumn[] treeColumnArray = this.tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            treeColumn.setText("Loading...");
            ++n2;
        }
    }

    private void endWait() {
        this.tree.getColumn(0).setText(Messages.BundleTree_Configuration);
        for (BundleTreeColumn bundleTreeColumn : this.columns) {
            this.tree.getColumn(bundleTreeColumn.getIndex()).setText(bundleTreeColumn.getName());
        }
    }

    private void makeTreeItem(BundleMember bundleMember, TreeItem treeItem) {
        TreeItem treeItem2 = null;
        if (bundleMember instanceof Package) {
            treeItem2 = this.createMember(bundleMember, new TreeItem(this.tree, 0));
            this.createChildren(((Package)bundleMember).getFeatures(), treeItem2);
            BundleTree.setFont(treeItem2, 1);
        } else if (bundleMember instanceof FeatureGroup) {
            treeItem2 = this.createMember(bundleMember, new TreeItem(treeItem, 0));
            this.createChildren(((FeatureGroup)bundleMember).getFeatures(), treeItem2);
            BundleTree.setFont(treeItem2, 2);
        } else if (bundleMember instanceof Feature) {
            treeItem2 = this.createMember(bundleMember, new TreeItem(treeItem, 0));
            this.createChildren(((Feature)bundleMember).getFeatureMembers(), treeItem2);
            BundleTree.setFont(treeItem2, 2);
        } else if (this.showFiles || bundleMember.getParent().getDescription().equals(com.ibm.informix.bundle.message.Messages.InstalledBundle_Miscellaneous)) {
            this.createMember(bundleMember, new TreeItem(treeItem, 0));
        }
    }

    private TreeItem createMember(BundleMember bundleMember, TreeItem treeItem) {
        treeItem.setText(0, bundleMember.getName());
        treeItem.setData((Object)bundleMember);
        this.onCreate(treeItem);
        return treeItem;
    }

    private void createChildren(Collection<?> collection, TreeItem treeItem) {
        for (Object obj : collection) {
            this.makeTreeItem((BundleMember)obj, treeItem);
        }
    }

    private static void setFont(TreeItem treeItem, int n) {
        FontData[] fontDataArray;
        FontData[] fontDataArray2 = fontDataArray = treeItem.getFont(0).getFontData();
        int n2 = fontDataArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FontData fontData = fontDataArray2[n3];
            fontData.setStyle(fontData.getStyle() | n);
            ++n3;
        }
        treeItem.setFont(new Font((Device)treeItem.getDisplay(), fontDataArray));
    }

    public IStatus getStatus() {
        return Status.OK_STATUS;
    }

    public void setToolTipText(String string) {
        this.tree.setToolTipText(string);
    }

    public Tree getTree() {
        return this.tree;
    }

    public void checkAll(Set<String> set, boolean bl) {
        if (set != null) {
            this.checkAll(set, bl, this.tree.getItems());
        }
    }

    private void checkAll(Set<String> set, boolean bl, TreeItem[] treeItemArray) {
        TreeItem[] treeItemArray2 = treeItemArray;
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray2[n2];
            BundleMember bundleMember = (BundleMember)treeItem.getData();
            if (set.contains(bundleMember.getId())) {
                if (this.isUncheckedOrGrayed(treeItem)) {
                    this.checkEvent(treeItem, true);
                }
            } else {
                if (bl && this.isCheckedOrGrayed(treeItem)) {
                    this.checkEvent(treeItem, false);
                }
                if (treeItem.getItemCount() > 0) {
                    this.checkAll(set, bl, treeItem.getItems());
                }
            }
            ++n2;
        }
    }

    public void checkAll() {
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (this.isUncheckedOrGrayed(treeItem)) {
                this.checkEvent(treeItem, true);
            }
            ++n2;
        }
    }

    private void checkEvent(TreeItem treeItem, boolean bl) {
        Event event = new Event();
        event.detail = 32;
        event.item = treeItem;
        event.widget = treeItem;
        event.doit = true;
        treeItem.setChecked(bl);
        this.widgetSelected(new SelectionEvent(event));
    }

    private boolean isCheckedOrGrayed(TreeItem treeItem) {
        return treeItem.getChecked() || treeItem.getGrayed();
    }

    private boolean isUncheckedOrGrayed(TreeItem treeItem) {
        return !treeItem.getChecked() || treeItem.getGrayed();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        switch (selectionEvent.detail) {
            case 32: {
                BundleTree.check((TreeItem)selectionEvent.item);
            }
        }
        this.notifyListeners(selectionEvent);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.notifyListeners(selectionEvent);
    }

    private static void check(TreeItem treeItem) {
        treeItem.setGrayed(false);
        BundleTree.recurse(treeItem.getItems());
        BundleTree.setGrayed(treeItem);
    }

    private static void recurse(TreeItem[] treeItemArray) {
        TreeItem[] treeItemArray2 = treeItemArray;
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray2[n2];
            treeItem.setChecked(treeItem.getParentItem().getChecked());
            treeItem.setGrayed(false);
            BundleTree.recurse(treeItem.getItems());
            ++n2;
        }
    }

    private static void setGrayed(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.getParentItem();
        if (treeItem2 != null) {
            TreeItem[] treeItemArray = treeItem2.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem3 = treeItemArray[n2];
                if (treeItem3.getChecked() != treeItem.getChecked()) {
                    treeItem2.setGrayed(true);
                    treeItem2.setChecked(true);
                    TreeItem treeItem4 = treeItem2;
                    while ((treeItem4 = treeItem4.getParentItem()) != null) {
                        treeItem4.setGrayed(true);
                        treeItem4.setChecked(true);
                    }
                    return;
                }
                ++n2;
            }
            treeItem2.setGrayed(false);
            treeItem2.setChecked(treeItem.getChecked());
            BundleTree.setGrayed(treeItem2);
        }
    }
}

