/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle.ui;

import com.ibm.arcs.status.IStatusProvider;
import com.ibm.arcs.status.forward.AllStatusForwarder;
import com.ibm.informix.bundle.BundleMember;
import com.ibm.informix.bundle.Feature;
import com.ibm.informix.bundle.FeatureGroup;
import com.ibm.informix.bundle.ui.BundleTree;
import com.ibm.informix.bundle.ui.BundleTreeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TreeItem;

public class Dependency
extends AllStatusForwarder
implements IStatusProvider,
BundleTreeListener {
    private static final String PLUGIN_ID = "com.ibm.informix.bundle.ui";
    private final BundleTree bundleTree;
    private final int priority;
    private IStatus status = null;

    public Dependency(BundleTree bundleTree, int n) {
        this.bundleTree = bundleTree;
        bundleTree.addListener(this);
        this.priority = n;
    }

    @Override
    public void itemSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.detail == 32) {
            this.status = null;
            this.publishStatus(this.getStatus());
        }
    }

    public IStatus getStatus() {
        if (this.status == null) {
            this.status = Status.OK_STATUS;
            HashMap<String, Independent> hashMap = new HashMap<String, Independent>();
            this.check(hashMap, this.bundleTree.getTree().getItems());
            for (Independent independent : hashMap.values()) {
                if (independent.isSelected()) {
                    if (independent.isComplete()) continue;
                    BundleMember bundleMember = (BundleMember)this.bundleTree.getTree().getItem(0).getData();
                    String string = String.valueOf(Feature.getName((String)independent.getId())) + " in " + bundleMember.getBundle().getMember(independent.getId()).getParent().getName() + " does not have all its files selected.  The feature may not work correctly as a result.";
                    this.status = new Status(2, PLUGIN_ID, this.priority, string, null);
                    break;
                }
                Feature feature = independent.getDependents().iterator().next();
                String string = String.valueOf(feature.getName()) + " in " + feature.getParent().getName() + " requires the following: " + Feature.getName((String)independent.getId()) + " in " + feature.getBundle().getMember(independent.getId()).getParent().getName();
                this.status = new Status(4, PLUGIN_ID, this.priority, string, null);
                break;
            }
        }
        return this.status;
    }

    private void check(Map<String, Independent> map, TreeItem[] treeItemArray) {
        TreeItem[] treeItemArray2 = treeItemArray;
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray2[n2];
            if (treeItem.getChecked() || treeItem.getGrayed()) {
                BundleMember bundleMember = (BundleMember)treeItem.getData();
                if (bundleMember instanceof FeatureGroup) {
                    this.check(map, treeItem.getItems());
                } else if (bundleMember instanceof Feature) {
                    Independent independent = this.getIndependent(map, (Feature)bundleMember);
                    independent.setSelected(true);
                    if (treeItem.getGrayed()) {
                        independent.setComplete(false);
                    }
                } else {
                    this.check(map, treeItem.getItems());
                }
            }
            ++n2;
        }
    }

    private Independent getIndependent(Map<String, Independent> map, Feature feature) {
        Object object2;
        for (Object object2 : feature.getDependencies()) {
            Independent independent = map.get(object2);
            if (independent == null) {
                map.put((String)object2, new Independent((String)object2, feature));
                continue;
            }
            independent.addDependent(feature);
        }
        object2 = map.get(feature.getId());
        if (object2 == null) {
            object2 = new Independent(feature.getId());
            map.put(feature.getId(), (Independent)object2);
        }
        return object2;
    }

    class Independent {
        private final String id;
        private final Set<Feature> dependents;
        private boolean selected = false;
        private boolean complete = true;

        public Independent(String string) {
            this.id = string;
            this.dependents = new HashSet<Feature>(4);
        }

        public Independent(String string, Feature feature) {
            this(string);
            this.dependents.add(feature);
        }

        public String getId() {
            return this.id;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setComplete(boolean bl) {
            this.complete = bl;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public void addDependent(Feature feature) {
            this.dependents.add(feature);
        }

        public Set<Feature> getDependents() {
            return Collections.unmodifiableSet(this.dependents);
        }
    }
}

