/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration;

import com.ibm.arcs.host.HostCatalog;
import com.ibm.informix.configuration.EnvironmentVariable;
import java.io.File;
import java.util.HashMap;

public class EnvironmentReader {
    private final HashMap<EnvironmentVariable, String> informixVariables = new HashMap();

    public EnvironmentReader() {
        this.informixVariables.put(EnvironmentVariable.INFORMIXSERVER, System.getenv(EnvironmentVariable.INFORMIXSERVER.getDisplayName()));
        this.informixVariables.put(EnvironmentVariable.INFORMIXDIR, System.getenv(EnvironmentVariable.INFORMIXDIR.getDisplayName()));
        this.informixVariables.put(EnvironmentVariable.ONCONFIG, System.getenv(EnvironmentVariable.ONCONFIG.getDisplayName()));
        String string = null;
        switch (HostCatalog.getLocalHost().getOperatingEnvironment().getKernel().getKernelType()) {
            case Windows: {
                string = this.getWindowsSqlHosts();
                break;
            }
            default: {
                string = this.getUnixSqlHosts();
            }
        }
        this.informixVariables.put(EnvironmentVariable.INFORMIXSQLHOSTS, string);
    }

    private String getWindowsSqlHosts() {
        return System.getenv(EnvironmentVariable.INFORMIXSQLHOSTS.getDisplayName());
    }

    private String getUnixSqlHosts() {
        String string;
        String string2 = System.getenv(EnvironmentVariable.INFORMIXSQLHOSTS.getDisplayName());
        if (string2 == null && (string = this.informixVariables.get((Object)EnvironmentVariable.INFORMIXDIR)) != null) {
            string2 = String.valueOf(string) + "/etc/sqlhosts";
        }
        return string2;
    }

    public String get(EnvironmentVariable environmentVariable) {
        return this.informixVariables.get((Object)environmentVariable);
    }

    public String getOnconfigAbsolutePath() {
        String string = this.informixVariables.get((Object)EnvironmentVariable.INFORMIXDIR);
        String string2 = this.informixVariables.get((Object)EnvironmentVariable.ONCONFIG);
        if (string != null && string2 != null) {
            return String.valueOf(string) + File.separator + "etc" + File.separator + string2;
        }
        return null;
    }
}

