/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration;

import com.ibm.arcs.database.DatabaseServerName;
import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.OperatingEnvironment;
import com.ibm.arcs.host.Processor;
import com.ibm.informix.configuration.InformixServer;
import com.ibm.informix.configuration.InformixServerEnvironmentVariables;
import com.ibm.informix.configuration.InformixVersion;
import com.ibm.informix.configuration.Platform;
import com.ibm.informix.configuration.space.InformixDataSpace;
import java.util.Collection;
import java.util.Map;

public class InformixInstance
implements InformixServer {
    private final ConnectionParameters connectionParameters;
    private final Map<Integer, InformixDataSpace> dataSpaces;
    private final String informixDir;
    private final String onconfig;
    private final String sqlHosts;
    private final String path;
    private final InformixVersion informixVersion;
    private final Platform platform;

    public InformixInstance(ConnectionParameters connectionParameters) throws Exception {
        this.connectionParameters = connectionParameters;
        this.informixDir = InformixServerEnvironmentVariables.getInformixDirectory(connectionParameters);
        this.onconfig = InformixServerEnvironmentVariables.getOnconfig(connectionParameters);
        this.sqlHosts = InformixServerEnvironmentVariables.getSQLHosts(connectionParameters);
        this.path = InformixServerEnvironmentVariables.getPath(connectionParameters);
        this.informixVersion = InformixVersion.getInformixVersion(connectionParameters);
        this.dataSpaces = InformixDataSpace.getDataSpaces(connectionParameters);
        this.platform = this.getPlatform(connectionParameters);
    }

    @Override
    public Collection<InformixDataSpace> getInformixDataSpaces() throws Exception {
        return this.dataSpaces.values();
    }

    public ConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    @Override
    public DatabaseServerName getDatabaseServerName() {
        return this.connectionParameters.getDatabaseServerName();
    }

    @Override
    public String getInformixDir() {
        return this.informixDir;
    }

    @Override
    public String getOnconfig() {
        return this.onconfig;
    }

    @Override
    public String getSQLHosts() {
        return this.sqlHosts;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public InformixVersion getInformixVersion() {
        return this.informixVersion;
    }

    private Platform getPlatform(ConnectionParameters connectionParameters) {
        Host host = connectionParameters.getHostName().getHost();
        OperatingEnvironment operatingEnvironment = host.getOperatingEnvironment();
        return new Platform(operatingEnvironment.getKernel().getKernelType(), this.getInformixVersion().getPlatformBits(), ((Processor)operatingEnvironment.getProcessors().get(0)).getISA().getISAType());
    }

    public Platform getServerPlatform() {
        return this.platform;
    }
}

