/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration.logging;

import com.ibm.arcs.basic.number.NaturalNumber;
import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;
import java.util.HashMap;

public class InformixLogicalLog {
    private NaturalNumber numberOfLogFiles;
    private ByteValue logFileSize;
    private ByteValue bufferSize;
    private int dynamicLoggingMode;

    public InformixLogicalLog() {
        this.setDefaults();
    }

    private void setDefaults() {
        this.numberOfLogFiles = new NaturalNumber(Integer.valueOf(6));
        this.logFileSize = new ByteValue(10L, ByteUnit.MEBIBYTE);
        this.dynamicLoggingMode = 2;
        this.bufferSize = new ByteValue(64L, ByteUnit.KIBIBYTE);
    }

    public void setNumberOfLogFiles(NaturalNumber naturalNumber) {
        this.numberOfLogFiles = naturalNumber;
    }

    public void setLogFileSize(ByteValue byteValue) {
        this.logFileSize = byteValue;
    }

    public void setBufferSize(ByteValue byteValue) {
        this.bufferSize = byteValue;
    }

    public void setDynamicLoggingMode(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("dynamic logging mode must be between 0 and 2 inclusive");
        }
        this.dynamicLoggingMode = n;
    }

    public void disableDynamicLogAllocation() {
        this.dynamicLoggingMode = 0;
    }

    public void enableManualLogAllocation() {
        this.dynamicLoggingMode = 1;
    }

    public void enableAutomaticLogAllocation() {
        this.dynamicLoggingMode = 2;
    }

    public NaturalNumber getNumberOfLogFiles() {
        return this.numberOfLogFiles;
    }

    public ByteValue getLogFileSize() {
        return this.logFileSize;
    }

    public boolean isDynamicLoggingEnabled() {
        return this.dynamicLoggingMode != 0;
    }

    public boolean isDynamicLoggingAutomatic() {
        return this.dynamicLoggingMode == 2;
    }

    public int getDynamicLoggingMode() {
        return this.dynamicLoggingMode;
    }

    public ByteValue getBufferSize() {
        return this.bufferSize;
    }

    public String setParameters(HashMap<String, String> hashMap) {
        String string = "";
        if (hashMap.containsKey("LOGFILES")) {
            this.numberOfLogFiles = NaturalNumber.valueOf((String)hashMap.get("LOGFILES"));
            string = String.valueOf(string) + "\nlogfiles was changed to " + this.numberOfLogFiles;
        }
        if (hashMap.containsKey("LOGSIZE")) {
            this.logFileSize = new ByteValue((long)Integer.valueOf(hashMap.get("LOGSIZE")).intValue(), ByteUnit.KIBIBYTE);
            string = String.valueOf(string) + "\nlogsize was changed to " + this.logFileSize;
        }
        if (hashMap.containsKey("DYNAMIC_LOGS")) {
            this.dynamicLoggingMode = Integer.parseInt(hashMap.get("DYNAMIC_LOGS"));
            string = String.valueOf(string) + "\ndynamic_logs was changed to " + this.dynamicLoggingMode;
        }
        if (hashMap.containsKey("LOGBUFF")) {
            this.bufferSize = new ByteValue((long)Integer.valueOf(hashMap.get("LOGBUFF")).intValue(), ByteUnit.KIBIBYTE);
            string = String.valueOf(string) + "\nlogbuff was changed to " + this.bufferSize;
        }
        return string;
    }
}

