/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration.logging;

import com.ibm.arcs.basic.number.NaturalNumber;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameterSearches;
import com.ibm.arcs.basic.strings.IStringMatcher;
import com.ibm.arcs.basic.strings.StringMatcherExact;
import com.ibm.arcs.basic.unit.ByteValue;
import com.ibm.arcs.serialization.xml.AbstractXmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.serializer.ObjectSerializer;
import com.ibm.informix.configuration.logging.InformixLogicalLog;
import org.eclipse.core.runtime.CoreException;

public class InformixLogicalLogXmlSerializer
extends AbstractXmlSerializer {
    private static final String TAG_NUMBERLOGFILES = "numberLogFiles";
    private static final String TAG_LOGFILESIZE = "logFileSize";
    private static final String TAG_BUFFERSIZE = "bufferSize";
    private static final String TAG_DYNAMICLOGGINGMODE = "dynamicLoggingMode";
    private static final IStringMatcher numberLogFilesTagMatcher = new StringMatcherExact("numberLogFiles");
    private static final IStringMatcher logFileSizeTagMatcher = new StringMatcherExact("logFileSize");
    private static final IStringMatcher bufferSizeTagMatcher = new StringMatcherExact("bufferSize");
    private static final IStringMatcher dynamicLoggingModeTagMatcher = new StringMatcherExact("dynamicLoggingMode");

    public boolean accepts(Class<?> clazz) {
        return clazz.equals(InformixLogicalLog.class);
    }

    public HierarchicalParameter toHierarchicalParameter(Object object, XmlSerializerCatalog xmlSerializerCatalog) {
        if (this.accepts(object.getClass())) {
            InformixLogicalLog informixLogicalLog = (InformixLogicalLog)object;
            HierarchicalParameter hierarchicalParameter = ObjectSerializer.createRootNode(object.getClass(), (XmlSerializerCatalog)xmlSerializerCatalog);
            new HierarchicalParameter(TAG_NUMBERLOGFILES, informixLogicalLog.getNumberOfLogFiles().toString(), hierarchicalParameter);
            new HierarchicalParameter(TAG_LOGFILESIZE, informixLogicalLog.getLogFileSize().toString(), hierarchicalParameter);
            new HierarchicalParameter(TAG_BUFFERSIZE, informixLogicalLog.getBufferSize().toString(), hierarchicalParameter);
            new HierarchicalParameter(TAG_DYNAMICLOGGINGMODE, Integer.toString(informixLogicalLog.getDynamicLoggingMode()), hierarchicalParameter);
            return hierarchicalParameter;
        }
        throw new IllegalArgumentException("unsupported object type");
    }

    public Object fromXml(HierarchicalParameter hierarchicalParameter, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        String string = HierarchicalParameterSearches.getFirstMatchingKey((HierarchicalParameter)hierarchicalParameter, (IStringMatcher)numberLogFilesTagMatcher).getValue();
        String string2 = HierarchicalParameterSearches.getFirstMatchingKey((HierarchicalParameter)hierarchicalParameter, (IStringMatcher)logFileSizeTagMatcher).getValue();
        String string3 = HierarchicalParameterSearches.getFirstMatchingKey((HierarchicalParameter)hierarchicalParameter, (IStringMatcher)bufferSizeTagMatcher).getValue();
        String string4 = HierarchicalParameterSearches.getFirstMatchingKey((HierarchicalParameter)hierarchicalParameter, (IStringMatcher)dynamicLoggingModeTagMatcher).getValue();
        InformixLogicalLog informixLogicalLog = new InformixLogicalLog();
        informixLogicalLog.setNumberOfLogFiles(NaturalNumber.valueOf((String)string));
        informixLogicalLog.setLogFileSize(new ByteValue(string2));
        informixLogicalLog.setBufferSize(new ByteValue(string3));
        informixLogicalLog.setDynamicLoggingMode(Integer.parseInt(string4));
        return informixLogicalLog;
    }
}

