/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration.space;

import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;
import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.informix.configuration.InformixServer;
import com.ibm.informix.configuration.logging.InformixSpaceLogMode;
import com.ibm.informix.configuration.space.InformixChunk;
import com.ibm.informix.connection.InformixJdbcConnection;
import com.ibm.informix.connection.listener.InformixSystemDatabases;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InformixDataSpace {
    InformixServer server;
    public static final String TABLE_NAME = "sysdbspaces";
    private final String name;
    private final int number;
    private final Map<Integer, InformixChunk> informixChunks;
    private InformixSpaceLogMode logMode;
    private String path;
    private ByteValue size;
    private ByteValue offset;
    private boolean mirrorEnable;
    private String mirrorPath;
    private ByteValue mirrorSize;
    private ByteValue mirrorOffset;

    public InformixDataSpace(int n, String string) {
        if (!InformixDataSpace.isNameValid(string) || n < 0) {
            throw new IllegalArgumentException("Invalid Chunk information specified");
        }
        this.name = string;
        this.number = n;
        this.informixChunks = new HashMap<Integer, InformixChunk>();
        this.setDefaults();
    }

    public static Map<Integer, InformixDataSpace> getDataSpaces(ConnectionParameters connectionParameters) throws SQLException, ClassNotFoundException {
        InformixJdbcConnection informixJdbcConnection = new InformixJdbcConnection(connectionParameters);
        Connection connection = informixJdbcConnection.changeDatabase(InformixSystemDatabases.SYSMASTER.getName());
        Statement statement = connection.createStatement();
        statement.execute("SELECT a.dbsnum,name,chknum,fname FROM sysdbspaces a,syschunks b WHERE a.dbsnum=b.dbsnum ORDER BY a.dbsnum,chknum;");
        ResultSet resultSet = statement.getResultSet();
        HashMap<Integer, InformixDataSpace> hashMap = new HashMap<Integer, InformixDataSpace>();
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            InformixDataSpace informixDataSpace = (InformixDataSpace)hashMap.get(n);
            if (informixDataSpace == null) {
                informixDataSpace = new InformixDataSpace(n, resultSet.getString(2).trim());
                hashMap.put(n, informixDataSpace);
            }
            String string = resultSet.getString(4).trim();
            try {
                string = new File(string).getCanonicalPath();
            }
            catch (IOException iOException) {}
            informixDataSpace.putChunk(new InformixChunk(resultSet.getInt(3), string));
        }
        return hashMap;
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    public InformixSpaceLogMode getLogMode() {
        return this.logMode;
    }

    public String getPath() {
        return this.path;
    }

    public ByteValue getSize() {
        return this.size;
    }

    public ByteValue getOffset() {
        return this.offset;
    }

    public boolean isMirroringEnabled() {
        return this.mirrorEnable;
    }

    public String getMirrorPath() {
        return this.mirrorPath;
    }

    public ByteValue getMirrorSize() {
        return this.mirrorSize;
    }

    public ByteValue getMirrorOffset() {
        return this.mirrorOffset;
    }

    public InformixChunk putChunk(InformixChunk informixChunk) {
        return this.informixChunks.put(informixChunk.getNumber(), informixChunk);
    }

    public Collection<InformixChunk> getChunks() {
        return Collections.unmodifiableCollection(this.informixChunks.values());
    }

    public InformixChunk getChunk(int n) {
        return this.informixChunks.get(n);
    }

    public void setDefaults() {
        this.logMode = InformixSpaceLogMode.getDefaultDatabaseSpaceLogMode();
        this.path = "$INFORMIXDIR/rootdbs.ids0";
        this.size = new ByteValue(256L, ByteUnit.MEBIBYTE);
        this.offset = new ByteValue(0L, ByteUnit.BYTE);
        this.mirrorEnable = false;
        this.mirrorPath = "$INFORMIXDIR/rootdbs_mirror.ids0";
        this.mirrorSize = new ByteValue(1L, ByteUnit.GIBIBYTE);
        this.mirrorOffset = new ByteValue(0L, ByteUnit.BYTE);
    }

    public static boolean isNameValid(String string) {
        return string != null && string.length() != 0;
    }
}

