/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration.xml;

import com.ibm.informix.configuration.xml.InformixXML;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class InformixXSD {
    public static final String xsdFileName = "Informix.xsd";
    private static String sqlSAXExceptionError = null;
    private static Validator validator = null;
    private static Logger log;

    static {
        InformixXSD.configureLog();
    }

    public static boolean validateXML(File file) {
        InformixXSD.loadSchemaValidator();
        StreamSource streamSource = new StreamSource(file);
        return InformixXSD.validateStreamSource(streamSource);
    }

    public static String getXSDLocalPath() throws IOException {
        String string = String.valueOf(InformixXML.getDirectoryPath()) + File.separator + xsdFileName;
        log.debug("XSD Local Path: " + string);
        return string;
    }

    public static String getSQLExceptionMessage() {
        return sqlSAXExceptionError.substring(sqlSAXExceptionError.indexOf("'"));
    }

    private static void configureLog() {
        if (log == null) {
            log = LoggerFactory.getLogger(InformixXSD.class);
        }
    }

    private static void loadSchemaValidator() {
        try {
            String string = InformixXSD.getXSDLocalPath();
            StreamSource streamSource = new StreamSource(string);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(streamSource);
            validator = schema.newValidator();
        }
        catch (IOException iOException) {
            log.error("Error while reading Informix XSD file", iOException.getCause());
        }
        catch (SAXException sAXException) {
            log.error("Error making schema with xsdFile in InformixXSD.java", sAXException.getCause());
        }
    }

    private static boolean validateStreamSource(StreamSource streamSource) {
        try {
            validator.validate(streamSource);
            return true;
        }
        catch (SAXException sAXException) {
            log.error("SAXException while validating ", (Throwable)sAXException);
            return false;
        }
        catch (IOException iOException) {
            log.error("Error with validation in InformixXSD.java", (Throwable)iOException);
            return false;
        }
    }
}

