/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum FileType implements ByteSequence
{
    X509CRL(ByteSequenceFactory.newByteSequence(88, 53, 48, 57, 67, 82, 76, 0)),
    X509KEY(ByteSequenceFactory.newByteSequence(88, 53, 48, 57, 75, 69, 89, 0)),
    X509KYP(ByteSequenceFactory.newByteSequence(88, 53, 48, 57, 75, 89, 80, 0));

    private final ByteSequence sequence;

    public static FileType fileTypeFromByteSequence(ByteSequence sequence) throws NullPointerException {
        if (sequence == null) {
            throw new NullPointerException();
        }
        return Mapping.get(sequence);
    }

    private FileType(ByteSequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public byte get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.sequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.sequence.get(index);
    }

    @Override
    public int length() {
        return this.sequence.length();
    }

    @Override
    public ByteSequence append(ByteSequence sequence) throws NullPointerException {
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (sequence.length() == 0) {
            return this;
        }
        return this.sequence.append(sequence);
    }

    @Override
    public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
        if (fromPosition < 0 || toPosition > this.sequence.length() || fromPosition > toPosition) {
            throw new IndexOutOfBoundsException();
        }
        return this.sequence.getSubSequence(fromPosition, toPosition);
    }

    @Override
    public int indexOf(byte b) {
        return this.sequence.indexOf(b);
    }

    @Override
    public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
        if (position < 0 || position > this.sequence.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(position));
        }
        return this.sequence.indexOf(position, b);
    }

    @Override
    public int lastIndexOf(byte b) {
        return this.sequence.lastIndexOf(b);
    }

    @Override
    public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
        if (position < 0 || position > this.sequence.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(position));
        }
        return this.sequence.lastIndexOf(position, b);
    }

    @Override
    public boolean isEmpty() {
        return this.sequence.isEmpty();
    }

    @Override
    public InputStream getInputStream() {
        return this.sequence.getInputStream();
    }

    @Override
    public ByteSequenceIterator getIterator() {
        return this.sequence.getIterator();
    }

    @Override
    public ByteSequenceIterator getIterator(int position) throws IndexOutOfBoundsException {
        if (position < 0 || position > this.sequence.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(position));
        }
        return this.sequence.getIterator(position);
    }

    @Override
    public String toBinaryString() {
        return this.sequence.toBinaryString();
    }

    @Override
    public String toOctalString() {
        return this.sequence.toOctalString();
    }

    @Override
    public String toHexString() {
        return this.sequence.toHexString();
    }

    @Override
    public String toString() {
        return this.sequence.toString();
    }

    private static final class Mapping {
        private static final Map<ByteSequence, FileType> m = new HashMap<ByteSequence, FileType>();

        private Mapping() {
        }

        public static FileType get(ByteSequence sequence) {
            return m.get(sequence);
        }

        static {
            for (FileType t : FileType.values()) {
                m.put(t.sequence, t);
            }
        }
    }
}

