/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ByteStream;
import com.ibm.jvm.trace.format.api.DataHeader;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class TraceSection {
    BigInteger startPlatform;
    BigInteger startSystem;
    int type;
    int generations;
    int pointerSize = 4;
    TraceContext context;
    String textSummary;

    public TraceSection(TraceContext context, ByteBuffer data) throws IllegalArgumentException {
        this.context = context;
        DataHeader dataHeader = new DataHeader(context, data, "UTTS");
        byte[] bytes = new byte[16];
        data.get(bytes);
        ByteStream stream = context.createByteStream(bytes);
        this.startPlatform = stream.getBigInteger(8);
        this.startSystem = stream.getBigInteger(8);
        this.type = data.getInt();
        this.generations = data.getInt();
        this.pointerSize = data.getInt();
        if (context.debugStream != null) {
            context.debug(this, 1, this.summary());
        }
    }

    public String toString() {
        return "Trace file header";
    }

    public String summary() {
        if (this.textSummary == null) {
            StringBuilder s = new StringBuilder(this.toString() + ":" + System.getProperty("line.separator"));
            s.append("        JVM start time: " + this.context.getFormattedTime(this.startPlatform)).append(System.getProperty("line.separator"));
            s.append("        Generations:    " + this.generations).append(System.getProperty("line.separator"));
            s.append("        Pointer size:   " + this.pointerSize).append(System.getProperty("line.separator"));
            this.textSummary = s.toString();
        }
        return this.textSummary;
    }
}

