/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxSQLOutStream;
import com.informix.jdbc.IfxDirectBlob;
import com.informix.jdbc.IfxDirectClob;
import com.informix.lang.JavaToIfxType;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class IfmxSQLDirOutStream
extends IfmxSQLOutStream {
    private byte[] dataArr = null;

    public IfmxSQLDirOutStream(DBAMonitor mon, long blobConn, byte[] ba) {
        super(mon, blobConn, 0L);
        this.dataArr = ba;
    }

    @Override
    void writeTimestamptoBytes(byte[] x, int max) throws SQLException {
        UDRLMInfo.writeTimestampToByteArray(this.dataArr, x, this.currPos, max);
        this.currPos += max;
    }

    @Override
    public void writeTime(Time x) throws SQLException {
        this.writeTimestamp(new Timestamp(x.getTime()));
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        throw GenErr.sqle(-9438, "writeStruct");
    }

    @Override
    public void writeString(String x) throws SQLException {
        throw GenErr.sqle(-9438, "writeString(String)");
    }

    @Override
    public void writeString(String x, int length) throws SQLException {
        byte[] str;
        int len = x.length();
        JavaToIfxType javatoifx = new JavaToIfxType();
        try {
            str = javatoifx.JavaToIfxChar(x);
        }
        catch (IOException ioe) {
            throw GenErr.sqle(-9438, "writeString(String, length)");
        }
        System.arraycopy(str, 2, this.dataArr, this.currPos, len);
        this.currPos += length;
    }

    @Override
    public void writeShort(short x) throws SQLException {
        this.alignPosition(2);
        this.currPos = UDRLMInfo.writeShortToByteArray(this.dataArr, x, this.currPos);
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        throw GenErr.sqle(-9438, "writeRef");
    }

    @Override
    public void writeObject(SQLData x) throws SQLException {
        throw GenErr.sqle(-9438, "writeObject");
    }

    @Override
    public void writeLong(long x) throws SQLException {
        byte[] ba = JavaToIfxType.JavaToIfxLongInt((long)x);
        this.alignPosition(4);
        this.currPos = UDRLMInfo.writeLongToByteArray(this.dataArr, ba, this.currPos);
    }

    public void writeBigint(long x) throws SQLException {
        this.alignPosition(8);
        this.currPos = UDRLMInfo.writeBigintToByteArray(this.dataArr, x, this.currPos);
    }

    @Override
    public void writeInt(int x) throws SQLException {
        this.alignPosition(4);
        this.currPos = UDRLMInfo.writeIntToByteArray(this.dataArr, x, this.currPos);
    }

    @Override
    public void writeFloat(float x) throws SQLException {
        this.alignPosition(4);
        this.currPos = UDRLMInfo.writeFloatToByteArray(this.dataArr, x, this.currPos);
    }

    @Override
    public void writeDouble(double x) throws SQLException {
        this.alignPosition(8);
        this.currPos = UDRLMInfo.writeDoubleToByteArray(this.dataArr, x, this.currPos);
    }

    @Override
    public void writeDate(Date x) throws SQLException {
        byte[] ba = JavaToIfxType.JavaToIfxDate((Date)x);
        this.alignPosition(4);
        this.currPos = UDRLMInfo.writeDateToByteArray(this.dataArr, ba, this.currPos);
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        byte[] ba = ((IfxDirectClob)x).toIfx();
        System.arraycopy(ba, 0, this.dataArr, this.currPos, ba.length);
        this.currPos += ba.length;
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        throw GenErr.sqle(-9438, "writeCharacterStream");
    }

    @Override
    public void writeBytes(byte[] x) throws SQLException {
        throw GenErr.sqle(-9438, "writeBytes(byte[]");
    }

    @Override
    public void writeBytes(byte[] x, int length) throws SQLException {
        System.arraycopy(x, 0, this.dataArr, this.currPos, length);
        this.currPos += length;
    }

    @Override
    public void writeByte(byte x) throws SQLException {
        this.dataArr[this.currPos] = x;
        ++this.currPos;
    }

    @Override
    public void writeBoolean(boolean x) throws SQLException {
        boolean c = x;
        this.dataArr[this.currPos] = (byte)(c ? 1 : 0);
        ++this.currPos;
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        byte[] ba = ((IfxDirectBlob)x).toIfx();
        System.arraycopy(ba, 0, this.dataArr, this.currPos, ba.length);
        this.currPos += ba.length;
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        throw GenErr.sqle(-9438, "writeBinaryStream");
    }

    @Override
    void doBigDecWrite(byte[] data) {
        this.currPos = UDRLMInfo.writeBigDecimalToByteArray(this.dataArr, data, this.currPos);
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        throw GenErr.sqle(-9438, "writeAsciiStream");
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        throw GenErr.sqle(-9438, "writeArray");
    }

    @Override
    public int length() {
        return this.currPos;
    }
}

