/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfxDataPointer;
import com.informix.jdbc.IfxDirectBlob;
import com.informix.jdbc.IfxDirectClob;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import informix.jvp.JVP;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

public class IfmxSQLInStream
implements IfmxUDTSQLInput,
SQLInput {
    long dataPtr;
    int currPos = 0;
    int datalength = 0;
    boolean isNull = false;
    DBAMonitor dbaMonitor = null;
    long conn = 0L;
    boolean autoAlignment = true;

    public IfmxSQLInStream(IfxDataPointer dp) {
        this.conn = 0L;
        this.dataPtr = dp.bufp;
        this.datalength = dp.length;
    }

    public IfmxSQLInStream(DBAMonitor mon, long blobConn, long ptr, int len) {
        this.dbaMonitor = mon;
        this.conn = blobConn;
        this.dataPtr = ptr;
        this.datalength = len;
    }

    public IfmxSQLInStream(DBAMonitor mon, long blobConn, long ptr) {
        this.dbaMonitor = mon;
        this.conn = blobConn;
        this.dataPtr = ptr;
        this.datalength = -1;
    }

    @Override
    public boolean wasNull() {
        return this.isNull;
    }

    void checkAvailable(int len) throws SQLException {
        JVP.traceable.tracePrint("JVP.JDBC", 4, "checkAvailable() looking for " + Integer.toString(len) + " bytes with " + Integer.toString(this.datalength - this.currPos) + " available");
        if (len > this.datalength - this.currPos) {
            throw GenErr.sqle(-79772);
        }
    }

    void alignPosition(int alignment) throws SQLException {
        if (!this.autoAlignment) {
            return;
        }
        int skip = (this.currPos + alignment - 1 & ~(alignment - 1)) - this.currPos;
        if (skip <= 0) {
            return;
        }
        JVP.traceable.tracePrint("JVP.JDBC", 4, "alignPosition() at position " + Integer.toString(this.currPos) + " skipping next " + Integer.toString(skip) + " bytes");
        this.skipBytes(skip);
    }

    public void skipBytes(int len) throws SQLException {
        if (len <= 0) {
            return;
        }
        this.checkAvailable(len);
        this.currPos += len;
    }

    public void setCurrentPosition(int position) throws SQLException {
        if (position < 0 || position > this.datalength) {
            throw GenErr.sqle(-79772);
        }
        this.currPos = position;
    }

    public void setAutoAlignment(boolean value) {
        this.autoAlignment = value;
    }

    void doBigDecRead(byte[] ba) {
        this.currPos = UDRLMInfo.readBigDecimal(this.dataPtr, ba, this.currPos);
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        short qualifier = this.readShort();
        byte[] ba = new byte[22];
        this.checkAvailable(22);
        this.alignPosition(2);
        this.doBigDecRead(ba);
        Decimal d = Decimal.dec_tToJava((byte[])ba);
        if (d.isNull()) {
            this.isNull = true;
            return null;
        }
        d.setTimestampQualifier(qualifier);
        Timestamp time = d.timestampValue();
        return time;
    }

    @Override
    public Time readTime() throws SQLException {
        Timestamp ts = this.readTimestamp();
        if (ts == null) {
            this.isNull = true;
            return null;
        }
        return new Time(ts.getTime());
    }

    @Override
    public String readString() throws SQLException {
        throw GenErr.sqle(-9438, "readString()");
    }

    public String readString(int maxlen) throws SQLException {
        byte[] str = new byte[maxlen];
        this.checkAvailable(maxlen);
        this.currPos = UDRLMInfo.readString(this.dataPtr, str, maxlen, this.currPos);
        String s = new String(str);
        if (s == null) {
            this.isNull = true;
        } else {
            s = s.trim();
        }
        return s;
    }

    @Override
    public short readShort() throws SQLException {
        short[] shortVal = new short[1];
        this.checkAvailable(2);
        this.alignPosition(2);
        this.currPos = UDRLMInfo.readShort(this.dataPtr, shortVal, this.currPos);
        if (shortVal[0] == Short.MIN_VALUE) {
            this.isNull = true;
        }
        return shortVal[0];
    }

    @Override
    public Ref readRef() throws SQLException {
        throw GenErr.sqle(-9438, "readRef");
    }

    @Override
    public Object readObject() throws SQLException {
        throw GenErr.sqle(-9438, "readObject");
    }

    void doLongRead(byte[] ba) {
        this.currPos = UDRLMInfo.readLong(this.dataPtr, ba, this.currPos);
    }

    @Override
    public long readLong() throws SQLException {
        byte[] ba = new byte[10];
        byte[] signba = new byte[2];
        this.checkAvailable(10);
        this.alignPosition(4);
        this.doLongRead(ba);
        System.arraycopy(ba, 0, signba, 0, 2);
        short sign = IfxToJavaType.IfxToJavaSmallInt((byte[])ba, (short)0);
        if (sign == 0) {
            this.isNull = true;
        }
        long l = IfxToJavaType.IfxToJavaLongInt((byte[])ba, (short)0);
        return l;
    }

    public long readBigint() throws SQLException {
        long[] bintVal = new long[1];
        this.checkAvailable(8);
        this.alignPosition(8);
        this.currPos = UDRLMInfo.readBigint(this.dataPtr, bintVal, this.currPos);
        if (bintVal[0] == Long.MIN_VALUE) {
            this.isNull = true;
        }
        return bintVal[0];
    }

    public Interval readInterval() throws SQLException {
        short qualifier = this.readShort();
        byte[] ba = new byte[22];
        this.checkAvailable(22);
        this.alignPosition(2);
        this.doBigDecRead(ba);
        Decimal d = Decimal.dec_tToJava((byte[])ba);
        if (d.isNull()) {
            this.isNull = true;
            return null;
        }
        d.setTimestampQualifier(qualifier);
        return d.intervalValue();
    }

    @Override
    public int readInt() throws SQLException {
        int[] intVal = new int[1];
        this.checkAvailable(4);
        this.alignPosition(4);
        this.currPos = UDRLMInfo.readInt(this.dataPtr, intVal, this.currPos);
        if (intVal[0] == Integer.MIN_VALUE) {
            this.isNull = true;
        }
        return intVal[0];
    }

    @Override
    public float readFloat() throws SQLException {
        float[] floatVal = new float[1];
        this.checkAvailable(4);
        this.alignPosition(4);
        this.currPos = UDRLMInfo.readFloat(this.dataPtr, floatVal, this.currPos);
        return floatVal[0];
    }

    @Override
    public double readDouble() throws SQLException {
        double[] dVal = new double[1];
        this.checkAvailable(8);
        this.alignPosition(8);
        this.currPos = UDRLMInfo.readDouble(this.dataPtr, dVal, this.currPos);
        return dVal[0];
    }

    void doDateRead(byte[] ba) {
        this.currPos = UDRLMInfo.readDate(this.dataPtr, ba, this.currPos);
    }

    @Override
    public Date readDate() throws SQLException {
        byte[] ba = new byte[4];
        this.checkAvailable(4);
        this.alignPosition(4);
        this.doDateRead(ba);
        Date date = IfxToJavaType.IfxToJavaDate((byte[])ba, (short)0);
        if (date == null) {
            this.isNull = true;
        }
        return date;
    }

    @Override
    public Clob readClob() throws SQLException {
        byte[] lo = new byte[72];
        this.checkAvailable(72);
        this.currPos = UDRLMInfo.readBlob(this.dataPtr, lo, this.currPos);
        IfxDirectClob clob = new IfxDirectClob(this.dbaMonitor, this.conn, lo);
        if (clob.isNull()) {
            this.isNull = true;
            return null;
        }
        return (Clob)clob.toObject();
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        throw GenErr.sqle(-9438, "readCharacterStream");
    }

    @Override
    public byte[] readBytes() throws SQLException {
        throw GenErr.sqle(-9438, "readBytes()");
    }

    public byte[] readBytes(int maxlen) throws SQLException {
        byte[] ba = new byte[maxlen];
        this.checkAvailable(maxlen);
        this.currPos = UDRLMInfo.readBytes(this.dataPtr, ba, maxlen, this.currPos);
        return ba;
    }

    @Override
    public byte readByte() throws SQLException {
        byte[] b = new byte[1];
        this.checkAvailable(1);
        this.currPos = UDRLMInfo.readBytes(this.dataPtr, b, 1, this.currPos);
        return b[0];
    }

    @Override
    public boolean readBoolean() throws SQLException {
        boolean[] bVal = new boolean[1];
        this.checkAvailable(1);
        this.currPos = UDRLMInfo.readBoolean(this.dataPtr, bVal, this.currPos);
        return bVal[0];
    }

    @Override
    public Blob readBlob() throws SQLException {
        byte[] lo = new byte[72];
        this.checkAvailable(72);
        this.currPos = UDRLMInfo.readBlob(this.dataPtr, lo, this.currPos);
        IfxDirectBlob b = new IfxDirectBlob(this.dbaMonitor, this.conn, lo);
        if (b.isNull()) {
            this.isNull = true;
            return null;
        }
        return (Blob)b.toObject();
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        throw GenErr.sqle(-9438, "readBinaryStream");
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        byte[] ba = new byte[22];
        this.checkAvailable(22);
        this.alignPosition(2);
        this.doBigDecRead(ba);
        Decimal d = Decimal.dec_tToJava((byte[])ba);
        if (d.isNull()) {
            this.isNull = true;
            return null;
        }
        BigDecimal dec = d.numericValue();
        return dec;
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        throw GenErr.sqle(-9438, "readAsciiStream");
    }

    @Override
    public Array readArray() throws SQLException {
        throw GenErr.sqle(-9438, "readArray");
    }

    public int length() {
        return this.datalength;
    }

    public IfxUDTInfo getUDTInfo(int xid) throws SQLException {
        throw GenErr.sqle(-9438, "getUDTInfo");
    }

    public IfxUDTInfo getUDTInfo(String name, String owner) throws SQLException {
        throw GenErr.sqle(-9438, "getUDTInfo");
    }

    public int getCurrentPosition() {
        return this.currPos;
    }

    public boolean getAutoAlignment() {
        return this.autoAlignment;
    }

    public int available() {
        return this.datalength - this.currPos;
    }

    public long readPointer() {
        long[] ptrVal = new long[1];
        System.out.println("In JVTI's readPointer");
        this.currPos = UDRLMInfo.readPointer(this.dataPtr, ptrVal, this.currPos);
        if (ptrVal[0] == 0L) {
            this.isNull = true;
        }
        return ptrVal[0];
    }

    @Override
    public URL readURL() throws SQLException {
        throw GenErr.sqle(-9438, "readURL");
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw GenErr.sqle(-9439, "readRowId");
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        throw GenErr.sqle(-9439, "readSQLXML");
    }

    @Override
    public String readNString() throws SQLException {
        throw GenErr.sqle(-9439, "readNString");
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw GenErr.sqle(-9439, "readNClob");
    }
}

