/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxDataPointer;
import com.informix.jdbc.IfxDirectBlob;
import com.informix.jdbc.IfxDirectClob;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.Decimal;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import informix.jvp.JVP;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class IfmxSQLOutStream
implements IfmxUDTSQLOutput,
SQLOutput {
    long dataPtr = 0L;
    int currPos = 0;
    DBAMonitor dbaMonitor = null;
    long conn = 0L;
    boolean autoAlignment = true;

    public IfmxSQLOutStream(IfxDataPointer dp) {
        this.conn = 0L;
        this.dataPtr = dp.bufp;
    }

    public IfmxSQLOutStream(DBAMonitor mon, long blobConn, long ptr) {
        this.dbaMonitor = mon;
        this.conn = blobConn;
        this.dataPtr = ptr;
    }

    void alignPosition(int alignment) {
        if (!this.autoAlignment) {
            return;
        }
        int skip = (this.currPos + alignment - 1 & ~(alignment - 1)) - this.currPos;
        if (skip <= 0) {
            return;
        }
        JVP.traceable.tracePrint("JVP.JDBC", 4, "alignPosition() at position " + Integer.toString(this.currPos) + " skipping next " + Integer.toString(skip) + " bytes");
        this.currPos += skip;
    }

    @Override
    public void writeTimestamp(Timestamp x) throws SQLException {
        Decimal dec = JavaToIfxType.convertTimestampToDecimal((Timestamp)x);
        short qual = 4365;
        this.writeShort(qual);
        byte[] ba = dec.javaToDec_t();
        this.alignPosition(2);
        this.writeTimestamptoBytes(ba, ba.length);
    }

    void writeTimestamptoBytes(byte[] x, int max) throws SQLException {
        this.currPos = UDRLMInfo.writeTimestamptoBytes(this.dataPtr, x, max, this.currPos);
    }

    @Override
    public void writeTime(Time x) throws SQLException {
        this.writeTimestamp(new Timestamp(x.getTime()));
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        throw GenErr.sqle(-9438, "writeStruct");
    }

    @Override
    public void writeString(String x) throws SQLException {
        throw GenErr.sqle(-9438, "writeString(String)");
    }

    public void writeString(String x, int length) throws SQLException {
        int len = x.length();
        if (len > length) {
            x = x.substring(0, length);
        }
        if (len < length) {
            char[] c = new char[length - len];
            for (int i = 0; i < length - len; ++i) {
                c[i] = 32;
            }
            x = new StringBuffer(x).append(c).toString();
        }
        this.currPos = UDRLMInfo.writeString(this.dataPtr, x, length, this.currPos);
    }

    @Override
    public void writeShort(short x) throws SQLException {
        this.alignPosition(2);
        this.currPos = UDRLMInfo.writeShort(this.dataPtr, x, this.currPos);
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        throw GenErr.sqle(-9438, "writeRef");
    }

    @Override
    public void writeObject(SQLData x) throws SQLException {
        throw GenErr.sqle(-9438, "writeObject");
    }

    @Override
    public void writeLong(long x) throws SQLException {
        byte[] ba = JavaToIfxType.JavaToIfxLongInt((long)x);
        this.alignPosition(4);
        this.currPos = UDRLMInfo.writeLong(this.dataPtr, ba, this.currPos);
    }

    public void writeInterval(Interval interval) throws SQLException {
        this.writeShort(interval.getQualifier());
        Decimal dec = interval instanceof IntervalYM ? JavaToIfxType.convertIntervalToDecimal((IntervalYM)((IntervalYM)interval)) : JavaToIfxType.convertIntervalToDecimal((IntervalDF)((IntervalDF)interval));
        byte[] ba = dec.javaToDec_t();
        this.alignPosition(2);
        this.doBigDecWrite(ba);
    }

    void doBigDecWrite(byte[] data) {
        this.currPos = UDRLMInfo.writeBigDecimal(this.dataPtr, data, this.currPos);
    }

    @Override
    public void writeInt(int x) throws SQLException {
        this.alignPosition(4);
        this.currPos = UDRLMInfo.writeInt(this.dataPtr, x, this.currPos);
    }

    @Override
    public void writeFloat(float x) throws SQLException {
        this.alignPosition(4);
        this.currPos = UDRLMInfo.writeFloat(this.dataPtr, x, this.currPos);
    }

    @Override
    public void writeDouble(double x) throws SQLException {
        this.alignPosition(8);
        this.currPos = UDRLMInfo.writeDouble(this.dataPtr, x, this.currPos);
    }

    @Override
    public void writeDate(Date x) throws SQLException {
        byte[] ba = JavaToIfxType.JavaToIfxDate((Date)x);
        this.alignPosition(4);
        this.currPos = UDRLMInfo.writeDate(this.dataPtr, ba, this.currPos);
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        byte[] ba = ((IfxDirectClob)x).toIfx();
        this.currPos = UDRLMInfo.writeBlob(this.dataPtr, ba, this.currPos);
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        throw GenErr.sqle(-9438, "writeCharacterStream");
    }

    @Override
    public void writeBytes(byte[] x) throws SQLException {
        throw GenErr.sqle(-9438, "writeBytes(byte[]");
    }

    public void writeBytes(byte[] x, int length) throws SQLException {
        if (x == null) {
            throw new NullPointerException();
        }
        this.currPos = UDRLMInfo.writeBytes(this.dataPtr, x, length, this.currPos);
    }

    @Override
    public void writeByte(byte x) throws SQLException {
        byte[] ba = new byte[]{x};
        this.currPos = UDRLMInfo.writeBytes(this.dataPtr, ba, 1, this.currPos);
    }

    @Override
    public void writeBoolean(boolean x) throws SQLException {
        this.currPos = UDRLMInfo.writeBoolean(this.dataPtr, x, this.currPos);
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        byte[] ba = ((IfxDirectBlob)x).toIfx();
        this.currPos = UDRLMInfo.writeBlob(this.dataPtr, ba, this.currPos);
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        throw GenErr.sqle(-9438, "writeBinaryStream");
    }

    @Override
    public void writeBigDecimal(BigDecimal x) throws SQLException {
        byte[] ba = new Decimal(x).javaToDec_t();
        this.alignPosition(2);
        this.doBigDecWrite(ba);
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        throw GenErr.sqle(-9438, "writeAsciiStream");
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        throw GenErr.sqle(-9438, "writeArray");
    }

    public int length() {
        return this.currPos;
    }

    public void setAutoAlignment(boolean value) {
        this.autoAlignment = value;
    }

    public boolean getAutoAlignment() {
        return this.autoAlignment;
    }

    public void skipBytes(int len) throws SQLException {
        if (len <= 0) {
            return;
        }
        this.currPos += len;
    }

    public int getCurrentPosition() {
        return this.currPos;
    }

    public void setCurrentPosition(int position) throws SQLException {
        if (position < 0) {
            throw GenErr.sqle(-79772);
        }
        this.currPos = position;
    }

    public int available() {
        return 0;
    }

    public IfxUDTInfo getUDTInfo(int xid) throws SQLException {
        return null;
    }

    public IfxUDTInfo getUDTInfo(String name, String owner) throws SQLException {
        return null;
    }

    public void writePointer(long x) throws SQLException {
        this.currPos = UDRLMInfo.writePointer(this.dataPtr, x, this.currPos);
    }

    @Override
    public void writeURL(URL x) throws SQLException {
        throw GenErr.sqle(-9438, "writeURL");
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
        throw GenErr.sqle(-9439, "writeSQLXML");
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
        throw GenErr.sqle(-9439, "RowId");
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
        throw GenErr.sqle(-9439, "writeNClob");
    }

    @Override
    public void writeNString(String x) throws SQLException {
        throw GenErr.sqle(-9439, "writeNString");
    }
}

