/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.Interval;
import informix.jvp.dbapplet.impl.GenErr;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.StringTokenizer;

public class IfmxTextInStream
implements IfmxUDTSQLInput,
SQLInput {
    private String origInput;
    private String newDelimiters = null;
    private StringTokenizer tokenizer;
    private int inLength;
    private boolean isNull = true;
    private int offset = 0;
    private boolean autoAlignment = false;
    private static String StringExceedsLength = "Input exceeds Length for the specified type";
    private static String StringFinished = "End of the String reached";
    private static String StringInvalid = "Invalid input value";
    private static String StringNotSupported = "Type not supported";

    public IfmxTextInStream(String str) {
        this.origInput = new String(str);
        this.inLength = str.length();
        this.tokenizer = new StringTokenizer(str);
    }

    private String getNextToken() throws SQLException {
        if (!this.tokenizer.hasMoreTokens()) {
            this.isNull = true;
            throw GenErr.sqle(-79772, this.origInput);
        }
        this.isNull = false;
        if (this.newDelimiters != null) {
            String nextToken = this.tokenizer.nextToken(this.newDelimiters);
            this.newDelimiters = null;
            return nextToken;
        }
        return this.tokenizer.nextToken();
    }

    public void setDelimiters(String delimiters) {
        this.newDelimiters = delimiters;
    }

    @Override
    public boolean wasNull() {
        return this.isNull;
    }

    public void skipBytes(int len) throws SQLException {
    }

    public void setCurrentPosition(int position) throws SQLException {
    }

    public void setAutoAlignment(boolean value) {
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        String val = this.getNextToken();
        if (val.indexOf(32) < 0) {
            val = val + " " + this.getNextToken();
        }
        try {
            return Timestamp.valueOf(val);
        }
        catch (Exception e) {
            throw GenErr.sqle(-486, "java.sql.Timestamp");
        }
    }

    @Override
    public Time readTime() throws SQLException {
        String val = this.getNextToken();
        try {
            return Time.valueOf(val);
        }
        catch (Exception e) {
            throw GenErr.sqle(-486, "java.sql.Time");
        }
    }

    @Override
    public String readString() throws SQLException {
        return this.getNextToken();
    }

    public String readString(int maxlen) throws SQLException {
        String str = this.getNextToken();
        int len = str.length();
        if (len <= maxlen) {
            return str;
        }
        return str.substring(0, maxlen);
    }

    @Override
    public short readShort() throws SQLException {
        String val = this.getNextToken();
        try {
            return Integer.valueOf(val).shortValue();
        }
        catch (Exception e) {
            throw GenErr.sqle(-486, "short");
        }
    }

    @Override
    public Ref readRef() throws SQLException {
        throw GenErr.sqle(-9438, "readRef");
    }

    @Override
    public Object readObject() throws SQLException {
        throw GenErr.sqle(-9438, "readObject");
    }

    @Override
    public long readLong() throws SQLException {
        String val = this.getNextToken();
        try {
            return Long.valueOf(val);
        }
        catch (Exception e) {
            throw GenErr.sqle(-486, "long");
        }
    }

    public Interval readInterval() throws SQLException {
        throw GenErr.sqle(-9438, "readInterval");
    }

    @Override
    public int readInt() throws SQLException {
        String val = this.getNextToken();
        try {
            return Integer.valueOf(val);
        }
        catch (Exception e) {
            throw GenErr.sqle(-486, "int");
        }
    }

    @Override
    public float readFloat() throws SQLException {
        String val = this.getNextToken();
        try {
            return Float.valueOf(val).floatValue();
        }
        catch (Exception e) {
            throw GenErr.sqle(-486, "float");
        }
    }

    @Override
    public double readDouble() throws SQLException {
        String val = this.getNextToken();
        try {
            return Double.valueOf(val);
        }
        catch (Exception e) {
            throw GenErr.sqle(-486, "double");
        }
    }

    @Override
    public Date readDate() throws SQLException {
        String val = this.getNextToken();
        try {
            return Date.valueOf(val);
        }
        catch (Exception e) {
            throw GenErr.sqle(-486, "java.sql.Date");
        }
    }

    @Override
    public Clob readClob() throws SQLException {
        throw GenErr.sqle(-9438, "readClob");
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        throw GenErr.sqle(-9438, "readCharacterStream");
    }

    @Override
    public byte[] readBytes() throws SQLException {
        throw GenErr.sqle(-9438, "readBytes()");
    }

    public byte[] readBytes(int maxlen) throws SQLException {
        throw GenErr.sqle(-9438, "readBytes(length)");
    }

    @Override
    public byte readByte() throws SQLException {
        throw GenErr.sqle(-9438, "readByte");
    }

    @Override
    public boolean readBoolean() throws SQLException {
        String val = this.getNextToken();
        if (val.length() > 1) {
            throw GenErr.sqle(-486, "boolean");
        }
        switch (val.charAt(0)) {
            case 'T': 
            case 't': {
                return true;
            }
            case 'F': 
            case 'f': {
                return false;
            }
        }
        throw GenErr.sqle(-486, "boolean");
    }

    @Override
    public Blob readBlob() throws SQLException {
        throw GenErr.sqle(-9438, "readBlob");
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        throw GenErr.sqle(-9438, "readBinaryStream");
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        String val = this.getNextToken();
        return new BigDecimal(val);
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        throw GenErr.sqle(-9438, "readAsciiStream");
    }

    @Override
    public Array readArray() throws SQLException {
        throw GenErr.sqle(-9438, "readArray");
    }

    public int length() {
        return this.inLength;
    }

    public IfxUDTInfo getUDTInfo(int xid) throws SQLException {
        throw GenErr.sqle(-9438, "getUDTInfo");
    }

    public IfxUDTInfo getUDTInfo(String name, String owner) throws SQLException {
        throw GenErr.sqle(-9438, "getUDTInfo");
    }

    public int getCurrentPosition() {
        return 0;
    }

    public boolean getAutoAlignment() {
        return this.autoAlignment;
    }

    public int available() {
        return this.tokenizer.countTokens();
    }

    @Override
    public URL readURL() throws SQLException {
        throw GenErr.sqle(-9438, "readURL");
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw GenErr.sqle(-9439, "readRowId");
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        throw GenErr.sqle(-9439, "readSQLXML");
    }

    @Override
    public String readNString() throws SQLException {
        throw GenErr.sqle(-9439, "readNString");
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw GenErr.sqle(-9439, "readNClob");
    }
}

