/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.Interval;
import informix.jvp.dbapplet.impl.GenErr;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class IfmxTextOutStream
implements IfmxUDTSQLOutput,
SQLOutput {
    private StringBuffer outBuf;
    private boolean init = false;

    public IfmxTextOutStream(StringBuffer out) {
        this.outBuf = out;
    }

    private void addSpace() {
        if (this.init) {
            this.outBuf.append(" ");
        } else {
            this.init = true;
        }
    }

    @Override
    public void writeTimestamp(Timestamp x) throws SQLException {
        this.addSpace();
        this.outBuf.append(x);
    }

    @Override
    public void writeTime(Time x) throws SQLException {
        this.addSpace();
        this.outBuf.append(x);
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        throw GenErr.sqle(-9438, "writeStruct");
    }

    @Override
    public void writeString(String x) throws SQLException {
        this.addSpace();
        this.outBuf.append(x);
    }

    public void writeString(String x, int length) throws SQLException {
        this.addSpace();
        int len = x.length();
        if (len <= length) {
            this.outBuf.append(x);
        } else {
            this.outBuf.append(x.substring(0, length));
        }
    }

    @Override
    public void writeShort(short x) throws SQLException {
        this.addSpace();
        this.outBuf.append(x);
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        throw GenErr.sqle(-9438, "writeRef");
    }

    @Override
    public void writeObject(SQLData x) throws SQLException {
        throw GenErr.sqle(-9438, "writeObject");
    }

    @Override
    public void writeLong(long x) throws SQLException {
        this.addSpace();
        this.outBuf.append(x);
    }

    public void writeInterval(Interval x) throws SQLException {
        throw GenErr.sqle(-9438, "writeInterval");
    }

    @Override
    public void writeInt(int x) throws SQLException {
        this.addSpace();
        this.outBuf.append(x);
    }

    @Override
    public void writeFloat(float x) throws SQLException {
        this.addSpace();
        this.outBuf.append(x);
    }

    @Override
    public void writeDouble(double x) throws SQLException {
        this.addSpace();
        this.outBuf.append(x);
    }

    @Override
    public void writeDate(Date x) throws SQLException {
        this.addSpace();
        this.outBuf.append(x);
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        throw GenErr.sqle(-9438, "writeClob");
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        throw GenErr.sqle(-9438, "writeCharacterStream");
    }

    @Override
    public void writeBytes(byte[] x) throws SQLException {
        throw GenErr.sqle(-9438, "writeBytes");
    }

    public void writeBytes(byte[] x, int length) throws SQLException {
        throw GenErr.sqle(-9438, "writeBytes(length)");
    }

    @Override
    public void writeByte(byte x) throws SQLException {
        this.addSpace();
        this.outBuf.append(x);
    }

    @Override
    public void writeBoolean(boolean x) throws SQLException {
        this.addSpace();
        if (x) {
            this.outBuf.append("t");
        } else if (!x) {
            this.outBuf.append("f");
        }
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        throw GenErr.sqle(-9438, "writeBlob");
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        throw GenErr.sqle(-9438, "writeBinaryStream");
    }

    @Override
    public void writeBigDecimal(BigDecimal x) throws SQLException {
        this.addSpace();
        this.outBuf.append(x);
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        throw GenErr.sqle(-9438, "writeAsciiStream");
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        throw GenErr.sqle(-9438, "writeArray");
    }

    public int length() {
        return this.outBuf.length();
    }

    public void setAutoAlignment(boolean value) {
    }

    public boolean getAutoAlignment() {
        return false;
    }

    public void skipBytes(int len) throws SQLException {
    }

    public int getCurrentPosition() {
        return 0;
    }

    public void setCurrentPosition(int position) throws SQLException {
    }

    public int available() {
        return 0;
    }

    public IfxUDTInfo getUDTInfo(int xid) throws SQLException {
        return null;
    }

    public IfxUDTInfo getUDTInfo(String name, String owner) throws SQLException {
        return null;
    }

    @Override
    public void writeURL(URL x) throws SQLException {
        throw GenErr.sqle(-9438, "writeURL");
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
        throw GenErr.sqle(-9439, "writeSQLXML");
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
        throw GenErr.sqle(-9439, "RowId");
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
        throw GenErr.sqle(-9439, "writeNClob");
    }

    @Override
    public void writeNString(String x) throws SQLException {
        throw GenErr.sqle(-9439, "writeNString");
    }
}

