/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxDirectBlobStream;
import com.informix.jdbc.IfxDirectConnection;
import com.informix.jdbc.IfxObject;
import com.informix.util.IfxErrMsg;
import informix.jvp.JVP;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.SAPIRequestFreeList;
import informix.jvp.dbapplet.impl.SAPIRequestImpl;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Locale;

public class IfxDirectBlob
extends IfxObject
implements Blob {
    public long connHandle;
    public DBAMonitor dbaMonitor;
    public byte[] blob;
    protected long blobLength;

    public IfxDirectBlob() throws SQLException {
    }

    public IfxDirectBlob(DBAMonitor mon, long conn, byte[] lo) throws SQLException {
        this.fromIfx(mon, conn, lo);
    }

    protected void checkError(SAPIRequestImpl req) throws SQLException {
        int rc = req.getStatus();
        switch (rc) {
            case -4: 
            case -3: 
            case -1: {
                throw GenErr.sqle(-9455);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        long retval = 0L;
        if (this.blobLength >= 0L) {
            return this.blobLength;
        }
        long blobHandle = UDRLMInfo.getArrayRef(this.blob);
        try {
            SAPIRequestImpl req;
            SAPIRequestFreeList sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            try {
                req = sapiFreeList.getFromFreeList();
            }
            catch (Exception e) {
                throw (SQLException)e;
            }
            req.clearArgs();
            req.setFuncid(14);
            req.setArgData(0, this.connHandle);
            req.setArgData(1, blobHandle);
            JVP.traceable.tracePrint("JVP.BLOB", 3, "read blob length");
            this.dbaMonitor.notifySAPICall(req);
            this.dbaMonitor.waitSAPICallDone(req);
            retval = req.getRetPtr();
            this.checkError(req);
            sapiFreeList.returnToFreeList(req);
            if (retval < 0L) {
                throw GenErr.sqle(-9456);
            }
            this.blobLength = retval;
        }
        finally {
            UDRLMInfo.releaseArrayRef(this.blob, blobHandle);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long readBlobSAPI(long conn, long pos, long length, byte[] buf) throws SQLException {
        long retval;
        SAPIRequestImpl req;
        SAPIRequestFreeList sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
        long blobHandle = UDRLMInfo.getArrayRef(this.blob);
        long bufHandle = UDRLMInfo.getArrayRef(buf);
        try {
            req = sapiFreeList.getFromFreeList();
        }
        catch (Exception e) {
            throw (SQLException)e;
        }
        try {
            req.clearArgs();
            req.setFuncid(15);
            req.setArgData(0, this.connHandle);
            req.setArgData(1, blobHandle);
            req.setArgData(2, pos);
            req.setArgData(3, length);
            req.setArgData(4, bufHandle);
            JVP.traceable.tracePrint("JVP.BLOB", 4, "read blob: " + conn + " " + this.blob + " " + pos + " " + length + " " + bufHandle);
            this.dbaMonitor.notifySAPICall(req);
            this.dbaMonitor.waitSAPICallDone(req);
            retval = req.getRetPtr();
            this.checkError(req);
            sapiFreeList.returnToFreeList(req);
        }
        finally {
            UDRLMInfo.releaseArrayRef(this.blob, blobHandle);
            UDRLMInfo.releaseArrayRef(buf, bufHandle);
        }
        return retval;
    }

    protected long readBlob(long pos, long length, byte[] buf) throws SQLException {
        return this.readBlobSAPI(this.connHandle, pos, length, buf);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] result = new byte[length];
        long len = this.readBlob(pos, length, result);
        if (len < 0L) {
            throw GenErr.sqle(-9457);
        }
        if (len < (long)length) {
            byte[] trunc = new byte[(int)len];
            System.arraycopy(result, 0, trunc, 0, (int)len);
            return trunc;
        }
        return result;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new IfxDirectBlobStream(this);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        InputStream s = this.getBinaryStream();
        int next = -1;
        int current = 0;
        long pos = 0L;
        try {
            if (s.skip(start) != start) {
                throw GenErr.sqle(-9458);
            }
            pos = start;
            while (true) {
                if ((next = s.read()) == -1) {
                    return -1L;
                }
                if ((byte)next != pattern[current]) {
                    current = 0;
                } else if (++current >= pattern.length) {
                    return pos - (long)pattern.length + 1L;
                }
                ++pos;
            }
        }
        catch (Exception ex) {
            throw GenErr.sqle(-9459, ex.toString());
        }
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        byte[] bpat = pattern.getBytes(0L, (int)pattern.length());
        return this.position(bpat, start);
    }

    public byte[] toIfx() {
        return this.blob;
    }

    public void fromIfx(DBAMonitor mon, long conn, byte[] lo) {
        this.connHandle = conn;
        this.dbaMonitor = mon;
        this.blob = lo;
        if (lo == null) {
            this.nullify();
            this.blobLength = -1L;
        } else {
            this.unnullify();
            this.blobLength = -1L;
        }
        if (this.isNull()) {
            JVP.traceable.tracePrint("JVP.BLOB", 3, "create null blob" + conn + " " + this.blob);
        } else {
            JVP.traceable.tracePrint("JVP.BLOB", 3, "create new blob" + conn + " " + this.blob);
        }
    }

    public void fromInputStream(InputStream s, int length) throws SQLException {
        this.fromBinaryStream(s, length);
    }

    public void fromBinaryStream(InputStream s, int length) throws SQLException {
        if (!(this.conn instanceof IfxDirectConnection)) {
            throw GenErr.sqle(-9460);
        }
        this.fromBinaryStream((IfxDirectConnection)this.conn, s, length);
    }

    public void fromBytes(byte[] buf) throws SQLException {
        if (!(this.conn instanceof IfxDirectConnection)) {
            throw GenErr.sqle(-9460);
        }
        this.fromBytes((IfxDirectConnection)this.conn, buf);
    }

    public void fromBlob(Blob b) throws SQLException {
        if (b instanceof IfxDirectBlob) {
            IfxDirectBlob db = (IfxDirectBlob)b;
            this.fromIfx(db.dbaMonitor, db.connHandle, db.blob);
        } else {
            this.fromBytes((IfxDirectConnection)this.conn, b.getBytes(0L, (int)b.length()));
        }
    }

    public byte[] toBytes() throws SQLException {
        return this.getBytes(0L, (int)this.length());
    }

    public InputStream toBinaryStream() throws SQLException {
        return this.getBinaryStream();
    }

    public Object toObject() throws SQLException {
        return this.makeCopy();
    }

    public Blob toBlob() throws SQLException {
        return (Blob)this.makeCopy();
    }

    public IfxObject makeCopy() throws SQLException {
        IfxDirectBlob b = new IfxDirectBlob();
        b.fromIfx(this.dbaMonitor, this.connHandle, this.blob);
        return b;
    }

    public void fromBinaryStream(IfxDirectConnection jconn, InputStream is, int length) throws SQLException {
        int len;
        byte[] buf = new byte[length];
        this.fromIfx(jconn.getDBAMonitor(), SAPIRequestImpl.getMiConn(jconn.getConnHandle()), null);
        try {
            len = is.read(buf);
        }
        catch (Exception ex) {
            throw GenErr.sqle(-9459, ex.toString());
        }
        if (len != length) {
            throw GenErr.sqle(-9461, String.valueOf(length));
        }
        this.createSAPIBlob(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSAPIBlob(byte[] buf) throws SQLException {
        SAPIRequestImpl req;
        SAPIRequestFreeList sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
        try {
            req = sapiFreeList.getFromFreeList();
        }
        catch (Exception e) {
            throw (SQLException)e;
        }
        this.blob = new byte[72];
        long blobHandle = UDRLMInfo.getArrayRef(this.blob);
        long bufHandle = UDRLMInfo.getArrayRef(buf);
        try {
            req.clearArgs();
            req.setFuncid(22);
            req.setArgData(0, this.connHandle);
            req.setArgData(1, blobHandle);
            req.setArgData(2, bufHandle);
            req.setArgData(3, buf.length);
            JVP.traceable.tracePrint("JVP.BLOB", 1, "create new blob: " + this.connHandle + " " + blobHandle);
            this.dbaMonitor.notifySAPICall(req);
            this.dbaMonitor.waitSAPICallDone(req);
            this.checkError(req);
            sapiFreeList.returnToFreeList(req);
            this.unnullify();
        }
        finally {
            UDRLMInfo.releaseArrayRef(this.blob, blobHandle);
            UDRLMInfo.releaseArrayRef(buf, bufHandle);
        }
    }

    public void fromBytes(IfxDirectConnection jconn, byte[] buf) throws SQLException {
        int len = buf.length;
        this.fromIfx(jconn.getDBAMonitor(), SAPIRequestImpl.getMiConn(jconn.getConnHandle()), null);
        this.createSAPIBlob(buf);
    }

    public String toString() {
        return "<SBlob Data>";
    }

    @Override
    public int setBytes(long pos, byte[] str) throws SQLException {
        JVP.traceable.tracePrint("JVP.BLOB", 1, "IfxDirectBlob:setBytes(long,byte[]) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectBlob:setBytes(long,byte[])", (Locale)Locale.getDefault());
    }

    @Override
    public int setBytes(long pos, byte[] str, int offset, int len) throws SQLException {
        JVP.traceable.tracePrint("JVP.BLOB", 1, "IfxDirectBlob:setBytes(long,byte[],int,int) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectBlob:setBytes(long,byte[],int,int)", (Locale)Locale.getDefault());
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        JVP.traceable.tracePrint("JVP.BLOB", 1, "IfxDirectBlob:setBinaryStream(long) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectBlob:setBinaryStream(long)", (Locale)Locale.getDefault());
    }

    @Override
    public void truncate(long size) throws SQLException {
        JVP.traceable.tracePrint("JVP.BLOB", 1, "IfxDirectBlob:truncate(long) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectBlob:truncate(long)", (Locale)Locale.getDefault());
    }

    @Override
    public InputStream getBinaryStream(long size1, long size2) throws SQLException {
        throw GenErr.sqle(-9438, "getBinaryStream");
    }

    @Override
    public void free() throws SQLException {
        throw GenErr.sqle(-9438, "free");
    }
}

