/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxDirectBlob;
import informix.jvp.JVP;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class IfxDirectBlobStream
extends InputStream {
    protected static final int BLOB_STREAM_BUF_SIZE = 4096;
    protected long pos;
    protected byte[] buf;
    protected int last;
    protected int index;
    protected IfxDirectBlob blob;

    public IfxDirectBlobStream(IfxDirectBlob b) {
        this.blob = b;
        this.pos = 0L;
        this.buf = new byte[4096];
        this.index = 0;
        this.last = -1;
    }

    @Override
    public int read() throws IOException {
        if (this.index > this.last) {
            long len;
            JVP.traceable.tracePrint("JVP.BLOB", 3, "read blob into stream, max size =4096");
            try {
                len = this.blob.readBlob(this.pos, 4096L, this.buf);
            }
            catch (SQLException ex) {
                len = -1L;
            }
            if (len < 0L) {
                throw new IOException("Cannot read blob");
            }
            if (len == 0L) {
                return -1;
            }
            this.pos += len;
            this.index = 0;
            this.last = (int)len - 1;
        }
        int result = this.buf[this.index] & 0xFF;
        ++this.index;
        return result;
    }
}

