/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxDirectBlob;
import com.informix.jdbc.IfxDirectClobReader;
import com.informix.jdbc.IfxDirectConnection;
import com.informix.jdbc.IfxObject;
import com.informix.util.IfxErrMsg;
import informix.jvp.JVP;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.impl.GenErr;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Locale;

public class IfxDirectClob
extends IfxDirectBlob
implements Clob {
    public IfxDirectClob() throws SQLException {
    }

    public IfxDirectClob(DBAMonitor mon, long conn, byte[] lo) throws SQLException {
        super(mon, conn, lo);
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        byte[] buf = this.getBytes(pos, length);
        return new String(buf);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new IfxDirectClobReader(this);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.getBinaryStream();
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        return this.position(searchstr.getBytes(), start);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        return this.position((IfxDirectBlob)((Object)searchstr), start);
    }

    public InputStream toAsciiStream() throws SQLException {
        return this.getAsciiStream();
    }

    public void fromAsciiStream(IfxDirectConnection jconn, InputStream is, int length) throws SQLException {
        this.fromBinaryStream(jconn, is, length);
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        try {
            String res = this.getSubString(0L, (int)this.length());
            return res;
        }
        catch (Exception ex) {
            JVP.log.log("JVP.CLOB -- cannot convert clob to string");
            return null;
        }
    }

    public void fromClob(Clob c) throws SQLException {
        if (c instanceof IfxDirectClob) {
            IfxDirectClob dc = (IfxDirectClob)c;
            this.fromIfx(dc.dbaMonitor, dc.connHandle, dc.blob);
        } else {
            InputStream cis = c.getAsciiStream();
            this.fromAsciiStream((IfxDirectConnection)this.conn, c.getAsciiStream(), (int)c.length());
        }
    }

    public Clob toClob() throws SQLException {
        return (Clob)this.makeCopy();
    }

    public void fromString(IfxDirectConnection jconn, String s) throws SQLException {
        byte[] buf = s.getBytes();
        this.fromBytes(jconn, buf);
    }

    @Override
    public IfxObject makeCopy() throws SQLException {
        IfxDirectClob b = new IfxDirectClob();
        b.fromIfx(this.dbaMonitor, this.connHandle, this.blob);
        return b;
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        JVP.traceable.tracePrint("JVP.BLOB", 1, "IfxDirectClob:setString(long,String) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectClob:setString(long,String)", (Locale)Locale.getDefault());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        JVP.traceable.tracePrint("JVP.BLOB", 1, "IfxDirectClob:setString(long,String,int,int) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectClob:setString(long,String,int,int)", (Locale)Locale.getDefault());
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        JVP.traceable.tracePrint("JVP.BLOB", 1, "IfxDirectClob:setAsciiStream(long) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectClob:setAsciiStream(long)", (Locale)Locale.getDefault());
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        JVP.traceable.tracePrint("JVP.BLOB", 1, "IfxDirectClob:setCharacterStream(long) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectClob:setCharacterStream(long)", (Locale)Locale.getDefault());
    }

    @Override
    public Reader getCharacterStream(long x1, long x2) throws SQLException {
        throw GenErr.sqle(-9439, "getCharacterStream");
    }

    @Override
    public void free() throws SQLException {
        throw GenErr.sqle(-9439, "free");
    }
}

