/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxDirectClob;
import informix.jvp.JVP;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class IfxDirectClobReader
extends Reader {
    protected static final int BLOB_STREAM_BUF_SIZE = 1024;
    protected long pos;
    protected byte[] buf;
    protected int last;
    protected int index;
    protected IfxDirectClob clob;

    public IfxDirectClobReader(IfxDirectClob b) {
        this.clob = b;
        this.pos = 0L;
        this.buf = new byte[1024];
        this.index = 0;
        this.last = -1;
    }

    @Override
    public int read() throws IOException {
        if (this.index > this.last) {
            long len;
            JVP.traceable.tracePrint("JVP.BLOB", 3, "read clob into reader, max size =1024");
            try {
                len = this.clob.readBlob(this.pos, 1024L, this.buf);
            }
            catch (SQLException ex) {
                len = -1L;
            }
            if (len < 0L) {
                throw new IOException("Cannot read clob");
            }
            if (len == 0L) {
                return -1;
            }
            this.pos += len;
            this.index = 0;
            this.last = (int)len - 1;
        }
        byte result = this.buf[this.index];
        ++this.index;
        return result;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = 0;
        int num = -1;
        while (i < len) {
            int ch;
            try {
                ch = this.read();
            }
            catch (Exception e) {
                throw new IOException("Cannot read clob");
            }
            if (ch == -1) {
                return num;
            }
            cbuf[i] = (char)ch;
            ++i;
            ++num;
        }
        return num;
    }

    @Override
    public void close() throws IOException {
    }
}

