/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDirectProtocol;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.udr.UDREnv;
import com.informix.udr.UDRManager;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import informix.jvp.DBA;
import informix.jvp.JVP;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.impl.DBAMonitorImpl;
import informix.jvp.dbapplet.impl.DBAThreadImpl;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.SAPIRequestFreeList;
import informix.jvp.dbapplet.impl.SAPIRequestImpl;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import informix.jvp.dbapplet.impl.UDRDBAManagerImpl;
import informix.jvp.dbapplet.impl.UDREnvImpl;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import informix.jvp.impl.SemaphoreImpl;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;

public class IfxDirectConnection
extends IfxSqliConnect
implements IfxConnection,
Runnable {
    private static Vector openConnections;
    private static boolean enabled;
    private static SemaphoreImpl lock;
    String dbDate = null;
    String glDate = null;
    String dbCentury = null;
    private boolean Internal_Trans = false;
    private boolean implBegin = false;
    private String clientLocale = null;
    private String URL = null;
    private String passwd = null;
    private int transFlag = 0;
    private String curDbName = null;
    private String traceZone = "JVP.JDBC";
    private DBAMonitor dbaMonitor = null;
    private DBAThreadImpl currThread = null;
    private DBAMonitor javaListenerMonitor;
    private long conn_handle = 0L;
    private boolean udrConnection = false;
    private SemaphoreImpl connLock = null;
    private IfxDirectConnection secondConn;
    Vector statementHandles = new Vector(1, 1);

    public static void shutdown() throws SQLException {
        Thread shut = new Thread(new IfxDirectConnection());
        shut.start();
    }

    public boolean isDirect() {
        return true;
    }

    public String getConnClassName() {
        return "com.informix.jdbc.IfxDirectConnection";
    }

    public String getclLocale() {
        if (this.clientLocale == null) {
            JVP.traceable.tracePrint(this.traceZone, 3, "IfxDirectConnect:clientLocale");
            String inStr = new String();
            try {
                UDREnv env = UDRManager.getUDREnv();
                if (env != null) {
                    inStr = env.getClientLocale();
                }
            }
            catch (Exception e) {
                JVP.log.log("Cannot get UDRManager environment");
                inStr = null;
            }
            if (inStr != null) {
                try {
                    char c;
                    String localeStr = new String();
                    String countrStr = new String();
                    int i = 0;
                    for (i = 0; i < inStr.length() && (c = inStr.charAt(i)) != '.'; ++i) {
                        if (i < 2) {
                            localeStr = localeStr + c;
                            continue;
                        }
                        countrStr = countrStr + c;
                    }
                    inStr = localeStr.toLowerCase() + countrStr.toUpperCase();
                }
                catch (Exception e) {
                    JVP.log.log("Cannot convert clLocale from UDRManager environment");
                    return super.getclLocale();
                }
            } else {
                inStr = super.getclLocale();
            }
            this.clientLocale = inStr;
        }
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnect:clLocale Client Locale = " + this.clientLocale);
        return this.clientLocale;
    }

    public IfxDirectConnection() throws SQLException {
    }

    @Override
    public void run() {
        if (openConnections == null) {
            return;
        }
        IfxDirectConnection c = null;
        try {
            JVP.traceable.tracePrint("JVP.JDBC", 3, "lock driver for shutdown");
            lock.P();
            enabled = false;
            lock.V();
            JVP.traceable.tracePrint("JVP.JDBC", 3, "close all open connectiins for shutdown: " + openConnections.size());
            while (openConnections.size() > 0) {
                c = (IfxDirectConnection)openConnections.elementAt(0);
                JVP.traceable.tracePrint("JVP.JDBC", 3, "shutdown open connection" + c);
                c.close();
                JVP.traceable.tracePrint("JVP.JDBC", 3, "shutdown complete " + c);
            }
        }
        catch (Exception ex) {
            JVP.log.log("Cannot close open connections " + openConnections.size() + ":" + ex.toString());
        }
    }

    public Connection getSecondConn() throws SQLException {
        if (this.secondConn != null) {
            this.secondConn.close();
        }
        this.secondConn = new IfxDirectConnection();
        this.secondConn.initIfxDirectConnection(this.URL, this.connInfo, null);
        JVP.traceable.tracePrint("JVP.JDBC", 3, "created secondary connection for Solano");
        return this.secondConn;
    }

    public IfxDirectConnection(String url, Properties prop) throws SQLException {
        this.initIfxDirectConnection(url, prop, null);
    }

    public IfxDirectConnection(String url, Properties prop, String reuse_dbname) throws SQLException {
        this.initIfxDirectConnection(url, prop, reuse_dbname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initIfxDirectConnection(String url, Properties prop, String reuse_dbname) throws SQLException {
        Integer i;
        Object ipAddr = null;
        Object portNo = null;
        String traceFile = null;
        String traceLevelString = null;
        String protoFile = null;
        String protoLevelString = null;
        short traceLevel = 0;
        short protoLevel = 0;
        Object envvar_list = null;
        boolean javaUDR = false;
        if (openConnections == null) {
            JVP.traceable.tracePrint("JVP.JDBC", 3, "initialize JDBC driver info");
            openConnections = new Vector();
            enabled = true;
            lock = new SemaphoreImpl(1);
        }
        if (!enabled) {
            throw GenErr.sqle(-9462, this);
        }
        this.URL = url;
        this.connInfo = prop;
        this.userName = this.connInfo.getProperty("USER");
        this.passwd = this.connInfo.getProperty("PASSWORD");
        this.dbName = this.connInfo.getProperty("DATABASE");
        if (this.dbName == null || this.dbName.equals("")) {
            this.dbName = reuse_dbname;
        }
        this.connLock = new SemaphoreImpl(1);
        JVP.traceable.tracePrint(this.traceZone, 1, "userName " + this.userName + ", dbName " + this.dbName + ", passwd " + this.passwd);
        protoFile = this.connInfo.getProperty("PROTOCOLTRACEFILE");
        protoLevelString = this.connInfo.getProperty("PROTOCOLTRACE");
        try {
            i = new Integer(protoLevelString);
            protoLevel = i.shortValue();
        }
        catch (NumberFormatException e) {
            protoLevel = 0;
        }
        this.protoTraceObj = protoFile != null && protoLevel > 0 ? new Trace((int)protoLevel, protoFile) : new Trace();
        traceFile = this.connInfo.getProperty("TRACEFILE");
        traceLevelString = this.connInfo.getProperty("TRACE");
        try {
            i = new Integer(traceLevelString);
            traceLevel = i.shortValue();
        }
        catch (NumberFormatException e) {
            traceLevel = 0;
        }
        this.traceObj = traceFile != null && traceLevel > 0 ? new Trace((int)traceLevel, traceFile) : new Trace();
        this.IfxToJdkEncodingTable = new Hashtable();
        this.IfxNoToJdkEncodingTable = new Hashtable();
        this.IfxToJdkLocaleTable = new Hashtable();
        this.SetPrimEVars();
        if (this.getdbLocale() == null) {
            this.setLocale("en_US");
            Locale loc = new Locale("en", "US");
            Locale.setDefault(loc);
        }
        JVP.traceable.tracePrint(this.traceZone, 5, "Instantiating the protocol object...");
        try {
            this.protoClassName = this.connInfo.getProperty("PROTOCOLCLASS");
            JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectConnect.protoName: " + this.protoClassName);
            this.proto = new IfxDirectProtocol(this);
        }
        catch (Exception e) {
            throw GenErr.sqle(-9463, e.toString(), this);
        }
        JVP.traceable.tracePrint(this.traceZone, 5, "Instantiated the protocol object... proto is " + this.proto);
        JVP.traceable.tracePrint(this.traceZone, 1, "userName " + this.userName + ", dbName " + this.dbName + ", passwd " + this.passwd);
        if (this.dbName != null || this.userName != null || this.passwd != null) {
            JVP.traceable.tracePrint(this.traceZone, 4, "going for solano");
            if (this.userName == null) {
                JVP.traceable.tracePrint(this.traceZone, 4, "userName is null: throw SQLException");
                throw GenErr.sqle(-9464, this);
            }
            if (this.dbName == null) {
                JVP.traceable.tracePrint(this.traceZone, 4, "dbName is null: throw SQLException");
                throw GenErr.sqle(-9465, this);
            }
            if (this.passwd == null) {
                JVP.traceable.tracePrint(this.traceZone, 4, "passwd is null: throw SQLException");
                throw GenErr.sqle(-9466, this);
            }
            JVP.traceable.tracePrint(this.traceZone, 1, "calling createSolanoConnection");
            this.createSolanoConnection(this.dbName, this.userName, this.passwd);
            this.udrConnection = false;
        } else {
            this.udrConnection = true;
            this.createUDRConnection();
        }
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnection returning");
        lock.P();
        if (enabled) {
            if (!this.udrConnection) {
                openConnections.addElement(this);
            }
        } else {
            try {
                this.close();
            }
            finally {
                lock.V();
                throw GenErr.sqle(-9467, this);
            }
        }
        lock.V();
    }

    public void lock() {
        JVP.traceable.tracePrint(this.traceZone, 5, "lock connection object: " + this);
        this.connLock.P();
    }

    public void unLock() {
        JVP.traceable.tracePrint(this.traceZone, 5, "unlock connection object " + this);
        this.connLock.V();
    }

    public void close() throws SQLException {
        if (this.secondConn != null) {
            this.secondConn.close(false);
        }
        this.close(false);
        DBA.removeSolanoEntry(Thread.currentThread());
    }

    protected void close(boolean gc) throws SQLException {
        if (!this.isOpen) {
            return;
        }
        if (this.Internal_Trans && this.implBegin && this.udrConnection) {
            try {
                this.proto.executeRollback();
            }
            catch (SQLException e) {
                JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnection:close.executeRollback() has failed");
            }
        }
        super.closeAllStatements();
        super.close();
        if (!gc || !this.udrConnection) {
            this.proto.executeCloseDatabase();
        }
        if (!this.udrConnection) {
            openConnections.removeElement(this);
        }
    }

    public void createUDRConnection() throws SQLException {
        try {
            this.currThread = (DBAThreadImpl)Thread.currentThread();
            this.dbaMonitor = this.currThread.getDBAMonitor();
        }
        catch (ClassCastException ex) {
            throw GenErr.sqle(-9468, this);
        }
        JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectConnect: Calling mi_open");
        this.conn_handle = this.mi_open(this.dbaMonitor, null, null, null);
        if (this.conn_handle == 0L) {
            throw GenErr.sqle(-9469, this);
        }
        JVP.traceable.tracePrint(this.traceZone, 4, "createUDRConnection mi_open returned");
    }

    public void createSolanoConnection(String dbName, String userName, String passwd) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        SAPIRequestImpl req = null;
        try {
            JVP.traceable.tracePrint(this.traceZone, 3, "IfxDirectConnect:createSolanoConnection: Create DBAMonitor");
            this.dbaMonitor = new DBAMonitorImpl("Solano Connection", 0L);
            JVP.traceable.tracePrint(this.traceZone, 4, "createSolanoConnection: get ListenerMonitor");
            this.javaListenerMonitor = UDRDBAContextImpl.getJavaListenerMonitor();
            if (this.javaListenerMonitor == null) {
                throw GenErr.sqle(-9470, this);
            }
            JVP.traceable.tracePrint(this.traceZone, 5, "javaListenerMonitor is " + this.javaListenerMonitor.toString());
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            req = sapiFreeList.getFromFreeList();
            req.setSappMon(this.dbaMonitor);
            JVP.traceable.tracePrint(this.traceZone, 4, "createSolanoConnection calling notifySAPICall");
            this.javaListenerMonitor.notifySAPICall(req);
            this.javaListenerMonitor.waitSAPICallDone(req);
            sapiFreeList.returnToFreeList(req);
            req = null;
            JVP.traceable.tracePrint(this.traceZone, 4, "createSolanoConnection calling mi_open");
            this.conn_handle = this.mi_open(this.dbaMonitor, dbName, userName, passwd);
            if (this.conn_handle == 0L) {
                throw GenErr.sqle(-9471, this);
            }
            Thread userThread = Thread.currentThread();
            DBA.addSolanoEntry(userThread, (Connection)((Object)this));
            try {
                DBAThreadImpl dbaThread = (DBAThreadImpl)userThread;
                dbaThread.setHasSolanoConns();
            }
            catch (ClassCastException ignore) {}
        }
        catch (Exception e) {
            if (req != null) {
                sapiFreeList.returnToFreeList(req);
            }
            req = null;
            sapiFreeList = null;
            throw GenErr.sqle(-9472, e.toString(), this);
        }
    }

    private long mi_open(DBAMonitor monitor, String dbname, String user, String passwd) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        SAPIRequestImpl req = null;
        long handle = 0L;
        int noPasswdCheck = 0;
        try {
            JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnect:mi_open");
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            req = sapiFreeList.getFromFreeList();
            if (dbname != null && user != null && passwd != null) {
                req.setStringData(0, 0, dbname);
                req.setStringData(1, 1, user);
                req.setStringData(2, 2, passwd);
            } else {
                req.setArgData(0, 0L);
                req.setArgData(1, 0L);
                req.setArgData(2, 0L);
            }
            this.dbDate = this.getdbDate();
            this.glDate = this.getglDate();
            this.dbCentury = this.getdbCentury();
            if (this.dbDate != null) {
                req.setStringData(3, 4, this.dbDate);
            } else {
                req.setStringData(3, 4, "");
            }
            if (this.glDate != null) {
                req.setStringData(4, 6, this.glDate);
            } else {
                req.setStringData(4, 6, "");
            }
            if (this.dbCentury != null) {
                req.setStringData(5, 7, this.dbCentury);
            } else {
                req.setStringData(5, 7, "");
            }
            UDRDBAManagerImpl mgr = (UDRDBAManagerImpl)UDRDBAContextImpl.udrDBAManager;
            noPasswdCheck = !mgr.passwordCheck ? 1 : 0;
            req.setArgData(6, noPasswdCheck);
            req.setFuncid(1);
            monitor.notifySAPICall(req);
            monitor.waitSAPICallDone(req);
            req.checkQueryStatus(this.conn_handle, (IfxDirectProtocol)this.proto, this.getdbLocale());
            handle = req.getRetPtr();
            JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnect:mi_open got handle " + handle);
            if (handle == 0L) {
                throw GenErr.sqle(-9473, this);
            }
            this.transFlag = req.getTransFlag(handle);
            byte[] dbArr = new byte[UDREnvImpl.IDENTSIZE + 1];
            long dbPtr = req.getDbName(handle);
            int dbLen = UDREnvImpl.copyCString(dbPtr, dbArr);
            this.curDbName = new String(dbArr, 0, dbLen);
            this.delimIdent = req.isDelimIdentSet(handle);
            if (user == null) {
                byte[] userArr = new byte[UDREnvImpl.IDENTSIZE + 1];
                long userPtr = req.getUserName(handle);
                int userLen = UDREnvImpl.copyCString(userPtr, userArr);
                this.userName = new String(userArr, 0, userLen);
            }
            sapiFreeList.returnToFreeList(req);
            req = null;
            JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectConnect:mi_open transFlag is " + this.transFlag + " curDbName is " + this.curDbName);
            this.isOpen = true;
            short sval = 0;
            if ((this.transFlag & 3) != 0) {
                sval = (short)(sval | 1);
            }
            if ((this.transFlag & 4) != 0) {
                sval = (short)(sval | 2);
            }
            ((IfxDirectProtocol)this.proto).setServerWarningsShort(sval);
            JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectConnect:mi_open transFlag is " + this.transFlag + " ServerWarningsShort is " + ((IfxDirectProtocol)this.proto).getServerWarningsShort() + " SVAL is " + sval);
            this.setDatabaseOpen(true, ((IfxDirectProtocol)this.proto).getServerWarningsShort());
            if (this.udrConnection) {
                long lminfo = this.currThread.getCurrentUDRContext().getLminfo();
                if (this.AnsiDb && UDRLMInfo.alreadyInTransaction(lminfo)) {
                    this.SendCommit = false;
                }
            }
            return handle;
        }
        catch (Exception e) {
            if (req != null) {
                sapiFreeList.returnToFreeList(req);
            }
            req = null;
            sapiFreeList = null;
            if (!this.udrConnection && this.proto != null) {
                this.proto.executeCloseDatabase();
            }
            throw GenErr.sqle(-9474, e.toString(), this);
        }
    }

    public boolean isUSVER() {
        return true;
    }

    public void setConnHandle(long conn_h) {
        this.conn_handle = conn_h;
    }

    public long getConnHandle() {
        return this.conn_handle;
    }

    public int getTransFlag() {
        return this.transFlag;
    }

    public String getDbName() {
        return this.curDbName;
    }

    public void setDBAMonitor(DBAMonitor mon) {
        this.dbaMonitor = mon;
    }

    public DBAMonitor getDBAMonitor() {
        return this.dbaMonitor;
    }

    public void addStatementHandle(long handle) {
    }

    public void dropStatementHandle(long handle) {
    }

    public void closeStatements() {
    }

    public boolean getIsUdrConnection() {
        return this.udrConnection;
    }

    public boolean is90303() {
        return true;
    }

    protected void finalize() {
        JVP.traceable.tracePrint("JVP.JDBC", 4, "GC connection " + this);
        try {
            this.close(true);
        }
        catch (SQLException ex) {
            JVP.log.log("Cannot GC connection " + this);
        }
    }

    public IfxProtocol getProto() {
        return this.proto;
    }

    public boolean isLongID() {
        return true;
    }

    public void setResultSetMetaData(IfxResultSetMetaData rsmd) {
        ((IfxDirectProtocol)this.proto).setResultSetMetaData(rsmd);
    }

    public IfxObject makeInstance(int i) throws SQLException {
        return ((IfxDirectProtocol)this.proto).makeInstance(i);
    }

    public IfxObject makeInstanceFromIfxType(Connection conn, short type) throws SQLException {
        return ((IfxDirectProtocol)this.proto).makeInstanceFromIfxType(conn, type);
    }

    public long gettypebyname(String owner, String typename) throws SQLException {
        return ((IfxDirectProtocol)this.proto).gettypebyname(owner, typename);
    }

    public String getExtendedTypeName(IfxObject obj) {
        return obj.getExtendedTypeName();
    }

    public boolean getInternalTrans() {
        return this.Internal_Trans;
    }

    public void setImplBegin(boolean implbgn) {
        this.implBegin = implbgn;
    }

    public void setHoldability(int holdability) {
    }

    public void setAutoCommit(boolean newAC) throws SQLException {
        if (!this.udrConnection) {
            super.setAutoCommit(newAC);
            return;
        }
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException((int)-79730, (IfxConnection)this);
        }
        long lminfo = this.currThread.getCurrentUDRContext().getLminfo();
        if (UDRLMInfo.alreadyInTransaction(lminfo)) {
            throw GenErr.sqle(-535);
        }
        if (newAC && this.Internal_Trans) {
            if (this.implBegin) {
                try {
                    this.proto.executeRollback();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            this.Internal_Trans = false;
        }
        if (!this.db_use_log && !newAC) {
            this.autoCommit = true;
            throw IfxErrMsg.getSQLException((int)-79744, (IfxConnection)this);
        }
        if (!newAC) {
            if (this.AnsiDb) {
                this.SendCommit = false;
            }
            this.lazyImplicitBegin("setAutoCommit");
            this.Internal_Trans = true;
        }
        this.autoCommit = newAC;
    }

    public void setForcedSendCommit(boolean newFSC) {
        this.SendCommit = newFSC;
    }

    public void lazyImplicitBegin(String funcName) {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol:" + funcName + "called lazyImplicitBegin ");
        if (this.Internal_Trans && !this.implBegin) {
            try {
                this.proto.executeBegin();
                this.setTxBeginState();
                this.implBegin = true;
            }
            catch (SQLException e) {
                JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol:lazyImplicitBegin.executeBegin has failed");
                return;
            }
        }
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public Savepoint setSavepoint() throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnection:setSavepoint() not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectConnection:setSavepoint()", (Locale)Locale.getDefault());
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnection:setSavepoint(String) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectConnection:setSavepoint(String)", (Locale)Locale.getDefault());
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnection:releaseSavepoint(Savepoint) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectConnection:releaseSavePoint(Savepoint)", (Locale)Locale.getDefault());
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnection:rollback(Savepoint) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectConnection:rollback(Savepoint)", (Locale)Locale.getDefault());
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnection:createStatement(int,int,int) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectConnection:createStatement(int,int,int)", (Locale)Locale.getDefault());
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnection:prepareStatement(String,int,int,int) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectConnection:prepareStatement(String,int,int,int)", (Locale)Locale.getDefault());
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnection:prepareCall(String,int,int,int) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectConnection:prepareCall(String,int,int,int)", (Locale)Locale.getDefault());
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnection:prepareStatement(String,int) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectConnection:prepareStatement(String,int)", (Locale)Locale.getDefault());
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnection:prepareStatement(String,int) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectConnection:prepareStatement(String,int)", (Locale)Locale.getDefault());
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectConnection:prepareStatement(String,String[]) not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectConnection:prepareStatement(String,String[])", (Locale)Locale.getDefault());
    }

    boolean isBatchUpdatePerSpec() {
        return false;
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw GenErr.sqle(-9438, "createStruct");
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw GenErr.sqle(-9438, "createArrayOf");
    }

    public Properties getClientInfo() throws SQLException {
        throw GenErr.sqle(-9438, "getClientInfo");
    }

    public String getClientInfo(String name) throws SQLException {
        throw GenErr.sqle(-9438, "getClientInfo");
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        SQLClientInfoException scie = (SQLClientInfoException)GenErr.sqle(-9438, "setClientInfo");
        throw scie;
    }

    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        SQLClientInfoException scie = (SQLClientInfoException)GenErr.sqle(-9438, "setClientInfo");
        throw scie;
    }

    public int getNetworkTimeout() throws SQLException {
        throw GenErr.sqle(-9438, "getNetworkTimeout");
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw GenErr.sqle(-9438, "setNetworkTimeout");
    }

    public void abort(Executor executor) throws SQLException {
        throw GenErr.sqle(-9438, "abort");
    }

    public String getSchema() throws SQLException {
        throw GenErr.sqle(-9438, "getSchema");
    }

    public void setSchema(String schema) throws SQLException {
        throw GenErr.sqle(-9438, "setSchema");
    }

    public boolean isValid(int timeout) throws SQLException {
        throw GenErr.sqle(-9438, "isValid");
    }

    public SQLXML createSQLXML() throws SQLException {
        throw GenErr.sqle(-9438, "createSQLXML");
    }

    public NClob createNClob() throws SQLException {
        throw GenErr.sqle(-9438, "createNClob");
    }

    public Clob createClob() throws SQLException {
        throw GenErr.sqle(-9438, "createClob");
    }

    public Blob createBlob() throws SQLException {
        throw GenErr.sqle(-9438, "createBlob");
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw GenErr.sqle(-9439, "isWrapperFor");
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw GenErr.sqle(-9439, "unwrap");
    }
}

