/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxSQLDirOutStream;
import com.informix.jdbc.IfmxSQLInStream;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxDirectConnection;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxIntervalDF;
import com.informix.jdbc.IfxIntervalYM;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetCreate;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxRowColumn;
import com.informix.jdbc.IfxRowCreate;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxTypes;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import informix.jvp.JVP;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.impl.DBAThreadImpl;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.JVPClassLoader;
import informix.jvp.dbapplet.impl.SAPIRequestFreeList;
import informix.jvp.dbapplet.impl.SAPIRequestImpl;
import informix.jvp.dbapplet.impl.SQLJParamImpl;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import informix.jvp.dbapplet.impl.UDRDBAManagerImpl;
import informix.jvp.dbapplet.impl.UDREnvImpl;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class IfxDirectProtocol
implements IfxProtocol {
    private boolean internalQuery;
    static Hashtable dataTypes = new Hashtable(54);
    public static final int BYTESHIFT = 8;
    public static final int MI_ERROR = -1;
    public static final int MI_OK = 0;
    public static final int MI_ROWS = 1;
    public static final int MI_DML = 3;
    public static final int MI_DDL = 4;
    public static final int MI_FUNCTION_RESULTS = 5;
    public static final int MI_END_OF_DATA = 6;
    public static final int MI_NO_MORE_RESULTS = 7;
    public static final int ISNOLOG = 8;
    public static final int CBIF_ANSIDB = 4;
    public static final int CBIF_TRANS_MASK = 3;
    private Statement JvtiStmt = null;
    IfxResultSetMetaData desc = null;
    private boolean doneCommit = false;
    private boolean passBlobAsUDT = false;
    private FileOutputStream BlobFd = null;
    private int BlobWriteFailure = 0;
    private Trace trace = null;
    private Trace protoTrace = null;
    private long serial8Inserted = 0L;
    private int serialInserted = 0;
    private long bigSerialInserted = 0L;
    SAPIRequestImpl req = null;
    public int sqlcode;
    public String SQLState = null;
    public String message = null;
    private SQLWarning warn = null;
    private String sqlerrm = null;
    private int[] sqlerrd = new int[10];
    private StringBuffer serverWarningsString = new StringBuffer("        ");
    private short serverWarningsShort = 0;
    private String serverVersion = null;
    private int totalTuples = 0;
    private int curRow = -1;
    private short TxStmt = 0;
    private Vector DBList = null;
    private static final short NON_TX_STMT = 0;
    private static final short BEG_TX_STMT = 1;
    private static final short END_TX_STMT = 2;
    private static final short BLOB_BUFFER_SIZE = 1024;
    private final int INFX_BUFSIZE = 4096;
    private IfxRowColumn rowColumn = null;
    private DBAMonitor dbaMonitor;
    private IfxDirectConnection conn = null;
    private String traceZone = "JVP.JDBC";
    private long conn_handle = 0L;
    private long stmt_handle = 0L;
    private long jdr = 0L;
    private int numparams = 0;
    private int numcols = 0;
    private int fetchRows = 0;
    private int curTuple = 0;
    private boolean gotLastRow = false;
    private byte[][] informixSqlBytes = null;
    private int ifxSqlByteArrayLen = 0;
    private Vector fpRet;
    private boolean isUdrConnection = false;
    private String curDbName = null;
    private int statementType = 0;
    boolean isPrepared = false;
    private int rowcount = 0;
    private int currRowID = 0;
    private String dbEnc = null;
    private String dbLocale = null;

    public IfxDirectProtocol(IfxDirectConnection conn_arg) {
        JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectProtocol: constructor called");
        this.conn = conn_arg;
        this.dbEnc = this.conn.getdbEncoding();
        this.dbLocale = this.conn.getdbLocale();
        this.conn_handle = this.conn.getConnHandle();
        this.dbaMonitor = this.conn.getDBAMonitor();
        this.conn_handle = this.conn.getConnHandle();
        this.curDbName = this.conn.getDbName();
        this.isUdrConnection = this.conn.getIsUdrConnection();
        JVP.traceable.tracePrint(this.traceZone, 3, "IfxDirectProtocol: curDbName is " + this.curDbName + " conn_handle is " + this.conn_handle);
    }

    public ResultSetMetaData getMetaData() {
        return this.desc;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public void clear() {
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: clear() called");
        this.currRowID = 0;
        this.sqlcode = 0;
        this.SQLState = null;
        this.message = null;
        this.sqlerrm = null;
        this.doneCommit = false;
        for (int i = 0; i < 10; ++i) {
            this.sqlerrd[i] = 0;
            if (i >= 8) continue;
            this.serverWarningsString.setCharAt(i, ' ');
        }
        this.serverWarningsShort = 0;
        this.warn = null;
        this.resetTuples();
    }

    private void clearAll() {
        this.clear();
        this.jdr = 0L;
        this.numcols = 0;
        this.rowcount = 0;
        this.desc = null;
        this.statementType = 0;
        this.isPrepared = false;
        this.fetchRows = 0;
        this.curTuple = 0;
        this.gotLastRow = false;
        JVP.traceable.tracePrint(this.traceZone, 4, "clearing informixSqlBytes...");
        if (this.informixSqlBytes == null) {
            return;
        }
        for (int i = 0; i < this.ifxSqlByteArrayLen; ++i) {
            this.informixSqlBytes[i] = null;
        }
    }

    private void sendXact(int xacttype) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        if (this.conn.isClosed()) {
            throw GenErr.sqle(-9475, this.conn);
        }
        try {
            JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectProtocol:sendXact");
            if (this.conn_handle == 0L) {
                this.conn_handle = this.conn.getConnHandle();
            }
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            this.req = sapiFreeList.getFromFreeList();
            if (xacttype == 34) {
                xacttype = 18;
            } else if (xacttype == 35) {
                xacttype = 17;
            } else if (xacttype == 36) {
                xacttype = 19;
            }
            this.req.clearArgs();
            this.req.setFuncid(xacttype);
            this.req.setArgData(0, this.conn_handle);
            int args = this.req.getNumArgsUsed();
            int retry = 3;
            if (args != 1) {
                JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectProtocol:sendXact assert failure, args should be 1, it is: " + args + " conn_handle is: " + this.conn_handle);
                for (int i = 0; i < retry; ++i) {
                    JVP.traceable.tracePrint(this.traceZone, 4, "\tretry to set args for xacttype " + xacttype);
                    this.req.setArgData(0, this.conn_handle);
                    args = this.req.getNumArgsUsed();
                    JVP.traceable.tracePrint(this.traceZone, 4, "\tretry # " + i + "args should be 1, it is: " + args);
                    if (args == 1) break;
                }
            }
            if (this.dbaMonitor == null) {
                this.dbaMonitor = this.conn.getDBAMonitor();
            }
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            int xactres = this.req.getRes();
            if (xactres != 0) {
                String xactStr = xacttype == 34 ? "BEGIN WORK" : (xacttype == 35 ? "COMMIT" : (xacttype == 36 ? "ROLLBACK" : "UNKNOWN: " + xacttype));
                JVP.traceable.tracePrint(this.traceZone, 1, ">>> IfxDirectProtocol: sendXact() xactStr " + xactStr + " xactres " + xactres);
                if (xactres == -255) {
                    throw GenErr.sqle(-9423, "(" + xactStr + ": not in transaction)");
                }
                if (xactres == -256) {
                    throw GenErr.sqle(-9423, "(" + xactStr + ": no transaction)");
                }
                if (xactres == -535) {
                    this.conn.setImplBegin(true);
                    throw GenErr.sqle(-9423, "(" + xactStr + ": already in transaction)");
                }
                if (xactres != 0) {
                    throw GenErr.sqle(-9423, "(" + xacttype);
                }
            }
            this.statementType = this.req.getCmdType(this.conn_handle);
            this.setTxStmt(this.statementType);
            if (this.conn.getInternalTrans() && this.TxStmt == 2) {
                this.conn.setImplBegin(false);
            }
            JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: sendXact() txstmt " + this.TxStmt);
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: sendXact() exited");
        }
        catch (Exception e) {
            if (this.TxStmt == 2) {
                JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectProtocol: END_TX_STMT, return error IfxDirectProtocol.sendXact.sqlcode " + this.sqlcode);
                if (this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
            }
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
            throw GenErr.sqle(-9476, e.getMessage(), this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBegin() throws SQLException {
        try {
            this.conn.lock();
            this.doExecuteBegin();
        }
        finally {
            this.conn.unLock();
        }
    }

    private void doExecuteBegin() throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectProtocol: executeBegin() called");
        this.sendXact(34);
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeBegin() exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommit() throws SQLException {
        try {
            this.conn.lock();
            this.doExecuteCommit();
        }
        finally {
            this.conn.unLock();
        }
    }

    public void doExecuteCommit() throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectProtocol: executeCommit() called");
        this.sendXact(35);
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeCommit() exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRollback() throws SQLException {
        try {
            this.conn.lock();
            this.doExecuteRollback();
        }
        finally {
            this.conn.unLock();
        }
    }

    public void doExecuteRollback() throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectProtocol: executeRollback() called,  conn is " + this.conn_handle);
        this.sendXact(36);
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeRollback() exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(Statement stmt) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        IfxStatement ifxstmt = (IfxStatement)stmt;
        String cmnd = ifxstmt.commandString;
        byte[] cmnd_ba = null;
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: executeCommand(" + cmnd + ") called");
        if (cmnd != null && this.dbEnc != null) {
            try {
                cmnd_ba = cmnd.getBytes(this.dbEnc);
            }
            catch (Exception e) {
                JVP.traceable.tracePrint(this.traceZone, 3, "IfxDirectProtocol: executePrepare: bad encoding " + this.dbEnc);
                throw GenErr.sqle(-79750, this.conn);
            }
        }
        if (this.conn.isClosed()) {
            throw GenErr.sqle(-9475, this.conn);
        }
        this.conn.lazyImplicitBegin("executeCommand");
        this.currRowID = 0;
        try {
            this.conn.lock();
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            if (stmt instanceof IfxPreparedStatement) {
                IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
                Vector paramVector = pstmt.getVector();
                int numParams = pstmt.inputvals;
                if (numParams != pstmt.getqmarks()) {
                    throw GenErr.sqle(-79749, this.conn);
                }
                JVP.traceable.tracePrint(this.traceZone, 3, "IfxDirectProtocol: is a Prepared Statement");
                JVP.traceable.tracePrint(this.traceZone, 3, "executeCommand resetSqlBytes " + numParams);
                this.resetSqlBytes(numParams);
                if (this.putPrepValues(paramVector, this.informixSqlBytes, this.jdr) != 0) {
                    throw GenErr.sqle(-9496);
                }
                JVP.traceable.tracePrint(this.traceZone, 3, "executeCommand putPrepValues done");
                this.statementType = ((IfxStatement)stmt).getStatementType();
                if (this.statementType == 2 || this.statementType == 56 && this.numcols > 0) {
                    throw GenErr.sqle(-260);
                }
            }
            try {
                this.req = sapiFreeList.getFromFreeList();
            }
            catch (Exception reqee) {
                throw (SQLException)reqee;
            }
            this.req.clearArgs();
            if (stmt instanceof IfxPreparedStatement || this.isPrepared) {
                this.req.setFuncid(11);
                this.req.setArgData(0, this.conn_handle);
                this.req.setArgData(1, this.jdr);
            } else {
                this.req.setFuncid(0);
                this.req.setArgData(0, this.conn_handle);
                if (cmnd_ba != null) {
                    this.req.setByteArrayData(1, 3, cmnd_ba);
                } else {
                    this.req.setStringData(1, 3, cmnd);
                }
                this.req.setArgData(2, this.jdr);
            }
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            this.jdr = this.req.getRetPtr();
            int res = this.req.getRes();
            this.rowcount = this.req.getRetCount();
            this.statementType = this.req.getCmdType(this.conn_handle);
            this.serialInserted = this.req.getSerial(this.jdr);
            this.serial8Inserted = this.req.getSerial8(this.jdr);
            this.bigSerialInserted = this.req.getBigSerial(this.jdr);
            this.numcols = this.req.getJdrNumCols(this.jdr);
            this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
            if (this.jdr == 0L || res < 0) {
                throw GenErr.sqle(-9424);
            }
            if (this.statementType == 2 || this.statementType == 56 && this.numcols > 0) {
                throw GenErr.sqle(-260);
            }
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            this.setTxStmt(this.statementType);
            this.setConnTxState();
            JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeCommand() exited");
        }
        catch (SQLException e) {
            this.isPrepared = false;
            if (this.TxStmt == 2) {
                JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectProtocol: END_TX_STMT, return error IfxDirectProtocol.executeCommand.sqlcode " + this.sqlcode);
                if (this.sqlcode != -255) {
                    this.conn.setTxEndState();
                }
            }
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
            throw e;
        }
        finally {
            try {
                if (!(stmt instanceof IfxPreparedStatement)) {
                    this.doExecuteRelease(stmt);
                }
            }
            finally {
                this.conn.unLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executePrepare(Statement stmt) throws SQLException {
        try {
            this.conn.lazyImplicitBegin("executePrepare");
            this.conn.lock();
            this.doExecutePrepare(stmt);
        }
        finally {
            this.conn.unLock();
        }
    }

    public void doExecutePrepare(Statement stmt) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        IfxStatement ifxstmt = (IfxStatement)stmt;
        String cmnd = ifxstmt.commandString;
        byte[] cmnd_ba = null;
        int internalQry = 0;
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: executePrepare(" + cmnd + ") called");
        IfxProtocol protocol = this.conn.getProto();
        if (((IfxDirectProtocol)protocol).internalQuery) {
            internalQry = 1;
        }
        if (cmnd != null && this.dbEnc != null) {
            try {
                cmnd_ba = cmnd.getBytes(this.dbEnc);
            }
            catch (Exception e) {
                JVP.traceable.tracePrint(this.traceZone, 3, "IfxDirectProtocol: executePrepare: bad encoding " + this.dbEnc);
                throw GenErr.sqle(-79750, this.conn);
            }
        }
        if (this.conn.isClosed()) {
            throw GenErr.sqle(-9475, this.conn);
        }
        this.conn.lazyImplicitBegin("executePrepare");
        this.stmt_handle = 0L;
        this.currRowID = 0;
        try {
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            this.req = sapiFreeList.getFromFreeList();
            this.conn_handle = this.conn.getConnHandle();
            this.req.clearArgs();
            this.req.setFuncid(7);
            this.req.setArgData(0, this.conn_handle);
            if (cmnd_ba != null) {
                this.req.setByteArrayData(1, 3, cmnd_ba);
            } else {
                this.req.setStringData(1, 3, cmnd);
            }
            this.req.setStringData(2, 0, ifxstmt.getCursorName());
            this.req.setArgData(3, this.jdr);
            this.req.setArgData(4, internalQry);
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            this.jdr = this.req.getRetPtr();
            this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
            this.statementType = this.req.getCmdType(this.conn_handle);
            ((IfxStatement)stmt).setStatementType(this.statementType);
            this.numcols = this.req.getJdrNumCols(this.jdr);
            this.numparams = this.req.getJdrNumParams(this.jdr);
            JVP.traceable.tracePrint(this.traceZone, 4, "executePrepare conn_handle is " + this.conn_handle + " waitSAPICallDone done: result jdr " + this.jdr);
            if (this.numparams > 0) {
                JVP.traceable.tracePrint(this.traceZone, 4, "creating new desc for prepare ");
                if (this.statementType != 2 && this.statementType != 56) {
                    this.desc = new IfxResultSetMetaData(this.numparams, (IfxConnection)this.conn);
                    if (this.dbEnc == null) {
                        this.req.initParamResultSetMetaData((ResultSetMetaData)this.desc, this.jdr);
                    } else {
                        this.req.initParamRSMD_GLS((ResultSetMetaData)this.desc, this.jdr, this.dbEnc == "ISO2022CN_GB" ? "ISO2022CN" : this.dbEnc);
                    }
                } else {
                    this.desc = new IfxResultSetMetaData(0, (IfxConnection)this.conn);
                }
            } else {
                this.desc = new IfxResultSetMetaData(0, (IfxConnection)this.conn);
            }
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
        }
        catch (SQLException e) {
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
            throw e;
        }
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executePrepare() exited");
    }

    public void executeStatementQuery(Statement stmt) throws SQLException {
        this.executeStatementQuery(stmt, false, null);
    }

    public void executeStatementQuery(Statement stmt, boolean withHold) throws SQLException {
        this.executeStatementQuery(stmt, withHold, null);
    }

    public void executeStatementQuery(Statement stmt, boolean withHold, ResultSetMetaData outputDesc) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        IfxStatement ifxstmt = (IfxStatement)stmt;
        int fetchDirection = 0;
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: executeStatementQuery('" + ifxstmt.commandString + "') called");
        if (this.conn.isClosed()) {
            throw GenErr.sqle(-9475, this.conn);
        }
        this.conn.lazyImplicitBegin("executeStatementQuery");
        this.currRowID = 0;
        this.gotLastRow = false;
        this.curTuple = 0;
        this.fetchRows = 0;
        try {
            this.conn.lock();
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            if (!(stmt instanceof IfxPreparedStatement) && !this.isPrepared) {
                this.doExecutePrepare(stmt);
                this.isPrepared = true;
            }
            this.statementType = ((IfxStatement)stmt).getStatementType();
            if (this.statementType != 2 && (this.statementType != 56 || this.numcols <= 0)) {
                throw GenErr.sqle(-79750, this.conn);
            }
            if (this.jdr == 0L) {
                throw GenErr.sqle(-9495);
            }
            if (stmt instanceof IfxPreparedStatement) {
                IfxPreparedStatement pstmt = (IfxPreparedStatement)stmt;
                Vector paramVector = pstmt.getVector();
                int numParams = pstmt.inputvals;
                if (numParams != pstmt.getqmarks()) {
                    throw GenErr.sqle(-79749, this.conn);
                }
                JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectProtocol: is a Prepared Statement");
                JVP.traceable.tracePrint(this.traceZone, 4, "executeStatementQuery resetSqlBytes " + numParams);
                this.resetSqlBytes(numParams);
                if (this.putPrepValues(paramVector, this.informixSqlBytes, this.jdr) != 0) {
                    throw GenErr.sqle(-9496);
                }
                JVP.traceable.tracePrint(this.traceZone, 4, "executeStatementQuery putPrepValues done");
            }
            this.req = sapiFreeList.getFromFreeList();
            this.req.clearArgs();
            this.req.setFuncid(8);
            JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeStatementQuery: cursorOpen turned on");
            ((IfxStatement)stmt).cursorOpen = true;
            this.req.setArgData(0, this.conn_handle);
            this.req.setArgData(1, this.jdr);
            if (stmt.getResultSetType() == 1004) {
                fetchDirection = ((IfxStatement)stmt).getFetchDirection();
                this.req.setArgData(2, fetchDirection);
            } else {
                this.req.setArgData(2, 0L);
            }
            this.req.setArgData(3, 0L);
            if (withHold) {
                this.req.setArgData(4, 32L);
            } else {
                this.req.setArgData(4, 0L);
            }
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            int res = this.req.getRes();
            this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
            JVP.traceable.tracePrint(this.traceZone, 3, "executeStatementQuery: conn_handle is " + this.conn_handle + " result is " + res);
            if (res < 0) {
                throw GenErr.sqle(-9440);
            }
            if (this.numcols > 0) {
                JVP.traceable.tracePrint(this.traceZone, 3, "creating new desc");
                this.desc = new IfxResultSetMetaData(this.numcols, (IfxConnection)this.conn);
                if (this.dbEnc == null) {
                    this.req.initOutputResultSetMetaData((ResultSetMetaData)this.desc, this.jdr);
                } else {
                    this.req.initOutputRSMD_GLS((ResultSetMetaData)this.desc, this.jdr, this.dbEnc == "ISO2022CN_GB" ? "ISO2022CN" : this.dbEnc);
                }
            }
            this.statementType = this.req.getCmdType(this.conn_handle);
            ((IfxStatement)stmt).setStatementType(this.statementType);
            this.setTxStmt(this.statementType);
            JVP.traceable.tracePrint(this.traceZone, 3, "executeStatementQuery stmtType is " + this.statementType + " numcols is " + this.numcols);
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            if (fetchDirection == 0 && res != 7) {
                this.doExecuteFetch(0, 0, 0, 0, stmt);
            } else {
                this.resetTuples();
            }
        }
        catch (SQLException e) {
            this.isPrepared = false;
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
            throw e;
        }
        finally {
            this.isPrepared = false;
            this.conn.unLock();
        }
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeStatementQuery() exited");
    }

    public void executeClose(Statement stmt) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: executeClose() called");
        SAPIRequestFreeList sapiFreeList = null;
        IfxStatement ifxstmt = (IfxStatement)stmt;
        if (this.conn.isClosed()) {
            throw GenErr.sqle(-9475, this.conn);
        }
        this.currRowID = 0;
        try {
            this.conn.lock();
            long retval = 0L;
            if (((IfxStatement)stmt).cursorOpen) {
                sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
                this.req = sapiFreeList.getFromFreeList();
                this.req.clearArgs();
                this.req.setFuncid(12);
                this.req.setArgData(0, this.conn_handle);
                this.req.setArgData(1, this.jdr);
                this.dbaMonitor.notifySAPICall(this.req);
                this.dbaMonitor.waitSAPICallDone(this.req);
                retval = this.req.getRes();
                this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
                if (this.req != null) {
                    sapiFreeList.returnToFreeList(this.req);
                }
                this.req = null;
            }
        }
        catch (SQLException e) {
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
            throw e;
        }
        finally {
            this.conn.unLock();
        }
        ((IfxStatement)stmt).cursorOpen = false;
        this.doneCommit = false;
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeClose() exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRelease(Statement stmt) throws SQLException {
        try {
            this.conn.lock();
            this.doExecuteRelease(stmt);
        }
        finally {
            this.conn.unLock();
        }
    }

    private void doExecuteRelease(Statement stmt) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: executeRelease() called: cursorOpen " + ((IfxStatement)stmt).cursorOpen + " this prot is " + this);
        if (this.jdr == 0L) {
            return;
        }
        try {
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            this.req = sapiFreeList.getFromFreeList();
            this.req.clearArgs();
            this.req.setFuncid(10);
            this.req.setArgData(0, this.conn_handle);
            this.req.setArgData(1, this.jdr);
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            int res = this.req.getRes();
            this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
            JVP.traceable.tracePrint(this.traceZone, 3, "executeRelease: conn_handle is " + this.conn_handle + " result is " + this.jdr);
            if (res != 0) {
                throw GenErr.sqle(-9495);
            }
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
        }
        catch (SQLException e) {
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
            throw e;
        }
        this.jdr = 0L;
        ((IfxStatement)stmt).cursorOpen = false;
        this.isPrepared = false;
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeRelease() exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFetch(int direction, int count, int scrolltype, int isscrollcurs) throws SQLException {
        try {
            this.conn.lock();
            this.doExecuteFetch(direction, count, scrolltype, isscrollcurs, null);
        }
        finally {
            this.conn.unLock();
        }
    }

    void doExecuteFetch(int direction, int count, int scrolltype, int isscrollcurs, Statement stmt) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: executeFetch(dir:" + direction + ", cnt:" + count + ", stype:" + scrolltype + ", isscroll:" + isscrollcurs + ") called");
        if (this.jdr == 0L) {
            throw GenErr.sqle(-9453);
        }
        this.resetTuples();
        SAPIRequestFreeList sapiFreeList = null;
        int res = 0;
        long row = 0L;
        long rowdesc = 0L;
        long retval = 0L;
        if (this.conn.isClosed()) {
            throw GenErr.sqle(-9475, this.conn);
        }
        try {
            int ctlen;
            IfxColumnInfo cinfo;
            int i;
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            this.req = sapiFreeList.getFromFreeList();
            JVP.traceable.tracePrint(this.traceZone, 3, "doExecuteFetch: curTuple is " + this.curTuple + " fetchRows is " + this.fetchRows + " gotLastRow is " + this.gotLastRow);
            if (this.fetchRows > 0 && this.curTuple != this.fetchRows && ++this.curTuple < this.fetchRows) {
                JVP.traceable.tracePrint(this.traceZone, 3, "doExecuteFetch: curTuple is " + this.curTuple + " fetchRows is " + this.fetchRows + " gotLastRow is " + this.gotLastRow);
                this.req.clearArgs();
                this.req.fetchCachedRow(this.jdr, this.curTuple);
            } else if (!this.gotLastRow || isscrollcurs == 1) {
                this.req.clearArgs();
                this.req.setFuncid(3);
                this.req.setArgData(0, this.conn_handle);
                this.req.setArgData(1, this.jdr);
                this.req.setArgData(2, scrolltype);
                this.req.setArgData(3, count);
                this.req.setArgData(4, isscrollcurs);
                this.dbaMonitor.notifySAPICall(this.req);
                this.dbaMonitor.waitSAPICallDone(this.req);
                retval = this.req.getRetPtr();
                res = this.req.getRes();
                if (res == -1) {
                    this.jdr = retval;
                }
                this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
                JVP.traceable.tracePrint(this.traceZone, 3, "executeFetch: MI_NEXT_ROW: conn_handle is " + this.conn_handle + " MI_NEXT_ROW result is " + retval);
                res = this.req.getRes();
                if (res == 0 && retval == 0L) {
                    this.gotLastRow = true;
                }
                this.fetchRows = this.req.getRowsFetched(this.jdr);
                JVP.traceable.tracePrint(this.traceZone, 1, "executeFetch: fetchRows = " + this.fetchRows + " gotLastRow = " + this.gotLastRow);
                this.curTuple = 0;
            }
            if (this.gotLastRow && this.curTuple == this.fetchRows) {
                this.rowcount = this.req.getRetCount();
                if (direction == 0) {
                    ((IfxStatement)stmt).cursorOpen = false;
                } else {
                    this.currRowID = this.rowcount;
                }
                JVP.traceable.tracePrint(this.traceZone, 3, "executeFetch: No more data: rowcount " + this.rowcount);
                if (this.req != null) {
                    sapiFreeList.returnToFreeList(this.req);
                }
                this.req = null;
                return;
            }
            if (scrolltype == 4) {
                this.rowcount = this.req.getRetCount();
                if (this.rowcount >= 0) {
                    this.currRowID = this.rowcount;
                }
                JVP.traceable.tracePrint(this.traceZone, 3, "!!!!executeFetch: LAST: currRowId " + this.currRowID);
            }
            if (res != 0) {
                JVP.traceable.tracePrint(this.traceZone, 3, "res is " + res + " retval is " + retval);
                if (this.req != null) {
                    sapiFreeList.returnToFreeList(this.req);
                }
                this.req = null;
                this.jdr = retval;
                throw GenErr.sqle(-9495);
            }
            if (this.jdr != retval && retval != 0L) {
                this.jdr = retval;
            }
            res = this.req.getRes();
            this.numcols = this.req.getJdrNumCols(this.jdr);
            JVP.traceable.tracePrint(this.traceZone, 3, "getRes " + res + " getJdrNumCols " + this.numcols);
            if (this.numcols > 0) {
                JVP.traceable.tracePrint(this.traceZone, 3, "getJdrIsNull " + this.req.getJdrIsNull(this.jdr, 1) + " getJdrColVal " + this.req.getJdrColVal(this.jdr, 1));
            }
            if (this.desc == null) {
                this.desc = new IfxResultSetMetaData(this.numcols, (IfxConnection)this.conn);
                if (this.dbEnc == null) {
                    this.req.initOutputResultSetMetaData((ResultSetMetaData)this.desc, this.jdr);
                } else {
                    this.req.initOutputRSMD_GLS((ResultSetMetaData)this.desc, this.jdr, this.dbEnc == "ISO2022CN_GB" ? "ISO2022CN" : this.dbEnc);
                }
            }
            block8: for (i = 0; i < this.numcols; ++i) {
                switch (this.desc.getIfxColumnType(i + 1)) {
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        cinfo = this.desc.getColumnInfo(i + 1);
                        ctlen = cinfo.ColLength;
                        int jdr_len = UDRLMInfo.getColLen(this.jdr, i);
                        JVP.traceable.tracePrint(this.traceZone, 3, "executeFetch: CT ba len is " + ctlen + " jdr_len is " + jdr_len);
                        if (jdr_len == ctlen) continue block8;
                        this.desc.setEncodedLength(i + 1, jdr_len);
                        continue block8;
                    }
                }
            }
            JVP.traceable.tracePrint(this.traceZone, 3, "getJdrRow " + this.req.getJdrRow(this.jdr) + " getJdrRowDesc " + this.req.getJdrRowDesc(this.jdr));
            this.totalTuples = 1;
            this.resetSqlBytes(this.numcols);
            this.initInformixSqlBytes();
            block9: for (i = 0; i < this.numcols; ++i) {
                switch (this.desc.getIfxColumnType(i + 1)) {
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        JVP.traceable.tracePrint(this.traceZone, 4, "putPrepValues: jdr is " + this.jdr);
                        cinfo = this.desc.getColumnInfo(i + 1);
                        ctlen = cinfo.ColLength;
                        JVP.traceable.tracePrint(this.traceZone, 3, "executeFetch: CT ba len is " + ctlen);
                        if (this.informixSqlBytes[i] != null && this.informixSqlBytes[i].length >= ctlen) continue block9;
                        this.informixSqlBytes[i] = new byte[ctlen];
                        continue block9;
                    }
                }
            }
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeFetch() exited");
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
            throw e;
        }
    }

    private void byteArraySetup() throws SQLException {
        boolean alloc = this.informixSqlBytes == null || this.numcols > this.ifxSqlByteArrayLen;
        this.resetSqlBytes(this.numcols);
        block3: for (int i = 0; i < this.numcols; ++i) {
            switch (this.desc.getIfxColumnType(i + 1)) {
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    JVP.traceable.tracePrint(this.traceZone, 4, "putPrepValues: jdr is " + this.jdr);
                    IfxColumnInfo cinfo = this.desc.getColumnInfo(i + 1);
                    int ctlen = cinfo.ColLength;
                    JVP.traceable.tracePrint(this.traceZone, 4, "executeFetch: CT ba len is " + ctlen);
                    if (this.informixSqlBytes[i] != null && this.informixSqlBytes[i].length >= ctlen) continue block3;
                    this.informixSqlBytes[i] = new byte[ctlen];
                    continue block3;
                }
            }
        }
    }

    public void initInformixSqlBytes() throws SQLException {
        try {
            for (int i = 0; i < this.numcols; ++i) {
                Integer hashValue = (Integer)dataTypes.get(new Integer(this.desc.getIfxColumnType(i + 1)));
                if (hashValue == null || this.informixSqlBytes[i] != null && this.informixSqlBytes[i].length >= hashValue) continue;
                this.informixSqlBytes[i] = new byte[hashValue.intValue()];
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCloseDatabase() throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: executeCloseDatabase() called");
        SAPIRequestFreeList sapiFreeList = null;
        if (this.isUdrConnection) {
            return;
        }
        try {
            this.conn.lock();
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            this.req = sapiFreeList.getFromFreeList();
            if (this.dbaMonitor == null) {
                this.dbaMonitor = this.conn.getDBAMonitor();
            }
            if (this.conn_handle == 0L) {
                this.conn_handle = this.conn.getConnHandle();
            }
            this.req.clearArgs();
            this.req.setFuncid(13);
            this.req.setArgData(0, this.conn_handle);
            this.req.setArgData(1, this.jdr);
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
        }
        finally {
            this.conn.unLock();
        }
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeCloseDatabase() exited");
    }

    public void executeExecute(Statement stmt, boolean holdable) throws SQLException {
        this.executeExecute(stmt, holdable, null);
    }

    public void executeExecute(Statement stmt, boolean holdable, ResultSetMetaData outputDesc) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: executeExecute() called");
        if (!(stmt instanceof IfxPreparedStatement) && !this.isPrepared) {
            this.executePrepare(stmt);
            this.isPrepared = true;
        }
        this.statementType = ((IfxStatement)stmt).getStatementType();
        if (this.statementType == 2 || this.statementType == 56 && this.numcols > 0) {
            this.executeStatementQuery(stmt);
            if (!(stmt instanceof IfxPreparedStatement) && !this.isResultSet()) {
                this.executeRelease(stmt);
            }
        } else {
            this.executeCommand(stmt);
        }
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeExecute() exited");
    }

    public boolean executeRowCreate(IfxRowCreate stmt, long rowdesc, int num_cols) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        JVP.traceable.tracePrint(this.traceZone, 3, "executeRowCreate : num_cols is" + num_cols + " rowdesc is" + rowdesc + " stmt is" + (Object)((Object)stmt));
        try {
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            this.req = sapiFreeList.getFromFreeList();
            if (this.conn_handle == 0L) {
                this.conn_handle = this.conn.getConnHandle();
            }
            this.req.clearArgs();
            this.req.setArgData(0, this.conn_handle);
            this.req.setArgData(1, rowdesc);
            this.req.setFuncid(23);
            JVP.traceable.tracePrint(this.traceZone, 3, "executeRowCreate : set argu in req");
            if (this.dbaMonitor == null) {
                this.dbaMonitor = this.conn.getDBAMonitor();
            }
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            this.jdr = this.req.getRetPtr();
            this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
            IfxRowCreate pstmt = stmt;
            Vector paramVector = pstmt.getVector();
            int numParams = pstmt.inputvals;
            JVP.traceable.tracePrint(this.traceZone, 3, "executeRowCreate : after mi_row_create_setup convertparam now. numParams is " + numParams + "paramVector is " + paramVector);
            for (int i = 0; i < numParams; ++i) {
                IfxObject obj = (IfxObject)paramVector.elementAt(i);
                int ifxtype = obj.getIfxType();
                String udtName = obj.getExtendedTypeName();
                if (ifxtype != 41 && ifxtype != 40 && ifxtype != 44) continue;
                String udtExtName = JVPClassLoader.getUDTExternalName(udtName, null, false);
                JVP.traceable.tracePrint(this.traceZone, 3, "executeRowCreate : udtExtName =  " + udtExtName + " udtName = " + udtName);
            }
            if (numParams != pstmt.getqmarks()) {
                throw GenErr.sqle(-79749, this.conn);
            }
            JVP.traceable.tracePrint(this.traceZone, 4, "executeCommand resetSqlBytes " + numParams);
            this.resetSqlBytes(numParams);
            if (this.putPrepValues(paramVector, this.informixSqlBytes, this.jdr) != 0) {
                throw GenErr.sqle(-9496);
            }
            JVP.traceable.tracePrint(this.traceZone, 3, "executeRowCreate: putPrepValues done");
            this.req.clearArgs();
            this.req.setArgData(0, this.conn_handle);
            this.req.setArgData(1, this.jdr);
            this.req.setFuncid(24);
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            long row = this.req.getRetPtr();
            this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
            JVP.traceable.tracePrint(this.traceZone, 3, "executeRowCreate : done with mi_row_create call");
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
        }
        catch (SQLException e) {
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
            throw e;
        }
        return true;
    }

    public boolean createNextRow(IfxRowCreate stmt, long rowdesc) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        try {
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            this.req = sapiFreeList.getFromFreeList();
            if (this.conn_handle == 0L) {
                this.conn_handle = this.conn.getConnHandle();
            }
            IfxRowCreate pstmt = stmt;
            Vector paramVector = pstmt.getVector();
            int numParams = pstmt.inputvals;
            if (numParams != pstmt.getqmarks()) {
                throw GenErr.sqle(-79749, this.conn);
            }
            JVP.traceable.tracePrint(this.traceZone, 3, "executeCommand resetSqlBytes " + numParams);
            this.resetSqlBytes(numParams);
            if (this.putPrepValues(paramVector, this.informixSqlBytes, this.jdr) != 0) {
                throw GenErr.sqle(-9496);
            }
            JVP.traceable.tracePrint(this.traceZone, 3, "executeRowCreate: putPrepValues done");
            JVP.traceable.tracePrint(this.traceZone, 3, "createNextRow: called \n     conn is " + this.conn_handle + "\n     rowdesc is " + rowdesc + "\n     proto is " + this + "\n     jdr is " + this.jdr);
            this.req.clearArgs();
            this.req.setArgData(0, this.conn_handle);
            this.req.setArgData(1, this.jdr);
            this.req.setFuncid(24);
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            long row = this.req.getRetPtr();
            this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            return true;
        }
        catch (SQLException e) {
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
            throw e;
        }
    }

    public boolean setNextRow(IfxRowCreate stmt, long rowdesc, int rowId) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        try {
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            this.req = sapiFreeList.getFromFreeList();
            if (this.conn_handle == 0L) {
                this.conn_handle = this.conn.getConnHandle();
            }
            IfxRowCreate pstmt = stmt;
            Vector paramVector = pstmt.getVector();
            int numParams = pstmt.inputvals;
            if (numParams != pstmt.getqmarks()) {
                throw GenErr.sqle(-79749, this.conn);
            }
            JVP.traceable.tracePrint(this.traceZone, 3, "setNextRow resetSqlBytes " + numParams);
            this.resetSqlBytes(numParams);
            if (this.putPrepValues(paramVector, this.informixSqlBytes, this.jdr) != 0) {
                throw GenErr.sqle(-9496);
            }
            JVP.traceable.tracePrint(this.traceZone, 3, "setNextRow: putPrepValues done");
            this.req.clearArgs();
            this.req.setArgData(0, this.conn_handle);
            this.req.setArgData(1, this.jdr);
            this.req.setArgData(2, rowId);
            this.req.setFuncid(31);
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            long row = this.req.getRetPtr();
            this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
        }
        catch (SQLException e) {
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
            throw e;
        }
        return true;
    }

    public ResultSet executeResultSetCreate(IfxResultSetCreate stmt, long rowdesc, int num_cols) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        JVP.traceable.tracePrint(this.traceZone, 3, "executeResultSetCreate: called");
        try {
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            this.req = sapiFreeList.getFromFreeList();
            this.numcols = num_cols;
            if (this.conn_handle == 0L) {
                this.conn_handle = this.conn.getConnHandle();
            }
            this.req.clearArgs();
            JVP.traceable.tracePrint(this.traceZone, 3, "executeResultSetCreate : called");
            this.req.setFuncid(29);
            this.req.setArgData(0, this.conn_handle);
            this.req.setArgData(1, rowdesc);
            if (this.dbaMonitor == null) {
                this.dbaMonitor = this.conn.getDBAMonitor();
            }
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            this.jdr = this.req.getRetPtr();
            this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
            this.desc = new IfxResultSetMetaData(num_cols, (IfxConnection)this.conn);
            this.req.initOutputResultSetMetaData((ResultSetMetaData)this.desc, this.jdr);
            IfxResultSet rs = new IfxResultSet((IfxStatement)stmt, (IfxConnection)this.conn, stmt.prot);
            IfxDirectProtocol rsProto = (IfxDirectProtocol)rs.getProtocol();
            rsProto.JvtiStmt = stmt;
            rsProto.desc = this.desc;
            rsProto.jdr = this.jdr;
            rsProto.numcols = num_cols;
            rsProto.byteArraySetup();
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            JVP.traceable.tracePrint(this.traceZone, 3, "executeResultSetCreate: \n     conn is " + this.conn_handle + "\n     rowdesc is " + rowdesc + "\n     jdr is " + this.jdr + "\n     proto is " + this + "\n     rs is " + rs);
            return rs;
        }
        catch (SQLException e) {
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
            throw e;
        }
    }

    public boolean convertNextRow(long rowdesc) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        try {
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            this.req = sapiFreeList.getFromFreeList();
            if (this.conn_handle == 0L) {
                this.conn_handle = this.conn.getConnHandle();
                JVP.traceable.tracePrint(this.traceZone, 3, "convertNextRow: done with getConnHandle");
            }
            JVP.traceable.tracePrint(this.traceZone, 3, "convertNextRow: called \n     conn is " + this.conn_handle + "\n     rowdesc is " + rowdesc + "\n     proto is " + this + "\n     jdr is " + this.jdr);
            this.req.clearArgs();
            this.req.setFuncid(30);
            this.req.setArgData(0, this.conn_handle);
            this.req.setArgData(1, rowdesc);
            this.req.setArgData(2, this.jdr);
            DBAThreadImpl currThread = (DBAThreadImpl)Thread.currentThread();
            this.dbaMonitor = currThread.getDBAMonitor();
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
        }
        catch (SQLException e) {
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
            throw e;
        }
        return true;
    }

    private void setError(int errcode) throws SQLException {
        throw GenErr.sqle(errcode);
    }

    public void setServerWarningsShort(short val) {
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: setServerWarningsShort() to " + val);
        this.serverWarningsShort = val;
    }

    public short getServerWarningsShort() {
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: getServerWarningsShort() returns " + this.serverWarningsShort);
        return this.serverWarningsShort;
    }

    String getServerWarningsString() {
        return this.serverWarningsString.toString();
    }

    public int getSerialInsert() {
        return this.serialInserted;
    }

    public long getSerial8Inserted() {
        return this.serial8Inserted;
    }

    public long getBigSerialInserted() {
        return this.bigSerialInserted;
    }

    public int getEstimateNumberofRow() {
        return this.sqlerrd[0];
    }

    int getISAMCode() {
        return this.sqlerrd[1];
    }

    public int getNumberOfRowsProcessed() {
        return this.rowcount;
    }

    int getEstimatedCode() {
        return this.sqlerrd[3];
    }

    public void chainWarnings(SQLWarning cwarn) {
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: chainWarnings() called");
        if (cwarn != null) {
            if (this.warn != null) {
                this.warn.setNextWarning(cwarn);
            } else {
                this.warn = cwarn;
            }
        }
    }

    public void clearWarnings() {
        this.sqlcode = 0;
        this.SQLState = null;
        this.message = null;
        this.warn = null;
    }

    public void clearExceptions() {
        this.sqlcode = 0;
        this.SQLState = null;
        this.message = null;
        this.warn = null;
    }

    public SQLWarning getWarnings() {
        return this.warn;
    }

    public void clearErrs() {
        this.sqlcode = 0;
        this.SQLState = null;
        this.message = null;
        this.sqlerrm = null;
    }

    int getSQLCode() {
        return this.sqlcode;
    }

    String getSQLErrm() {
        return this.sqlerrm;
    }

    String getSQLState() {
        return this.SQLState;
    }

    String getMessage() {
        return this.message;
    }

    public boolean isResultSet() throws SQLException {
        int outputNumber = 0;
        if (this.desc != null) {
            outputNumber = this.desc.getColumnCount();
        }
        return this.statementType == 2 || this.statementType == 56 && outputNumber > 0;
    }

    public int getTupleCount() {
        return this.totalTuples - this.curRow - 1;
    }

    public IfxObject getColumnInRow(int colIndex) throws SQLException {
        if (this.jdr == 0L) {
            JVP.traceable.tracePrint(this.traceZone, 4, "getColumnInRow jdr is null");
            throw GenErr.sqle(-79739, this.conn);
        }
        JVP.traceable.tracePrint(this.traceZone, 4, "getColumnInRow colIndex " + colIndex);
        if (this.passBlobAsUDT) {
            this.desc.setBlobColAsUDT(colIndex);
        }
        int ifxColType = UDRLMInfo.getSingleColTypeid(this.jdr, colIndex - 1);
        IfxObject obj = IfxValue.makeInstance((IfxConnection)this.conn, (IfxColumnInfo)this.desc.getColumnInfo(colIndex));
        if (obj == null) {
            JVP.traceable.tracePrint(this.traceZone, 4, "getColumnInRow: obj is null");
            throw GenErr.sqle(-79739, this.conn);
        }
        int rc = this.getSingleColValue(obj, this.jdr, colIndex);
        JVP.traceable.tracePrint(this.traceZone, 3, "getColumnInRow: getSingleColValue returned " + rc);
        if (rc != 0) {
            JVP.traceable.tracePrint(this.traceZone, 4, "getColumnInRow: getSingleColValue failed");
            throw GenErr.sqle(-79739, this.conn);
        }
        JVP.traceable.tracePrint(this.traceZone, 2, "getColumnInRow: getSingleColValue returning");
        return obj;
    }

    public void loadColumnData(int colIndex, IfxObject val) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "loadColumnData called");
        if (val == null) {
            JVP.traceable.tracePrint(this.traceZone, 4, "loadColumnData IfxObject val is null");
            throw GenErr.sqle(-79739, this.conn);
        }
        if (this.jdr == 0L) {
            JVP.traceable.tracePrint(this.traceZone, 4, "loadColumnData jdr is null");
            throw GenErr.sqle(-79739, this.conn);
        }
        int rc = this.getSingleColValue(val, this.jdr, colIndex);
        if (rc != 0) {
            JVP.traceable.tracePrint(this.traceZone, 4, "loadColumnData: getSingleColValue failed " + rc);
            throw GenErr.sqle(-79739, this.conn);
        }
    }

    public void executeFetchBlob(IfxObject blobDesc) throws SQLException {
    }

    private void resetTuples() {
        this.curRow = -1;
        this.totalTuples = 0;
    }

    public int getColValues(Vector v, byte[][] ba, long colinfo) {
        int[] ifxColTypes = UDRLMInfo.getColTypeids(colinfo);
        if (ifxColTypes == null) {
            return -1;
        }
        int numCols = ifxColTypes.length;
        if (numCols > ba.length) {
            return -1;
        }
        if (UDRLMInfo.convertColData(ba, colinfo) != 0) {
            return -1;
        }
        for (int i = 0; i < numCols; ++i) {
            IfxObject colObj = null;
            if (i < v.size()) {
                colObj = (IfxObject)v.elementAt(i);
            }
            if (colObj == null) {
                try {
                    colObj = IfxValue.makeInstanceFromIfxType(null, (int)ifxColTypes[i]);
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.toString());
                }
                if (colObj == null) {
                    return -1;
                }
                if (i < v.size()) {
                    v.insertElementAt(colObj, i);
                } else {
                    v.addElement(colObj);
                }
            }
            try {
                colObj.fromIfx(ba[i]);
                continue;
            }
            catch (SQLException sqle) {
                System.out.println(sqle.toString());
            }
        }
        return 0;
    }

    public int getSingleColValue(IfxObject obj, long colinfo, int index) throws SQLException {
        if (colinfo == 0L) {
            return -1;
        }
        if (UDRLMInfo.isColDataNull(colinfo, index - 1)) {
            JVP.traceable.tracePrint(this.traceZone, 1, "getSingleColValue: col is null " + index);
            obj.nullify();
            return 0;
        }
        JVP.traceable.tracePrint(this.traceZone, 1, "getSingleColValue: index is " + index);
        int ifxColType = UDRLMInfo.getSingleColTypeid(colinfo, index - 1);
        JVP.traceable.tracePrint(this.traceZone, 3, "getSingleColValue: ifxColType is " + ifxColType);
        if (ifxColType == -1) {
            return -1;
        }
        JVP.traceable.tracePrint(this.traceZone, 3, "getSingleColValue: got an obj, index is " + index);
        if (ifxColType == 2 || ifxColType == 6) {
            int intVal = UDRLMInfo.convertSingleIntColData(colinfo, index - 1);
            try {
                if (intVal == Integer.MIN_VALUE) {
                    obj.nullify();
                }
                obj.fromInt(intVal);
            }
            catch (SQLException sqle) {
                System.out.println(sqle.toString());
                return -1;
            }
        } else if (ifxColType == 45) {
            int boolVal = UDRLMInfo.convertSingleBooleanColData(colinfo, index - 1);
            try {
                if (boolVal == -1) {
                    obj.nullify();
                }
                obj.fromInt(boolVal);
            }
            catch (SQLException sqle) {
                System.out.println(sqle.toString());
                return -1;
            }
        } else if (ifxColType == 1) {
            short shortVal = UDRLMInfo.convertSingleShortColData(colinfo, index - 1);
            try {
                if (shortVal == Short.MIN_VALUE) {
                    obj.nullify();
                }
                obj.fromShort(shortVal);
            }
            catch (SQLException sqle) {
                System.out.println(sqle.toString());
                return -1;
            }
        } else if (ifxColType == 0 || ifxColType == 15 || ifxColType == 43) {
            byte[] arr = this.informixSqlBytes[index - 1];
            int[] len = new int[1];
            long str = UDRLMInfo.convertSingleStringColData(colinfo, index - 1, len);
            int strlen = len[0];
            if (arr == null || arr.length < strlen || arr.length > strlen) {
                arr = new byte[strlen];
            }
            JVP.traceable.tracePrint(this.traceZone, 3, "getSingleColValue: char/lvarchar: strlen is " + strlen + " arr is " + arr + " coltype is " + ifxColType);
            try {
                if (str == 0L || strlen < 0) {
                    obj.nullify();
                }
                UDREnvImpl.copyCStringWithLen(str, arr, strlen);
                if (ifxColType == 43) {
                    String s = null;
                    if (this.dbEnc != null) {
                        try {
                            s = new String(arr, 0, strlen, this.dbEnc);
                        }
                        catch (IOException e) {
                            throw GenErr.sqle(-79783, this.conn);
                        }
                    } else {
                        s = new String(arr, 0, strlen);
                    }
                    s = s.trim();
                    obj.fromString(s);
                }
                obj.fromIfx(arr);
            }
            catch (SQLException sqle) {
                System.out.println(sqle.toString());
                return -1;
            }
        } else {
            if (ifxColType == 13 || ifxColType == 16) {
                JVP.traceable.tracePrint(this.traceZone, 3, "getSingleColValue: varchar or nvarchar");
                byte[] arr = this.informixSqlBytes[index - 1];
                int len = this.desc.getColumnLength(index);
                if (arr == null || arr.length <= len) {
                    arr = new byte[len + 1];
                }
                UDRLMInfo.convertSingleVarCharColData(colinfo, index - 1, arr);
                try {
                    obj.fromIfx(arr);
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.toString());
                    return -1;
                }
            }
            if (ifxColType == 7) {
                byte[] arr = this.informixSqlBytes[index - 1];
                UDRLMInfo.convertSingleDateColData(colinfo, index - 1, arr);
                try {
                    obj.fromIfx(arr);
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.toString());
                    return -1;
                }
            }
            if (ifxColType == 5 || ifxColType == 8) {
                JVP.traceable.tracePrint(this.traceZone, 3, "getSingleColValue: DECIMAL/MONEY");
                try {
                    short scale = (short)this.desc.getEncodedLength(index);
                    byte[] arr = this.informixSqlBytes[index - 1];
                    UDRLMInfo.convertSingleDecimalColData(colinfo, index - 1, arr);
                    JVP.traceable.tracePrint(this.traceZone, 4, "getSingleColValue: convertSingleDecimalColData returned, encoded len is " + scale);
                    obj.fromIfx(arr, scale);
                    JVP.traceable.tracePrint(this.traceZone, 3, "getSingleColValue: fromIfx returned");
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.toString());
                    sqle.printStackTrace();
                    return -1;
                }
            }
            if (ifxColType == 10 || ifxColType == 14) {
                JVP.traceable.tracePrint(this.traceZone, 3, "getSingleColValue: DATETIME/INTERVAL");
                try {
                    short scale = (short)this.desc.getEncodedLength(index);
                    byte[] arr = this.informixSqlBytes[index - 1];
                    int digits = UDRLMInfo.convertSingleDatetimeColData(colinfo, index - 1, arr);
                    JVP.traceable.tracePrint(this.traceZone, 3, "getSingleColValue: convertSingleDatetimeColData returned, encoded len is " + scale);
                    byte[] dt = new byte[digits];
                    System.arraycopy(arr, 0, dt, 0, digits);
                    obj.fromIfx(dt, scale);
                    JVP.traceable.tracePrint(this.traceZone, 3, "getSingleColValue: fromIfx returned");
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.toString());
                    sqle.printStackTrace();
                    return -1;
                }
            }
            if (ifxColType == 3) {
                double dVal = UDRLMInfo.convertSingleDoubleColData(colinfo, index - 1);
                try {
                    obj.fromDouble(dVal);
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.toString());
                    sqle.printStackTrace();
                    return -1;
                }
            }
            if (ifxColType == 4) {
                float floatVal = UDRLMInfo.convertSingleFloatColData(colinfo, index - 1);
                try {
                    obj.fromFloat(floatVal);
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.toString());
                    sqle.printStackTrace();
                    return -1;
                }
            }
            if (ifxColType == 17 || ifxColType == 18) {
                byte[] arr = this.informixSqlBytes[index - 1];
                UDRLMInfo.convertSingleInt8ColData(colinfo, index - 1, arr);
                try {
                    obj.fromIfx(arr);
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.toString());
                    return -1;
                }
            }
            if (ifxColType == 52 || ifxColType == 53) {
                long lVal = UDRLMInfo.convertSingleBigintColData(colinfo, index - 1);
                try {
                    if (lVal == Long.MIN_VALUE) {
                        obj.nullify();
                    }
                    obj.fromLong(lVal);
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.toString());
                    return -1;
                }
            } else if (ifxColType == 102 || ifxColType == 101 || ifxColType == 41 && (this.desc.getExtendedName(index).equals("ifx_lo_stat") || this.desc.getExtendedName(index).equals("ifx_lo_spec"))) {
                JVP.traceable.tracePrint("JVP.BLOB", 3, "JDBC converting blob/clob object " + this.conn);
                byte[] arr = this.informixSqlBytes[index - 1];
                int len = this.desc.getColumnLength(index);
                if (arr == null || arr.length < len + 5) {
                    arr = new byte[len + 5];
                }
                int stat = UDRLMInfo.convertSingleFixedUDTColData(colinfo, index - 1, arr);
                byte[] ba = null;
                if (stat < 0) {
                    obj.nullify();
                    return 0;
                }
                if (stat == 0) {
                    ba = arr;
                }
                obj.fromIfx(arr);
                JVP.traceable.tracePrint("JVP.BLOB", 3, "JDBC converted blob/clob object " + this.conn);
            } else if (ifxColType == 41 || ifxColType == 40) {
                String udtName = this.desc.getExtendedName(index);
                JVP.traceable.tracePrint(this.traceZone, 3, "the name of the type is " + udtName);
                Class udtCls = null;
                if (!this.isUdrConnection) {
                    UDRDBAManagerImpl mgr = (UDRDBAManagerImpl)UDRDBAContextImpl.udrDBAManager;
                    String udtExtName = JVPClassLoader.getUDTExternalName(udtName, (Connection)((Object)this.conn), false);
                    JVPClassLoader l = mgr.getsolanoLoader();
                    l.setSolanoConn((Connection)((Object)this.conn));
                    try {
                        udtCls = l.loadClass(udtExtName, true);
                    }
                    catch (ClassNotFoundException cnfe) {
                        l.unsetSolanoConn();
                        throw GenErr.sqle(-9443, udtName, this.conn);
                    }
                    l.unsetSolanoConn();
                } else {
                    DBAThreadImpl currThread = (DBAThreadImpl)Thread.currentThread();
                    SQLJParamImpl paramMgr = currThread.getParamMgr();
                    String udtExtName = JVPClassLoader.getUDTExternalName(udtName, null, false);
                    udtCls = paramMgr.JavaToClass(udtExtName);
                }
                SQLData udtObj = null;
                try {
                    udtObj = (SQLData)udtCls.newInstance();
                }
                catch (Exception e) {
                    throw GenErr.sqle(-9476, e.toString(), this.conn);
                }
                long udtPtr = UDRLMInfo.getUDTColDataHandle(colinfo, index - 1);
                int length = UDRLMInfo.getColLen(colinfo, index - 1);
                IfmxSQLInStream sqlIn = new IfmxSQLInStream(this.dbaMonitor, this.conn_handle, udtPtr, length);
                udtObj.readSQL(sqlIn, udtName);
                obj.fromObject((Object)udtObj);
            } else if (ifxColType == 19 || ifxColType == 21 || ifxColType == 20 || ifxColType == 22) {
                JVP.traceable.tracePrint("JVP", 3, "Handling complex types");
                IfxColumnInfo cinfo = this.desc.getColumnInfo(index);
                JVP.traceable.tracePrint("JVP", 3, "got cinfo, len is " + cinfo.ColLength);
                byte[] arr = this.informixSqlBytes[index - 1];
                JVP.traceable.tracePrint("JVP", 3, "arr is" + arr + " size is " + arr.length);
                byte[] ba = UDRLMInfo.fillColArray(colinfo, index - 1, arr, cinfo.ColLength);
                JVP.traceable.tracePrint("JVP", 3, "ba is" + ba + " size is " + ba.length);
                if (ba == null) {
                    obj.nullify();
                    return 0;
                }
                try {
                    obj.fromIfx(ba);
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.toString());
                    sqle.printStackTrace();
                    return -1;
                }
            } else {
                System.out.println("Missing Type in DirectProtocol.java" + ifxColType);
                throw GenErr.sqle(-9495);
            }
        }
        return 0;
    }

    public int putPrepValues(Vector v, byte[][] ba, long jdr) {
        JVP.traceable.tracePrint(this.traceZone, 1, "putPrepValues: jdr is " + jdr);
        int numParams = v.size();
        if (numParams <= 0) {
            return 0;
        }
        JVP.traceable.tracePrint(this.traceZone, 3, "putPrepValues: numParams " + numParams + "ba.length is " + ba.length);
        if (numParams > ba.length) {
            return -1;
        }
        for (int i = 0; i < numParams; ++i) {
            IfxObject obj = (IfxObject)v.elementAt(i);
            try {
                String typename;
                int length = 0;
                int ifxtype = obj.getIfxType();
                String className = obj.getClass().getName();
                JVP.traceable.tracePrint(this.traceZone, 3, "putPrepValues[" + i + "] type " + ifxtype + " class " + className);
                if (ifxtype == 41 || ifxtype == 40 || ifxtype == 44) {
                    typename = obj.getExtendedTypeName();
                    JVP.traceable.tracePrint(this.traceZone, 3, " putPrepValues: UDTFIX/VAR/SENDRECV gets type " + typename);
                } else {
                    IfxResultSetMetaData rsmd;
                    IfxDateTime d;
                    typename = ifxtype == 10 ? ((d = (IfxDateTime)obj).isTimeValue() ? "datetime hour to second" : "datetime year to fraction(5)") : (ifxtype == 14 ? (obj instanceof IfxIntervalYM ? "interval year to month" : (obj instanceof IfxIntervalDF ? "interval day to fraction(5)" : "interval")) : (ifxtype == 22 || ifxtype == 19 || ifxtype == 21 || ifxtype == 20 ? ((rsmd = (IfxResultSetMetaData)this.getMetaData()) == null ? "choke on this type" : rsmd.getExtendedName(i + 1)) : IfxTypes.IfxTypeToName((int)ifxtype)));
                }
                if ((typename == null || typename.equals("")) && className.equals("com.informix.jdbc.IfxCollection")) {
                    typename = "multiset(char(1) not null)";
                }
                JVP.traceable.tracePrint(this.traceZone, 3, "++putPrepValues typename is " + typename);
                if (!obj.isNull()) {
                    if (ifxtype == 3) {
                        ba[i] = new byte[8];
                        UDRLMInfo.doubleToByteArray(jdr, i, ba[i], obj.toDouble(), typename);
                        length = ba[i].length;
                    } else if (ifxtype == 4) {
                        ba[i] = new byte[4];
                        UDRLMInfo.floatToByteArray(jdr, i, ba[i], obj.toFloat(), typename);
                        length = ba[i].length;
                    } else if (ifxtype == 41 || ifxtype == 40) {
                        length = JVPClassLoader.getUDTLength(this.conn.getDbName() + "." + typename);
                        ba[i] = new byte[length];
                        IfmxSQLDirOutStream sqlOut = new IfmxSQLDirOutStream(this.dbaMonitor, this.conn_handle, ba[i]);
                        SQLData udtObj = (SQLData)obj.toObject();
                        udtObj.writeSQL(sqlOut);
                        length = sqlOut.length();
                    } else if (ifxtype == 43) {
                        String s = obj.toString();
                        if (this.dbEnc == null) {
                            try {
                                ba[i] = this.conn.javatoifx.JavaToIfxChar(s);
                            }
                            catch (IOException ioe) {
                                return -1;
                            }
                        }
                        try {
                            ba[i] = this.conn.javatoifx.JavaToIfxChar(s, this.dbEnc);
                        }
                        catch (IOException ioe) {
                            return -1;
                        }
                        length = ba[i].length;
                    } else if (ifxtype == 45) {
                        int ival = obj.toInt();
                        ba[i] = JavaToIfxType.JavaToIfxInt((int)ival);
                        length = ba[i].length;
                    } else if (obj instanceof IfxSmBlob) {
                        byte[] tempba = obj.toIfx();
                        length = tempba.length - 4;
                        ba[i] = new byte[length];
                        System.arraycopy(tempba, 4, ba[i], 0, length);
                    } else {
                        ba[i] = obj.toIfx();
                        length = ba[i].length;
                    }
                } else {
                    ba[i] = new byte[0];
                    length = 0;
                }
                JVP.traceable.tracePrint(this.traceZone, 3, "ba[" + i + "].length is " + length + " typename = " + typename + " ifxtype = " + ifxtype + " classname is " + className);
                int rc = 0;
                if (obj.isNull() || ifxtype != 3 && ifxtype != 4) {
                    rc = UDRLMInfo.setJdrColVal(jdr, i, ba[i], length, typename);
                }
                if (rc != 0) {
                    return -1;
                }
                JVP.traceable.tracePrint(this.traceZone, 3, "putPrepValues: ba[i] is " + ba[i].toString());
                continue;
            }
            catch (SQLException sqle) {
                System.out.println(sqle.toString());
                return -1;
            }
        }
        return 0;
    }

    public int putPrepValues(IfxObject obj, long jdr, int index) {
        byte[] ba = null;
        try {
            ba = obj.toIfx();
        }
        catch (SQLException sqle) {
            System.out.println(sqle.toString());
        }
        if (UDRLMInfo.convertSinglePrepData(ba, jdr, index) != 0) {
            return -1;
        }
        return 0;
    }

    private void resetSqlBytes(int numcols) {
        if (this.informixSqlBytes != null && numcols > this.ifxSqlByteArrayLen) {
            for (int i = 0; i < this.ifxSqlByteArrayLen; ++i) {
                this.informixSqlBytes[i] = null;
            }
            this.informixSqlBytes = null;
            this.ifxSqlByteArrayLen = 0;
        }
        if (this.informixSqlBytes == null && numcols > 0) {
            this.informixSqlBytes = new byte[numcols][];
            this.ifxSqlByteArrayLen = numcols;
            JVP.traceable.tracePrint(this.traceZone, 3, "resetSqlBytes:  allocated informixSqlBytes with cols = " + numcols);
        }
    }

    public void setTxStmt(int statementType) {
        this.TxStmt = 0;
        if (statementType == 34) {
            this.TxStmt = 1;
        } else if (statementType == 35 || statementType == 36) {
            this.TxStmt = (short)2;
        }
        JVP.traceable.tracePrint(this.traceZone, 4, "IfxDirectProtocol: setTxStmt() statementType " + statementType + " TxStmt " + this.TxStmt);
    }

    public void setConnTxState() throws SQLException {
        if (this.TxStmt == 1) {
            this.conn.setTxBeginState();
        } else if (this.TxStmt == 2) {
            this.conn.setTxEndState();
        } else {
            try {
                if (this.conn.SendCommit) {
                    this.doExecuteCommit();
                    this.doneCommit = true;
                }
            }
            catch (SQLException sqle) {
                System.out.println(sqle.toString());
                throw sqle;
            }
        }
    }

    public long gettypebyname(String owner, String typename) throws SQLException {
        if (this.dbaMonitor == null) {
            this.dbaMonitor = this.conn.getDBAMonitor();
        }
        if (this.conn_handle == 0L) {
            this.conn_handle = this.conn.getConnHandle();
        }
        SAPIRequestFreeList sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
        this.req = sapiFreeList.getFromFreeList();
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: gettypebyname(" + typename + ")" + " conn " + this.conn_handle);
        this.req.clearArgs();
        this.req.setArgData(0, this.conn_handle);
        if (owner == null) {
            this.req.setArgData(1, 0L);
        } else {
            this.req.setStringData(1, 1, owner);
        }
        this.req.setStringData(2, 3, typename);
        this.req.setFuncid(25);
        this.dbaMonitor.notifySAPICall(this.req);
        this.dbaMonitor.waitSAPICallDone(this.req);
        long typeinfo = this.req.getRetPtr();
        this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
        JVP.traceable.tracePrint(this.traceZone, 3, "IfxDirectProtocol: gettypebyname got back " + typeinfo);
        return typeinfo;
    }

    public void executeVersion() throws SQLException {
    }

    public String getServerVersion() {
        return null;
    }

    public void executeEnv(Properties EnvVars) throws SQLException {
    }

    public int getTupleSize() throws SQLException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getaRow(int direction, int count, int scrolltype, int isscrollcurs, Statement stmt) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: getaRow(dir: " + direction + ", cnt: " + count + ", scrolltype: " + scrolltype + ", isscroll: " + isscrollcurs + ") called");
        if (this.JvtiStmt != null) {
            return true;
        }
        if (isscrollcurs == 1 && this.gotLastRow) {
            this.gotLastRow = false;
        }
        if (!((IfxStatement)stmt).cursorOpen || this.jdr == 0L) {
            return false;
        }
        if (scrolltype == 6) {
            this.currRowID = count;
        } else if (scrolltype == 2) {
            --this.currRowID;
        } else if (scrolltype == 1) {
            ++this.currRowID;
        } else if (scrolltype == 4) {
            // empty if block
        }
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: getaRow currRowID is " + this.currRowID);
        int tcount = this.getTupleCount();
        if (tcount == 0 || isscrollcurs == 1) {
            try {
                this.conn.lock();
                this.doExecuteFetch(direction, count, scrolltype, isscrollcurs, stmt);
            }
            finally {
                this.conn.unLock();
            }
            tcount = this.getTupleCount();
        }
        JVP.traceable.tracePrint(this.traceZone, 3, "IfxDirectProtocol: getaRow() getTupleCount " + tcount);
        if (tcount == 0) {
            return false;
        }
        ++this.curRow;
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: getaRow() exited");
        return true;
    }

    public int getTupid() throws SQLException {
        return this.currRowID;
    }

    public int executeReadSmBlob(int lofd, byte[] buffer, int nbytes) throws SQLException {
        return this.readSmartBlob(lofd, buffer, nbytes, 0);
    }

    public int executeReadSmBlob(int lofd, byte[] buffer, int nbytes, int offset) throws SQLException {
        return this.readSmartBlob(lofd, buffer, nbytes, offset);
    }

    public int executeReadSmBlob(int lofd, FileOutputStream filefd, int nbytes) throws SQLException {
        byte[] buffer = new byte[nbytes];
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeReadSmBlob() called.lofd = " + lofd + "using filefd, nbytes =" + nbytes);
        int retval = this.readSmartBlob(lofd, buffer, nbytes, 0);
        if (retval != nbytes) {
            throw GenErr.sqle(-9461, String.valueOf(nbytes));
        }
        try {
            filefd.write(buffer);
        }
        catch (Exception ex) {
            throw GenErr.sqle(-9459, ex.toString());
        }
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeReadSmBlob() with filefd exited.retval = " + retval);
        return retval;
    }

    public int readSmartBlob(int lofd, byte[] buffer, int length, int offset) throws SQLException {
        SAPIRequestImpl req;
        SAPIRequestFreeList sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
        long bufHandle = UDRLMInfo.getArrayRef(buffer);
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: readSmartBlob called. lofd = " + lofd + " length = " + length + " offset = " + offset);
        try {
            req = sapiFreeList.getFromFreeList();
        }
        catch (Exception e) {
            UDRLMInfo.releaseArrayRef(buffer, bufHandle);
            throw (SQLException)e;
        }
        req.clearArgs();
        req.setFuncid(33);
        req.setArgData(0, this.conn_handle);
        req.setArgData(1, lofd);
        req.setArgData(2, offset);
        req.setArgData(3, length);
        req.setArgData(4, bufHandle);
        this.dbaMonitor.notifySAPICall(req);
        this.dbaMonitor.waitSAPICallDone(req);
        int retval = (int)req.getRetPtr();
        req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
        sapiFreeList.returnToFreeList(req);
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeReadSmBlob() exited.retval = " + retval);
        UDRLMInfo.releaseArrayRef(buffer, bufHandle);
        return retval;
    }

    public int executeWriteSmBlob(int lofd, byte[] buffer) throws SQLException {
        return this.writeSmartBlob(lofd, buffer.length, buffer);
    }

    public int executeWriteSmBlob(int lofd, byte[] buffer, int offset, int length) throws SQLException {
        if (offset == 0) {
            return this.writeSmartBlob(lofd, buffer.length, buffer);
        }
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocl:executeWriteSmBlob(int lofd, byte[] buffer, int offset, int length) is not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectProtocol:executeWriteSmBlob(int lofd, byte[] buffer, int offset, int length)", (Locale)Locale.getDefault());
    }

    public int executeWriteSmBlob(int lofd, InputStream fd, int nbytes) throws SQLException {
        int len;
        byte[] buffer;
        JVP.traceable.tracePrint(this.traceZone, 5, "IfxDirectProtocol: executeWriteSmBlob() called.lofd = " + lofd + "using filefd, nbytes =" + nbytes);
        try {
            buffer = new byte[nbytes];
            len = fd.read(buffer);
        }
        catch (Exception ex) {
            throw GenErr.sqle(-9459, ex.toString());
        }
        if (len != nbytes) {
            throw GenErr.sqle(-9461, String.valueOf(nbytes));
        }
        return this.writeSmartBlob(lofd, len, buffer);
    }

    private int writeSmartBlob(int lofd, int length, byte[] buffer) throws SQLException {
        SAPIRequestImpl req;
        SAPIRequestFreeList sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
        long bufHandle = UDRLMInfo.getArrayRef(buffer);
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: writeSmartBlob called. lofd = " + lofd + "  length = " + length + "buffer = " + buffer);
        try {
            req = sapiFreeList.getFromFreeList();
        }
        catch (Exception e) {
            UDRLMInfo.releaseArrayRef(buffer, bufHandle);
            throw (SQLException)e;
        }
        req.clearArgs();
        req.setFuncid(34);
        req.setArgData(0, this.conn_handle);
        req.setArgData(1, lofd);
        req.setArgData(2, length);
        req.setArgData(3, bufHandle);
        this.dbaMonitor.notifySAPICall(req);
        this.dbaMonitor.waitSAPICallDone(req);
        int retval = (int)req.getRetPtr();
        req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
        sapiFreeList.returnToFreeList(req);
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: writeSmartBlob exited.reval = " + retval);
        UDRLMInfo.releaseArrayRef(buffer, bufHandle);
        return retval;
    }

    public int incRefCount(byte[] locator) throws SQLException {
        SAPIRequestImpl req;
        SAPIRequestFreeList sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
        int res = 0;
        long bufHandle = UDRLMInfo.getArrayRef(locator);
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: incRefCount called. locator = " + locator);
        try {
            req = sapiFreeList.getFromFreeList();
        }
        catch (Exception e) {
            UDRLMInfo.releaseArrayRef(locator, bufHandle);
            throw (SQLException)e;
        }
        req.clearArgs();
        req.setFuncid(36);
        req.setArgData(0, this.conn_handle);
        req.setArgData(1, bufHandle);
        this.dbaMonitor.notifySAPICall(req);
        this.dbaMonitor.waitSAPICallDone(req);
        int retval = (int)req.getRetPtr();
        res = req.getRes();
        req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
        if (res < 0) {
            throw GenErr.sqle(retval);
        }
        if (req != null) {
            sapiFreeList.returnToFreeList(req);
        }
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: incRefCount exited.reval = " + retval);
        UDRLMInfo.releaseArrayRef(locator, bufHandle);
        return retval;
    }

    public int decRefCount(byte[] locator) throws SQLException {
        SAPIRequestImpl req;
        SAPIRequestFreeList sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
        int res = 0;
        long bufHandle = UDRLMInfo.getArrayRef(locator);
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: decRefCount called. locator = " + locator);
        try {
            req = sapiFreeList.getFromFreeList();
        }
        catch (Exception e) {
            UDRLMInfo.releaseArrayRef(locator, bufHandle);
            throw (SQLException)e;
        }
        req.clearArgs();
        req.setFuncid(37);
        req.setArgData(0, this.conn_handle);
        req.setArgData(1, bufHandle);
        this.dbaMonitor.notifySAPICall(req);
        this.dbaMonitor.waitSAPICallDone(req);
        int retval = (int)req.getRetPtr();
        res = req.getRes();
        req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
        if (res < 0) {
            throw GenErr.sqle(retval);
        }
        if (req != null) {
            sapiFreeList.returnToFreeList(req);
        }
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: decRefCount exited.reval = " + retval);
        UDRLMInfo.releaseArrayRef(locator, bufHandle);
        return retval;
    }

    public Vector executeFastPath(String signature, Vector inParams, boolean fParam) throws SQLException {
        this.passBlobAsUDT = true;
        this.executeFastPath(signature, inParams, false, fParam);
        return this.fpRet;
    }

    public Vector getDBList() {
        return null;
    }

    public void executeGetDBList() throws SQLException {
    }

    public void executeOpenDatabase(String dbName, int flags) throws SQLException {
        throw GenErr.sqle(-9492, "executeOpenDatabase(String, int)");
    }

    public void executeFastPath(String signature, Vector inParams, boolean hasOutParameter, boolean request_fparam) throws SQLException {
        SAPIRequestFreeList sapiFreeList = null;
        Object outParam = null;
        Object value = null;
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: executeFastPath('" + signature + "') called");
        if (this.conn.isClosed()) {
            throw GenErr.sqle(-9475, this.conn);
        }
        this.conn.lazyImplicitBegin("executeFastPath");
        try {
            if (!this.passBlobAsUDT) {
                this.conn.lock();
            }
            sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
            this.req = sapiFreeList.getFromFreeList();
            this.req.clearArgs();
            this.req.setFuncid(26);
            this.req.setArgData(0, this.conn_handle);
            this.req.setStringData(1, 3, signature);
            this.req.setArgData(2, this.jdr);
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            this.jdr = this.req.getRetPtr();
            this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
            if (this.jdr == 0L) {
                JVP.traceable.tracePrint(this.traceZone, 1, "Could not get the JDR from server REQ : routine_get");
                throw GenErr.sqle(-9495, this.conn);
            }
            JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocol: executeFastPath: MI_EXEC_ROUTINE");
            this.req.clearArgs();
            this.req.setFuncid(27);
            this.req.setArgData(0, this.conn_handle);
            this.req.setStringData(1, 3, signature);
            this.req.setArgData(2, this.jdr);
            this.resetSqlBytes(inParams.size());
            if (this.putPrepValues(inParams, this.informixSqlBytes, this.jdr) != 0) {
                JVP.traceable.tracePrint(this.traceZone, 1, "Could not pass the Params to JDR : ExecuteFastPath");
                throw GenErr.sqle(-9496);
            }
            this.dbaMonitor.notifySAPICall(this.req);
            this.dbaMonitor.waitSAPICallDone(this.req);
            this.jdr = this.req.getRetPtr();
            int res = this.req.getRes();
            this.req.checkQueryStatus(this.conn_handle, this, this.dbLocale);
            if (this.jdr == 0L) {
                JVP.traceable.tracePrint(this.traceZone, 1, "Could not get the JDR from server REQ : routine_exec");
                throw GenErr.sqle(-9495, this.conn);
            }
            this.numcols = this.req.getJdrNumCols(this.jdr);
            this.desc = new IfxResultSetMetaData(this.numcols, (IfxConnection)this.conn);
            this.req.initOutputResultSetMetaData((ResultSetMetaData)this.desc, this.jdr);
            this.initInformixSqlBytes();
            this.fpRet = new Vector();
            if (this.numcols > 1) {
                this.fpRet.addElement(this.getColumnInRow(this.numcols));
                for (int i = 0; i < this.numcols - 1; ++i) {
                    this.fpRet.addElement(this.getColumnInRow(i + 1));
                }
            } else {
                this.fpRet.addElement(this.getColumnInRow(1));
            }
            this.passBlobAsUDT = false;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (!this.passBlobAsUDT) {
                this.conn.unLock();
            }
            this.passBlobAsUDT = false;
            if (this.req != null) {
                sapiFreeList.returnToFreeList(this.req);
            }
            this.req = null;
            sapiFreeList = null;
        }
    }

    public Vector getFPReturnVector() {
        return this.fpRet;
    }

    public IfxFParam getFParam() {
        return null;
    }

    public void setResultSetMetaData(IfxResultSetMetaData rsmd) {
        this.desc = rsmd;
    }

    public IfxObject makeInstance(int i) throws SQLException {
        IfxColumnInfo colinfo = this.desc.getColumnInfo(i);
        return IfxValue.makeInstance((IfxConnection)this.conn, (IfxColumnInfo)colinfo);
    }

    public IfxObject makeInstanceFromIfxType(Connection conn, short type) throws SQLException {
        return IfxValue.makeInstanceFromIfxType((IfxConnection)((IfxConnection)conn), (int)type);
    }

    public void setInternalQuery() {
        this.internalQuery = true;
    }

    public void resetInternalQuery() {
        this.internalQuery = false;
    }

    public void executeProtocols(byte[] protocols) {
    }

    public byte[] getProtocols() {
        return null;
    }

    public IfxResultSetMetaData executeDescribeInput() throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocl:executeDescribeInput() is not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectProtocol:executeDescribeInput()", (Locale)Locale.getDefault());
    }

    public IfxResultSetMetaData executeFPDescribe(String signature, boolean isProc, String procName, int numargs) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocl:executeFPDescribe(String signature, boolean isProc, String procName, int numargs) is not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectProtocol:executeFPDescribe(String signature, boolean isProc, String procName, int numargs)", (Locale)Locale.getDefault());
    }

    public void handlePAMAuthentication(String cn) throws SQLException {
        JVP.traceable.tracePrint(this.traceZone, 1, "IfxDirectProtocl:handlePAMAuthentication(String cn) is not supported");
        throw IfxErrMsg.getSQLException((int)-79700, (String)": IfxDirectProtocol:handlePAMAuthentication(String cn)", (Locale)Locale.getDefault());
    }

    static {
        try {
            dataTypes.put(new Integer(7), new Integer(4));
            dataTypes.put(new Integer(5), new Integer(22));
            dataTypes.put(new Integer(8), new Integer(22));
            dataTypes.put(new Integer(10), new Integer(17));
            dataTypes.put(new Integer(14), new Integer(17));
            dataTypes.put(new Integer(17), new Integer(10));
            dataTypes.put(new Integer(18), new Integer(10));
        }
        catch (Exception e) {
            GenErr.sqle(-9495);
        }
    }
}

