/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.UDREnvImpl;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

public class SQLDistinctInput
implements IfmxUDTSQLInput,
SQLInput {
    private long lminfo;
    private boolean isNull = false;
    private DBAMonitor dbaMonitor = null;
    private long conn = 0L;
    private int distinctIndex;
    private int ifxtype;
    private int datalength;
    private boolean autoAlignment = false;

    public SQLDistinctInput(DBAMonitor mon, long blobConn, long ptr, int idx, int type) {
        this.dbaMonitor = mon;
        this.conn = blobConn;
        this.lminfo = ptr;
        this.datalength = UDRLMInfo.getUDTLength(this.lminfo, idx);
        this.distinctIndex = idx;
        this.ifxtype = type;
    }

    @Override
    public boolean wasNull() {
        return this.isNull;
    }

    public void skipBytes(int len) throws SQLException {
    }

    public void setCurrentPosition(int position) throws SQLException {
    }

    public void setAutoAlignment(boolean value) {
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        Timestamp time = null;
        int maxlen = UDRLMInfo.getParamMaxLength(this.lminfo, this.distinctIndex);
        byte[] ba = new byte[maxlen];
        int[] encLen = new int[1];
        UDRLMInfo.getParamValue(this.lminfo, this.distinctIndex, ba, encLen);
        time = IfxToJavaType.IfxToJavaDateTime((byte[])ba, (short)((short)encLen[0]));
        if (time == null) {
            this.isNull = true;
        }
        return time;
    }

    @Override
    public Time readTime() throws SQLException {
        Timestamp ts = this.readTimestamp();
        if (ts == null) {
            this.isNull = true;
            return null;
        }
        return new Time(ts.getTime());
    }

    @Override
    public String readString() throws SQLException {
        throw GenErr.sqle(-9439, "readString()");
    }

    public String readString(int len) throws SQLException {
        String s = null;
        if (this.ifxtype == 14) {
            int[] encLen = new int[1];
            int maxlen = UDRLMInfo.getParamMaxLength(this.lminfo, this.distinctIndex);
            byte[] ba = new byte[maxlen];
            UDRLMInfo.getParamValue(this.lminfo, this.distinctIndex, ba, encLen);
            Interval itrvl = IfxToJavaType.IfxToJavaInterval((byte[])ba, (short)((short)encLen[0]));
            if (itrvl != null) {
                s = itrvl.toString();
            }
        } else {
            int[] strLen = new int[1];
            long l = UDRLMInfo.getStringInputParamValue(this.lminfo, this.distinctIndex, strLen);
            if (l != 0L) {
                int length = strLen[0];
                byte[] str = new byte[length];
                UDREnvImpl.copyCStringWithLen(l, str, length);
                s = new String(str, 0, length);
            }
        }
        if (s == null) {
            this.isNull = true;
        } else {
            s = s.trim();
        }
        return s;
    }

    @Override
    public short readShort() throws SQLException {
        short s = UDRLMInfo.getShortInputParamValue(this.lminfo, this.distinctIndex);
        if (s == Short.MIN_VALUE) {
            this.isNull = true;
        }
        return s;
    }

    @Override
    public Ref readRef() throws SQLException {
        throw GenErr.sqle(-9439, "readRef");
    }

    @Override
    public Object readObject() throws SQLException {
        throw GenErr.sqle(-9439, "readObject");
    }

    @Override
    public long readLong() throws SQLException {
        long l = 0L;
        int maxlen = UDRLMInfo.getParamMaxLength(this.lminfo, this.distinctIndex);
        byte[] ba = new byte[maxlen];
        UDRLMInfo.getParamValue(this.lminfo, this.distinctIndex, ba, null);
        byte[] bSign = new byte[2];
        System.arraycopy(ba, 0, bSign, 0, 2);
        short sign = IfxToJavaType.IfxToJavaSmallInt((byte[])bSign, (short)0);
        if (sign != 0) {
            l = IfxToJavaType.IfxToJavaLongInt((byte[])ba, (short)0);
        } else {
            this.isNull = true;
        }
        return l;
    }

    public long readBigint() throws SQLException {
        long s = UDRLMInfo.getBigintInputParamValue(this.lminfo, this.distinctIndex);
        if (s == Long.MIN_VALUE) {
            this.isNull = true;
        }
        return s;
    }

    public Interval readInterval() throws SQLException {
        throw GenErr.sqle(-9439, "readInterval");
    }

    @Override
    public int readInt() throws SQLException {
        int val = UDRLMInfo.getIntInputParamValue(this.lminfo, this.distinctIndex);
        if (val == Integer.MIN_VALUE) {
            this.isNull = true;
        }
        return val;
    }

    @Override
    public float readFloat() throws SQLException {
        boolean[] isnull = new boolean[]{false};
        float f = UDRLMInfo.getFloatInputParamValue(this.lminfo, isnull, this.distinctIndex);
        if (isnull[0]) {
            this.isNull = true;
        }
        return f;
    }

    @Override
    public double readDouble() throws SQLException {
        boolean[] isnull = new boolean[]{false};
        double d = UDRLMInfo.getDoubleInputParamValue(this.lminfo, isnull, this.distinctIndex);
        if (isnull[0]) {
            this.isNull = true;
        }
        return d;
    }

    @Override
    public Date readDate() throws SQLException {
        Date d = null;
        int maxlen = UDRLMInfo.getParamMaxLength(this.lminfo, this.distinctIndex);
        byte[] ba = new byte[maxlen];
        UDRLMInfo.getParamValue(this.lminfo, this.distinctIndex, ba, null);
        d = IfxToJavaType.IfxToJavaDate((byte[])ba, (short)0);
        if (d == null) {
            this.isNull = true;
        }
        return d;
    }

    @Override
    public Clob readClob() throws SQLException {
        throw GenErr.sqle(-9439, "readClob");
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        throw GenErr.sqle(-9439, "readCharacterStream");
    }

    @Override
    public byte[] readBytes() throws SQLException {
        throw GenErr.sqle(-9439, "readBytes");
    }

    public byte[] readBytes(int len) throws SQLException {
        throw GenErr.sqle(-9439, "readBytes");
    }

    @Override
    public byte readByte() throws SQLException {
        throw GenErr.sqle(-9439, "readByte not supportted for distinct types");
    }

    @Override
    public boolean readBoolean() throws SQLException {
        boolean bool = false;
        int val = UDRLMInfo.getBooleanInputParamValue(this.lminfo, this.distinctIndex);
        if (val == -1) {
            this.isNull = true;
        } else {
            bool = val != 0;
        }
        return bool;
    }

    @Override
    public Blob readBlob() throws SQLException {
        throw GenErr.sqle(-9439, "readBlob");
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        throw GenErr.sqle(-9439, "readBinaryStream");
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        BigDecimal dec = null;
        int[] encLen = new int[1];
        int maxlen = UDRLMInfo.getParamMaxLength(this.lminfo, this.distinctIndex);
        byte[] ba = new byte[maxlen];
        UDRLMInfo.getParamValue(this.lminfo, this.distinctIndex, ba, encLen);
        if (ba[0] == 0 && ba[1] == 0) {
            this.isNull = true;
        } else {
            dec = IfxToJavaType.IfxToJavaDecimal((byte[])ba, (short)((short)encLen[0]));
        }
        return dec;
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        throw GenErr.sqle(-9439, "readAsciiStream");
    }

    @Override
    public Array readArray() throws SQLException {
        throw GenErr.sqle(-9439, "readArray");
    }

    public int length() {
        return this.datalength;
    }

    public IfxUDTInfo getUDTInfo(int xid) throws SQLException {
        throw GenErr.sqle(-9438, "getUDTInfo");
    }

    public IfxUDTInfo getUDTInfo(String name, String owner) throws SQLException {
        throw GenErr.sqle(-9438, "getUDTInfo");
    }

    public int getCurrentPosition() {
        return 0;
    }

    public boolean getAutoAlignment() {
        return this.autoAlignment;
    }

    public int available() {
        return 0;
    }

    @Override
    public URL readURL() throws SQLException {
        throw GenErr.sqle(-9439, "readURL");
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw GenErr.sqle(-9439, "readRowId");
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        throw GenErr.sqle(-9439, "readSQLXML");
    }

    @Override
    public String readNString() throws SQLException {
        throw GenErr.sqle(-9439, "readNString");
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw GenErr.sqle(-9439, "readNClob");
    }
}

