/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class SQLDistinctOutput
implements IfmxUDTSQLOutput,
SQLOutput {
    private long lminfo;
    private DBAMonitor dbaMonitor = null;
    private long conn = 0L;
    private int distinctIndex;
    private int ifxtype;
    private int datalength = 25;

    public SQLDistinctOutput(DBAMonitor mon, long blobConn, long ptr, int idx, int type) {
        this.dbaMonitor = mon;
        this.conn = blobConn;
        this.lminfo = ptr;
        this.distinctIndex = idx;
        this.ifxtype = type;
    }

    @Override
    public void writeTimestamp(Timestamp x) throws SQLException {
        byte[] ba = JavaToIfxType.JavaToIfxDateTime((Timestamp)x);
        UDRLMInfo.putParamValue(this.lminfo, ba, this.distinctIndex);
    }

    @Override
    public void writeTime(Time x) throws SQLException {
        this.writeTimestamp(new Timestamp(x.getTime()));
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        throw GenErr.sqle(-9439, "writeStruct");
    }

    @Override
    public void writeString(String x) throws SQLException {
        throw GenErr.sqle(-9439, "writeString(String)");
    }

    public void writeString(String x, int len) throws SQLException {
        if (this.ifxtype == 14) {
            byte[] ba;
            int qual = UDRLMInfo.getIntervalQual(this.lminfo, this.distinctIndex);
            int start = qual >> 4 & 0xF;
            if (start <= 2) {
                IntervalYM iym = new IntervalYM(x, (short)qual);
                ba = JavaToIfxType.JavaToIfxInterval((IntervalYM)iym);
            } else {
                IntervalDF idf = new IntervalDF(x, (short)qual);
                ba = JavaToIfxType.JavaToIfxInterval((IntervalDF)idf);
            }
            UDRLMInfo.putParamValue(this.lminfo, ba, this.distinctIndex);
        } else {
            UDRLMInfo.putStringOutputParamValue(this.lminfo, x, this.distinctIndex);
        }
    }

    @Override
    public void writeShort(short x) throws SQLException {
        UDRLMInfo.putShortOutputParamValue(this.lminfo, x, this.distinctIndex);
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        throw GenErr.sqle(-9439, "writeRef");
    }

    @Override
    public void writeObject(SQLData x) throws SQLException {
        throw GenErr.sqle(-9439, "writeObject");
    }

    @Override
    public void writeLong(long x) throws SQLException {
        byte[] ba = JavaToIfxType.JavaToIfxLongInt((long)x);
        UDRLMInfo.putParamValue(this.lminfo, ba, this.distinctIndex);
    }

    public void writeBigint(long x) throws SQLException {
        UDRLMInfo.putBigintOutputParamValue(this.lminfo, x, this.distinctIndex);
    }

    public void writeInterval(Interval interval) throws SQLException {
        throw GenErr.sqle(-9439, "writeBytes");
    }

    @Override
    public void writeInt(int x) throws SQLException {
        UDRLMInfo.putIntOutputParamValue(this.lminfo, x, this.distinctIndex);
    }

    @Override
    public void writeFloat(float x) throws SQLException {
        UDRLMInfo.putFloatOutputParamValue(this.lminfo, x, this.distinctIndex);
    }

    @Override
    public void writeDouble(double x) throws SQLException {
        UDRLMInfo.putDoubleOutputParamValue(this.lminfo, x, this.distinctIndex);
    }

    @Override
    public void writeDate(Date x) throws SQLException {
        byte[] ba = JavaToIfxType.JavaToIfxDate((Date)x);
        UDRLMInfo.putParamValue(this.lminfo, ba, this.distinctIndex);
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        throw GenErr.sqle(-9439, "writeClob");
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        throw GenErr.sqle(-9439, "writeCharacterStream");
    }

    @Override
    public void writeBytes(byte[] x) throws SQLException {
        throw GenErr.sqle(-9439, "writeBytes");
    }

    public void writeBytes(byte[] x, int len) throws SQLException {
        throw GenErr.sqle(-9439, "writeBytes");
    }

    @Override
    public void writeByte(byte x) throws SQLException {
        throw GenErr.sqle(-9439, "writeByte");
    }

    @Override
    public void writeBoolean(boolean x) throws SQLException {
        UDRLMInfo.putBooleanOutputParamValue(this.lminfo, x, this.distinctIndex);
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        throw GenErr.sqle(-9439, "writeBlob");
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        throw GenErr.sqle(-9439, "writeBinaryStream");
    }

    @Override
    public void writeBigDecimal(BigDecimal x) throws SQLException {
        byte[] ba = JavaToIfxType.JavaToIfxDecimal((BigDecimal)x);
        UDRLMInfo.putParamValue(this.lminfo, ba, this.distinctIndex);
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        throw GenErr.sqle(-9439, "writeAsciiStream");
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        throw GenErr.sqle(-9439, "writeArray");
    }

    public int length() {
        return this.datalength;
    }

    public void setAutoAlignment(boolean value) {
    }

    public boolean getAutoAlignment() {
        return false;
    }

    public void skipBytes(int len) throws SQLException {
    }

    public int getCurrentPosition() {
        return 0;
    }

    public void setCurrentPosition(int position) throws SQLException {
    }

    public int available() {
        return 0;
    }

    public IfxUDTInfo getUDTInfo(int xid) throws SQLException {
        return null;
    }

    public IfxUDTInfo getUDTInfo(String name, String owner) throws SQLException {
        return null;
    }

    @Override
    public void writeURL(URL x) throws SQLException {
        throw GenErr.sqle(-9439, "writeURL");
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
        throw GenErr.sqle(-9439, "writeSQLXML");
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
        throw GenErr.sqle(-9439, "RowId");
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
        throw GenErr.sqle(-9439, "writeNClob");
    }

    @Override
    public void writeNString(String x) throws SQLException {
        throw GenErr.sqle(-9439, "writeNString");
    }
}

