/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp;

import com.informix.jdbc.IfxDirectConnection;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxSqliConnReUsableConnection;
import informix.jvp.JVP;
import informix.jvp.JVPService;
import informix.jvp.ServiceDirectory;
import informix.jvp.SolanoMaintenance;
import informix.jvp.SolanoStatus;
import informix.jvp.SolanoThreads;
import informix.jvp.dbapplet.impl.DBAThreadImpl;
import informix.jvp.impl.ServiceDirImpl;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.Vector;

public class DBA {
    public static final String traceZone = "DBA";
    public static ServiceDirectory serviceDir;
    public static JVPService logService;
    public static JVPService traceService;
    public static ThreadGroup dbaThreadGroup;
    public static Vector solanoThreadList;

    public static boolean startServiceDirectory(int vp_id) {
        if (serviceDir == null) {
            try {
                serviceDir = new ServiceDirImpl(vp_id);
                return true;
            }
            catch (RemoteException re) {
                re.printStackTrace();
                return false;
            }
        }
        JVP.traceable.tracePrint(traceZone, 2, "ServiceDirectory already running");
        return false;
    }

    public static Vector getSolanoThreads() {
        return solanoThreadList;
    }

    public static synchronized void addSolanoEntry(Thread t, Connection c) {
        SolanoThreads st;
        if (solanoThreadList == null) {
            solanoThreadList = new Vector(3, 3);
        }
        JVP.traceable.tracePrint(traceZone, 2, "addSolanoEntry: " + t.toString());
        for (int i = 0; i < solanoThreadList.size(); ++i) {
            st = (SolanoThreads)solanoThreadList.elementAt(i);
            if (st == null || t != st.getThread() || c != st.getConnection()) continue;
            JVP.traceable.tracePrint(traceZone, 2, "Connection already there");
            return;
        }
        st = new SolanoThreads(t, c);
        solanoThreadList.addElement(st);
    }

    public static synchronized void addSolanoEntry(Object app, Thread t, Connection c) {
        SolanoThreads st;
        if (solanoThreadList == null) {
            solanoThreadList = new Vector(3, 3);
        }
        JVP.traceable.tracePrint(traceZone, 2, "addSolanoEntry: " + t.toString());
        for (int i = 0; i < solanoThreadList.size(); ++i) {
            st = (SolanoThreads)solanoThreadList.elementAt(i);
            if (st == null) continue;
            if (app != null && app == st.getApp()) {
                JVP.traceable.tracePrint(traceZone, 2, "App already in list");
                return;
            }
            if (t != null && t == st.getThread()) {
                JVP.traceable.tracePrint(traceZone, 2, "Thread already in list");
                st.setApp(app);
                return;
            }
            if (c == null || c != st.getConnection()) continue;
            JVP.traceable.tracePrint(traceZone, 2, "Connection already in list");
            st.setApp(app);
            return;
        }
        st = new SolanoThreads(app, t, c);
        solanoThreadList.addElement(st);
    }

    public static synchronized void removeSolanoEntry(Thread t) {
        JVP.traceable.tracePrint(traceZone, 2, "removeSolanoEntry: " + t.toString());
        if (solanoThreadList == null) {
            return;
        }
        for (int i = 0; i < solanoThreadList.size(); ++i) {
            Thread sol_thread;
            JVP.traceable.tracePrint(traceZone, 2, "removeSolanoEntry: trying index " + i);
            SolanoThreads st = (SolanoThreads)solanoThreadList.elementAt(i);
            if (st == null || t != (sol_thread = st.getThread())) continue;
            JVP.traceable.tracePrint(traceZone, 4, "removeSolanoEntry: removed solconn");
            solanoThreadList.removeElementAt(i);
            return;
        }
    }

    public static synchronized void removeSolanoEntry(Connection c) {
        if (solanoThreadList == null) {
            return;
        }
        for (int i = 0; i < solanoThreadList.size(); ++i) {
            Connection sol_conn;
            SolanoThreads st = (SolanoThreads)solanoThreadList.elementAt(i);
            if (st == null || c != (sol_conn = st.getConnection())) continue;
            JVP.traceable.tracePrint(traceZone, 4, "removeSolanoEntry: removed solconn");
            solanoThreadList.removeElementAt(i);
            return;
        }
    }

    public static synchronized void removeSolanoEntry(Object o) {
        if (solanoThreadList == null) {
            return;
        }
        for (int i = 0; i < solanoThreadList.size(); ++i) {
            SolanoThreads st = (SolanoThreads)solanoThreadList.elementAt(i);
            if (st == null || o != st.getApp()) continue;
            JVP.traceable.tracePrint(traceZone, 4, "removeSolanoEntry: removed Object: " + o);
            solanoThreadList.removeElementAt(i);
            return;
        }
    }

    public static synchronized void closeConnsInThread(Thread toPool) {
        if (solanoThreadList == null) {
            return;
        }
        for (int i = 0; i < solanoThreadList.size(); ++i) {
            SolanoThreads st = (SolanoThreads)solanoThreadList.elementAt(i);
            Thread t = st.getThread();
            if (t != toPool) continue;
            Connection conn = st.getConnection();
            try {
                if (conn != null) {
                    try {
                        IfxDirectConnection dirConn = (IfxDirectConnection)((Object)conn);
                        JVP.traceable.tracePrint(traceZone, 2, "closeConnsInThread close DirectConn " + conn);
                        dirConn.close();
                        conn = null;
                    }
                    catch (Exception ee) {}
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (conn == null) {
                try {
                    solanoThreadList.removeElementAt(i);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            --i;
        }
    }

    public static synchronized void closeConnsWithDeadThread() {
        if (solanoThreadList == null) {
            return;
        }
        for (int i = 0; i < solanoThreadList.size(); ++i) {
            SolanoThreads st = (SolanoThreads)solanoThreadList.elementAt(i);
            Thread t = st.getThread();
            if (!t.isAlive()) {
                Connection conn = st.getConnection();
                try {
                    IfxSqliConnReUsableConnection sqliConn;
                    if (conn != null) {
                        try {
                            sqliConn = (IfxSqliConnReUsableConnection)conn;
                            JVP.traceable.tracePrint(traceZone, 2, "closeConnsWithDeadThread close SqliConnReUse " + conn);
                            sqliConn.hardClose();
                            conn = null;
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            IfxDirectConnection dirConn = (IfxDirectConnection)((Object)conn);
                            JVP.traceable.tracePrint(traceZone, 2, "closeConnsWithDeadThread close DirectConn " + conn);
                            dirConn.close();
                            conn = null;
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            sqliConn = (IfxSqliConnect)conn;
                            JVP.traceable.tracePrint(traceZone, 2, "closeConnsWithDeadThread close SqliConn " + conn);
                            sqliConn.close();
                            conn = null;
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (conn == null) {
                    solanoThreadList.removeElementAt(i);
                }
                --i;
                continue;
            }
            JVP.traceable.tracePrint(traceZone, 2, "closeConnsWithDeadThread thread not dead " + t);
        }
    }

    public static Vector listSolanoThreads() {
        if (solanoThreadList == null) {
            return null;
        }
        Vector<SolanoStatus> vicky = new Vector<SolanoStatus>(solanoThreadList.size());
        for (int i = 0; i < solanoThreadList.size(); ++i) {
            String appName = null;
            SolanoThreads st = (SolanoThreads)solanoThreadList.elementAt(i);
            int id = DBA.getThreadId(st);
            if (id < 0) continue;
            Thread t = st.getThread();
            appName = st.getAppString();
            SolanoStatus stat = new SolanoStatus(id, t.getName(), t.toString() + " App " + appName, t.isAlive(), t.isDaemon());
            vicky.addElement(stat);
        }
        return vicky;
    }

    public static Vector getSolanoThreadIds() {
        if (solanoThreadList == null) {
            return null;
        }
        Vector<Integer> vicky = new Vector<Integer>(solanoThreadList.size());
        for (int i = 0; i < solanoThreadList.size(); ++i) {
            SolanoThreads st = (SolanoThreads)solanoThreadList.elementAt(i);
            if (st == null) continue;
            vicky.addElement(new Integer(DBA.getThreadId(st)));
        }
        return vicky;
    }

    public static synchronized boolean killSolanoConnection(int threadno, String user) throws Exception {
        int i;
        SolanoThreads st = null;
        int id = -1;
        if (!user.equals("informix") && !user.equals("root")) {
            throw new Exception("Only the DBA can shut down Solano connections");
        }
        JVP.traceable.tracePrint(traceZone, 2, "killSolanoConnection " + threadno);
        for (i = 0; i < solanoThreadList.size(); ++i) {
            st = (SolanoThreads)solanoThreadList.elementAt(i);
            id = DBA.getThreadId(st);
            if (id < 0) continue;
            if (id == threadno) break;
            st = null;
        }
        Thread t = null;
        if (st == null) {
            return false;
        }
        t = st.getThread();
        if (t == null) {
            return false;
        }
        id = DBA.getThreadId(st);
        if (id < 0) {
            return false;
        }
        boolean found_conn = false;
        if (t != null && id == threadno) {
            JVP.traceable.tracePrint(traceZone, 2, "   closing connection");
            Connection c = st.getConnection();
            if (c != null) {
                found_conn = true;
                try {
                    c.close();
                }
                catch (Exception e) {
                    JVP.traceable.tracePrint(traceZone, 2, "Cannot close connection " + e.getMessage());
                    e.printStackTrace();
                    return false;
                }
            }
        }
        try {
            solanoThreadList.removeElementAt(i);
        }
        catch (Exception e) {
            // empty catch block
        }
        return found_conn;
    }

    public static synchronized boolean askSolanoThreadToDie(int threadno, String user) throws Exception {
        Object t = null;
        SolanoThreads st = null;
        Object app = null;
        if (!user.equals("informix") && !user.equals("root")) {
            throw new Exception("Only the DBA can shut down Solano connections");
        }
        JVP.traceable.tracePrint(traceZone, 2, "askSolanoThreadToDie " + threadno);
        for (int i = 0; solanoThreadList != null && i < solanoThreadList.size(); ++i) {
            st = (SolanoThreads)solanoThreadList.elementAt(i);
            int id = DBA.getThreadId(st);
            if (id < 0 || id != threadno) continue;
            app = st.getApp();
            if (app == null) {
                JVP.log.log(" There is no application to kill, it did not extend SolanoMaintenance");
                return false;
            }
            SolanoMaintenance sm = null;
            try {
                sm = (SolanoMaintenance)app;
            }
            catch (Exception e) {
                JVP.log.log("Can't cast app to SolanoMaintenance " + e.getMessage());
                return false;
            }
            sm.setShutDown(true);
            return true;
        }
        return false;
    }

    public static DBAThreadImpl getParent() {
        Thread thr = Thread.currentThread();
        return DBA.getParent(thr);
    }

    public static DBAThreadImpl getParent(Thread thr) {
        DBAThreadImpl dbathr = null;
        String dbappletname = "DBAPPLET";
        if (thr == null) {
            return null;
        }
        try {
            dbathr = (DBAThreadImpl)thr;
            return dbathr;
        }
        catch (Exception e) {
            ThreadGroup tg = thr.getThreadGroup();
            if (tg == null) {
                return null;
            }
            if (tg.getName().equals(dbappletname)) {
                return null;
            }
            int tc = tg.activeCount();
            if (tc == 0) {
                return null;
            }
            Thread[] list = new Thread[tc];
            tg.enumerate(list);
            for (int j = 0; j < tc; ++j) {
                thr = list[j];
                try {
                    dbathr = (DBAThreadImpl)thr;
                    return dbathr;
                }
                catch (Exception e2) {
                    continue;
                }
            }
            return null;
        }
    }

    private static int getThreadId(SolanoThreads st) {
        Thread t = null;
        if (st == null) {
            return -1;
        }
        t = st.getThread();
        if (t == null) {
            return -1;
        }
        DBAThreadImpl dba_thr = DBA.getParent(t);
        if (dba_thr == null) {
            return -1;
        }
        return dba_thr.getThreadUID();
    }

    static {
        solanoThreadList = null;
    }
}

