/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp;

import informix.jvp.JVP;

public class JVPError
extends Exception {
    private int errCode = 0;
    private int errSeverity = 0;
    public static final int NOERROR = 0;
    public static final int ALLOCFAIL = 1;
    public static final int INITFAIL = 2;
    public static final int OPENFAIL = 4;
    public static final int ENVFAIL = 5;
    public static final int RUNFAIL = 6;
    public static final int EXCPTFAIL = 7;
    public static final int LOADFAIL = 8;
    public static final int THREADFAIL = 9;
    public static final int UNIMPLEMENTED = 10;
    public static final int APPLETEXEC = 11;
    public static final int STDERRFAIL = 12;
    public static final int PANICED = 13;
    public static final int REQUESTERR = 14;
    public static final int PANIC = -1;
    public static final int FATAL = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int STATUS = 4;

    public JVPError(int code, int severity) {
        this.errCode = code;
        this.errSeverity = severity;
    }

    public JVPError(int code, int severity, String message) {
        super(message);
        this.errCode = code;
        this.errSeverity = severity;
    }

    public int severity() {
        return this.errSeverity;
    }

    public int code() {
        return this.errCode;
    }

    public String message() {
        return super.getMessage();
    }

    public void code(int newCode) {
        this.errCode = newCode;
    }

    public void severity(int newSeverity) {
        this.errSeverity = newSeverity;
    }

    public void message(String newMessage) {
    }

    public void log(boolean printTrace) {
        String preamble = null;
        switch (this.severity()) {
            case -1: {
                preamble = "PANIC: ";
                break;
            }
            case 0: {
                preamble = "FATAL: ";
                break;
            }
            case 1: {
                preamble = "ERROR: ";
                break;
            }
            case 2: {
                preamble = "Warning: ";
                break;
            }
            case 3: {
                preamble = "Informational Message: ";
                break;
            }
            case 4: {
                preamble = "Status: ";
                break;
            }
            default: {
                preamble = "Unknown Error Type: ";
            }
        }
        if (printTrace) {
            JVP.log.log(preamble + this.getMessage() + " (code: " + this.code() + ")");
            this.printStackTrace(JVP.log.outStream());
        } else {
            JVP.log.log(preamble + this.getMessage() + " (code: " + this.code() + ")");
        }
    }

    public void process() {
        this.log(false);
        if (this.severity() <= 0) {
            JVPError.errorExit(6, null);
        }
    }

    public void processAsException() {
        this.log(true);
        if (this.severity() <= 0) {
            JVPError.errorExit(6, null);
        }
    }

    public static void unImplemented() {
        JVPError exce = new JVPError(10, -1, "Called unimplemented method");
        exce.processAsException();
    }

    public static void unexpectedException(boolean fatal, Throwable thr) {
        JVP.log.log("Caught unexpected exception: ");
        thr.printStackTrace(JVP.log.outStream());
        if (fatal) {
            JVPError.errorExit(7, null);
        }
    }

    public static void panic(Throwable thr) {
        JVP.log.log("PANIC: ");
        thr.printStackTrace(JVP.log.outStream());
        JVPError.errorExit(13, null);
    }

    public static void panic(String message) {
        JVP.log.log("PANIC: " + message);
        Thread.currentThread();
        Thread.dumpStack();
        JVPError.errorExit(13, null);
    }

    public static void errorExit(int retCode, String errString) {
        if (errString != null) {
            JVP.log.log(errString);
        }
        JVP.log.log("**** JVP exiting abnormally with error code " + retCode);
        JVP.exit(retCode);
    }
}

