/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import com.informix.udr.UDRLog;
import informix.jvp.JVP;
import informix.jvp.JVPError;
import informix.jvp.Logger;
import informix.jvp.impl.LoggerImpl;
import informix.jvp.impl.TraceStreamImpl;
import informix.jvp.impl.TraceableImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;

public class DBALogImpl
implements UDRLog {
    private Logger log = null;
    private String dbaLogPfx = "JAVA UDR Message: ";
    private PrintStream slstream = null;
    private int splitLog = 0;
    private String logFileName = null;
    private int current = 0;

    public void checkLog() {
        if (this.splitLog <= 0) {
            return;
        }
        ++this.current;
        if (this.current < this.splitLog) {
            return;
        }
        this.switchLog();
    }

    private void switchLog() {
        File oldf;
        String oldfname;
        if (this.slstream != null) {
            this.slstream.close();
            this.slstream = null;
        }
        System.out.println("*** Start copying old log content to " + this.logFileName + "old ***");
        try {
            oldfname = this.logFileName + "old";
            oldf = new File(oldfname);
            oldf.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            oldfname = this.logFileName + "old";
            oldf = new File(oldfname);
            File newf = new File(this.logFileName);
            newf.renameTo(oldf);
            newf.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.slstream = new PrintStream(new FileOutputStream(this.logFileName, true));
            LoggerImpl logImpl = new LoggerImpl(this.slstream);
            JVP.log = logImpl;
            TraceStreamImpl tstream = new TraceStreamImpl();
            JVP.traceable = new TraceableImpl(new TraceStreamImpl());
            System.out.println("*** Log file reset is successful ***" + new Date().toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.current = 0;
    }

    public DBALogImpl(String logFile, int split) {
        if (logFile == null) {
            JVPError.panic("cannot access log file");
        }
        this.logFileName = logFile;
        this.splitLog = split;
        this.current = 0;
        if (split > 0) {
            this.switchLog();
        }
    }

    @Override
    public void log(String logMsg) {
        String name = Thread.currentThread().getName();
        if (name == null) {
            name = "<**** Unknown JAVA UDR ****>";
        }
        if (logMsg == null) {
            this.log.log(this.dbaLogPfx + name + ": " + "<Null JAVA UDR log Message>");
        } else {
            this.log.log(this.dbaLogPfx + name + ": " + logMsg);
        }
    }
}

