/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import informix.jvp.JVP;
import informix.jvp.JVPError;
import informix.jvp.Semaphore;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.IfxSQLException;
import informix.jvp.dbapplet.SAPIRequest;
import informix.jvp.impl.MTEventImpl;
import informix.jvp.impl.SemaphoreImpl;
import java.util.Vector;

public class DBAMonitorImpl
implements DBAMonitor {
    int msgId0 = 0;
    int msgId1;
    private Semaphore semDBATask;
    private MTEventImpl eventAny;
    private int dbaTask;
    private int dbaStatus;
    private Vector sapiRequests;
    private IfxSQLException sqlex;
    private DBAMonitor solanoMonitor = null;
    private String name = null;

    public DBAMonitorImpl(String name, long handle) {
        this.fillDBAMonitorImpl(name, handle);
    }

    public DBAMonitorImpl(String name) {
        this.name = name;
    }

    public void fillDBAMonitorImpl(String semAname, long mtcb) {
        this.name = semAname;
        JVP.traceable.tracePrint("JVP.DBA.Monitor", 4, "fillDBAMonitorImpl " + semAname + ": mtcb " + mtcb);
        this.semDBATask = new SemaphoreImpl(semAname);
        this.dbaTask = 0;
        this.dbaStatus = 0;
        this.eventAny = mtcb != 0L ? new MTEventImpl(mtcb) : null;
        this.sapiRequests = new Vector(1, 1);
    }

    @Override
    public void setHandle(long mtcb) {
        JVP.traceable.tracePrint("JVP.DBA.Monitor", 4, "setHandle " + mtcb);
        this.eventAny = new MTEventImpl(mtcb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDBATask(int task) {
        DBAMonitorImpl dBAMonitorImpl = this;
        synchronized (dBAMonitorImpl) {
            this.dbaTask = task;
            this.msgId1 = ++this.msgId0;
        }
        this.semDBATask.V();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitDBATask() {
        int task;
        this.semDBATask.P();
        DBAMonitorImpl dBAMonitorImpl = this;
        synchronized (dBAMonitorImpl) {
            task = this.dbaTask;
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDBAException(IfxSQLException ex) {
        JVP.traceable.tracePrint("JVP.DBA.Monitor", 1, "notify JAVA UDR error = " + ex.toString());
        DBAMonitorImpl dBAMonitorImpl = this;
        synchronized (dBAMonitorImpl) {
            this.sqlex = ex;
        }
        this.notifyDBAStatus(11);
    }

    public static int getMsgId0(DBAMonitorImpl m) {
        return m.msgId0;
    }

    public static int getMsgId1(DBAMonitorImpl m) {
        return m.msgId1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDBAStatus(int status) {
        JVP.traceable.tracePrint("JVP.DBA.Monitor", 4, "notify JAVA UDR status = " + new Integer(status).toString() + " tcb: " + this.eventAny.mtcb);
        this.eventAny.lockTcb();
        DBAMonitorImpl dBAMonitorImpl = this;
        synchronized (dBAMonitorImpl) {
            this.dbaStatus = status;
            ++this.msgId1;
        }
        this.eventAny.sendSignal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySAPICall(SAPIRequest req) {
        JVP.traceable.tracePrint("JVP.DBA.Monitor", 4, "notifySAPICall for " + this.name + " tcb: " + this.eventAny.mtcb + "\t req = " + req);
        if (this.sapiRequests == null) {
            JVP.traceable.tracePrint("JVP.DBA.Monitor", 5, "sapiRequests is null, allocing one");
            this.sapiRequests = new Vector(1, 1);
        }
        this.eventAny.lockTcb();
        DBAMonitorImpl dBAMonitorImpl = this;
        synchronized (dBAMonitorImpl) {
            this.sapiRequests.addElement(req);
            ++this.msgId1;
        }
        this.eventAny.sendSignal();
    }

    @Override
    public void waitSAPICallDone(SAPIRequest req) {
        JVP.traceable.tracePrint("JVP.DBA.Monitor", 5, "In waitSAPICallDone req = " + req);
        req.getSemaphore().P();
        JVP.traceable.tracePrint("JVP.DBA.Monitor", 5, "P Finished");
    }

    @Override
    public void notifySAPICallDone(SAPIRequest req) {
        JVP.traceable.tracePrint("JVP.DBA.Monitor", 5, "In notifySAPICallDone req = " + req + "V Started");
        this.msgId1 = ++this.msgId0;
        req.getSemaphore().V();
        JVP.traceable.tracePrint("JVP.DBA.Monitor", 5, "V Finished");
    }

    @Override
    public void wakeServerCredential(SAPIRequest req) {
        JVP.traceable.tracePrint("JVP.DBA.Monitor", 5, "V Finished");
        if (++this.msgId0 < 0) {
            this.msgId0 = 1;
        }
        this.msgId1 = this.msgId0;
        req.getSemaphore().V();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int retrieveDBAStatus() {
        DBAMonitorImpl dBAMonitorImpl = this;
        synchronized (dBAMonitorImpl) {
            int status = this.dbaStatus;
            this.dbaStatus = 0;
            JVP.traceable.tracePrint("JVP.DBA.Monitor", 4, "retrieve JAVA UDR status = " + new Integer(status).toString() + " tcb = " + this.eventAny.mtcb);
            return status;
        }
    }

    @Override
    public IfxSQLException retrieveDBAException() {
        return this.sqlex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SAPIRequest retrieveNextSAPICall() {
        DBAMonitorImpl dBAMonitorImpl = this;
        synchronized (dBAMonitorImpl) {
            try {
                if (this.sapiRequests == null || this.sapiRequests.size() == 0) {
                    return null;
                }
                SAPIRequest req = (SAPIRequest)this.sapiRequests.firstElement();
                this.sapiRequests.removeElement(req);
                return req;
            }
            catch (Exception se) {
                JVPError.unexpectedException(false, se);
                return null;
            }
        }
    }

    @Override
    public void setSolanoAppMonitor(DBAMonitor mon) {
        this.solanoMonitor = mon;
    }

    @Override
    public DBAMonitor getSolanoAppMonitor() {
        return this.solanoMonitor;
    }

    public String getName() {
        return this.name;
    }
}

