/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import com.informix.jdbc.IfxLocales;
import com.informix.udr.UDREnv;
import informix.jvp.DBA;
import informix.jvp.JVP;
import informix.jvp.JVPError;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.DBAThread;
import informix.jvp.dbapplet.DBAThreadPool;
import informix.jvp.dbapplet.IfxSQLException;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.PerJavaUDRContext;
import informix.jvp.dbapplet.impl.SAPIRequestImpl;
import informix.jvp.dbapplet.impl.SQLJParamImpl;
import informix.jvp.dbapplet.impl.TimeEventTrace;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import informix.jvp.dbapplet.impl.UDREnvImpl;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBAThreadImpl
extends Thread
implements DBAThread {
    private boolean noDBWork;
    private boolean DBAThreadExit;
    private DBAThreadPool threadPoolOwner;
    private LinkedList JavaUDRContextV;
    private SAPIRequestImpl sapiReqCache;
    private IfxSQLException ifxSQLException = null;
    private PerJavaUDRContext currJavaUDRContext;
    private long lminfo = 0L;
    DBAMonitor dbaMonitor;
    private String dbEncoding = null;
    private String dbLocale = null;
    int threadUID;
    private static int threadUIDGen = 0;
    private String threadState;
    private boolean hasSolanoConns = false;

    @Override
    public SAPIRequestImpl getSAPIReqFromThreadCache() {
        return this.sapiReqCache;
    }

    @Override
    public void setSAPIReqThreadCache(SAPIRequestImpl req) {
        this.sapiReqCache = req;
    }

    @Override
    public void clearSAPIReqThreadCache() {
        this.sapiReqCache = null;
    }

    public void setLminfo(long lminf) {
        this.lminfo = lminf;
    }

    public long getLminfo() {
        return this.lminfo;
    }

    private static synchronized int makeThreadUID() {
        return ++threadUIDGen;
    }

    @Override
    public int getThreadUID() {
        return this.threadUID;
    }

    @Override
    public PerJavaUDRContext getCurrentUDRContext() {
        return this.currJavaUDRContext;
    }

    @Override
    public void setCurrentUDRContext(PerJavaUDRContext udrC) {
        this.currJavaUDRContext = udrC;
    }

    @Override
    public UDREnv getUDREnv() {
        return this.currJavaUDRContext.getUDREnv();
    }

    public SQLJParamImpl getParamMgr() {
        return this.currJavaUDRContext.getParamMgr();
    }

    public DBAThreadImpl(ThreadGroup group, String name, DBAMonitor dbaMonitor, DBAThreadPool pool) throws SQLException {
        super(group, name);
        this.setDaemon(true);
        try {
            this.DBAThreadExit = false;
            this.noDBWork = true;
            this.threadUID = DBAThreadImpl.makeThreadUID();
            this.threadState = "BORN";
            this.dbaMonitor = dbaMonitor;
            this.JavaUDRContextV = new LinkedList();
            this.currJavaUDRContext = null;
            this.threadPoolOwner = pool;
            this.setPriority(3);
            this.dbLocale = this.ggetEnv("DB_LOCALE");
            JVP.traceable.tracePrint("JVP.DBA.Thread", 2, "DB_LOCALE " + this.dbLocale);
            if (this.dbLocale != null) {
                this.parseIfxLocale("db", this.dbLocale);
            }
        }
        catch (Exception e) {
            JVP.log.log("Cannot create DBAThreadImpl object " + e.toString());
            throw GenErr.sqle(-9441, e.toString(), this.dbLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitYourSelf() {
        this.DBAThreadExit = true;
        DBAThreadImpl dBAThreadImpl = this;
        synchronized (dBAThreadImpl) {
            this.notify();
        }
    }

    private void initialize() {
        this.JavaUDRContextV = new LinkedList();
    }

    private void cleanup() {
        if (this.threadPoolOwner != null) {
            this.dbaMonitor = null;
            this.JavaUDRContextV = null;
            this.currJavaUDRContext = null;
        }
        if (this.hasSolanoConns) {
            DBA.closeConnsInThread(this);
        }
        this.hasSolanoConns = false;
        SAPIRequestImpl req = this.getSAPIReqFromThreadCache();
        if (req != null) {
            this.clearSAPIReqThreadCache();
            UDRDBAContextImpl.getSapiFreeList().returnToFreeListDirectly(req);
        }
    }

    @Override
    public void setMonitor(DBAMonitor dbaMonitor) {
        this.dbaMonitor = dbaMonitor;
    }

    @Override
    public String getModuleName() {
        return this.currJavaUDRContext.getModuleName();
    }

    @Override
    public void setModuleName(String newName) {
        this.currJavaUDRContext.setModuleName(newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: {
            try {
                this.setPriority(9);
            }
            catch (SecurityException se) {
                JVPError.unexpectedException(false, se);
            }
            while (true) {
                if (this.threadPoolOwner != null) {
                    this.threadState = "IN-POOL";
                    DBAThreadImpl dBAThreadImpl = this;
                    synchronized (dBAThreadImpl) {
                        while (this.noDBWork && !this.DBAThreadExit) {
                            JVP.traceable.tracePrint("JVP.DBA.Thread", 1, "Thread " + this.toString() + " IN POOL WAITS FOR WORK");
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (this.DBAThreadExit) {
                        this.threadState = "EXIT";
                        JVP.traceable.tracePrint("JVP.DBA.Thread", 1, "Thread " + this.toString() + " DIES");
                        break block11;
                    }
                }
                this.runDBWork();
                if (this.threadPoolOwner == null) break;
                this.noDBWork = true;
                this.threadPoolOwner.putThreadBackToPool(this);
                JVP.traceable.tracePrint("JVP.DBA.Thread", 1, "return thread " + this.toString() + " back to pool");
            }
            this.threadState = "EXIT";
            JVP.traceable.tracePrint("JVP.DBA.Thread", 2, "Thread " + this.toString() + " DIES");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalDBMSWork() {
        DBAThreadImpl dBAThreadImpl = this;
        synchronized (dBAThreadImpl) {
            JVP.traceable.tracePrint("JVP.DBA.Thread", 2, "Thread " + this.toString() + " IN POOL GETS WORK");
            this.noDBWork = false;
            this.notify();
        }
    }

    public void runDBWork() {
        JVP.traceable.tracePrint("JVP.DBA.Thread", 2, "start runDBWork");
        this.initialize();
        this.runDBApplet();
        this.cleanup();
        JVP.traceable.tracePrint("JVP.DBA.Thread", 2, "Finish runDBWork");
    }

    private void runDBApplet() {
        while (true) {
            this.threadState = " IDLE";
            JVP.traceable.tracePrint("JVP.DBA.Thread", 4, this.getName() + " JAVA UDR WAITING on new JLM task code ");
            int task = this.dbaMonitor.waitDBATask();
            JVP.traceable.tracePrint("JVP.DBA.Thread", 4, this.getName() + " JAVA UDR receives new JLM task code " + new Integer(task).toString());
            if (TimeEventTrace.tracing) {
                TimeEventTrace.StopEvent(4, 1);
            }
            if (TimeEventTrace.tracing) {
                TimeEventTrace.StopEvent(6, 1);
            }
            try {
                try {
                    switch (task) {
                        case 1: {
                            this.threadState = "INIT";
                            JVP.traceable.tracePrint("JVP.DBA.Thread", 5, "Running JAVA UDR");
                            this.JavaUDRContextV.add(this.currJavaUDRContext);
                            this.dbaMonitor.notifyDBAStatus(10);
                            break;
                        }
                        case 2: {
                            if (TimeEventTrace.tracing) {
                                TimeEventTrace.StartEvent(21, this.threadUID);
                            }
                            this.threadState = "EXECUTE";
                            this.dbLocale = this.getCurrentUDRContext().getUDREnv().getDBLocale();
                            JVP.traceable.tracePrint("JVP.DBA.Thread", 2, "DB_LOCALE " + this.dbLocale);
                            if (this.dbLocale != null) {
                                this.parseIfxLocale("db", this.dbLocale);
                            }
                            this.currJavaUDRContext.invokeUDR();
                            if (TimeEventTrace.tracing) {
                                TimeEventTrace.StopEvent(21, this.threadUID);
                                TimeEventTrace.StartEvent(4, 1);
                                TimeEventTrace.StartEvent(7, 1);
                            }
                            this.dbaMonitor.notifyDBAStatus(10);
                            break;
                        }
                        case 4: {
                            this.threadState = "CLOSE";
                            JVP.traceable.tracePrint("JVP.DBA.Thread", 5, "receiving DBA_CLOSE message");
                            JVP.traceable.tracePrint("JVP.DBA.Thread", 5, "trying to close the current java udr context under this dba thread.");
                            this.currJavaUDRContext.cleanup();
                            this.JavaUDRContextV.remove(this.currJavaUDRContext);
                            this.currJavaUDRContext = null;
                            JVP.traceable.tracePrint("JVP.DBA.Thread", 5, "finish closing the current java udr context under this dba thread.");
                            JVP.traceable.tracePrint("JVP.DBA.Thread", 5, "just closing udr context but continuing with JAVA UDR");
                            this.dbaMonitor.notifyDBAStatus(10);
                            break;
                        }
                        case 3: {
                            this.threadState = "DESTROY";
                            JVP.traceable.tracePrint("JVP.DBA.Thread", 5, "receiving DBA_DESTROY message");
                            JVP.traceable.tracePrint("JVP.DBA.Thread", 5, "trying to close all java udr contexts under this dba thread.");
                            while (!this.JavaUDRContextV.isEmpty()) {
                                PerJavaUDRContext p = (PerJavaUDRContext)this.JavaUDRContextV.removeLast();
                                p.cleanup();
                            }
                            JVP.traceable.tracePrint("JVP.DBA.Thread", 5, "finish closing all java udr contexts under this dba thread.");
                            this.JavaUDRContextV = null;
                            JVP.traceable.tracePrint("JVP.DBA.Thread", 5, "stopping JAVA UDR");
                            this.dbaMonitor.notifyDBAStatus(10);
                            JVP.traceable.tracePrint("JVP.DBA.Thread", 5, "runDBApplet returns");
                            return;
                        }
                    }
                    continue;
                }
                catch (AbstractMethodError err) {
                    String msg;
                    if (err == null || (msg = err.getMessage()) == null) {
                        throw GenErr.sqle(-9479, "AbstractMethodError");
                    }
                    Pattern p = Pattern.compile("javax?\\/sql\\/[^(]+\\([^)]+\\)");
                    Matcher m = p.matcher(msg);
                    if (!m.find()) {
                        throw err;
                    }
                    throw GenErr.sqle(-26491, m.group(0));
                }
            }
            catch (SQLException sqle) {
                JVP.traceable.tracePrint("JVP.DBA.Thread", 5, "SQL Exception thrown during UDR execution " + sqle.toString());
                sqle.printStackTrace();
                SQLException last = sqle;
                while (last.getNextException() != null) {
                    last = last.getNextException();
                }
                sqle = last;
                if (this.ifxSQLException == null || this.ifxSQLException.getSQLException() != sqle) {
                    GenErr.setIfxSQLException(sqle);
                }
                this.dbaMonitor.notifyDBAException(this.ifxSQLException);
                continue;
            }
            catch (Throwable th) {
                JVP.traceable.tracePrint("JVP.DBA.Thread", 5, "Unknown Exception thrown during UDR execution " + th.toString());
                th.printStackTrace();
                GenErr.sqle(-9479, th.toString(), this.dbLocale);
                this.dbaMonitor.notifyDBAException(this.ifxSQLException);
                continue;
            }
            break;
        }
    }

    public DBAMonitor getDBAMonitor() {
        return this.dbaMonitor;
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = res + ",state = " + this.threadState;
        res = res + " T#" + this.getThreadUID();
        return res;
    }

    @Override
    public String getLocale() {
        return this.dbLocale;
    }

    @Override
    public String getEncoding() {
        return this.dbEncoding;
    }

    public String ggetEnv(String envVar) {
        int[] len = new int[1];
        long envValPtr = UDRLMInfo.ggetEnv(this.getLminfo(), envVar, len);
        byte[] buf = new byte[len[0]];
        String envVal = null;
        if (envValPtr != 0L) {
            UDREnvImpl.copyCString(envValPtr, buf);
            envVal = new String(buf);
        }
        return envVal;
    }

    @Override
    public IfxSQLException getIfxSQLException() {
        return this.ifxSQLException;
    }

    @Override
    public void setIfxSQLException(IfxSQLException ifxsqle) {
        this.ifxSQLException = ifxsqle;
    }

    public void setHasSolanoConns() {
        this.hasSolanoConns = true;
    }

    private void parseIfxLocale(String prefix, String glsOrNLSLocale) throws SQLException {
        SortedMap<String, Charset> available;
        String originalEncoding = null;
        String originalLocale = null;
        String tmpValue = glsOrNLSLocale;
        String tLocale = null;
        String tEncoding = null;
        StringTokenizer itok = new StringTokenizer(tmpValue, "@");
        tmpValue = itok.nextToken();
        itok = new StringTokenizer(tmpValue, ".");
        tLocale = itok.nextToken();
        if (itok.hasMoreTokens()) {
            tEncoding = itok.nextToken();
        }
        originalEncoding = tEncoding;
        originalLocale = tLocale;
        if (tLocale != null) {
            tmpValue = IfxLocales.FromIfxToJdkLocale((String)tLocale);
            tLocale = tmpValue != null ? tmpValue : IfxLocales.FromIfxQAToJdkLocale((String)tLocale);
        }
        if (tEncoding != null) {
            tmpValue = IfxLocales.FromIfxNameToJdkName((String)tEncoding);
            tEncoding = tmpValue != null ? tmpValue : ((tmpValue = IfxLocales.FromIfxNoToJdkName((String)tEncoding)) != null ? tmpValue : IfxLocales.FromIfxQANameToJdkName((String)tEncoding));
        }
        if (tEncoding == null || tLocale == null) {
            String[] tmpResult = new String[2];
            tmpResult = null;
            tmpResult = IfxLocales.FromNLSToJDK((String)glsOrNLSLocale);
            if (tmpResult != null) {
                tLocale = tmpResult[0];
                tEncoding = tmpResult[1];
            }
        }
        if (tEncoding == null && originalEncoding != null && (available = Charset.availableCharsets()).containsKey(originalEncoding)) {
            tEncoding = originalEncoding;
            try {
                if (this.threadPoolOwner != null && !this.threadPoolOwner.hasCharset(originalEncoding)) {
                    this.threadPoolOwner.addCharset(originalEncoding);
                    UDRLMInfo.mtLogPrint("JVP: using non-default Java Charset \"" + originalEncoding + "\"");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tLocale == null && originalLocale != null && (tLocale = IfxLocales.FromIfxToJdkLocale((String)originalLocale)) == null) {
                tLocale = IfxLocales.FromIfxQAToJdkLocale((String)originalLocale);
            }
        }
        if (tLocale == null || tEncoding == null) {
            throw GenErr.sqle(-79784);
        }
        this.dbLocale = tLocale;
        this.dbEncoding = tEncoding;
    }
}

