/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import informix.jvp.JVP;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.DBAThread;
import informix.jvp.dbapplet.DBAThreadPool;
import informix.jvp.dbapplet.impl.DBAThreadImpl;
import informix.jvp.dbapplet.impl.DBAThreadPoolPatrol;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;

public class DBAThreadPoolImpl
implements DBAThreadPool {
    int initialPoolSize;
    int numberOfThreadsInPool;
    long currentNumberOfGetCount;
    LinkedList pool;
    int patrolInterval;
    private HashMap<String, Boolean> customCharsets = new HashMap();

    public DBAThreadPoolImpl(int poolSize, int patrolInterval) throws SQLException {
        this.initialPoolSize = poolSize;
        this.numberOfThreadsInPool = poolSize;
        this.currentNumberOfGetCount = 0L;
        this.patrolInterval = patrolInterval;
        this.pool = new LinkedList();
        for (int i = 0; i < poolSize; ++i) {
            DBAThreadImpl p = new DBAThreadImpl(UDRDBAContextImpl.dbaThreadGroup, "DBAThreadInPool", null, this);
            this.pool.add(p);
            p.start();
        }
        if (patrolInterval > 0) {
            new DBAThreadPoolPatrol(this).start();
        }
    }

    @Override
    public boolean hasCharset(String name) {
        return this.customCharsets != null && name != null && this.customCharsets.containsKey(name);
    }

    @Override
    public void addCharset(String name) {
        if (this.customCharsets == null || name == null) {
            return;
        }
        this.customCharsets.put(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBAThread getDBAThreadFromPool(ThreadGroup grp, String name, DBAMonitor monitor) throws SQLException {
        DBAThreadPoolImpl dBAThreadPoolImpl = this;
        synchronized (dBAThreadPoolImpl) {
            if (!this.pool.isEmpty()) {
                DBAThreadImpl p = (DBAThreadImpl)this.pool.removeFirst();
                --this.numberOfThreadsInPool;
                p.setMonitor(monitor);
                p.setName(name);
                JVP.traceable.tracePrint("JVP.DBAThreadPool", 1, "get a DBAThread " + p.toString() + "From Pool");
                return p;
            }
            ++this.currentNumberOfGetCount;
        }
        DBAThreadImpl p = new DBAThreadImpl(grp, name, monitor, this);
        JVP.traceable.tracePrint("JVP.DBAThreadPool", 1, "create a new DBAThread " + p.toString());
        p.start();
        return p;
    }

    @Override
    public synchronized void putThreadBackToPool(DBAThread dbaThread) {
        this.pool.add(dbaThread);
        ++this.numberOfThreadsInPool;
    }
}

