/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import informix.jvp.JVP;
import informix.jvp.dbapplet.impl.DBAThreadImpl;
import informix.jvp.dbapplet.impl.DBAThreadPoolImpl;

class DBAThreadPoolPatrol
extends Thread {
    private boolean noExit;
    DBAThreadPoolImpl pool;
    long pastNumberOfGetCount;
    static final int MAX_THREAD_RELEASED_AT_A_TIME = 10;
    static final int NUMBER_OF_COUNT_DIFF = 50;

    public DBAThreadPoolPatrol(DBAThreadPoolImpl pool) {
        this.pool = pool;
        this.noExit = true;
        this.setDaemon(true);
        this.pastNumberOfGetCount = 0L;
        JVP.traceable.tracePrint("JVP.DBAThreadPool", 1, "DBAThreadPool Patrol started");
    }

    public void exitYourSelf() {
        this.noExit = false;
    }

    boolean releaseThreadCondition() {
        return this.pool.numberOfThreadsInPool > this.pool.initialPoolSize && this.pool.currentNumberOfGetCount - this.pastNumberOfGetCount < 50L;
    }

    void releaseThreads() {
        int exceed = this.pool.numberOfThreadsInPool - this.pool.initialPoolSize;
        int numberOfThreadsToBeReleased = exceed < 10 ? exceed : 10;
        for (int i = 0; i < numberOfThreadsToBeReleased; ++i) {
            DBAThreadImpl p = (DBAThreadImpl)this.pool.pool.removeFirst();
            --this.pool.numberOfThreadsInPool;
            p.exitYourSelf();
        }
        JVP.traceable.tracePrint("JVP.DBAThreadPool", 1, "DBAThreadCleanedUp = " + numberOfThreadsToBeReleased + " currentNumberOfGetCount = " + this.pool.currentNumberOfGetCount + " pastNumberOfGetCount = " + this.pastNumberOfGetCount);
        this.pool.currentNumberOfGetCount = 0L;
        this.pastNumberOfGetCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.noExit) {
            try {
                DBAThreadPoolPatrol.sleep(this.pool.patrolInterval * 60);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.pastNumberOfGetCount = this.pool.currentNumberOfGetCount;
            if (!this.releaseThreadCondition()) continue;
            DBAThreadPoolImpl dBAThreadPoolImpl = this.pool;
            synchronized (dBAThreadPoolImpl) {
                if (this.releaseThreadCondition()) {
                    this.releaseThreads();
                }
            }
        }
    }
}

