/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import informix.jvp.dbapplet.impl.EventTrace;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;

public class EventTraceList {
    public static final int numEventTraces = 256;
    public static EventTrace[] eList = new EventTrace[256];
    public static final int EventJavaUDRExec = 1;
    public static final int EventContextOpenClose = 2;
    public static final int EventLangCOverhead = 3;
    public static final int EventContextSwitch = 4;
    public static final int EventSAPIDispatch = 5;
    public static final int EventC2JAVAContextSwitch = 6;
    public static final int EventJAVA2CContextSwitch = 7;
    public static final int EventLangJavaUDR = 21;
    public static final int EventUserUDRCode = 22;
    public static final int EventJavaToSQLMapping = 23;
    public static final int EventStartJavaThread = 24;

    public static void initEventTraceList() {
        for (int i = 0; i < 256; ++i) {
            EventTraceList.eList[i] = new EventTrace();
            EventTraceList.eList[i].numEvents = 0;
            EventTraceList.eList[i].cumEventTime = 0L;
            EventTraceList.eList[i].eventName = "Undefined";
        }
        EventTraceList.eList[1].eventName = "Total Java UDR execution time";
        EventTraceList.eList[2].eventName = "Java Context Open/Close";
        EventTraceList.eList[3].eventName = "C-part lang manager overhead";
        EventTraceList.eList[4].eventName = "Context switch overhead";
        EventTraceList.eList[6].eventName = "C2JAVA Context switch overhead";
        EventTraceList.eList[7].eventName = "JAVA2C Context switch overhead";
        EventTraceList.eList[5].eventName = "SAPI dispatch loop";
        EventTraceList.eList[21].eventName = "Java lang manager with user UDR code";
        EventTraceList.eList[22].eventName = "User's UDR code";
        EventTraceList.eList[23].eventName = "Java to SQL type mapping";
        EventTraceList.eList[24].eventName = "Java thread creation/destroy";
    }

    public static void PrintEventTraceList() {
        System.out.println("Events recorded: JVP = " + UDRDBAContextImpl.vpid);
        for (int i = 0; i < 256; ++i) {
            if (EventTraceList.eList[i].cumEventTime == 0L) continue;
            System.out.println("    Event: " + EventTraceList.eList[i].eventName);
            System.out.println("\tNumEvents: " + EventTraceList.eList[i].numEvents);
            System.out.println("\tTotalTime: " + EventTraceList.eList[i].cumEventTime);
        }
    }
}

