/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import informix.jvp.JVP;
import informix.jvp.JVPError;
import informix.jvp.Semaphore;
import informix.jvp.dbapplet.impl.YieldThreadImpl;
import informix.jvp.impl.MTAlarmThreadImpl;
import informix.jvp.impl.SemaphoreImpl;

public class IdleThreadImpl
extends Thread {
    private static Semaphore mtSem;
    private static boolean run_status;

    public static void init() {
        try {
            mtSem = new SemaphoreImpl("IdleThreadImpl Sem");
        }
        catch (Exception e) {
            JVP.log.log("IdleThreadImpl init() exception " + e.toString());
        }
    }

    public static void drainWork() {
        try {
            mtSem.P();
        }
        catch (Exception e) {
            JVP.log.log("IdleThreadImpl init() exception " + e.toString());
        }
    }

    public static void wakeUpMT() {
        try {
            mtSem.statelessV();
        }
        catch (Exception e) {
            JVP.log.log("IdleThreadImpl init() exception " + e.toString());
        }
    }

    @Override
    public void run() {
        try {
            this.setPriority(2);
        }
        catch (Exception ce) {
            JVPError.unexpectedException(false, ce);
            return;
        }
        try {
            while (this.getRunStatus()) {
                this.yield();
                IdleThreadImpl.wakeUpMT();
            }
            while (!YieldThreadImpl.getTerminateStatus()) {
                this.yield();
            }
            while (!MTAlarmThreadImpl.getTerminateStatus()) {
                this.yield();
            }
            System.err.println("Idle thread terminate");
            return;
        }
        catch (Exception ce) {
            JVPError.panic("Idle thread died:" + ce.toString());
            return;
        }
    }

    synchronized boolean getRunStatus() {
        return run_status;
    }

    static synchronized void terminate() {
        run_status = false;
    }

    static {
        run_status = true;
    }
}

