/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDirectConnection;
import com.informix.jdbc.IfxDirectProtocol;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.udr.UDREnv;
import informix.jvp.JVP;
import informix.jvp.dbapplet.impl.DBAThreadImpl;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.JarHandler;
import informix.jvp.dbapplet.impl.PerJavaUDRContext;
import informix.jvp.dbapplet.impl.SQLJParamImpl;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import informix.jvp.dbapplet.impl.UDRDBAManagerImpl;
import informix.jvp.dbapplet.impl.UDREnvImpl;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class JVPClassLoader
extends ClassLoader {
    private static Hashtable udtExtNames = null;
    private static boolean haveAllTypes = false;
    private static Hashtable udtLengths = null;
    private Connection callerConn;
    String jarPath = null;
    private Hashtable cache;
    private String jarName = null;
    private boolean isSolanoLoader = false;
    private static final int UDTCLASS = 1;
    private static final int OTHERCLASS = 2;

    protected JVPClassLoader(String name) {
        this.jarName = name;
        this.cache = new Hashtable();
        this.callerConn = null;
    }

    public JVPClassLoader() {
        this.callerConn = null;
    }

    public JVPClassLoader(boolean isSolano) {
        this.isSolanoLoader = isSolano;
        this.callerConn = null;
        this.jarName = "NULL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        UDRDBAManagerImpl mgr;
        UDRDBAManagerImpl uDRDBAManagerImpl = mgr = (UDRDBAManagerImpl)UDRDBAContextImpl.udrDBAManager;
        synchronized (uDRDBAManagerImpl) {
            Class ClassObj = null;
            String className = null;
            int pos = name.indexOf(":");
            if (pos != -1) {
                className = name.substring(pos + 1);
                try {
                    if (this.cache != null) {
                        ClassObj = (Class)this.cache.get(className);
                    }
                }
                catch (ClassCastException cce) {
                    throw new ClassNotFoundException(cce.toString());
                }
                if (ClassObj == null) {
                    String jar = name.substring(0, pos);
                    if (!jar.equals(this.jarName)) {
                        mgr.loadClassWorkhorse(name);
                        return mgr.getLoadedClass(name);
                    }
                    ClassObj = this.getClassFromJar(className, this.callerConn);
                    if (ClassObj == null) {
                        throw new ClassNotFoundException("Class " + name + " not found in jar " + this.jarName + ". Please verify the three part name " + "(dbname.username.jarid) of the installed " + "jar with the jar file name in your " + "JAR_TEMP_PATH or /tmp directory.");
                    }
                }
            } else {
                try {
                    ClassObj = this.findSystemClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                if (ClassObj != null) {
                    if (resolve) {
                        this.resolveClass(ClassObj);
                    }
                    return ClassObj;
                }
                try {
                    if (this.cache != null) {
                        ClassObj = (Class)this.cache.get(name);
                    }
                }
                catch (ClassCastException cce) {
                    throw new ClassNotFoundException(cce.toString());
                }
                if (ClassObj == null) {
                    ClassObj = this.loadClassWorkHorse(name, 2);
                }
                if (ClassObj == null) {
                    className = JVPClassLoader.getUDTExternalName(name, this.callerConn, true);
                    if (className == null) {
                        throw new ClassNotFoundException("cannot load class " + name);
                    }
                    try {
                        ClassObj = this.findSystemClass(className);
                    }
                    catch (ClassNotFoundException cnf) {
                        // empty catch block
                    }
                    if (ClassObj == null && this.cache != null) {
                        ClassObj = (Class)this.cache.get(className);
                    }
                    if (ClassObj == null) {
                        ClassObj = this.loadClassWorkHorse(className, 1);
                    }
                }
            }
            if (resolve) {
                this.resolveClass(ClassObj);
            }
            return ClassObj;
        }
    }

    private Class loadClassWorkHorse(String className, int classType) throws ClassNotFoundException {
        Class ClassObj = null;
        if (this.jarName == null) {
            if (classType == 1) {
                throw new ClassNotFoundException("cannot load class " + className);
            }
            return null;
        }
        if (!this.jarName.equals("NULL")) {
            ClassObj = this.getClassFromJar(className, this.callerConn);
        }
        if (ClassObj == null) {
            String jar = this.getJarFromPath(className, this.callerConn);
            if (jar != null) {
                UDRDBAManagerImpl mgr = (UDRDBAManagerImpl)UDRDBAContextImpl.udrDBAManager;
                className = jar + ":" + className;
                mgr.loadClassWorkhorse(className);
                return mgr.getLoadedClass(className);
            }
            if (classType == 1) {
                throw new ClassNotFoundException("cannot load class " + className);
            }
            return null;
        }
        return ClassObj;
    }

    private Class getClassFromJar(String className, Connection myConn) {
        IfxProtocol proto = null;
        String fileName = JarHandler.getJarTmpPath() + this.jarName + ".jar";
        byte[] classBytes = null;
        boolean connClose = false;
        File fileObj = new File(fileName);
        if (!fileObj.exists()) {
            try {
                if (myConn == null) {
                    if (Thread.currentThread() instanceof DBAThreadImpl) {
                        DBAThreadImpl currThread = (DBAThreadImpl)Thread.currentThread();
                        PerJavaUDRContext puc = currThread.getCurrentUDRContext();
                        if (!puc.noJdbcConn) {
                            UDREnv env = currThread.getUDREnv();
                            myConn = ((UDREnvImpl)env).getJdbcConn();
                        } else {
                            myConn = JVPClassLoader.openSolanoConn();
                            connClose = true;
                        }
                    } else {
                        myConn = JVPClassLoader.openSolanoConn();
                        connClose = true;
                    }
                } else {
                    myConn = ((IfxDirectConnection)((Object)myConn)).getSecondConn();
                }
                ((IfxSqliConnect)myConn).isHDREnabled();
                proto = ((IfxDirectConnection)((Object)myConn)).getProto();
                ((IfxDirectProtocol)proto).setInternalQuery();
                Statement stmt = myConn.createStatement();
                ResultSet rs = stmt.executeQuery("select jardata from 'sqlj'.retained_jars where jarname = '" + this.jarName + "'");
                ((IfxDirectProtocol)proto).resetInternalQuery();
                if (!rs.next()) {
                    rs.close();
                    stmt.close();
                    if (connClose) {
                        myConn.close();
                    }
                    return null;
                }
                Blob blob = ((IfxResultSet)rs).getBlob("jardata", 4);
                byte[] blobdata = blob.getBytes(1L, (int)blob.length());
                rs.close();
                stmt.close();
                if (connClose) {
                    myConn.close();
                }
                try {
                    FileOutputStream Out = new FileOutputStream(fileName);
                    Out.write(blobdata);
                    Out.close();
                }
                catch (IOException ioe) {
                    System.out.println("Error writing jar blob data to file: " + ioe.toString());
                    return null;
                }
                fileObj = new File(fileName);
                if (!fileObj.exists()) {
                    return null;
                }
            }
            catch (SQLException sqle) {
                ((IfxDirectProtocol)proto).resetInternalQuery();
                try {
                    if (connClose) {
                        myConn.close();
                    }
                }
                catch (SQLException e) {
                    System.out.println(e.toString());
                }
                System.out.println(sqle.toString());
                return null;
            }
        }
        try {
            ByteArrayOutputStream bytesOut;
            InputStream inStream;
            ZipFile jarFile;
            block27: {
                int count = 0;
                String entryName = className.replace('.', '/');
                jarFile = new ZipFile(fileObj);
                ZipEntry entry = jarFile.getEntry(entryName + ".class");
                if (entry == null) {
                    return null;
                }
                inStream = jarFile.getInputStream(entry);
                bytesOut = new ByteArrayOutputStream(512);
                byte[] buf = new byte[512];
                int bytesRead = 0;
                try {
                    while ((count = inStream.read(buf)) > 0) {
                        bytesRead += count;
                        bytesOut.write(buf, 0, count);
                    }
                }
                catch (EOFException eofe) {
                    long size = entry.getSize();
                    if ((long)bytesRead == size) break block27;
                    System.out.println("Error getting class data: " + eofe.toString());
                    return null;
                }
            }
            inStream.close();
            jarFile.close();
            classBytes = bytesOut.toByteArray();
            bytesOut.close();
        }
        catch (ZipException ze) {
            System.out.println(ze.toString());
            return null;
        }
        catch (IOException ioe) {
            System.out.println("Error getting class data: " + ioe.toString());
            return null;
        }
        Class<?> udrClass = null;
        if (classBytes != null) {
            udrClass = this.defineClass(className, classBytes, 0, classBytes.length);
        }
        if (udrClass != null) {
            this.cache.put(className, udrClass);
        }
        return udrClass;
    }

    Class getClass(String className) {
        return (Class)this.cache.get(className);
    }

    public static String getUDTExternalName(String name, Connection conn, boolean internalFlag) {
        String extName = null;
        boolean jdbcConn = false;
        boolean connClose = false;
        if (conn == null) {
            if (Thread.currentThread() instanceof DBAThreadImpl) {
                DBAThreadImpl currThread = (DBAThreadImpl)Thread.currentThread();
                PerJavaUDRContext puc = currThread.getCurrentUDRContext();
                if (!puc.noJdbcConn) {
                    UDREnv env = currThread.getUDREnv();
                    try {
                        conn = ((UDREnvImpl)env).getJdbcConn();
                    }
                    catch (SQLException sqle) {}
                } else if (internalFlag) {
                    try {
                        conn = JVPClassLoader.openSolanoConn();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    connClose = true;
                } else {
                    System.out.println("Error : the method is invoked in a wrong context");
                }
            } else if (internalFlag) {
                try {
                    conn = JVPClassLoader.openSolanoConn();
                }
                catch (SQLException e) {
                    System.out.println("Error in opening SolanoConnection in getUDTExternalName()");
                }
                connClose = true;
            } else {
                System.out.println("User threads are not allowed in this context, must be a DBAThread");
            }
            jdbcConn = true;
        }
        String dbName = null;
        String udtName = null;
        try {
            dbName = ((IfxConnection)conn).getDbName();
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        int sub = name.indexOf(46);
        if (sub != -1) {
            udtName = name;
            name = name.substring(sub + 1);
        } else {
            udtName = dbName != null ? dbName + "." + name : name;
        }
        if (udtExtNames != null) {
            boolean clear = UDRLMInfo.getUDTCacheCleanFlag(UDRDBAContextImpl.javaLangHandle);
            if (clear) {
                haveAllTypes = false;
                udtExtNames.clear();
                udtLengths.clear();
            }
            extName = (String)udtExtNames.get(udtName);
        }
        if (extName == null) {
            try {
                if (!jdbcConn) {
                    conn = ((IfxDirectConnection)((Object)conn)).getSecondConn();
                }
                extName = JVPClassLoader.cacheUdtExtNames(dbName, name, conn);
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            if (connClose) {
                conn.close();
            }
        }
        catch (SQLException e) {
            System.out.println("Solano connection close failed ..");
        }
        return extName;
    }

    public static synchronized String cacheUdtExtNames(String dbname, String name, Connection myConn) throws ClassNotFoundException {
        String extName = null;
        ResultSet rs = null;
        Statement stmt = null;
        IfxProtocol proto = null;
        JVP.traceable.tracePrint("JVP.DBA.UDRClassLoader", 4, "Load information from udtextnames ");
        try {
            stmt = myConn.createStatement();
            proto = ((IfxDirectConnection)((Object)myConn)).getProto();
            ((IfxDirectProtocol)proto).setInternalQuery();
            rs = stmt.executeQuery("select * from 'sqlj'.udtextnames where sqlname = '" + name.toLowerCase() + "'");
            if (rs.next()) {
                if (udtExtNames == null) {
                    udtExtNames = new Hashtable();
                    udtLengths = new Hashtable();
                }
                extName = rs.getString(2);
                Statement stmt2 = myConn.createStatement();
                ResultSet rs2 = stmt2.executeQuery("select length, maxlen from 'informix'.sysxtdtypes where name = '" + name + "'");
                int udtlen = -1;
                if (rs2.next()) {
                    udtlen = rs2.getInt(2);
                }
                String udtName = (dbname + "." + name).toLowerCase();
                udtExtNames.put(udtName, extName);
                udtLengths.put(udtName, new Integer(udtlen));
                rs2.close();
                stmt2.close();
            }
            ((IfxDirectProtocol)proto).resetInternalQuery();
            rs.close();
            stmt.close();
            JVP.traceable.tracePrint("JVP.DBA.UDRClassLoader", 4, "Done loading UDT name mapping");
        }
        catch (SQLException sqle) {
            ((IfxDirectProtocol)proto).resetInternalQuery();
            boolean OK = sqle.getErrorCode() == -206 && sqle.getSQLState().equals("42000");
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            if (OK) {
                String string = null;
                return string;
            }
            throw new ClassNotFoundException(sqle.toString());
        }
        return extName;
    }

    public static synchronized Map cacheAllUdtExtNames(IfxDirectConnection myConn) {
        String extName = null;
        ResultSet rs = null;
        Statement stmt = null;
        IfxProtocol proto = null;
        Vector<String> sqlNames = null;
        Vector<String> extNames = null;
        JVP.traceable.tracePrint("JVP", 4, "!!! cacheAllUdtExtNames " + myConn);
        if (haveAllTypes && JVP.properties.getEnableTypeCache()) {
            JVP.traceable.tracePrint("JVP", 4, " !!! using Cached entries");
            return JVPClassLoader.fillMap(myConn);
        }
        if (sqlNames == null) {
            sqlNames = new Vector<String>(5, 1);
            extNames = new Vector<String>(5, 1);
        } else {
            sqlNames.clear();
            extNames.clear();
        }
        try {
            String sqlName;
            stmt = myConn.createStatement();
            proto = myConn.getProto();
            ((IfxDirectProtocol)proto).setInternalQuery();
            rs = stmt.executeQuery("select * from 'sqlj'.udtextnames");
            if (udtExtNames == null) {
                udtExtNames = new Hashtable();
                udtLengths = new Hashtable();
            }
            while (rs.next()) {
                sqlName = rs.getString(1);
                extName = rs.getString(2);
                JVP.traceable.tracePrint("JVP", 4, " !!! Select: " + sqlName + ", " + extName);
                sqlNames.addElement(sqlName);
                extNames.addElement(extName);
            }
            JVP.traceable.tracePrint("JVP", 4, " !!! # of sqlNames " + sqlNames.size());
            rs.close();
            for (int i = 0; i < sqlNames.size(); ++i) {
                sqlName = (String)sqlNames.elementAt(i);
                extName = (String)extNames.elementAt(i);
                rs = stmt.executeQuery("select maxlen from 'informix'.sysxtdtypes where name = '" + sqlName + "'");
                int udtlen = -1;
                if (rs.next()) {
                    udtlen = rs.getInt(1);
                }
                udtExtNames.put(sqlName.toLowerCase(), extName);
                udtLengths.put(sqlName.toLowerCase(), new Integer(udtlen));
            }
            ((IfxDirectProtocol)proto).resetInternalQuery();
            rs.close();
            stmt.close();
            JVP.traceable.tracePrint("JVP.DBA.UDRClassLoader", 4, "Done loading UDT name mapping");
        }
        catch (SQLException sqle) {
            ((IfxDirectProtocol)proto).resetInternalQuery();
            JVP.traceable.tracePrint("JVP.DBA.UDRClassLoader", 4, " EXCEPTION " + sqle.getMessage());
            boolean OK = sqle.getErrorCode() == -206 && sqle.getSQLState().equals("42000");
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            return null;
        }
        catch (Exception e) {
            JVP.traceable.tracePrint("JVP.DBA.UDRClassLoader", 4, "Exception " + e.getMessage());
            return null;
        }
        return JVPClassLoader.fillMap(myConn);
    }

    private static Map fillMap(IfxDirectConnection myConn) {
        Map map = null;
        try {
            map = myConn.getTypeMap();
        }
        catch (Exception e) {
            return null;
        }
        int size = udtExtNames.size();
        JVP.traceable.tracePrint("JVP", 4, "!!! fillMap Hashtable size is " + udtExtNames.size());
        String extName = null;
        Enumeration sqlNames = udtExtNames.keys();
        while (sqlNames.hasMoreElements()) {
            String sqlName = (String)sqlNames.nextElement();
            extName = (String)udtExtNames.get(sqlName);
            try {
                Class extClass = JVPClassLoader.check4Interfaces(extName);
                if (extClass == null) {
                    JVP.traceable.tracePrint("JVP", 4, "!!! classnotfound: " + extName);
                    continue;
                }
                JVP.traceable.tracePrint("JVP", 4, "!!! class found: " + extName);
                map.put(sqlName, extClass);
            }
            catch (Exception e) {
                JVP.traceable.tracePrint("JVP", 4, "JVPClassLoader.fillMap can't find class: " + extName);
            }
        }
        return map;
    }

    private static Class check4Interfaces(String extName) {
        Class<?> udtCls;
        block15: {
            SQLJParamImpl paramMgr = null;
            if (!(Thread.currentThread() instanceof DBAThreadImpl)) {
                System.out.println("ERROR: User threads are not allowed in this context");
                return null;
            }
            DBAThreadImpl currThread = (DBAThreadImpl)Thread.currentThread();
            paramMgr = currThread.getParamMgr();
            if (extName == null) {
                return null;
            }
            udtCls = null;
            try {
                int pos = extName.indexOf(":");
                if (pos != -1) {
                    udtCls = paramMgr.JavaToClass(extName);
                    break block15;
                }
                try {
                    udtCls = Class.forName(extName);
                }
                catch (ClassNotFoundException cnf) {
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "check4Interfaces: Cannot find class for " + extName + " Exception: " + cnf.toString());
                }
                if (udtCls == null) {
                    udtCls = paramMgr.JavaToClass(extName);
                }
            }
            catch (SQLException e) {
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " <><><><> checkTypeMap JavaToClass failed: " + e.toString());
                return null;
            }
        }
        JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " <><><><> checkTypeMap udtCls " + udtCls);
        if (udtCls == null) {
            return null;
        }
        if (udtCls.isInterface()) {
            String className = udtCls.getName();
            try {
                if (className.equals("java.sql.Array")) {
                    udtCls = Class.forName("com.informix.jdbc.IfxArray");
                } else if (className.equals("java.sql.Struct")) {
                    udtCls = Class.forName("com.informix.jdbc.IfxStruct");
                }
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println("ClassNotFoundException: " + cnfe.getMessage());
                return null;
            }
            JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " ]]]] Converted interface to : " + udtCls.getName());
        }
        return udtCls;
    }

    public static int getUDTLength(String name) throws SQLException {
        Integer len = null;
        if (udtLengths != null) {
            len = (Integer)udtLengths.get(name);
        }
        if (len == null) {
            JVPClassLoader.getUDTExternalName(name, null, false);
            len = (Integer)udtLengths.get(name);
        }
        if (len == null) {
            throw GenErr.sqle(-9454, name);
        }
        return len;
    }

    private String getJarFromPath(String className, Connection myConn) throws ClassNotFoundException {
        Statement stmt = null;
        ResultSet rs = null;
        IfxProtocol proto = null;
        boolean newPath = false;
        boolean connClose = false;
        try {
            if (myConn == null) {
                if (Thread.currentThread() instanceof DBAThreadImpl) {
                    DBAThreadImpl currThread = (DBAThreadImpl)Thread.currentThread();
                    PerJavaUDRContext puc = currThread.getCurrentUDRContext();
                    if (!puc.noJdbcConn) {
                        UDREnv env = currThread.getUDREnv();
                        myConn = ((UDREnvImpl)env).getJdbcConn();
                    } else {
                        myConn = JVPClassLoader.openSolanoConn();
                        connClose = true;
                    }
                } else {
                    myConn = JVPClassLoader.openSolanoConn();
                    connClose = true;
                }
            } else {
                myConn = ((IfxDirectConnection)((Object)myConn)).getSecondConn();
            }
            if (!JarHandler.thisOS.startsWith(JarHandler.WINOS)) {
                newPath = UDRLMInfo.getNewPathFlag(this.jarName, UDRDBAContextImpl.javaLangHandle, UDRDBAContextImpl.vpid);
            }
            if (this.jarPath == null || newPath) {
                stmt = myConn.createStatement();
                proto = ((IfxDirectConnection)((Object)myConn)).getProto();
                ((IfxDirectProtocol)proto).setInternalQuery();
                rs = stmt.executeQuery("select jarpath from 'sqlj'.alter_java_paths where jarname = '" + this.jarName + "'");
                if (rs.next()) {
                    this.jarPath = rs.getString("jarpath");
                }
                ((IfxDirectProtocol)proto).resetInternalQuery();
                rs.close();
                stmt.close();
            }
            if (this.jarPath == null || this.jarPath.equals("")) {
                if (connClose) {
                    myConn.close();
                }
                return null;
            }
        }
        catch (SQLException sqle) {
            ((IfxDirectProtocol)proto).resetInternalQuery();
            boolean OK = sqle.getErrorCode() == -206 && sqle.getSQLState().equals("42000");
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connClose) {
                    myConn.close();
                }
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            if (OK) {
                // empty if block
            }
            throw new ClassNotFoundException(sqle.toString());
        }
        StringTokenizer tokens = new StringTokenizer(this.jarPath, "(,)");
        String jar = null;
        String resolutionJar = null;
        String classes = null;
        while (tokens.hasMoreTokens()) {
            classes = tokens.nextToken();
            classes = classes.trim();
            jar = tokens.nextToken();
            jar = jar.trim();
            if (classes.equals("*")) {
                resolutionJar = jar;
            }
            if (resolutionJar == null) {
                int wildPos = classes.indexOf("*");
                if (wildPos != -1) {
                    classes = classes.substring(0, wildPos);
                    if (className.startsWith(classes = classes.replace('/', '.'))) {
                        resolutionJar = jar;
                    }
                } else if (className.equals(classes)) {
                    resolutionJar = jar;
                }
            }
            if (resolutionJar == null) continue;
            try {
                JVP.traceable.tracePrint("JVP.DBA.UDRClassLoader", 4, "Getting full name for resolution jar in path..");
                String db = myConn.getCatalog();
                String user = myConn.getMetaData().getUserName();
                resolutionJar = JarHandler.setThreePartJarName(db, user, resolutionJar, false);
                JVP.traceable.tracePrint("JVP.DBA.UDRClassLoader", 4, "Checking if resolution jar in path is installed..");
                JarHandler.checkJarExistence(myConn, resolutionJar);
                if (connClose) {
                    myConn.close();
                }
                return resolutionJar;
            }
            catch (SQLException sqle) {
                throw new ClassNotFoundException(sqle.toString());
            }
        }
        return null;
    }

    String getJarName() {
        return this.jarName;
    }

    void setJarName(String newname) {
        this.jarName = newname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSolanoConn(Connection c) {
        JVPClassLoader jVPClassLoader = this;
        synchronized (jVPClassLoader) {
            this.callerConn = c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetSolanoConn() {
        JVPClassLoader jVPClassLoader = this;
        synchronized (jVPClassLoader) {
            this.callerConn = null;
        }
    }

    public static Connection openSolanoConn() throws SQLException {
        Connection myConn = null;
        UDRDBAManagerImpl mgr = (UDRDBAManagerImpl)UDRDBAContextImpl.udrDBAManager;
        mgr.passwordCheck = false;
        String url = "jdbc:informix-direct:/jdbc:usr=nouser;password=nopassword;";
        myConn = DriverManager.getConnection(url);
        mgr.passwordCheck = true;
        return myConn;
    }
}

