/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import com.informix.udr.UDREnv;
import com.informix.udr.UDRManager;
import informix.jvp.JVP;
import informix.jvp.dbapplet.impl.DBAThreadSupport;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class JVPControl
extends Thread {
    public static final int UNKNOWN = -1;
    public static final int THREADS = 1;
    public static final int MEMORY = 2;
    private int port;
    private ServerSocket listener;

    public JVPControl(int p) {
        this.port = p;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket req = null;
        JVP.log.log("JVP monitor thread starts on port " + this.port);
        try {
            try {
                this.listener = new ServerSocket(this.port);
                while (true) {
                    req = this.listener.accept();
                    InputStream in = req.getInputStream();
                    OutputStream out = req.getOutputStream();
                    byte[] buf = null;
                    int cmd = in.read();
                    switch (cmd) {
                        case 2: {
                            JVP.log.log("JVP monitor thread GC memory");
                            Runtime rt = Runtime.getRuntime();
                            rt.gc();
                            rt.runFinalization();
                            rt.gc();
                            long free = rt.freeMemory();
                            long total = rt.totalMemory();
                            String res = "Memory " + free + " bytes free, " + total + " bytes total";
                            buf = res.getBytes();
                            out.write(1);
                            out.write(buf.length);
                            out.write(buf);
                            break;
                        }
                        case 1: {
                            JVP.log.log("JVP monitor thread list threads");
                            ThreadGroup g = UDRDBAContextImpl.dbaThreadGroup;
                            while (g.getParent() != null) {
                                g = g.getParent();
                            }
                            Thread[] l = new Thread[g.activeCount()];
                            g.enumerate(l);
                            out.write(l.length);
                            for (int i = 0; i < l.length; ++i) {
                                String d = "";
                                if (!l[i].isDaemon()) {
                                    d = "\t*** NOT DAEMON ***";
                                }
                                String str = l[i].toString() + d;
                                buf = str.getBytes();
                                out.write(buf.length);
                                out.write(buf);
                            }
                            JVP.log.log("JVP monitor done processing command");
                            break;
                        }
                        default: {
                            out.write(-1);
                        }
                    }
                    if (req != null) {
                        req.close();
                    }
                    req = null;
                }
            }
            catch (Exception ex) {
                JVP.log.log("JVP monitor thread died: " + ex);
                if (req != null) {
                    try {
                        req.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Throwable throwable) {
            if (req != null) {
                try {
                    req.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    public static String JVPControlUDR(String command) throws SQLException {
        DBAThreadSupport state;
        String[] res;
        int num;
        UDREnv env = UDRManager.getUDREnv();
        int argn = 0;
        int cmd = -1;
        int vp = -1;
        int port = -1;
        StringTokenizer tk = new StringTokenizer(command, " ");
        block13: while (tk.hasMoreTokens()) {
            String arg = tk.nextToken();
            switch (++argn) {
                case 1: {
                    if (arg.equals("threads")) {
                        cmd = 1;
                        continue block13;
                    }
                    if (!arg.equals("memory")) continue block13;
                    cmd = 2;
                    continue block13;
                }
                case 2: {
                    vp = new Integer(arg);
                    continue block13;
                }
            }
            throw GenErr.sqle(-9492, "too many arguments");
        }
        if (cmd == -1 || vp < 0) {
            throw GenErr.sqle(-9492, "command syntax error");
        }
        port = JVP.properties.getJVPControlPort() - UDRDBAContextImpl.vpid + vp;
        JVP.log.log("Contact monitor thread on port " + port);
        Socket s = null;
        try {
            InetAddress local = InetAddress.getLocalHost();
            s = new Socket(local, port);
            InputStream in = s.getInputStream();
            OutputStream out = s.getOutputStream();
            out.write(cmd);
            num = in.read();
            res = new String[num];
            for (int i = 0; i < num; ++i) {
                int size = in.read();
                byte[] buf = new byte[size];
                in.read(buf);
                res[i] = new String(buf);
            }
        }
        catch (Exception ex) {
            throw GenErr.sqle(-9481, ex.toString());
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception ex) {}
            }
        }
        int iter = env.getSetIterationState();
        if (iter == 0) {
            state = new DBAThreadSupport();
            state.n = num;
            state.l = res;
            env.setUDRState(state);
            env.setSetIterationIsDone(false);
            return null;
        }
        if (iter == 2) {
            env.setSetIterationIsDone(true);
            return null;
        }
        if (iter == 1) {
            state = (DBAThreadSupport)env.getUDRState();
            --state.n;
            if (state.n < 0) {
                env.setSetIterationIsDone(true);
                return null;
            }
            env.setSetIterationIsDone(false);
            return (String)state.l[state.n];
        }
        throw GenErr.sqle(-9481, "Unknown iterator code");
    }
}

