/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDirectConnection;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxSmartBlob;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.JVPClassLoader;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import informix.jvp.dbapplet.impl.UDRDBAManagerImpl;
import informix.jvp.dbapplet.impl.UDREnvImpl;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

class JarHandler {
    static final String ConnURL = "jdbc:informix-direct:;tracefile=/tmp/jdbc.out;trace=1";
    private static final int REMOVE = 1;
    private static final int REPLACE = 2;
    static final boolean VERIFY = true;
    static final boolean NO_VERIFY = false;
    private static final String jarTmpPath = "JAR_TEMP_PATH";
    private static String jarTmpPathVal = null;
    static String WINOS = "Windows";
    static boolean IsWindows = false;
    static String thisOS = null;
    private static String slashType = null;
    private static String BACKSLASH = "\\";
    private static String FORWSLASH = "/";
    static UDRDBAManagerImpl mgr;

    JarHandler() {
    }

    public static synchronized void installJar(String url, String jarName, int deploy) throws SQLException {
        if (deploy == 0) {
            JarHandler.installJar(url, jarName);
        } else {
            JarHandler.installJarDeploy(url, jarName);
        }
    }

    public static synchronized void removeJar(String jarName, int undeploy) throws SQLException {
        if (undeploy == 0) {
            JarHandler.removeJar(jarName);
        } else {
            JarHandler.removeJarUndeploy(jarName);
        }
    }

    public static synchronized void installJar(String url, String jarName) throws SQLException {
        String[] dbName = new String[1];
        String[] userName = new String[1];
        Connection myConn = JarHandler.getConnDbUser(dbName, userName);
        if (((IfxDirectConnection)((Object)myConn)).getDatabaseType() == 1) {
            ((IfxDirectConnection)((Object)myConn)).setForcedSendCommit(false);
        }
        String fullJarName = JarHandler.setThreePartJarName(dbName[0], userName[0], jarName, true);
        JarHandler.installJarInternal(url, fullJarName, myConn);
        myConn.close();
    }

    private static File installJarInternal(String url, String fullJarName, Connection myConn) throws SQLException {
        System.out.println("Installing jar " + fullJarName + "...");
        JarHandler.checkRetainedJars(fullJarName, myConn);
        File fileObj = JarHandler.downloadJarFromURL(url, fullJarName);
        JarHandler.installJarData(myConn, fileObj, fullJarName);
        if (thisOS.startsWith(WINOS)) {
            IsWindows = true;
            JarHandler.mgr.jarMap.remove(fullJarName);
        } else if (UDRLMInfo.addJarToList(fullJarName, UDRDBAContextImpl.javaLangHandle) == -1) {
            throw GenErr.sqle(-9481, " Error adding jar in global JVP list.");
        }
        return fileObj;
    }

    public static synchronized void removeJar(String jarName) throws SQLException {
        System.out.println("Removing jar " + jarName + "...");
        JarHandler.removeOrReplaceJarInternal(null, jarName, 1);
    }

    public static synchronized void replaceJar(String url, String jarName) throws SQLException {
        System.out.println("Replacing jar " + jarName + "...");
        JarHandler.removeOrReplaceJarInternal(url, jarName, 2);
    }

    private static void removeOrReplaceJarInternal(String url, String jarName, int caller) throws SQLException {
        String[] dbName = new String[1];
        String[] userName = new String[1];
        Connection myConn = JarHandler.getConnDbUser(dbName, userName);
        if (((IfxDirectConnection)((Object)myConn)).getDatabaseType() == 1) {
            ((IfxDirectConnection)((Object)myConn)).setForcedSendCommit(false);
        }
        String fullJarName = JarHandler.setThreePartJarName(dbName[0], userName[0], jarName, true);
        JarHandler.checkJarExistence(myConn, fullJarName);
        File fileObj = null;
        ZipFile jarFile = null;
        if (caller == 2) {
            fileObj = JarHandler.downloadJarFromURL(url, fullJarName);
            try {
                jarFile = new ZipFile(fileObj);
            }
            catch (ZipException ze) {
                throw GenErr.sqle(-9481, ze.toString());
            }
            catch (IOException ioe) {
                throw GenErr.sqle(-9481, ioe.toString());
            }
        }
        JarHandler.checkJarReferencesBeforeRemoval(myConn, fullJarName, jarFile, caller);
        JarHandler.removeJarFromDatabase(myConn, fullJarName, caller);
        if (caller == 2) {
            try {
                jarFile.close();
            }
            catch (ZipException ze) {
                throw GenErr.sqle(-9481, ze.toString());
            }
            catch (IOException ioe) {
                throw GenErr.sqle(-9481, ioe.toString());
            }
            JarHandler.installJarData(myConn, fileObj, fullJarName);
        }
        myConn.close();
    }

    public static synchronized void installJarDeploy(String url, String jarName) throws SQLException {
        String[] dbName = new String[1];
        String[] userName = new String[1];
        Connection myConn = JarHandler.getConnDbUser(dbName, userName);
        if (((IfxDirectConnection)((Object)myConn)).getDatabaseType() == 1) {
            ((IfxDirectConnection)((Object)myConn)).setForcedSendCommit(false);
        }
        String fullJarName = JarHandler.setThreePartJarName(dbName[0], userName[0], jarName, true);
        File jarFile = JarHandler.installJarInternal(url, fullJarName, myConn);
        try {
            String currManifestLine;
            ZipFile zipObj = new ZipFile(jarFile);
            InputStream inStream = JarHandler.getManifestInputStream(zipObj, jarName);
            InputStreamReader ir = new InputStreamReader(inStream);
            BufferedReader bufRead = new BufferedReader(ir);
            while ((currManifestLine = bufRead.readLine()) != null) {
                ByteArrayOutputStream byteOut;
                InputStream depIn;
                String depFile;
                String depStr;
                block17: {
                    int depPos;
                    int pos = (currManifestLine = currManifestLine.trim()).indexOf(":");
                    if (pos == -1) continue;
                    String name = currManifestLine.substring(0, pos);
                    if (!(name = name.trim()).equals("Name")) continue;
                    String depLine = null;
                    do {
                        if ((depLine = bufRead.readLine()) == null) continue;
                        depLine = depLine.trim();
                    } while (depLine != null && !depLine.startsWith("SQLJDeploymentDescriptor") && !depLine.startsWith("Name"));
                    if (depLine == null || (depPos = depLine.indexOf(":")) == -1) continue;
                    depStr = depLine.substring(0, depPos);
                    if (!(depStr = depStr.trim()).equals("SQLJDeploymentDescriptor")) continue;
                    String depVal = depLine.substring(depPos + 1);
                    if (!(depVal = depVal.trim()).equals("TRUE")) continue;
                    depFile = currManifestLine.substring(pos + 1);
                    depFile = depFile.trim();
                    System.out.println("Deploying file: " + depFile);
                    ZipEntry depEntry = zipObj.getEntry(depFile);
                    if (depEntry == null) {
                        System.out.println("DEPLOYMENT FAILURE: File " + depFile + " not found in jar " + jarName + ". Continuing to" + " look for more deployment descriptors.");
                        continue;
                    }
                    depIn = zipObj.getInputStream(depEntry);
                    byteOut = new ByteArrayOutputStream(512);
                    byte[] ba = new byte[1024];
                    int count = 0;
                    long bytesRead = 0L;
                    try {
                        while ((count = depIn.read(ba)) > 0) {
                            bytesRead += (long)count;
                            byteOut.write(ba, 0, count);
                        }
                    }
                    catch (EOFException eofe) {
                        long size = depEntry.getSize();
                        if (bytesRead == size) break block17;
                        throw GenErr.sqle(-9487, eofe.toString());
                    }
                }
                depIn.close();
                depStr = new String(byteOut.toByteArray());
                byteOut.close();
                int beginPos = depStr.indexOf("BEGIN INSTALL");
                int endPos = depStr.indexOf("END INSTALL");
                if (beginPos == -1 || endPos == -1) {
                    throw GenErr.sqle(-9482, depFile);
                }
                depStr = depStr.substring(beginPos + 13, endPos);
                depStr = depStr.trim();
                StringTokenizer token = new StringTokenizer(depStr, ";");
                String query = null;
                Statement stmt = myConn.createStatement();
                while (token.hasMoreTokens()) {
                    try {
                        query = token.nextToken().trim() + ";";
                        if (!(query.startsWith("create") || query.startsWith("CREATE") || query.startsWith("grant") || query.startsWith("GRANT"))) {
                            System.out.println("Unsupported command from depoyment descriptor: " + query);
                            throw GenErr.sqle(-9493, query);
                        }
                        if (query.startsWith("create") || query.startsWith("CREATE")) {
                            query = JarHandler.replaceThisjar(query, fullJarName);
                        }
                        stmt.execute(query);
                        stmt.close();
                        stmt = myConn.createStatement();
                    }
                    catch (SQLException sqle) {
                        System.out.println("COMMAND EXECUTION FAILURE: The following exception occurred when executing the SQL statement \"" + query + "\" in deployment " + "descriptor file " + depFile + ": " + sqle.toString());
                        throw sqle;
                    }
                }
                stmt.close();
            }
            bufRead.close();
            ir.close();
            inStream.close();
            zipObj.close();
        }
        catch (EOFException eofe) {
        }
        catch (ZipException ze) {
            throw GenErr.sqle(-9481, ze.toString());
        }
        catch (IOException ioe) {
            throw GenErr.sqle(-9481, ioe.toString());
        }
        myConn.close();
    }

    public static synchronized void removeJarUndeploy(String jarName) throws SQLException {
        File jarFile;
        String[] dbName = new String[1];
        String[] userName = new String[1];
        Connection myConn = JarHandler.getConnDbUser(dbName, userName);
        if (((IfxDirectConnection)((Object)myConn)).getDatabaseType() == 1) {
            ((IfxDirectConnection)((Object)myConn)).setForcedSendCommit(false);
        }
        String fullJarName = JarHandler.setThreePartJarName(dbName[0], userName[0], jarName, true);
        JarHandler.checkJarExistence(myConn, fullJarName);
        String fileName = JarHandler.getJarTmpPath() + fullJarName;
        if (!fileName.endsWith(".jar")) {
            fileName = fileName + ".jar";
        }
        if (!(jarFile = new File(fileName)).exists()) {
            Statement stmt = myConn.createStatement();
            ResultSet rs = stmt.executeQuery("select jardata from 'sqlj'.retained_jars where jarname = '" + fullJarName + "'");
            rs.next();
            Blob blob = ((IfxResultSet)rs).getBlob("jardata");
            byte[] blobdata = blob.getBytes(1L, (int)blob.length());
            rs.close();
            stmt.close();
            try {
                FileOutputStream Out = new FileOutputStream(fileName);
                Out.write(blobdata);
                Out.close();
            }
            catch (IOException ioe) {
                System.out.println("Error writing jar blob data to file: " + ioe.toString());
                throw GenErr.sqle(-9481, ioe.toString());
            }
        }
        try {
            String currManifestLine;
            ZipFile zipObj = new ZipFile(jarFile);
            InputStream inStream = JarHandler.getManifestInputStream(zipObj, jarName);
            InputStreamReader ir = new InputStreamReader(inStream);
            BufferedReader bufRead = new BufferedReader(ir);
            while ((currManifestLine = bufRead.readLine()) != null) {
                ByteArrayOutputStream byteOut;
                InputStream depIn;
                String depFile;
                String depStr;
                block20: {
                    int depPos;
                    int pos = (currManifestLine = currManifestLine.trim()).indexOf(":");
                    if (pos == -1) continue;
                    String name = currManifestLine.substring(0, pos);
                    if (!(name = name.trim()).equals("Name")) continue;
                    String depLine = null;
                    do {
                        if ((depLine = bufRead.readLine()) == null) continue;
                        depLine = depLine.trim();
                    } while (depLine != null && !depLine.startsWith("SQLJDeploymentDescriptor") && !depLine.startsWith("Name"));
                    if (depLine == null || (depPos = depLine.indexOf(":")) == -1) continue;
                    depStr = depLine.substring(0, depPos);
                    if (!(depStr = depStr.trim()).equals("SQLJDeploymentDescriptor")) continue;
                    String depVal = depLine.substring(depPos + 1);
                    if (!(depVal = depVal.trim()).equals("TRUE")) continue;
                    depFile = currManifestLine.substring(pos + 1);
                    depFile = depFile.trim();
                    System.out.println("Undeploying file: " + depFile);
                    ZipEntry depEntry = zipObj.getEntry(depFile);
                    if (depEntry == null) {
                        System.out.println("DEPLOYMENT FAILURE: File " + depFile + " not found in jar " + jarName + ". Continuing to" + " look for more deployment descriptors.");
                        continue;
                    }
                    depIn = zipObj.getInputStream(depEntry);
                    byteOut = new ByteArrayOutputStream(512);
                    byte[] ba = new byte[512];
                    int count = 0;
                    long bytesRead = 0L;
                    try {
                        while ((count = depIn.read(ba)) > 0) {
                            bytesRead += (long)count;
                            byteOut.write(ba, 0, count);
                        }
                    }
                    catch (EOFException eofe) {
                        long size = depEntry.getSize();
                        if (bytesRead == size) break block20;
                        throw GenErr.sqle(-9487, eofe.toString());
                    }
                }
                depStr = new String(byteOut.toByteArray());
                int beginPos = depStr.indexOf("BEGIN REMOVE");
                int endPos = depStr.indexOf("END REMOVE");
                if (beginPos == -1 || endPos == -1) {
                    throw GenErr.sqle(-9482, depFile);
                }
                depStr = depStr.substring(beginPos + 13, endPos);
                depStr = depStr.trim();
                StringTokenizer token = new StringTokenizer(depStr, ";");
                Statement stmt = myConn.createStatement();
                String query = null;
                while (token.hasMoreTokens()) {
                    try {
                        query = token.nextToken().trim() + ";";
                        if (!(query.startsWith("drop") || query.startsWith("DROP") || query.startsWith("revoke") || query.startsWith("REVOKE"))) {
                            System.out.println("Unsupported command from deployment descriptor: " + query);
                            throw GenErr.sqle(-9493, query);
                        }
                        stmt.execute(query);
                        stmt.close();
                        stmt = myConn.createStatement();
                    }
                    catch (SQLException sqle) {
                        System.out.println("COMMAND EXECUTION FAILURE: The following exception occurred when executing the SQL statement \"" + query + "\" in deployment " + "descriptor file " + depFile + ": " + sqle.toString());
                        throw sqle;
                    }
                }
                depIn.close();
                byteOut.close();
                stmt.close();
            }
            zipObj.close();
            inStream.close();
            ir.close();
            bufRead.close();
        }
        catch (EOFException eofe) {
        }
        catch (ZipException ze) {
            throw GenErr.sqle(-9481, ze.toString());
        }
        catch (IOException ioe) {
            throw GenErr.sqle(-9481, ioe.toString());
        }
        JarHandler.checkJarReferencesBeforeRemoval(myConn, fullJarName, null, 1);
        JarHandler.removeJarFromDatabase(myConn, fullJarName, 1);
        myConn.close();
    }

    public static synchronized void alterJavaPath(String jarName, String path) throws SQLException {
        System.out.println("Alter java path to path string " + path + " for jar " + jarName + "...");
        String[] dbName = null;
        String[] userName = null;
        Connection myConn = null;
        if (!jarName.equals("NULL")) {
            dbName = new String[1];
            userName = new String[1];
        }
        if (((IfxDirectConnection)((Object)(myConn = JarHandler.getConnDbUser(dbName, userName)))).getDatabaseType() == 1) {
            ((IfxDirectConnection)((Object)myConn)).setForcedSendCommit(false);
        }
        String fullJarName = jarName;
        if (!jarName.equals("NULL")) {
            fullJarName = JarHandler.setThreePartJarName(dbName[0], userName[0], jarName, true);
            JarHandler.checkJarExistence(myConn, fullJarName);
        }
        JarHandler.addOrAlterPath(myConn, fullJarName, path);
        myConn.close();
    }

    public static synchronized void setUDTExternalName(String sqlName, String externalName) throws SQLException {
        String type;
        System.out.println("Setting UDT external name as " + externalName + " for type " + sqlName + "...");
        Connection myConn = DriverManager.getConnection(ConnURL);
        Statement stmt = myConn.createStatement();
        IfxDirectConnection idc = (IfxDirectConnection)((Object)myConn);
        StringTokenizer token = new StringTokenizer(sqlName, "(", false);
        int numTokens = token.countTokens();
        boolean complextype = false;
        if (numTokens > 1 && token.hasMoreTokens() && ((type = token.nextToken().trim()).equals("set") || type.equals("list") || type.equals("multiset"))) {
            complextype = true;
            sqlName = type;
        }
        if (!complextype && idc.gettypebyname(null, sqlName.toLowerCase()) == 0L) {
            System.out.println("ERROR: " + sqlName + " is not a recognized type.");
            throw GenErr.sqle(-9483, sqlName);
        }
        externalName = JarHandler.qualifyExternalName(externalName, myConn);
        try {
            stmt.executeUpdate("insert into 'sqlj'.udtextnames values('" + sqlName.toLowerCase() + "', '" + externalName + "')");
            stmt.close();
            myConn.close();
            return;
        }
        catch (SQLException e) {
            boolean OK;
            boolean bl = OK = e.getErrorCode() == -206 && e.getSQLState().equals("42000");
            if (!OK) {
                throw e;
            }
            stmt.execute("create table 'sqlj'.udtextnames(sqlname varchar(255) unique, externalname varchar(255))");
            stmt.execute("grant select on 'sqlj'.udtextnames to public as 'sqlj'");
            stmt.executeUpdate("insert into 'sqlj'.udtextnames values('" + sqlName.toLowerCase() + "', '" + externalName + "')");
            stmt.close();
            myConn.close();
            return;
        }
    }

    public static synchronized void unsetUDTExternalName(String sqlName) throws SQLException {
        System.out.println("UnSetting UDT external name for type " + sqlName + "...");
        Connection myConn = DriverManager.getConnection(ConnURL);
        Statement stmt = myConn.createStatement();
        ResultSet rs = stmt.executeQuery("select tabname from 'informix'.systables where tabname = 'udtextnames' and owner = 'sqlj'");
        boolean tableExists = rs.next();
        rs.close();
        stmt.close();
        if (tableExists) {
            stmt = myConn.createStatement();
            stmt.executeUpdate("delete from 'sqlj'.udtextnames where sqlname = '" + sqlName.toLowerCase() + "'");
            stmt.close();
        }
        myConn.close();
        if (UDRLMInfo.setUDTCacheCleanFlag(UDRDBAContextImpl.javaLangHandle) == -1) {
            throw GenErr.sqle(-9300, sqlName);
        }
    }

    public static synchronized void registerJUDTfuncs(String sqlName) throws SQLException {
        System.out.println("Registering UDT support functions for type " + sqlName + "...");
        Connection myConn = DriverManager.getConnection(ConnURL);
        Statement stmt = myConn.createStatement();
        IfxDirectConnection idc = (IfxDirectConnection)((Object)myConn);
        if (idc.gettypebyname(null, sqlName.toLowerCase()) == 0L) {
            System.out.println("ERROR: " + sqlName + " is not a recognized type.");
            throw GenErr.sqle(-9483, sqlName);
        }
        String sqlNameLower = sqlName.toLowerCase();
        JarHandler.registerInOutFuncs(stmt, sqlNameLower, "LVARCHAR");
        JarHandler.registerInOutFuncs(stmt, sqlNameLower, "SENDRECV");
        JarHandler.registerInOutFuncs(stmt, sqlNameLower, "IMPEXP");
        JarHandler.registerInOutFuncs(stmt, sqlNameLower, "IMPEXPBIN");
        stmt.close();
        myConn.close();
    }

    private static void registerInOutFuncs(Statement stmt, String sqlName, String format) throws SQLException {
        stmt.executeUpdate("create implicit cast (" + format + " as " + sqlName.toLowerCase() + " with IfxJava" + format + "In_" + sqlName.toLowerCase() + ")");
        stmt.executeUpdate("create function IfxJava" + format + "In_" + sqlName.toLowerCase() + "(" + format + ") returns " + sqlName.toLowerCase() + " external name " + "'com.informix.jdbc.IfxDataPointer.IfxDataInput" + "(java.lang.Object)' language java");
        stmt.executeUpdate("grant execute on function IfxJava" + format + "In_" + sqlName.toLowerCase() + " to public");
        stmt.executeUpdate("create explicit cast (" + sqlName.toLowerCase() + " as " + format + " with IfxJava" + format + "Out_" + sqlName.toLowerCase() + ")");
        stmt.executeUpdate("create function IfxJava" + format + "Out_" + sqlName.toLowerCase() + "(" + sqlName.toLowerCase() + ") returns " + format + " external name " + "'com.informix.jdbc.IfxDataPointer.IfxDataOutput" + "(java.sql.SQLData)' language java not variant");
        stmt.executeUpdate("grant execute on function IfxJava" + format + "Out_" + sqlName.toLowerCase() + " to public");
    }

    public static synchronized void unregisterJUDTfuncs(String sqlName) throws SQLException {
        System.out.println("Unregistering UDT support functions for type " + sqlName + "...");
        Connection myConn = DriverManager.getConnection(ConnURL);
        Statement stmt = myConn.createStatement();
        IfxDirectConnection idc = (IfxDirectConnection)((Object)myConn);
        if (idc.gettypebyname(null, sqlName.toLowerCase()) == 0L) {
            System.out.println("ERROR: " + sqlName + " is not a recognized type.");
            throw GenErr.sqle(-9483, sqlName);
        }
        String sqlNameLower = sqlName.toLowerCase();
        JarHandler.unregisterInOutFuncs(stmt, sqlNameLower, "LVARCHAR");
        JarHandler.unregisterInOutFuncs(stmt, sqlNameLower, "SENDRECV");
        JarHandler.unregisterInOutFuncs(stmt, sqlNameLower, "IMPEXP");
        JarHandler.unregisterInOutFuncs(stmt, sqlNameLower, "IMPEXPBIN");
        stmt.close();
        myConn.close();
    }

    private static void unregisterInOutFuncs(Statement stmt, String sqlName, String format) throws SQLException {
        JarHandler.dropCast(stmt, format, sqlName);
        JarHandler.dropFunction(stmt, "IfxJava" + format + "In_" + sqlName);
        JarHandler.dropCast(stmt, sqlName, format);
        JarHandler.dropFunction(stmt, "IfxJava" + format + "Out_" + sqlName);
    }

    private static void dropCast(Statement stmt, String from, String to) throws SQLException {
        block2: {
            try {
                stmt.executeUpdate("drop cast (" + from + " as " + to + ")");
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -9634) break block2;
                throw e;
            }
        }
    }

    private static void dropFunction(Statement stmt, String signature) throws SQLException {
        block2: {
            try {
                stmt.executeUpdate("drop function " + signature);
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -674) break block2;
                throw e;
            }
        }
    }

    private static Connection getConnDbUser(String[] db, String[] user) throws SQLException {
        Connection myConn = null;
        myConn = DriverManager.getConnection(ConnURL);
        if (db != null && user != null) {
            db[0] = ((IfxConnection)myConn).getDbName();
            user[0] = myConn.getMetaData().getUserName();
        }
        return myConn;
    }

    static String setThreePartJarName(String dbName, String userName, String jarName, boolean check) throws SQLException {
        StringTokenizer tokens = new StringTokenizer(jarName, ".", false);
        int numTokens = tokens.countTokens();
        String fullJarName = null;
        switch (numTokens) {
            case 1: {
                fullJarName = dbName + "." + userName + "." + jarName;
                break;
            }
            case 2: {
                String user;
                if (check && !(user = tokens.nextToken()).toLowerCase().equals(userName.toLowerCase())) {
                    System.out.println("Invalid jar name. Must use current user name.");
                    throw GenErr.sqle(-9484);
                }
                fullJarName = dbName + "." + jarName;
                break;
            }
            case 3: {
                if (!check) {
                    return jarName;
                }
                String db = tokens.nextToken();
                String user = tokens.nextToken();
                if (!db.toLowerCase().equals(dbName.toLowerCase()) || !user.toLowerCase().equals(userName.toLowerCase())) {
                    System.out.println("Invalid jar name. Must use current database and user names.");
                    throw GenErr.sqle(-9484);
                }
                fullJarName = jarName;
            }
        }
        return fullJarName;
    }

    private static void checkRetainedJars(String fullJarName, Connection myConn) throws SQLException {
        Statement stmt = myConn.createStatement();
        ResultSet rs = stmt.executeQuery("select tabname from 'informix'.systables where tabname = 'retained_jars' and owner = 'sqlj'");
        boolean tableExists = rs.next();
        rs.close();
        stmt.close();
        stmt = myConn.createStatement();
        if (!tableExists) {
            stmt.execute("create table 'sqlj'.retained_jars(jarname varchar(255) not null unique, jardata Blob)");
        } else {
            rs = stmt.executeQuery("select jarname from 'sqlj'.retained_jars where jarname = '" + fullJarName + "'");
            if (rs.next()) {
                throw GenErr.sqle(-9485, fullJarName);
            }
            rs.close();
        }
        stmt.close();
    }

    private static File downloadJarFromURL(String urlVal, String jarName) throws SQLException {
        String name;
        File Obj;
        File fileObj = null;
        URL URLObj = null;
        String url = urlVal;
        int idx = 0;
        String envVar = null;
        if (urlVal.startsWith("file") && (idx = urlVal.indexOf("$")) > -1) {
            int idx2 = urlVal.indexOf(47, idx);
            if (idx2 > -1) {
                envVar = urlVal.substring(idx + 1, idx2);
            }
            if (envVar != null) {
                String first = urlVal.substring(0, idx);
                String last = urlVal.substring(idx2, urlVal.length());
                String envVal = JarHandler.getEnv(envVar);
                url = first + envVal + last;
            }
        }
        if (url.startsWith("file") && (Obj = new File(name = url.substring(url.indexOf("/") + 1))).exists() && Obj.canRead()) {
            try {
                URLObj = new URL("file", null, name);
            }
            catch (MalformedURLException mue) {
                System.out.println(mue.toString());
                throw GenErr.sqle(-9486);
            }
        }
        try {
            if (URLObj == null) {
                URLObj = new URL(url);
            }
        }
        catch (MalformedURLException mue) {
            System.out.println(mue.toString());
            throw GenErr.sqle(-9486);
        }
        try {
            InputStream inStream = URLObj.openStream();
            String fullJarName = jarName;
            if (!jarName.endsWith(".jar")) {
                fullJarName = jarName.concat(".jar");
            }
            String fileName = JarHandler.getJarTmpPath() + fullJarName;
            fileObj = new File(fileName);
            FileOutputStream Out = new FileOutputStream(fileObj);
            byte[] buf = new byte[512];
            int count = 0;
            while ((count = inStream.read(buf)) > 0) {
                Out.write(buf, 0, count);
            }
            Out.close();
            inStream.close();
        }
        catch (FileNotFoundException fnfe) {
            throw GenErr.sqle(-9498, fnfe.toString());
        }
        catch (IOException ioe) {
            throw GenErr.sqle(-9481, ioe.toString());
        }
        try {
            ZipFile z = new ZipFile(fileObj);
            z.close();
        }
        catch (ZipException ze) {
            throw GenErr.sqle(-9486);
        }
        catch (IOException ioe) {
            throw GenErr.sqle(-9486);
        }
        return fileObj;
    }

    private static void installJarData(Connection myConn, File fileObj, String fullJarName) throws SQLException {
        try {
            FileInputStream inStream = new FileInputStream(fileObj);
            PreparedStatement prep = myConn.prepareStatement("insert into 'sqlj'.retained_jars values('" + fullJarName + "', ?)");
            IfxLobDescriptor loDesc = new IfxLobDescriptor(myConn);
            loDesc.setCreateFlags(1);
            IfxLocator loPtr = new IfxLocator();
            IfxSmartBlob smb = new IfxSmartBlob(myConn);
            int loFd = smb.IfxLoCreate(loDesc, 8, loPtr);
            int n = smb.IfxLoWrite(loFd, (InputStream)inStream, (int)fileObj.length());
            smb.IfxLoClose(loFd);
            IfxBblob blb = new IfxBblob(loPtr);
            prep.setBlob(1, (Blob)blb);
            prep.executeUpdate();
            prep.close();
            ((InputStream)inStream).close();
        }
        catch (FileNotFoundException fnfe) {
            fileObj.delete();
            throw GenErr.sqle(-9481, fnfe.toString());
        }
        catch (IOException ioe) {
            fileObj.delete();
            throw GenErr.sqle(-9481, ioe.toString());
        }
        catch (SQLException sqle) {
            fileObj.delete();
            throw sqle;
        }
    }

    static void checkJarExistence(Connection myConn, String fullJarName) throws SQLException {
        Statement stmt = myConn.createStatement();
        ResultSet rs = stmt.executeQuery("select tabname from 'informix'.systables where tabname = 'retained_jars' and owner = 'sqlj'");
        boolean tabExists = rs.next();
        rs.close();
        stmt.close();
        if (!tabExists) {
            throw GenErr.sqle(-9487, fullJarName);
        }
        stmt = myConn.createStatement();
        rs = stmt.executeQuery("select jarname from 'sqlj'.retained_jars where jarname = '" + fullJarName + "'");
        boolean jarExists = rs.next();
        rs.close();
        stmt.close();
        if (!jarExists) {
            throw GenErr.sqle(-9487, fullJarName);
        }
    }

    private static void checkJarReferencesBeforeRemoval(Connection myConn, String fullJarName, ZipFile jarFile, int caller) throws SQLException {
        Statement stmt = myConn.createStatement();
        ResultSet rs = stmt.executeQuery("select externalname from 'informix'.sysprocedures where langid = 3");
        String jar = null;
        while (rs.next()) {
            String jarID;
            String ext = rs.getString("externalname");
            int pos = ext.indexOf(":");
            if (pos == -1 || !(jar = ext.substring(0, pos)).equals(jarID = fullJarName.substring(fullJarName.lastIndexOf(46) + 1, fullJarName.length())) && !jar.equals(fullJarName)) continue;
            if (caller == 1) {
                throw GenErr.sqle(-9488);
            }
            if (caller != 2) continue;
            int parenPos = ext.indexOf("(");
            if (parenPos == -1) {
                parenPos = ext.length();
            }
            String className = ext.substring(pos + 1, parenPos);
            className = className.substring(0, className.lastIndexOf("."));
            ZipEntry entry = jarFile.getEntry(className = className.replace('.', '/') + ".class");
            if (entry != null) continue;
            throw GenErr.sqle(-9489, className);
        }
        rs.close();
        stmt.close();
    }

    private static void removeJarFromDatabase(Connection myConn, String fullJarName, int caller) throws SQLException {
        File fileObj;
        Statement stmt = myConn.createStatement();
        stmt.executeUpdate("delete from 'sqlj'.retained_jars where jarname = '" + fullJarName + "'");
        stmt.close();
        stmt = myConn.createStatement();
        ResultSet rs = stmt.executeQuery("select tabname from 'informix'.systables where tabname = 'alter_java_paths' and owner = 'sqlj'");
        boolean tableExists = rs.next();
        rs.close();
        stmt.close();
        if (tableExists) {
            stmt = myConn.createStatement();
            stmt.executeUpdate("delete from 'sqlj'.alter_java_paths where jarname = '" + fullJarName + "'");
            stmt.close();
        }
        if (IsWindows) {
            JarHandler.mgr.jarMap.remove(fullJarName);
        } else if (UDRLMInfo.setJarRemoveFlag(fullJarName, UDRDBAContextImpl.javaLangHandle, caller) == -1) {
            throw GenErr.sqle(-9301, fullJarName);
        }
        if (caller == 1 && (fileObj = new File(JarHandler.getJarTmpPath() + fullJarName + ".jar")) != null) {
            fileObj.delete();
        }
    }

    private static InputStream getManifestInputStream(ZipFile zipObj, String jarName) throws SQLException {
        ZipEntry entry = zipObj.getEntry("META-INF/MANIFEST.MF");
        if (entry == null) {
            System.out.println("ERROR:No deployment descriptors processed. Jar " + jarName + " has no manifest file.");
            throw GenErr.sqle(-9490, jarName);
        }
        try {
            return zipObj.getInputStream(entry);
        }
        catch (IOException ioe) {
            throw GenErr.sqle(-9481, ioe.toString());
        }
    }

    private static void addOrAlterPath(Connection myConn, String fullJarName, String path) throws SQLException {
        Statement stmt = myConn.createStatement();
        ResultSet rs = stmt.executeQuery("select tabname from 'informix'.systables where tabname = 'alter_java_paths' and owner = 'sqlj'");
        boolean tableExists = rs.next();
        rs.close();
        stmt.close();
        if (!tableExists) {
            stmt = myConn.createStatement();
            stmt.execute("create table 'sqlj'.alter_java_paths(jarname varchar(255) not null unique, jarpath varchar(255) not null)");
            stmt.close();
        }
        boolean newEntry = true;
        String query = null;
        if (tableExists) {
            stmt = myConn.createStatement();
            rs = stmt.executeQuery("select jarname from 'sqlj'.alter_java_paths where jarname = '" + fullJarName + "'");
            newEntry = !rs.next();
            rs.close();
            stmt.close();
            if (!newEntry) {
                query = "update 'sqlj'.alter_java_paths set jarpath = '" + path + "' where jarname = '" + fullJarName + "';";
                if (IsWindows) {
                    JVPClassLoader l = (JVPClassLoader)JarHandler.mgr.jarMap.get(fullJarName);
                    if (l != null) {
                        l.jarPath = path;
                    }
                } else if (UDRLMInfo.setNewPathFlag(fullJarName, UDRDBAContextImpl.javaLangHandle) == -1) {
                    throw GenErr.sqle(-9302, fullJarName);
                }
            }
        }
        if (newEntry) {
            query = "insert into 'sqlj'.alter_java_paths values('" + fullJarName + "', '" + path + "')";
        }
        stmt = myConn.createStatement();
        stmt.executeUpdate(query);
        stmt.close();
    }

    private static String replaceThisjar(String query, String fullJarName) {
        int extNameIndex = query.indexOf("external name");
        if (extNameIndex == -1) {
            extNameIndex = query.indexOf("EXTERNAL NAME");
        }
        if (extNameIndex == -1) {
            return query;
        }
        int quoteIndex = -1;
        quoteIndex = query.indexOf(34, extNameIndex);
        if (quoteIndex == -1 && (quoteIndex = query.indexOf(39, extNameIndex)) == -1) {
            return query;
        }
        if (!query.startsWith("thisjar:", quoteIndex + 1)) {
            return query;
        }
        String qFirstPart = query.substring(0, quoteIndex + 1);
        String qSecondPart = query.substring(query.indexOf(58, quoteIndex));
        String replacedQuery = qFirstPart + fullJarName + qSecondPart;
        return replacedQuery;
    }

    static String getEnv(String envVar) {
        int[] len = new int[1];
        long envValPtr = JarHandler.getEnv(envVar, len);
        byte[] buf = new byte[len[0]];
        String envVal = null;
        if (envValPtr != 0L) {
            UDREnvImpl.copyCString(envValPtr, buf);
            envVal = new String(buf);
        }
        return envVal;
    }

    static String getJarTmpPath() {
        String informixdir = null;
        if (jarTmpPathVal != null) {
            return jarTmpPathVal;
        }
        jarTmpPathVal = JarHandler.getEnv(jarTmpPath);
        informixdir = JarHandler.getEnv("INFORMIXDIR");
        jarTmpPathVal = jarTmpPathVal != null ? jarTmpPathVal + JarHandler.getSlashType() : (informixdir != null ? informixdir + JarHandler.getSlashType() + "tmp" + JarHandler.getSlashType() : JarHandler.getSlashType() + "tmp" + JarHandler.getSlashType());
        return jarTmpPathVal;
    }

    private static String getSlashType() {
        if (slashType != null) {
            return slashType;
        }
        slashType = IsWindows ? BACKSLASH : FORWSLASH;
        return slashType;
    }

    public static void renameInstalledJars() throws SQLException {
        String jarName = null;
        String userPlusId = null;
        String newJarName = null;
        JVPClassLoader loader = null;
        String tmpPath = null;
        String oldFileName = null;
        File oldFileObj = null;
        String extName = null;
        String latter = null;
        String[] dbName = new String[1];
        String[] userName = new String[1];
        Connection myConn = JarHandler.getConnDbUser(dbName, userName);
        Statement stmt = myConn.createStatement();
        ResultSet rs = stmt.executeQuery("select jarname from 'sqlj'.retained_jars");
        UDRDBAManagerImpl udrmgr = (UDRDBAManagerImpl)UDRDBAContextImpl.udrDBAManager;
        Statement updtstmt = myConn.createStatement();
        Statement extstmt = myConn.createStatement();
        ResultSet extrs = null;
        while (rs.next()) {
            jarName = rs.getString(1);
            userPlusId = jarName.substring(jarName.indexOf("."), jarName.length());
            newJarName = dbName[0] + userPlusId;
            updtstmt.executeUpdate("update 'sqlj'.retained_jars set jarname = '" + newJarName + "' where jarname = '" + jarName + "'");
            loader = (JVPClassLoader)udrmgr.jarMap.get(jarName);
            if (loader != null) {
                loader.setJarName(newJarName);
                udrmgr.jarMap.remove(jarName);
                udrmgr.jarMap.put(newJarName, loader);
            }
            if ((oldFileObj = new File(oldFileName = (tmpPath = JarHandler.getJarTmpPath()) + jarName + ".jar")) != null && oldFileObj.exists()) {
                oldFileObj.renameTo(new File(tmpPath + newJarName + ".jar"));
            }
            if (!IsWindows && UDRLMInfo.renameJarInList(jarName, newJarName, UDRDBAContextImpl.javaLangHandle) == -1) {
                throw GenErr.sqle(-9481, " Error renaming jar in global JVP list.");
            }
            extrs = extstmt.executeQuery("select externalname from 'informix'.sysprocedures where langid = 3 and externalname like '" + jarName + "%'");
            while (extrs.next()) {
                extName = extrs.getString(1);
                latter = extName.substring(extName.indexOf(":"), extName.length());
                updtstmt.executeUpdate("update 'informix'.sysprocedures set externalname = '" + newJarName + latter + "' where externalname = '" + extName + "'");
            }
        }
        extrs.close();
        extstmt.close();
        updtstmt.close();
        rs.close();
        stmt.close();
        myConn.close();
    }

    private static native long getEnv(String var0, int[] var1);

    public static void removeTempFile(String fileName) {
        File fileObj;
        if (fileName != null && (fileObj = new File(fileName)) != null) {
            fileObj.delete();
        }
    }

    private static String qualifyExternalName(String externalName, Connection myConn) throws SQLException {
        int pos = externalName.indexOf(":");
        if (pos != -1) {
            String jarName = externalName.substring(0, pos);
            String className = externalName.substring(pos + 1);
            jarName = JarHandler.setThreePartJarName(((IfxConnection)myConn).getDbName(), myConn.getMetaData().getUserName(), jarName, false);
            externalName = jarName + ":" + className;
        }
        return externalName;
    }
}

