/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import com.informix.udr.UDREnv;
import informix.jvp.JVP;
import informix.jvp.dbapplet.impl.DBAMonitorImpl;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.SQLJParamImpl;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import informix.jvp.dbapplet.impl.UDREnvImpl;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class PerJavaUDRContext {
    private String IDName;
    private String moduleName = null;
    private long lminfo;
    private DBAMonitorImpl dbaMonitor;
    public boolean noJdbcConn = false;
    String database;
    String user;
    String owner = null;
    private SQLJParamImpl paramMgr;
    private UDREnvImpl udrEnv;

    public UDREnv getUDREnv() {
        return this.udrEnv;
    }

    public SQLJParamImpl getParamMgr() {
        return this.paramMgr;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String newName) {
        this.moduleName = newName;
    }

    public void cleanup() {
    }

    public PerJavaUDRContext(String name, String modName, DBAMonitorImpl dbaMonitor, long lminfo) throws SQLException {
        try {
            this.IDName = name;
            this.lminfo = lminfo;
            this.dbaMonitor = dbaMonitor;
            this.paramMgr = null;
            this.udrEnv = new UDREnvImpl(lminfo);
            this.moduleName = modName;
            byte[] buf = new byte[UDREnvImpl.IDENTSIZE + 1];
            int len = UDREnvImpl.copyCString(UDRLMInfo.getCurrentDatabase(lminfo), buf);
            this.database = new String(buf, 0, len);
            len = UDREnvImpl.copyCString(UDRLMInfo.getCurrentUser(lminfo), buf);
            this.user = new String(buf, 0, len);
            this.owner = UDRLMInfo.getProcOwner(lminfo);
            this.noJdbcConn = UDRLMInfo.isSolano(lminfo);
        }
        catch (Exception e) {
            JVP.log.log("Cannot create PerJavaUDRContext object " + e.toString());
            throw GenErr.sqle(-9441, e.toString());
        }
    }

    private void initDBApplet() throws SQLException {
        Object dbaClass = null;
        JVP.traceable.tracePrint("JVP.DBA.PerJavaUDRContext", 5, "initialising JAVA UDR");
        try {
            int pos = this.moduleName.indexOf(":");
            if (pos != -1) {
                String jarName = this.moduleName.substring(0, pos);
                StringTokenizer tokens = new StringTokenizer(jarName, ".", false);
                int numTokens = tokens.countTokens();
                switch (numTokens) {
                    case 1: {
                        if (this.owner != null) {
                            this.moduleName = this.database + "." + this.owner + "." + this.moduleName;
                            break;
                        }
                        this.moduleName = this.database + "." + this.user + "." + this.moduleName;
                        break;
                    }
                    case 2: {
                        this.moduleName = this.database + "." + this.moduleName;
                    }
                }
                UDRDBAContextImpl.udrDBAManager.loadUDRClass(this.moduleName);
            } else {
                Class.forName(this.moduleName);
            }
        }
        catch (ClassNotFoundException cnfe) {
            JVP.log.log("Error loading UDR class: " + cnfe.toString());
            throw GenErr.sqle(-9442, "<" + this.moduleName + "> : " + cnfe.getMessage());
        }
        this.paramMgr = new SQLJParamImpl(this.dbaMonitor, this.lminfo);
        JVP.traceable.tracePrint("JVP.DBA.PerJavaUDRContext", 5, "returned from JAVA UDR init, declaring success");
    }

    public void invokeUDR() throws Throwable {
        if (this.paramMgr == null) {
            JVP.traceable.tracePrint("JVP.DBA.PerJavaUDRContext", 5, "lazy loading java class for this method");
            this.initDBApplet();
        }
        JVP.traceable.tracePrint("JVP.DBA.PerJavaUDRContext", 5, "Begining method invokation");
        this.paramMgr.invoke(this.lminfo);
        JVP.traceable.tracePrint("JVP.DBA.PerJavaUDRContext", 5, "finish method invokation");
    }

    public String toString() {
        return "PerJAVAUDRContext" + this.IDName;
    }

    public long getLminfo() {
        return this.lminfo;
    }
}

