/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import informix.jvp.JVP;
import informix.jvp.JVPError;
import informix.jvp.dbapplet.impl.DBAThreadImpl;
import informix.jvp.dbapplet.impl.SAPIRequestImpl;
import java.sql.SQLException;
import java.util.LinkedList;

public class SAPIRequestFreeList {
    LinkedList freelist;

    public SAPIRequestFreeList(int startSize) {
        try {
            this.freelist = new LinkedList();
            for (int i = 0; i < startSize; ++i) {
                SAPIRequestImpl req = new SAPIRequestImpl();
                this.freelist.add(req);
            }
        }
        catch (SQLException exce) {
            JVPError.unexpectedException(false, exce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SAPIRequestImpl getFromFreeList() throws SQLException {
        SAPIRequestImpl req;
        Thread th = Thread.currentThread();
        if (th instanceof DBAThreadImpl && (req = ((DBAThreadImpl)th).getSAPIReqFromThreadCache()) != null) {
            ((DBAThreadImpl)th).clearSAPIReqThreadCache();
            return req;
        }
        SAPIRequestFreeList sAPIRequestFreeList = this;
        synchronized (sAPIRequestFreeList) {
            if (this.freelist.isEmpty()) {
                try {
                    req = new SAPIRequestImpl();
                }
                catch (SQLException e) {
                    JVP.log.log(" new SAPIRequestImpl failed");
                    throw e;
                }
                return req;
            }
            req = (SAPIRequestImpl)this.freelist.removeLast();
            return req;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToFreeList(SAPIRequestImpl req) {
        SAPIRequestImpl req2 = null;
        req.clearArgs();
        Thread th = Thread.currentThread();
        if (th instanceof DBAThreadImpl && (req2 = ((DBAThreadImpl)th).getSAPIReqFromThreadCache()) == null) {
            ((DBAThreadImpl)th).setSAPIReqThreadCache(req);
            return;
        }
        SAPIRequestFreeList sAPIRequestFreeList = this;
        synchronized (sAPIRequestFreeList) {
            this.freelist.add(req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToFreeListDirectly(SAPIRequestImpl req) {
        req.clearArgs();
        SAPIRequestFreeList sAPIRequestFreeList = this;
        synchronized (sAPIRequestFreeList) {
            this.freelist.add(req);
        }
    }
}

