/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import com.informix.jdbc.IfxDirectProtocol;
import informix.jvp.JVP;
import informix.jvp.Semaphore;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.SAPIRequest;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.UDREnvImpl;
import informix.jvp.impl.SemaphoreImpl;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class SAPIRequestImpl
implements SAPIRequest {
    private int MAXARGS = 10;
    private int funcid;
    private int num_args_used = 0;
    private long[] args;
    private long[] strings;
    private int[] strlens = new int[]{20, 20, 20, 2048, 64, 64, 64, 64, 64};
    private long returnPointer;
    private int res;
    private int rowcount;
    private int sapi_req_status;
    private long dbname_storage;
    public static final int MI_EXEC = 0;
    public static final int MI_OPEN = 1;
    public static final int MI_GET_RESULT = 2;
    public static final int MI_NEXT_ROW = 3;
    public static final int MI_GET_ROW_DESCS = 4;
    public static final int MI_COLUMN_COUNT = 5;
    public static final int MI_VALUE = 6;
    public static final int MI_PREPARE = 7;
    public static final int MI_OPEN_PREPARED_STATEMENT = 8;
    public static final int MI_FETCH_STATEMENT = 9;
    public static final int MI_DROP_PREPARED_STATEMENT = 10;
    public static final int MI_EXEC_PREPARED_STATEMENT = 11;
    public static final int MI_CLOSE_STATEMENT = 12;
    public static final int MI_CLOSE = 13;
    public static final int MI_LO_LENGTH = 14;
    public static final int MI_LO_READ = 15;
    public static final int MI_LO_POSITION = 16;
    public static final int MI_COMMIT = 17;
    public static final int MI_BEGIN_WORK = 18;
    public static final int MI_ROLLBACK = 19;
    public static final int MI_LIBRARY_VERSION = 20;
    public static final int MI_QUERY_FINISH = 21;
    public static final int MI_LO_CREATE = 22;
    public static final int MI_ROW_CREATE_SETUP = 23;
    public static final int MI_ROW_CREATE = 24;
    public static final int MI_GET_TYPE_BYNAME = 25;
    public static final int MI_ROUTINE_GET = 26;
    public static final int MI_EXEC_ROUTINE = 27;
    public static final int MI_QUAL_EVAL = 28;
    public static final int MI_RESULT_SET_CREATE = 29;
    public static final int MI_CONVERT_NEXT_ROW = 30;
    public static final int MI_SETNEXTROW = 31;
    public static final int MI_QUAL_INIT = 32;
    public static final int MI_SMART_LO_READ = 33;
    public static final int MI_SMART_LO_WRITE = 34;
    public static final int MI_QUAL_FINDQUAL = 35;
    public static final int MI_LO_INC_REFCOUNT = 36;
    public static final int MI_LO_DEC_REFCOUNT = 37;
    public static final int JVP_MI_OK = 0;
    public static final int JVP_SQLERROR = -1;
    public static final int JVP_SQLWARNING = -2;
    public static final int JVP_MI_ERROR = -3;
    public static final int JVP_ABORT = -4;
    public static final int DBNAME = 0;
    public static final int CURNAME = 0;
    public static final int USER = 1;
    public static final int PASSWD = 2;
    public static final int STATEMENT = 3;
    public static final int DBDATE = 4;
    public static final int DBMONEY = 5;
    public static final int GL_DATE = 6;
    public static final int DB_CENTURY = 7;
    public static final int DB_LOCALE = 8;
    public static final int MAXSTRINGS = 9;
    public DBAMonitor to_sapp_mon;
    public Semaphore waitDone;

    public static native long getMiConn(long var0);

    public native int initStrings(long[] var1, int[] var2, int var3);

    public native int copyString(String var1, long[] var2, int[] var3, int var4);

    public native int copyByteArray(byte[] var1, int var2, long[] var3, int[] var4, int var5);

    public native int getJdrNumParams(long var1);

    public native int getJdrNumCols(long var1);

    public native int getJdrIsNull(long var1, int var3);

    public native long getJdrColVal(long var1, int var3);

    public native int getSQLCode(long var1);

    public native long getSQLMessage(long var1);

    public native long getSQLState(long var1);

    public native int getTransFlag(long var1);

    public native long getDbName(long var1);

    public native long getUserName(long var1);

    public native int getCmdType(long var1);

    public native boolean isDelimIdentSet(long var1);

    public native int getSerial(long var1);

    public native long getSerial8(long var1);

    public native long getBigSerial(long var1);

    public native long fetchCachedRow(long var1, int var3);

    public native int getRowsFetched(long var1);

    public native int initParamResultSetMetaData(ResultSetMetaData var1, long var2);

    public native int initOutputResultSetMetaData(ResultSetMetaData var1, long var2);

    public native int initParamRSMD_GLS(ResultSetMetaData var1, long var2, String var4);

    public native int initOutputRSMD_GLS(ResultSetMetaData var1, long var2, String var4);

    public native long getJdrRow(long var1);

    public native long getJdrRow(long var1, int var3);

    public native long getJdrRowDesc(long var1);

    public SAPIRequestImpl() throws SQLException {
        this.args = new long[this.MAXARGS];
        this.strings = new long[9];
        if (this.initStrings(this.strings, this.strlens, 9) != 0) {
            JVP.log.log("SAPIRequestImpl.initStrings failed to MTMALLOC");
            throw new SQLException("SAPIRequestImpl.initStrings failed to MTMALLOC");
        }
        this.returnPointer = 0L;
        this.sapi_req_status = 0;
        this.waitDone = new SemaphoreImpl("SAPIRequestImpl Sem");
        this.to_sapp_mon = null;
    }

    @Override
    public Semaphore getSemaphore() {
        return this.waitDone;
    }

    @Override
    public void setSappMon(DBAMonitor mon) {
        this.to_sapp_mon = mon;
    }

    @Override
    public DBAMonitor getSappMon() {
        return this.to_sapp_mon;
    }

    @Override
    public void setFuncid(int funcid) {
        this.funcid = funcid;
    }

    @Override
    public int getFuncid() {
        return this.funcid;
    }

    public void setByteArrayData(int i, int str_index, byte[] ba) throws SQLException {
        if (ba != null) {
            if (this.copyByteArray(ba, ba.length, this.strings, this.strlens, str_index) != 0) {
                throw new SQLException("copyByteArray failed on " + ba.toString());
            }
            this.args[i] = this.strings[str_index];
        } else {
            this.args[i] = 0L;
        }
        ++this.num_args_used;
    }

    @Override
    public void setStringData(int i, int str_index, String str) throws SQLException {
        if (str != null) {
            if (this.copyString(str, this.strings, this.strlens, str_index) != 0) {
                throw new SQLException("copyString failed on " + str);
            }
            this.args[i] = this.strings[str_index];
        } else {
            this.args[i] = 0L;
        }
        ++this.num_args_used;
    }

    @Override
    public void setArgData(int i, long data) {
        this.args[i] = data;
        ++this.num_args_used;
    }

    @Override
    public long[] getArgArray() {
        return this.args;
    }

    @Override
    public long getArgData(int i) throws Exception {
        if (i >= this.MAXARGS) {
            throw new Exception("SAPIRequestImpl.getArgData(" + i + ") out of range");
        }
        return this.args[i];
    }

    @Override
    public int getNumArgsUsed() {
        return this.num_args_used;
    }

    @Override
    public void clearArgs() {
        for (int i = 0; i < this.num_args_used; ++i) {
            this.args[i] = 0L;
        }
        this.num_args_used = 0;
        this.sapi_req_status = 0;
    }

    @Override
    public void setRetData(long ptr, int res, int row_count) {
        JVP.traceable.tracePrint("JVP.SAPIRequest", 5, "setRetData " + ptr + " rowcount " + row_count);
        this.returnPointer = ptr;
        this.res = res;
        this.rowcount = row_count;
    }

    @Override
    public long getRetPtr() {
        return this.returnPointer;
    }

    @Override
    public int getRes() {
        return this.res;
    }

    @Override
    public int getRetCount() {
        return this.rowcount;
    }

    public void setStatus(int status) {
        JVP.traceable.tracePrint("JVP.SAPIRequest", 5, "setStatus " + status);
        this.sapi_req_status = status;
    }

    public int getStatus() {
        return this.sapi_req_status;
    }

    public void checkQueryStatus(long conn, IfxDirectProtocol proto, String locale) throws SQLException {
        byte[] mesgArr = new byte[UDREnvImpl.IDENTSIZE + 1];
        byte[] stateArr = new byte[UDREnvImpl.IDENTSIZE + 1];
        JVP.traceable.tracePrint("JVP.SAPIRequest", 5, "SAPIRequestImpl: checkQueryStatus() called");
        switch (this.getStatus()) {
            case -1: {
                JVP.traceable.tracePrint("JVP.SAPIRequest", 1, "SAPIRequestImpl: SQL Error occured");
                if (conn != 0L) {
                    long mesgPtr = this.getSQLMessage(conn);
                    int mesgLen = UDREnvImpl.copyCString(mesgPtr, mesgArr);
                    proto.message = new String(mesgArr, 0, mesgLen);
                    long statePtr = this.getSQLState(conn);
                    int stateLen = UDREnvImpl.copyCString(statePtr, stateArr);
                    proto.SQLState = new String(stateArr, 0, stateLen);
                    proto.sqlcode = this.getSQLCode(conn);
                } else {
                    proto.sqlcode = -9474;
                    proto.message = new String("SQL connection Error");
                }
                throw GenErr.sqle(proto.sqlcode, proto.message, locale);
            }
            case -2: {
                JVP.traceable.tracePrint("JVP.SAPIRequest", 1, "SAPIRequestImpl: SQL Warning occured");
                long mesgPtr = this.getSQLMessage(conn);
                int mesgLen = UDREnvImpl.copyCString(mesgPtr, mesgArr);
                proto.message = new String(mesgArr, 0, mesgLen);
                long statePtr = this.getSQLState(conn);
                int stateLen = UDREnvImpl.copyCString(statePtr, stateArr);
                proto.SQLState = new String(stateArr, 0, stateLen);
                proto.sqlcode = this.getSQLCode(conn);
                proto.chainWarnings(new SQLWarning(proto.message, proto.SQLState, proto.sqlcode));
                break;
            }
            case -3: {
                JVP.traceable.tracePrint("JVP.SAPIRequest", 1, "SAPIRequestImpl: SAPI dispatch failed");
                proto.message = new String("SAPI dispatch failed");
                throw GenErr.sqle(-9446, proto.message, locale);
            }
            case -4: {
                JVP.traceable.tracePrint("JVP.SAPIRequest", 1, "SAPIRequestImpl: SAPI Aborted: unrecoverable error");
                proto.message = new String("SAPI Aborted: unrecoverable error");
                throw GenErr.sqle(-9446, proto.message, locale);
            }
            case 0: {
                JVP.traceable.tracePrint("JVP.SAPIRequest", 5, "SAPIRequestImpl: SAPI dispatch succeeded");
            }
        }
    }

    public static native int loadSetColInfoNative();

    public static int loadSetColInfo() {
        return SAPIRequestImpl.loadSetColInfoNative();
    }
}

