/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import com.informix.jdbc.IfmxSQLInStream;
import com.informix.jdbc.IfmxSQLOutStream;
import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDataPointer;
import com.informix.jdbc.IfxDirectConnection;
import com.informix.jdbc.IfxDirectProtocol;
import com.informix.jdbc.IfxLoc;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxRow;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.SQLDistinctInput;
import com.informix.jdbc.SQLDistinctOutput;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IfxTypes;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import com.informix.udr.UDREnv;
import informix.jvp.JVP;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.impl.DBAThreadImpl;
import informix.jvp.dbapplet.impl.GenErr;
import informix.jvp.dbapplet.impl.JVPClassLoader;
import informix.jvp.dbapplet.impl.SAPIRequestFreeList;
import informix.jvp.dbapplet.impl.SAPIRequestImpl;
import informix.jvp.dbapplet.impl.TimeEventTrace;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import informix.jvp.dbapplet.impl.UDRDBAManagerImpl;
import informix.jvp.dbapplet.impl.UDREnvImpl;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

public class SQLJParamImpl {
    static Hashtable JavaToClassTable;
    static Hashtable IfxToJavaTable;
    public static final short SMINTNULL = Short.MIN_VALUE;
    public static final int INTNULL = Integer.MIN_VALUE;
    public static final long BIGINTNULL = Long.MIN_VALUE;
    static boolean gotEnc;
    static String dbEncoding;
    static String dbLocale;
    static boolean schipdebug;
    private String moduleName;
    private String signature;
    private int[] sqlParamTypes = null;
    private int sqlRetType = -1;
    private Class[] javaParamTypes = null;
    private Class javaRetType = null;
    private Class udrClass = null;
    private Method udrMethod = null;
    private Object[] params = null;
    private Object result = null;
    private int numInput;
    private int numOutput;
    private int totalParams;
    DBAMonitor dbaMonitor;
    String[] paramTypeNames = null;
    long udrConn;
    private boolean[] distinctParamWithMap;
    private boolean distinctRetWithMap = false;
    private byte[][] inParamValues = null;
    int[] strParamLen = new int[1];
    boolean[] outputParams = null;
    Class objectClass;
    Class stringClass;
    Class intClass;
    Class integerClass;
    Class booleanClass;

    public Class JavaToClass(String name) throws SQLException {
        JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "JavaToClass: " + name);
        if (name == null) {
            return null;
        }
        Class res = (Class)JavaToClassTable.get(name);
        if (res == null) {
            JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "no map for " + name);
            try {
                res = this.JavaToClassLoad(name);
            }
            catch (ClassNotFoundException cnfe) {
                if (!gotEnc) {
                    this.setEnc();
                }
                throw GenErr.sqle(-9443, name, dbLocale);
            }
        }
        return res;
    }

    private Class JavaToClassLoad(String name) throws ClassNotFoundException {
        JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "JavaToClassLoad: " + name);
        JVPClassLoader l = null;
        int pos = this.moduleName.indexOf(":");
        if (pos != -1) {
            String jar = this.moduleName.substring(0, pos);
            UDRDBAManagerImpl mgr = (UDRDBAManagerImpl)UDRDBAContextImpl.udrDBAManager;
            l = (JVPClassLoader)mgr.jarMap.get(jar);
        } else {
            l = new JVPClassLoader();
        }
        Class res = l.loadClass(name, true);
        JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "JavaToClassLoad return: " + res);
        return res;
    }

    static String IfxToJava(int ifxType) throws SQLException {
        String res = (String)IfxToJavaTable.get(new Integer(ifxType));
        if (res == null) {
            JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "no map for " + ifxType);
        } else {
            JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "type: " + ifxType + "was converted to " + res);
        }
        return res;
    }

    public static Object makeParamObject(UDREnv env, int i, String[] SQLname) throws SQLException {
        Object obj;
        Class javaParamType;
        SQLname[0] = i == -1 ? env.getReturnTypeName() : env.getParamTypeName()[i];
        if (!(Thread.currentThread() instanceof DBAThreadImpl)) {
            throw GenErr.sqle(-9491);
        }
        DBAThreadImpl currThread = (DBAThreadImpl)Thread.currentThread();
        SQLJParamImpl paramMgr = currThread.getParamMgr();
        if (schipdebug) {
            System.out.println("makeParamObject for: " + SQLname[0]);
        }
        try {
            JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " getUDTExternalName on " + SQLname[0]);
            javaParamType = paramMgr.JavaToClassLoad(JVPClassLoader.getUDTExternalName(SQLname[0], null, false));
            obj = javaParamType.newInstance();
            if (obj instanceof Struct) {
                obj = (Struct)obj;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw GenErr.sqle(-9451, SQLname[0] + ":" + cnfe.toString());
        }
        catch (InstantiationException ine) {
            throw GenErr.sqle(-9451, SQLname[0] + ":" + ine.toString());
        }
        catch (IllegalAccessException ille) {
            throw GenErr.sqle(-9451, SQLname[0] + ":" + ille.toString());
        }
        JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "makeParamObject() made " + javaParamType.getName());
        return obj;
    }

    public SQLJParamImpl(DBAMonitor mon, long lminfo) throws SQLException {
        Object o = null;
        Object tmp = null;
        gotEnc = false;
        JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "dbLocale is " + dbLocale);
        JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "dbEncoding is " + dbEncoding);
        this.dbaMonitor = mon;
        if (!(Thread.currentThread() instanceof DBAThreadImpl)) {
            throw GenErr.sqle(-9491);
        }
        DBAThreadImpl currTh = (DBAThreadImpl)Thread.currentThread();
        this.moduleName = currTh.getModuleName();
        this.signature = UDRLMInfo.getSignature(lminfo);
        try {
            this.udrClass = UDRDBAContextImpl.udrDBAManager.getLoadedClass(this.moduleName);
        }
        catch (ClassNotFoundException cnfe) {
            if (!gotEnc) {
                this.setEnc();
            }
            throw GenErr.sqle(-9442, "<" + this.moduleName + "> : " + cnfe.getMessage(), dbLocale);
        }
        this.totalParams = UDRLMInfo.getTotalParams(lminfo);
        this.numOutput = UDRLMInfo.getNumOutput(lminfo);
        this.numInput = this.totalParams - this.numOutput;
        JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, this.moduleName + " : " + this.signature + " # input = " + new Integer(this.numInput).toString());
        this.sqlParamTypes = new int[this.totalParams];
        this.javaParamTypes = new Class[this.totalParams];
        Class[] javaMethodTypes = new Class[this.totalParams];
        JVP.traceable.tracePrint("JVP.JLM.PARAM", 3, this.moduleName + " : " + this.signature);
        UDRLMInfo.getSQLParamTypes(lminfo, this.sqlParamTypes, this.totalParams);
        StringTokenizer tokens = new StringTokenizer(this.signature, "(, )", false);
        String methodName = null;
        int nTypes = 0;
        this.distinctParamWithMap = new boolean[this.totalParams];
        for (int x = 0; x < this.totalParams; ++x) {
            this.distinctParamWithMap[x] = false;
        }
        while (tokens.hasMoreTokens()) {
            String t = tokens.nextToken();
            if (methodName == null) {
                methodName = t;
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "METHOD NAME " + t);
                continue;
            }
            int idx = t.indexOf(91);
            if (idx == -1) {
                this.javaParamTypes[nTypes] = this.JavaToClass(t);
            } else {
                t = t.substring(0, idx);
                Class c = this.JavaToClass(t);
                o = Array.newInstance(c, 1);
                this.javaParamTypes[nTypes] = o.getClass();
            }
            javaMethodTypes[nTypes] = this.javaParamTypes[nTypes];
            if (this.javaParamTypes[nTypes].isInterface()) {
                if (this.paramTypeNames == null) {
                    UDREnv env = this.getUDREnv();
                    this.paramTypeNames = env.getParamTypeName();
                }
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "SQLJParamImpl() replacing arg" + nTypes + ": " + this.javaParamTypes[nTypes] + " with SQLTYPE: " + this.paramTypeNames[nTypes]);
                String extname = JVPClassLoader.getUDTExternalName(this.paramTypeNames[nTypes], null, false);
                if (extname != null) {
                    try {
                        this.javaParamTypes[nTypes] = this.JavaToClassLoad(extname);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (!gotEnc) {
                            this.setEnc();
                        }
                        throw GenErr.sqle(-9443, this.paramTypeNames[nTypes], dbLocale);
                    }
                }
            }
            if (!this.checkSQLJavaTypeMap(this.sqlParamTypes[nTypes], t, lminfo, nTypes)) {
                String sqlTypeName = IfxTypes.IfxTypeToName((int)this.sqlParamTypes[nTypes]);
                if (!gotEnc) {
                    this.setEnc();
                }
                throw GenErr.sqle(-9447, t + " to " + sqlTypeName, dbLocale);
            }
            if (schipdebug) {
                System.out.println("Parsed: " + t);
                System.out.println("Param " + nTypes + ": SQLid=" + this.sqlParamTypes[nTypes] + " jParam: " + this.javaParamTypes[nTypes] + " jMethod: " + javaMethodTypes[nTypes]);
            }
            JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "CLASS " + t + " = " + this.javaParamTypes[nTypes].toString());
            ++nTypes;
        }
        if (nTypes == 0) {
            for (nTypes = 0; nTypes < this.totalParams; ++nTypes) {
                javaMethodTypes[nTypes] = this.javaParamTypes[nTypes] = this.JavaToClass(SQLJParamImpl.IfxToJava(this.sqlParamTypes[nTypes]));
            }
        } else if (nTypes != this.totalParams) {
            throw GenErr.sqle(-9448, this.signature, dbLocale);
        }
        try {
            try {
                this.udrMethod = this.udrClass.getMethod(methodName, javaMethodTypes);
            }
            catch (NoSuchMethodException nsme) {
                int pos = this.moduleName.indexOf(":");
                String clsName = this.moduleName.substring(pos + 1);
                try {
                    this.udrClass = Class.forName(clsName);
                    this.udrMethod = this.udrClass.getMethod(methodName, javaMethodTypes);
                }
                catch (Exception e) {
                    throw nsme;
                }
            }
            int mods = this.udrMethod.getModifiers();
            if (!Modifier.isStatic(mods)) {
                throw new Exception();
            }
            this.javaRetType = this.udrMethod.getReturnType();
            if (this.javaRetType != null) {
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 2, "METHOD FOUND " + this.udrMethod.toString() + " returns " + this.javaRetType.toString());
            }
        }
        catch (Exception ex) {
            JVP.log.log(ex.toString());
            throw GenErr.sqle(-9449, "<" + methodName + ">:" + ex.toString(), dbLocale);
        }
        this.params = new Object[this.totalParams];
        if (this.numOutput > 0) {
            this.outputParams = new boolean[this.totalParams];
            JVP.traceable.tracePrint("JVP.JLM.PARAM", 2, "numOutput = " + this.numOutput);
            for (int count = 0; count < this.totalParams; ++count) {
                if (UDRLMInfo.isOutputParameter(lminfo, count)) {
                    this.outputParams[count] = true;
                    o = Array.newInstance(this.javaParamTypes[count].getComponentType(), 1);
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 2, "Setting Out Param Index = " + count + " Type is " + this.javaParamTypes[count].getComponentType());
                    this.params[count] = o;
                    continue;
                }
                this.outputParams[count] = false;
            }
        }
        this.objectClass = this.JavaToClass("java.lang.Object");
        this.stringClass = this.JavaToClass("java.lang.String");
        this.intClass = this.JavaToClass("int");
        this.integerClass = this.JavaToClass("java.lang.Integer");
        this.booleanClass = this.JavaToClass("boolean");
    }

    public void invoke(long lminfo) throws Throwable {
        this.setEnc();
        try {
            if (TimeEventTrace.tracing) {
                TimeEventTrace.StartEvent(23, ((DBAThreadImpl)Thread.currentThread()).threadUID);
            }
            for (int i = this.totalParams - 1; i >= 0; --i) {
                if (this.numOutput > 0 && this.isOutParam(i)) continue;
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 2, "Setting Paramter type index " + i);
                if (this.isDistinctTypeWithMap(i)) {
                    this.convertDistinctInputWithMap(lminfo, i);
                    continue;
                }
                this.convertInputParam(lminfo, i);
            }
            if (TimeEventTrace.tracing) {
                TimeEventTrace.StopEvent(23, ((DBAThreadImpl)Thread.currentThread()).threadUID);
            }
            JVP.traceable.tracePrint("JVP.JLM.PARAM", 2, "INVOKE METHOD " + this.udrMethod.toString() + " num param = " + this.params.length);
            if (TimeEventTrace.tracing) {
                TimeEventTrace.StartEvent(22, ((DBAThreadImpl)Thread.currentThread()).threadUID);
            }
            try {
                if (JVP.traceable.traceLevel("JVP") > 0) {
                    for (int j = 0; j < this.params.length; ++j) {
                        Class<?> cl;
                        if (this.params[j] == null || (cl = this.params[j].getClass()) == null) continue;
                        JVP.traceable.tracePrint("JVP.JLM.PARAM", 2, " params[" + j + "] is " + cl.getName());
                    }
                }
                this.result = this.udrMethod.invoke(null, this.params);
            }
            catch (IllegalAccessException ile) {
                throw GenErr.sqle(-9450, ile.toString(), dbLocale);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            if (TimeEventTrace.tracing) {
                TimeEventTrace.StopEvent(22, ((DBAThreadImpl)Thread.currentThread()).threadUID);
            }
            if (TimeEventTrace.tracing) {
                TimeEventTrace.StartEvent(23, ((DBAThreadImpl)Thread.currentThread()).threadUID);
            }
            if (this.result != null && UDRLMInfo.getNumReturn(lminfo) > 0) {
                if (this.sqlRetType == -1) {
                    this.sqlRetType = UDRLMInfo.getSQLRetType(lminfo, 0);
                    String javaRetTypeName = this.result.getClass().getName();
                    if (schipdebug) {
                        System.out.println("checking map of: " + this.sqlRetType + " to " + javaRetTypeName);
                    }
                    if (!this.checkSQLJavaTypeMap(this.sqlRetType, javaRetTypeName, lminfo, -1)) {
                        String sqlTypeName = IfxTypes.IfxTypeToName((int)this.sqlRetType);
                        throw GenErr.sqle(-9447, javaRetTypeName + " to " + sqlTypeName, dbLocale);
                    }
                }
                if (this.isDistinctTypeWithMap(-1)) {
                    this.convertDistinctOutputWithMap(this.result, lminfo, -1);
                } else {
                    this.setRetAndOutputParams(this.result, this.sqlRetType, lminfo, -1);
                }
            } else {
                UDRLMInfo.setReturnIsNull(lminfo);
            }
            if (this.numOutput > 0) {
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 2, "After Invoke numOutput = " + this.numOutput);
                int j = 0;
                for (int idx = this.params.length - 1; idx >= 0; --idx) {
                    if (j >= this.numOutput || !this.isOutParam(idx)) continue;
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 2, "Getting OutParam index = " + idx);
                    Object out = Array.get(this.params[idx], 0);
                    if (out != null) {
                        String outParamName = out.getClass().getName();
                        JVP.traceable.tracePrint("JVP.JLM.PARAM", 2, " outparamname is " + outParamName + " Value is " + out);
                        if (this.isDistinctTypeWithMap(idx)) {
                            this.convertDistinctOutputWithMap(out, lminfo, idx);
                        } else {
                            this.setRetAndOutputParams(out, this.sqlParamTypes[idx], lminfo, idx);
                        }
                    }
                    ++j;
                }
            }
            if (this.numInput > 0) {
                for (int i = 0; i < this.totalParams; ++i) {
                    if (this.numOutput <= 0 || this.isOutParam(i)) continue;
                    if (this.params[i] instanceof Clob) {
                        JVP.traceable.tracePrint("JVP.JLM.INVOKE", 2, "Closing CLOB param. Method: " + this.udrMethod.toString());
                        ((IfxCblob)this.params[i]).close();
                        continue;
                    }
                    if (!(this.params[i] instanceof Blob)) continue;
                    JVP.traceable.tracePrint("JVP.JLM.INVOKE", 2, "Closing BLOB param. Method: " + this.udrMethod.toString());
                    ((IfxBblob)this.params[i]).close();
                }
            }
            if (TimeEventTrace.tracing) {
                TimeEventTrace.StopEvent(23, ((DBAThreadImpl)Thread.currentThread()).threadUID);
            }
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            Throwable iex = ex.getCause();
            JVP.log.log("UDR invocation exception: " + iex.toString());
            throw iex;
        }
    }

    boolean isOutParam(int index) {
        return this.outputParams[index];
    }

    boolean checkSQLJavaTypeMap(int sqlType, String javaType, long lminfo, int i) {
        boolean res = true;
        if (javaType.equals("java.lang.Object")) {
            return res;
        }
        switch (sqlType) {
            case 0: {
                if (javaType.equals("char") || javaType.equals("java.lang.Character") || javaType.equals("java.lang.String")) break;
                res = false;
                break;
            }
            case 1: {
                if (javaType.equals("short") || javaType.equals("java.lang.Short")) break;
                res = false;
                break;
            }
            case 2: {
                if (javaType.equals("int") || javaType.equals("java.lang.Integer") || javaType.equals("long") || javaType.equals("java.lang.Long")) break;
                res = false;
                break;
            }
            case 4: {
                if (javaType.equals("float") || javaType.equals("java.lang.Float")) break;
                res = false;
                break;
            }
            case 3: {
                if (javaType.equals("double") || javaType.equals("java.lang.Double")) break;
                res = false;
                break;
            }
            case 5: 
            case 8: {
                if (javaType.equals("java.math.BigDecimal")) break;
                res = false;
                break;
            }
            case 7: {
                if (javaType.equals("java.sql.Date")) break;
                res = false;
                break;
            }
            case 10: {
                if (javaType.equals("java.sql.Time") || javaType.equals("java.sql.Timestamp")) break;
                res = false;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 43: 
            case 46: {
                if (javaType.equals("java.lang.String")) break;
                res = false;
                break;
            }
            case 44: 
            case 47: {
                if (javaType.equals("com.informix.jdbc.IfxDataPointer")) break;
                res = false;
                break;
            }
            case 17: 
            case 52: {
                if (javaType.equals("long") || javaType.equals("java.lang.Long")) break;
                res = false;
                break;
            }
            case 45: {
                if (javaType.equals("boolean") || javaType.equals("java.lang.Boolean")) break;
                res = false;
                break;
            }
            case 102: {
                if (javaType.equals("java.sql.Blob") || javaType.equals("com.informix.jdbc.IfxBblob")) break;
                res = false;
                break;
            }
            case 101: {
                if (javaType.equals("java.sql.Clob") || javaType.equals("com.informix.jdbc.IfxCblob")) break;
                res = false;
            }
        }
        if (!res && UDRLMInfo.isTypeDistinct(lminfo, i)) {
            res = true;
            if (i == -1) {
                this.distinctRetWithMap = true;
            } else {
                this.distinctParamWithMap[i] = true;
            }
        }
        return res;
    }

    private boolean isDistinctTypeWithMap(int i) {
        if (i == -1) {
            return this.distinctRetWithMap;
        }
        return this.distinctParamWithMap[i];
    }

    void convertDistinctInputWithMap(long lminfo, int i) throws SQLException {
        SQLData udtObj = null;
        try {
            udtObj = (SQLData)this.javaParamTypes[i].newInstance();
        }
        catch (InstantiationException ine) {
            throw GenErr.sqle(-9451, this.javaParamTypes[i].getName() + ":" + ine.toString());
        }
        catch (IllegalAccessException ille) {
            throw GenErr.sqle(-9451, this.javaParamTypes[i].getName() + ":" + ille.toString());
        }
        SQLDistinctInput sqlIn = new SQLDistinctInput(this.dbaMonitor, this.udrConn, lminfo, i, this.sqlParamTypes[i]);
        if (this.paramTypeNames == null) {
            this.paramTypeNames = this.getParamTypeNames();
        }
        String sqlName = this.paramTypeNames[i];
        udtObj.readSQL(sqlIn, sqlName);
        this.params[i] = udtObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convertInputParam(long lminfo, int i) throws SQLException {
        if (this.inParamValues == null) {
            this.inParamValues = new byte[this.totalParams][];
        }
        if (!gotEnc) {
            this.setEnc();
        }
        switch (this.sqlParamTypes[i]) {
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 101: 
            case 102: {
                if (this.inParamValues[i] != null) break;
                int maxlen = UDRLMInfo.getParamMaxLength(lminfo, i);
                this.inParamValues[i] = new byte[maxlen];
            }
        }
        switch (this.sqlParamTypes[i]) {
            case 0: {
                String s = this.convertStringInputParam(lminfo, i);
                if (s == null) {
                    if (this.javaParamTypes[i] == this.JavaToClass("char")) {
                        throw GenErr.sqle(-9452, "char", dbLocale);
                    }
                    this.params[i] = null;
                    break;
                }
                if (this.javaParamTypes[i] == this.stringClass || this.javaParamTypes[i] == this.objectClass) {
                    this.params[i] = s;
                    break;
                }
                char c = s.charAt(0);
                this.params[i] = new Character(c);
                break;
            }
            case 1: {
                short s = UDRLMInfo.getShortInputParamValue(lminfo, i);
                if (s == Short.MIN_VALUE) {
                    if (this.javaParamTypes[i] == this.JavaToClass("short")) {
                        throw GenErr.sqle(-9452, "short", dbLocale);
                    }
                    this.params[i] = null;
                    break;
                }
                this.params[i] = new Short(s);
                break;
            }
            case 2: {
                int iVal = UDRLMInfo.getIntInputParamValue(lminfo, i);
                if (iVal == Integer.MIN_VALUE) {
                    if (this.javaParamTypes[i] == this.intClass || this.javaParamTypes[i] == this.JavaToClass("long")) {
                        throw GenErr.sqle(-9452, "int/long", dbLocale);
                    }
                    this.params[i] = null;
                    break;
                }
                if (this.javaParamTypes[i] == this.intClass || this.javaParamTypes[i] == this.integerClass) {
                    this.params[i] = new Integer(iVal);
                    break;
                }
                this.params[i] = new Long(iVal);
                break;
            }
            case 4: {
                boolean[] isNull = new boolean[]{false};
                float f = UDRLMInfo.getFloatInputParamValue(lminfo, isNull, i);
                if (isNull[0]) {
                    if (this.javaParamTypes[i] == this.JavaToClass("float")) {
                        throw GenErr.sqle(-9452, "float", dbLocale);
                    }
                    this.params[i] = null;
                    break;
                }
                this.params[i] = new Float(f);
                break;
            }
            case 3: {
                boolean[] isNull = new boolean[]{false};
                double d = UDRLMInfo.getDoubleInputParamValue(lminfo, isNull, i);
                if (isNull[0]) {
                    if (this.javaParamTypes[i] == this.JavaToClass("double")) {
                        throw GenErr.sqle(-9452, "double", dbLocale);
                    }
                    this.params[i] = null;
                    break;
                }
                this.params[i] = new Double(d);
                break;
            }
            case 5: 
            case 8: {
                int[] scale = new int[1];
                String decstr = UDRLMInfo.getParamValueAsString(lminfo, i, scale);
                if (decstr == null) {
                    this.params[i] = null;
                    break;
                }
                this.params[i] = new BigDecimal(new BigInteger(decstr, 10), scale[0]);
                break;
            }
            case 7: {
                UDRLMInfo.getParamValue(lminfo, i, this.inParamValues[i], null);
                this.params[i] = IfxToJavaType.IfxToJavaDate((byte[])this.inParamValues[i], (short)0);
                break;
            }
            case 10: {
                int[] encLen = new int[1];
                int len = this.inParamValues[i].length;
                for (int j = 0; j < len; ++j) {
                    this.inParamValues[i][j] = 0;
                }
                UDRLMInfo.getParamValue(lminfo, i, this.inParamValues[i], encLen);
                this.params[i] = IfxToJavaType.IfxToJavaDateTime((byte[])this.inParamValues[i], (short)((short)encLen[0]));
                if (this.javaParamTypes[i] != this.JavaToClass("java.sql.Time") || this.params[i] == null) break;
                this.params[i] = new Time(((Timestamp)this.params[i]).getTime());
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 43: {
                this.params[i] = this.convertStringInputParam(lminfo, i);
                break;
            }
            case 46: {
                String in = this.convertStringInputParam(lminfo, i);
                this.params[i] = new IfxDataPointer(lminfo, i, in);
                break;
            }
            case 44: 
            case 47: {
                this.params[i] = new IfxDataPointer(lminfo, i, null);
                break;
            }
            case 14: {
                int[] encLen = new int[1];
                int len = this.inParamValues[i].length;
                for (int j = 0; j < len; ++j) {
                    this.inParamValues[i][j] = 0;
                }
                UDRLMInfo.getParamValue(lminfo, i, this.inParamValues[i], encLen);
                Interval itrvl = IfxToJavaType.IfxToJavaInterval((byte[])this.inParamValues[i], (short)((short)encLen[0]));
                this.params[i] = itrvl != null ? itrvl.toString() : null;
                if (this.params[i] == null) break;
                this.params[i] = ((String)this.params[i]).trim();
                break;
            }
            case 52: {
                long iVal = UDRLMInfo.getBigintInputParamValue(lminfo, i);
                if (iVal == Long.MIN_VALUE) {
                    if (this.javaParamTypes[i] == this.JavaToClass("long")) {
                        throw GenErr.sqle(-9452, "long", dbLocale);
                    }
                    this.params[i] = null;
                    break;
                }
                this.params[i] = new Long(iVal);
                break;
            }
            case 17: {
                UDRLMInfo.getParamValue(lminfo, i, this.inParamValues[i], null);
                byte[] bSign = new byte[2];
                System.arraycopy(this.inParamValues[i], 0, bSign, 0, 2);
                short sign = IfxToJavaType.IfxToJavaSmallInt((byte[])bSign, (short)0);
                if (sign != 0) {
                    this.params[i] = new Long(IfxToJavaType.IfxToJavaLongInt((byte[])this.inParamValues[i], (short)0));
                    break;
                }
                if (this.javaParamTypes[i] == this.JavaToClass("long")) {
                    throw GenErr.sqle(-9452, "long", dbLocale);
                }
                this.params[i] = null;
                break;
            }
            case 45: {
                int ival = UDRLMInfo.getBooleanInputParamValue(lminfo, i);
                if (ival != -1) {
                    boolean b = ival != 0;
                    this.params[i] = new Boolean(b);
                    break;
                }
                if (this.javaParamTypes[i] == this.booleanClass) {
                    throw GenErr.sqle(-9452, "boolean", dbLocale);
                }
                this.params[i] = null;
                break;
            }
            case 101: 
            case 102: {
                UDRLMInfo.getParamValue(lminfo, i, this.inParamValues[i], null);
                this.processLO(lminfo, i, this.inParamValues[i]);
                break;
            }
            case 40: 
            case 41: {
                long udtPtr = UDRLMInfo.getUDTArgDataHandle(lminfo, i);
                if (udtPtr == 0L) break;
                int length = UDRLMInfo.getUDTLength(lminfo, i);
                SQLData udtObj = null;
                try {
                    udtObj = (SQLData)this.javaParamTypes[i].newInstance();
                }
                catch (InstantiationException ine) {
                    throw GenErr.sqle(-9451, this.javaParamTypes[i].getName() + ":" + ine.toString(), dbLocale);
                }
                catch (IllegalAccessException ile) {
                    throw GenErr.sqle(-9451, this.javaParamTypes[i].getName() + ":" + ile.toString(), dbLocale);
                }
                IfmxSQLInStream sqlIn = new IfmxSQLInStream(this.dbaMonitor, this.udrConn, udtPtr, length);
                if (this.paramTypeNames == null) {
                    this.paramTypeNames = this.getParamTypeNames();
                }
                String sqlName = this.paramTypeNames[i];
                udtObj.readSQL(sqlIn, sqlName);
                this.params[i] = udtObj;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                Connection jdbcConn = null;
                UDREnv env = this.getUDREnv();
                this.paramTypeNames = env.getParamTypeName();
                String sqlName = this.paramTypeNames[i];
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "  >> convertInputParam compt: " + sqlName);
                jdbcConn = ((UDREnvImpl)env).getJdbcConn();
                int length = UDRLMInfo.getUDTLength(lminfo, i);
                IfxResultSetMetaData desc = null;
                SAPIRequestFreeList sapiFreeList = null;
                SAPIRequestImpl req = null;
                long jdr = UDRLMInfo.getJdr(lminfo);
                int jdr_len = UDRLMInfo.getColLen(jdr, i);
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "len " + length + " jdr_len is " + jdr_len);
                IfxDirectProtocol proto = (IfxDirectProtocol)((IfxDirectConnection)((Object)jdbcConn)).getProto();
                desc = (IfxResultSetMetaData)proto.getMetaData();
                if (desc == null) {
                    sapiFreeList = UDRDBAContextImpl.getSapiFreeList();
                    try {
                        req = sapiFreeList.getFromFreeList();
                    }
                    catch (Exception e) {
                        throw (SQLException)e;
                    }
                    int numcols = req.getJdrNumCols(jdr);
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "numcols " + numcols);
                    desc = new IfxResultSetMetaData(numcols, (IfxConnection)jdbcConn);
                    req.initOutputResultSetMetaData((ResultSetMetaData)desc, jdr);
                    ((IfxDirectConnection)((Object)jdbcConn)).setResultSetMetaData(desc);
                }
                byte[] arr = new byte[jdr_len];
                JVP.traceable.tracePrint("JVP", 3, "arr  size is " + arr.length);
                byte[] ba = null;
                ba = UDRLMInfo.fillColArray(jdr, i, arr, jdr_len);
                JVP.traceable.tracePrint("JVP", 3, "ba is" + ba + " size is " + ba.length);
                IfxObject obj = null;
                try {
                    obj = ((IfxDirectConnection)((Object)jdbcConn)).makeInstance(i + 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                if (ba == null) {
                    obj.nullify();
                    break;
                }
                try {
                    obj.fromIfx(ba);
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.toString());
                    sqle.printStackTrace();
                }
                finally {
                    if (req != null) {
                        sapiFreeList.returnToFreeList(req);
                    }
                    req = null;
                }
                if (obj.isNull()) break;
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " got obj " + obj.toString());
                String xtdtypeName = null;
                xtdtypeName = this.sqlParamTypes[i] == 19 ? "set" : (this.sqlParamTypes[i] == 21 ? "list" : (this.sqlParamTypes[i] == 20 ? "multiset" : desc.getExtendedName(i + 1)));
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "  xtdtypename is " + xtdtypeName);
                Map map = null;
                boolean[] toArray = new boolean[2];
                map = this.checkTypeMap(jdbcConn, xtdtypeName, toArray);
                if (map != null) {
                    if (JVP.traceable.traceLevel("JVP") >= 5) {
                        JVP.traceable.tracePrint("JVP.JLM.PARAM", 5, " 0000 PI Setting Map into obj " + obj.toString());
                        this.dumpMap(map);
                    }
                    obj.setTypeMap(map);
                } else {
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 5, " checkTypeMap MAP is NULL");
                }
                Object tmp = toArray[0] ? ((IfxCollection)obj).toArray() : obj.toObject();
                try {
                    this.params[i] = tmp instanceof Struct ? (Struct)tmp : (tmp instanceof java.sql.Array ? (java.sql.Array)tmp : tmp);
                }
                catch (Exception E) {
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "  Failed to cast " + tmp.toString());
                    E.printStackTrace();
                }
                if (this.params[i] != null) {
                    Class<?> cl = this.params[i].getClass();
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "  toObject params[" + i + "] is " + cl.getName());
                    break;
                }
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "  toObject params[" + i + "] is NULL");
                break;
            }
        }
    }

    private Map checkTypeMap(Connection jdbcConn, String xtdtypeName, boolean[] toArray) {
        Map map = null;
        Object udtExtName = null;
        boolean newmap = false;
        Class classFound = null;
        toArray[0] = false;
        JVP.traceable.tracePrint("JVP.JLM.PARAM", 2, " checkTypeMap entered: look for " + xtdtypeName);
        try {
            map = ((IfxDirectConnection)((Object)jdbcConn)).getTypeMap();
        }
        catch (SQLException se) {
            JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " no map in jdbcConn");
        }
        if (map != null && JVP.properties.getEnableTypeCache() && (classFound = (Class)map.get(xtdtypeName)) != null) {
            JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "map already has " + xtdtypeName);
            if (classFound.getName().equals("com.informix.jdbc.IfxArray")) {
                toArray[0] = true;
            }
            return map;
        }
        try {
            map = JVPClassLoader.cacheAllUdtExtNames((IfxDirectConnection)((Object)jdbcConn));
            if (map == null) {
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " checkTypeMap map is null");
                return null;
            }
        }
        catch (Exception e) {
            JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " checkTypeMap exc 1: " + e.getMessage() + " " + e.toString());
            return null;
        }
        classFound = (Class)map.get(xtdtypeName);
        JVP.traceable.tracePrint("JVP.JLM.PARAM", 5, " classFound is " + classFound);
        if (classFound != null) {
            if (classFound.getName().equals("com.informix.jdbc.IfxArray")) {
                toArray[0] = true;
            }
            return map;
        }
        return null;
    }

    private UDREnv getUDREnv() {
        if (Thread.currentThread() instanceof DBAThreadImpl) {
            DBAThreadImpl currTh = (DBAThreadImpl)Thread.currentThread();
            return currTh.getUDREnv();
        }
        System.out.println("ERROR : Must be a DBAThread");
        return null;
    }

    private String[] getParamTypeNames() {
        UDREnv env = this.getUDREnv();
        return env.getParamTypeName();
    }

    String convertStringInputParam(long lminfo, int i) {
        long l;
        int len = -1;
        String s = null;
        IfxToJavaType ifxtojava = new IfxToJavaType();
        if (!gotEnc) {
            this.setEnc();
        }
        if (this.inParamValues[i] != null) {
            len = UDRLMInfo.getStringInputParamValue_fast(lminfo, i, this.inParamValues[i], this.inParamValues[i].length);
        }
        if (len >= 0) {
            JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "convertStringInputParam enc is dbEnc");
            if (dbEncoding == null) {
                s = new String(this.inParamValues[i], 0, len);
            } else {
                try {
                    byte[] str_ba = new byte[len];
                    System.arraycopy(this.inParamValues[i], 0, str_ba, 0, len);
                    if (JVP.traceable.traceLevel("JVP") > 5) {
                        this.printBytes(str_ba, "convertStringInputParam");
                    }
                    s = ifxtojava.IfxToJavaChar(str_ba, (short)0, dbEncoding);
                }
                catch (IOException ioe) {}
            }
        } else if (len == -1 && (l = UDRLMInfo.getStringInputParamValue(lminfo, i, this.strParamLen)) != 0L) {
            len = this.strParamLen[0];
            if (this.inParamValues[i] == null || this.inParamValues[i].length < len) {
                this.inParamValues[i] = new byte[len];
            }
            UDREnvImpl.copyCStringWithLen(l, this.inParamValues[i], len);
            if (dbEncoding == null) {
                s = new String(this.inParamValues[i], 0, len);
            } else {
                try {
                    if (JVP.traceable.traceLevel("JVP") > 5) {
                        this.printBytes(this.inParamValues[i], "convertStringInputParam2");
                    }
                    s = ifxtojava.IfxToJavaChar(this.inParamValues[i], (short)0, dbEncoding);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        return s;
    }

    private void processLO(long lminfo, int i, byte[] ba) throws SQLException {
        JVP.traceable.tracePrint("JVP.JLM.PARAM", 3, "BLOB ARG" + this.javaParamTypes[i].toString());
        if (!gotEnc) {
            this.setEnc();
        }
        try {
            UDREnv env = this.getUDREnv();
            Connection jdbcConn = ((UDREnvImpl)env).getJdbcConn();
            IfxLoc loc = new IfxLoc(ba, jdbcConn);
            if (this.javaParamTypes[i] == Class.forName("java.sql.Blob")) {
                IfxSmBlob smb = new IfxSmBlob((IfxConnection)jdbcConn, (IfxLocator)loc);
                this.params[i] = smb.toBlob();
            } else if (this.javaParamTypes[i] == Class.forName("java.sql.Clob")) {
                IfxSmBlob smb = new IfxSmBlob((IfxConnection)jdbcConn, (IfxLocator)loc);
                this.params[i] = smb.toClob();
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw GenErr.sqle(-9443, this.javaParamTypes[i].getName(), dbLocale);
        }
        catch (SQLException se) {
            System.out.println("SQLException in processLO().");
            se.printStackTrace();
            throw se;
        }
    }

    void convertDistinctOutputWithMap(Object result, long lminfo, int i) throws SQLException {
        int ifxtype = i == -1 ? this.sqlRetType : this.sqlParamTypes[i];
        SQLDistinctOutput sqlOut = new SQLDistinctOutput(this.dbaMonitor, this.udrConn, lminfo, i, ifxtype);
        ((SQLData)result).writeSQL(sqlOut);
        if (ifxtype == 40) {
            int len = sqlOut.length();
            UDRLMInfo.setUDTLength(lminfo, i, len);
        }
    }

    private void setRetAndOutputParams(Object result, int sqlType, long lminfo, int idx) throws SQLException {
        if (!gotEnc) {
            this.setEnc();
        }
        if (UDRLMInfo.nullReturnPtr(lminfo, idx)) {
            return;
        }
        switch (sqlType) {
            case 0: 
            case 13: 
            case 15: 
            case 16: 
            case 43: 
            case 46: {
                if (dbEncoding == null) {
                    UDRLMInfo.putStringOutputParamValue(lminfo, result.toString(), idx);
                    break;
                }
                byte[] ba = null;
                int len = 0;
                byte[] ba_data = null;
                try {
                    int MAXSMINT = UDRLMInfo.getMaxSmallIntValue();
                    String reslt = result.toString();
                    if (reslt.length() > MAXSMINT) {
                        reslt = reslt.substring(0, MAXSMINT);
                    }
                    JavaToIfxType javatoifx = new JavaToIfxType();
                    ba = javatoifx.JavaToIfxChar(reslt, dbEncoding);
                    if (JVP.traceable.traceLevel("JVP") > 5) {
                        this.printBytes(ba, "setRetAndOutputParams");
                    }
                    byte[] ba_len = new byte[2];
                    System.arraycopy(ba, 0, ba_len, 0, 2);
                    len = IfxToJavaType.IfxToJavaSmallInt((byte[])ba_len, (short)0);
                    int datalen = ba.length - 2;
                    ba_data = new byte[datalen];
                    System.arraycopy(ba, 2, ba_data, 0, datalen);
                    ba = null;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                UDRLMInfo.putStringOutputParamValue_enc(lminfo, ba_data, len, idx);
                break;
            }
            case 1: {
                UDRLMInfo.putShortOutputParamValue(lminfo, (Short)result, idx);
                break;
            }
            case 2: {
                int intVal = 0;
                intVal = result instanceof Integer ? ((Integer)result).intValue() : ((Long)result).intValue();
                UDRLMInfo.putIntOutputParamValue(lminfo, intVal, idx);
                break;
            }
            case 4: {
                UDRLMInfo.putFloatOutputParamValue(lminfo, ((Float)result).floatValue(), idx);
                break;
            }
            case 3: {
                UDRLMInfo.putDoubleOutputParamValue(lminfo, (Double)result, idx);
                break;
            }
            case 5: 
            case 8: {
                String str = ((BigDecimal)result).unscaledValue().toString();
                int scale = ((BigDecimal)result).scale();
                UDRLMInfo.putDecString(lminfo, str, idx, scale);
                break;
            }
            case 7: {
                byte[] ba = JavaToIfxType.JavaToIfxDate((Date)((Date)result));
                UDRLMInfo.putParamValue(lminfo, ba, idx);
                break;
            }
            case 10: {
                byte[] ba;
                if (result instanceof Time) {
                    Time t = (Time)result;
                    ba = JavaToIfxType.JavaToIfxDateTime((Time)t);
                } else {
                    Timestamp ts = (Timestamp)result;
                    ba = JavaToIfxType.JavaToIfxDateTime((Timestamp)ts);
                }
                UDRLMInfo.putParamValue(lminfo, ba, idx);
                break;
            }
            case 14: {
                byte[] ba;
                int qual = UDRLMInfo.getIntervalQual(lminfo, idx);
                int start = qual >> 4 & 0xF;
                if (start <= 2) {
                    IntervalYM iym = new IntervalYM((String)result, (short)qual);
                    ba = JavaToIfxType.JavaToIfxInterval((IntervalYM)iym);
                } else {
                    IntervalDF idf = new IntervalDF((String)result, (short)qual);
                    ba = JavaToIfxType.JavaToIfxInterval((IntervalDF)idf);
                }
                UDRLMInfo.putParamValue(lminfo, ba, idx);
                break;
            }
            case 17: {
                byte[] ba = JavaToIfxType.JavaToIfxLongInt((long)((Long)result));
                UDRLMInfo.putParamValue(lminfo, ba, idx);
                break;
            }
            case 52: {
                long bintVal = (Long)result;
                UDRLMInfo.putBigintOutputParamValue(lminfo, bintVal, idx);
                break;
            }
            case 45: {
                UDRLMInfo.putBooleanOutputParamValue(lminfo, (Boolean)result, idx);
                break;
            }
            case 101: 
            case 102: {
                IfxLocator loc = result instanceof IfxBblob ? ((IfxBblob)result).getLocator() : ((IfxCblob)result).getLocator();
                IfxLoc l = new IfxLoc(loc);
                byte[] ba = l.getRawLocator();
                UDRLMInfo.putByteArrayOutputParamValue(lminfo, ba, ba.length, idx);
                break;
            }
            case 44: 
            case 47: {
                IfxDataPointer ret = (IfxDataPointer)result;
                UDRLMInfo.setUDTLength(ret.lminfo, -1, ret.written);
                break;
            }
            case 40: 
            case 41: {
                long udtPtr = idx == -1 ? UDRLMInfo.getUDTRetDataHandle(lminfo) : UDRLMInfo.getUDTArgDataHandle(lminfo, idx);
                IfmxSQLOutStream sqlOut = new IfmxSQLOutStream(this.dbaMonitor, this.udrConn, udtPtr);
                ((SQLData)result).writeSQL(sqlOut);
                int len = sqlOut.length();
                UDRLMInfo.setUDTLength(lminfo, idx, len);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "  >>  setRetAndOutputParams: " + idx + " result is " + result);
                UDREnv env = this.getUDREnv();
                String returnTypeName = null;
                if (idx == -1) {
                    returnTypeName = env.getReturnTypeName();
                }
                if (this.paramTypeNames == null) {
                    this.paramTypeNames = env.getParamTypeName();
                }
                if (idx > 0) {
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " setRetAndOut OUT type " + this.paramTypeNames[idx]);
                } else {
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " setRetAndOut RET type " + returnTypeName);
                }
                Connection jdbcConn = ((UDREnvImpl)env).getJdbcConn();
                IfxDirectConnection idc = (IfxDirectConnection)((Object)jdbcConn);
                if (idx > 0) {
                    Class<?> cl = this.params[idx].getClass();
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "  params[" + idx + "] is " + cl.getName());
                }
                IfxObject obj = null;
                String sqlTypeString = null;
                if (idx > 0) {
                    sqlTypeString = this.paramTypeNames[idx];
                } else if (returnTypeName != null) {
                    sqlTypeString = returnTypeName;
                }
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " +++++ sqlTypeString " + sqlTypeString);
                IfxConnection iconn = (IfxConnection)jdbcConn;
                if (result instanceof java.sql.Array || result instanceof Collection) {
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "Array/Collection param");
                    obj = idc.makeInstanceFromIfxType(jdbcConn, (short)19);
                    IfxCollection coll = (IfxCollection)obj;
                    obj.setTypeMap(idc.getTypeMap());
                    if (sqlTypeString != null) {
                        coll.fromObject(result, sqlTypeString);
                    } else {
                        obj.fromObject(result);
                    }
                } else if (result instanceof IfxObject) {
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " IfxObject param");
                    obj = (IfxObject)result;
                } else {
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " ~~~~~~~~~~~ userType/Struct param");
                    obj = idc.makeInstanceFromIfxType(jdbcConn, (short)22);
                    IfxRow row = (IfxRow)obj;
                    obj.setTypeMap(idc.getTypeMap());
                    if (sqlTypeString != null) {
                        row.fromObject(result, sqlTypeString, iconn);
                    } else {
                        obj.fromObject(result);
                    }
                }
                byte[] ba = null;
                try {
                    ba = obj.toIfx();
                    JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, " ba is " + ba + " ba.len is " + ba.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int putFailed = 0;
                if (ba != null) {
                    putFailed = UDRLMInfo.putByteArrayOutputParamValue(lminfo, ba, ba.length, idx);
                }
                if (ba != null && putFailed == 0) break;
                if (obj == null) {
                    obj = idc.makeInstanceFromIfxType(jdbcConn, (short)19);
                }
                obj.nullify();
                break;
            }
        }
    }

    public String toString() {
        return this.signature;
    }

    public String byteToHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public void printBytes(byte[] array, String name) {
        for (int k = 0; k < array.length; ++k) {
            System.out.println(name + "[" + k + "] = " + "0x" + this.byteToHex(array[k]));
        }
    }

    private void setEnc() {
        if (Thread.currentThread() instanceof DBAThreadImpl) {
            DBAThreadImpl thr = (DBAThreadImpl)Thread.currentThread();
            dbEncoding = thr.getEncoding();
            dbLocale = thr.getLocale();
            gotEnc = true;
        } else {
            System.out.println("ERROR : Must be a DBAThread");
        }
    }

    private void dumpMap(Map map) {
        Collection collobj = map.values();
        if (collobj != null) {
            for (Object obj : collobj) {
                JVP.traceable.tracePrint("JVP.JLM.PARAM", 4, "IfxComplexInput.getTypeClass: obj " + obj.toString());
            }
        }
    }

    static {
        gotEnc = false;
        dbEncoding = null;
        dbLocale = null;
        schipdebug = false;
        JavaToClassTable = new Hashtable(54);
        byte[] temp = new byte[1];
        try {
            JavaToClassTable.put(new String("java.lang.Object"), Class.forName("java.lang.Object"));
            JavaToClassTable.put(new String("char"), Character.TYPE);
            JavaToClassTable.put(new String("java.lang.Character"), Class.forName("java.lang.Character"));
            JavaToClassTable.put(new String("java.lang.String"), Class.forName("java.lang.String"));
            JavaToClassTable.put(new String("java.math.BigDecimal"), Class.forName("java.math.BigDecimal"));
            JavaToClassTable.put(new String("boolean"), Boolean.TYPE);
            JavaToClassTable.put(new String("java.lang.Boolean"), Class.forName("java.lang.Boolean"));
            JavaToClassTable.put(new String("byte"), Byte.TYPE);
            JavaToClassTable.put(new String("short"), Short.TYPE);
            JavaToClassTable.put(new String("java.lang.Short"), Class.forName("java.lang.Short"));
            JavaToClassTable.put(new String("int"), Integer.TYPE);
            JavaToClassTable.put(new String("java.lang.Integer"), Class.forName("java.lang.Integer"));
            JavaToClassTable.put(new String("long"), Long.TYPE);
            JavaToClassTable.put(new String("java.lang.Long"), Class.forName("java.lang.Long"));
            JavaToClassTable.put(new String("float"), Float.TYPE);
            JavaToClassTable.put(new String("java.lang.Float"), Class.forName("java.lang.Float"));
            JavaToClassTable.put(new String("double"), Double.TYPE);
            JavaToClassTable.put(new String("java.lang.Double"), Class.forName("java.lang.Double"));
            JavaToClassTable.put(new String("byte[]"), temp.getClass());
            JavaToClassTable.put(new String("java.sql.Date"), Class.forName("java.sql.Date"));
            JavaToClassTable.put(new String("java.sql.Time"), Class.forName("java.sql.Time"));
            JavaToClassTable.put(new String("java.sql.Timestamp"), Class.forName("java.sql.Timestamp"));
            JavaToClassTable.put(new String("java.sql.Blob"), Class.forName("java.sql.Blob"));
            JavaToClassTable.put(new String("java.sql.Clob"), Class.forName("java.sql.Clob"));
            JavaToClassTable.put(new String("java.sql.SQLData"), Class.forName("java.sql.SQLData"));
            JavaToClassTable.put(new String("java.sql.Struct"), Class.forName("java.sql.Struct"));
            JavaToClassTable.put(new String("java.sql.Array"), Class.forName("java.sql.Array"));
            JVP.traceable.tracePrint("JVP.JLM.JavaToClass", 4, "map is set up");
        }
        catch (Exception e) {
            System.out.println("cannot set up JavaToClass table " + e.toString());
        }
        IfxToJavaTable = new Hashtable(54);
        try {
            IfxToJavaTable.put(new Integer(0), new String("java.lang.String"));
            IfxToJavaTable.put(new Integer(13), new String("java.lang.String"));
            IfxToJavaTable.put(new Integer(15), new String("java.lang.String"));
            IfxToJavaTable.put(new Integer(16), new String("java.lang.String"));
            IfxToJavaTable.put(new Integer(43), new String("java.lang.String"));
            IfxToJavaTable.put(new Integer(5), new String("java.math.BigDecimal"));
            IfxToJavaTable.put(new Integer(8), new String("java.math.BigDecimal"));
            IfxToJavaTable.put(new Integer(45), new String("java.lang.Boolean"));
            IfxToJavaTable.put(new Integer(45), new String("boolean"));
            IfxToJavaTable.put(new Integer(11), new String("byte[]"));
            IfxToJavaTable.put(new Integer(11), new String("byte"));
            IfxToJavaTable.put(new Integer(1), new String("java.lang.Short"));
            IfxToJavaTable.put(new Integer(1), new String("short"));
            IfxToJavaTable.put(new Integer(2), new String("java.lang.Integer"));
            IfxToJavaTable.put(new Integer(2), new String("int"));
            IfxToJavaTable.put(new Integer(52), new String("java.lang.Long"));
            IfxToJavaTable.put(new Integer(52), new String("long"));
            IfxToJavaTable.put(new Integer(17), new String("java.lang.Long"));
            IfxToJavaTable.put(new Integer(17), new String("long"));
            IfxToJavaTable.put(new Integer(4), new String("java.lang.Float"));
            IfxToJavaTable.put(new Integer(4), new String("float"));
            IfxToJavaTable.put(new Integer(3), new String("java.lang.Double"));
            IfxToJavaTable.put(new Integer(3), new String("double"));
            IfxToJavaTable.put(new Integer(7), new String("java.sql.Date"));
            IfxToJavaTable.put(new Integer(10), new String("java.sql.Time"));
            IfxToJavaTable.put(new Integer(10), new String("java.sql.Timestamp"));
            IfxToJavaTable.put(new Integer(14), new String("java.lang.String"));
            IfxToJavaTable.put(new Integer(102), new String("java.sql.Blob"));
            IfxToJavaTable.put(new Integer(101), new String("java.sql.Clob"));
            IfxToJavaTable.put(new Integer(44), new String("com.informix.jdbc.IfxDataPointer"));
            IfxToJavaTable.put(new Integer(46), new String("com.informix.jdbc.IfxDataPointer"));
            IfxToJavaTable.put(new Integer(47), new String("com.informix.jdbc.IfxDataPointer"));
            JVP.traceable.tracePrint("JVP.JLM.JavaToClass", 4, "map is set up");
        }
        catch (Exception e) {
            System.out.println("cannot set up JavaToClass table " + e.toString());
        }
    }
}

