/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import informix.jvp.DBA;
import informix.jvp.Debug;
import informix.jvp.JVP;
import informix.jvp.JVPError;
import informix.jvp.dbapplet.DBAManager;
import informix.jvp.dbapplet.DBAMonitor;
import informix.jvp.dbapplet.DBAThreadPool;
import informix.jvp.dbapplet.impl.DBALogImpl;
import informix.jvp.dbapplet.impl.DBAMonitorImpl;
import informix.jvp.dbapplet.impl.DBAThreadImpl;
import informix.jvp.dbapplet.impl.DBAThreadPoolImpl;
import informix.jvp.dbapplet.impl.DBAThreadSupport;
import informix.jvp.dbapplet.impl.IdleThreadImpl;
import informix.jvp.dbapplet.impl.JVPControl;
import informix.jvp.dbapplet.impl.JVPSecurityManagerImpl;
import informix.jvp.dbapplet.impl.JarHandler;
import informix.jvp.dbapplet.impl.PerJavaUDRContext;
import informix.jvp.dbapplet.impl.SAPIRequestFreeList;
import informix.jvp.dbapplet.impl.SolanoConnKiller;
import informix.jvp.dbapplet.impl.TimeEventTrace;
import informix.jvp.dbapplet.impl.UDRDBAManagerImpl;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import informix.jvp.dbapplet.impl.YieldThreadImpl;
import informix.jvp.impl.JVPPropertiesImpl;
import informix.jvp.impl.LoggerImpl;
import informix.jvp.impl.MTAlarmThreadImpl;
import informix.jvp.impl.TraceStreamImpl;
import informix.jvp.impl.TraceableImpl;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;

public class UDRDBAContextImpl {
    public static int vpid;
    public static DBAManager udrDBAManager;
    public static DBAThreadPool dbaThreadPool;
    public static long javaLangHandle;
    public static SAPIRequestFreeList sapiFreeList;
    public static String DEFAULT_LOG_FILE_NAME;
    public static final String DBA_THREAD_GROUP_NAME = "DBAPPLET";
    public static ThreadGroup dbaThreadGroup;
    public static IdleThreadImpl idleThread;
    public static YieldThreadImpl yieldThread;
    public static MTAlarmThreadImpl mtAlarmThread;
    public static JVPControl jvpControlThread;
    public static DBAMonitor javaListenerMonitor;
    private static SolanoConnKiller connKiller;

    public static int init(String jvpDir, String nativeObject, String logFileName, String propsFileName, int useNativeThread, int vp, int startAlarmThread, long langHandle) {
        String property;
        try {
            int snum;
            vpid = vp;
            javaLangHandle = langHandle;
            JVP.properties = new JVPPropertiesImpl();
            if (Debug.HAND_OFF) {
                Thread.currentThread().setPriority(2);
            } else {
                Thread.currentThread().setPriority(10);
            }
            if (logFileName == null) {
                logFileName = DEFAULT_LOG_FILE_NAME;
            }
            try {
                System.setErr(new PrintStream(new FileOutputStream(logFileName, true), true));
            }
            catch (Exception ex) {
                System.out.println("Cannot open JVP log file");
            }
            LoggerImpl logImpl = new LoggerImpl(System.err);
            JVP.log = logImpl;
            System.setOut(System.err);
            JVP.properties.setProperty("JVP.home.dir", jvpDir);
            JVP.properties.setProperty("JVP.libs.native", nativeObject);
            JVP.udrProperties = (Properties)((Object)JVP.properties);
            System.out.println("loading native library " + jvpDir + nativeObject);
            System.load(jvpDir + nativeObject);
            if (propsFileName != null) {
                propsFileName = JVP.properties.getAbsolutePath(propsFileName);
                System.out.println("Read JVP property file" + propsFileName);
                try {
                    JVP.properties.loadFromFile(propsFileName);
                }
                catch (Exception ex) {
                    System.out.println("Error: cannot read JVP property file");
                }
            }
            if ((snum = JVP.properties.getSplitLog()) > 0) {
                logFileName = logFileName + vpid;
            }
            JVP.dbaLog = new DBALogImpl(logFileName, snum);
            TraceStreamImpl tstream = new TraceStreamImpl();
            JVP.traceable = new TraceableImpl(new TraceStreamImpl());
            property = JVP.properties.getProperty("JVP.trace.verbose");
            if (property != null) {
                JVP.traceable.setVerbose(property);
            }
            if ((property = JVP.properties.getProperty("JVP.trace.timestampformat")) != null) {
                JVP.traceable.setTimeStampFormat(property);
            }
            TraceableImpl.zoneTabInit(JVP.properties.getProperty("JVP.trace.settings"));
            int pnum = JVP.properties.getJVPControlPort();
            if (pnum > 0) {
                jvpControlThread = new JVPControl(pnum);
                jvpControlThread.setName("JVP control monitor thread");
                jvpControlThread.setDaemon(true);
                jvpControlThread.start();
            }
            int intervalVal = 5;
            property = JVP.properties.getProperty("JVP.dbathreadpool.poolsize");
            int threadPoolSize = property == null ? 20 : new Integer(property);
            if (threadPoolSize > 0) {
                property = JVP.properties.getProperty("JVP.dbathreadpool.patrolinterval");
                intervalVal = property == null ? 5 : new Integer(property);
                dbaThreadPool = new DBAThreadPoolImpl(threadPoolSize, intervalVal > 0 ? intervalVal : 0);
                System.out.println("DBAThread Pool is enabled with size = " + threadPoolSize + " with patrol interval = " + intervalVal);
            } else {
                System.out.println("DBAThread Pool is disabled");
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            JVPError.unexpectedException(true, thr);
            return -199;
        }
        try {
            udrDBAManager = new UDRDBAManagerImpl();
            JarHandler.mgr = (UDRDBAManagerImpl)udrDBAManager;
            JarHandler.thisOS = System.getProperty("os.name");
            dbaThreadGroup = new ThreadGroup(DBA_THREAD_GROUP_NAME);
            if (useNativeThread == 0) {
                IdleThreadImpl.init();
                idleThread = new IdleThreadImpl();
                idleThread.setName("JVP Idle Thread");
                idleThread.start();
                yieldThread = new YieldThreadImpl();
                yieldThread.setName("JVP Yield Thread");
                yieldThread.start();
            }
            if (startAlarmThread == 1) {
                mtAlarmThread = new MTAlarmThreadImpl();
                mtAlarmThread.setName("MT Alarm Thread");
                mtAlarmThread.start();
            }
            try {
                JVPSecurityManagerImpl sm = new JVPSecurityManagerImpl();
                System.setSecurityManager(sm);
            }
            catch (Error e) {
                System.err.println("Exception while starting security manager: " + e.getMessage());
                e.printStackTrace();
            }
            property = JVP.properties.getProperty("JVP.reqFreeList.size");
            int freelistSize = property == null ? 20 : new Integer(property);
            sapiFreeList = new SAPIRequestFreeList(freelistSize > 0 ? freelistSize : 20);
            Class.forName("com.informix.jdbc.IfxDriver");
            try {
                boolean res = DBA.startServiceDirectory(vpid);
                if (res) {
                    JVP.traceable.tracePrint("JVP.DBA.Context", 4, "STARTED DBA serviceDir");
                } else {
                    JVP.traceable.tracePrint("JVP.DBA.Context", 4, "Failed to start DBA serviceDir");
                }
            }
            catch (Error e) {
                System.err.println("Exception while connecting to RMI: " + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                connKiller = new SolanoConnKiller(-1);
                connKiller.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                JVPError.unexpectedException(true, e);
            }
            return 199;
        }
        catch (Exception exce) {
            JVPError.unexpectedException(false, exce);
            return -199;
        }
    }

    public static void terminate() {
        IdleThreadImpl.terminate();
        YieldThreadImpl.terminate();
        MTAlarmThreadImpl.terminate();
    }

    public static int openContext(long lminfo, DBAThreadImpl udrDbaThread) {
        DBAThreadImpl dbaThread = null;
        DBAMonitorImpl dbaMonitor = null;
        String modName = null;
        String dbaName = null;
        try {
            JVP.traceable.tracePrint("JVP.DBA.Context", 4, "processing open context request");
            modName = UDRLMInfo.getModuleName(lminfo);
            if (modName == null) {
                new JVPError(14, 1, "open context: null module name").log(true);
                return -199;
            }
            JVP.traceable.tracePrint("JVP.DBA.Context", 5, "module name: " + modName);
            JVP.traceable.tracePrint("JVP.JLM", 1, "load module " + modName);
            dbaName = DBAThreadSupport.getUniqueThreadName(modName);
            if (udrDbaThread == null) {
                if (TimeEventTrace.tracing) {
                    TimeEventTrace.StartEvent(24, 1);
                }
                JVP.traceable.tracePrint("JVP.JLM", 4, "Starting a new JAVA UDR thread: open context for " + dbaName + " of thread group " + dbaThreadGroup.toString());
                dbaMonitor = new DBAMonitorImpl(dbaName, UDRLMInfo.getTCB(lminfo));
                dbaThread = dbaThreadPool == null ? new DBAThreadImpl(dbaThreadGroup, dbaName, dbaMonitor, null) : (DBAThreadImpl)dbaThreadPool.getDBAThreadFromPool(dbaThreadGroup, dbaName, dbaMonitor);
                JVP.traceable.tracePrint("JVP.DBA.Context", 5, "tcb: " + UDRLMInfo.getTCB(lminfo));
                Object res = UDRLMInfo.udrContextOpenSetLMINfo(lminfo, dbaThread, dbaMonitor, dbaThread.getThreadUID());
                if (res == null) {
                    return -199;
                }
                JVP.traceable.tracePrint("JVP.DBA.Thread", 2, "starting dbaThread");
                if (dbaThreadPool == null) {
                    dbaThread.start();
                } else {
                    dbaThread.signalDBMSWork();
                }
                if (TimeEventTrace.tracing) {
                    TimeEventTrace.StopEvent(24, 1);
                }
            } else {
                dbaThread = udrDbaThread;
                dbaMonitor = (DBAMonitorImpl)udrDbaThread.dbaMonitor;
            }
            dbaThread.setLminfo(lminfo);
            PerJavaUDRContext p = new PerJavaUDRContext(dbaName, modName, dbaMonitor, lminfo);
            dbaThread.setCurrentUDRContext(p);
            Object res = UDRLMInfo.setUDRContext(lminfo, p);
            if (res == null) {
                JVP.traceable.tracePrint("JVP.DBA.Thread", 2, "setUDRContext returns : res == null");
                return -199;
            }
            dbaMonitor.notifyDBATask(1);
            JVP.traceable.tracePrint("JVP.DBA.Context", 5, "done monitor: " + dbaMonitor.toString() + " " + dbaMonitor.getName());
            return 199;
        }
        catch (Exception exce) {
            JVPError.unexpectedException(false, exce);
            return -199;
        }
    }

    public static int execute(long lminfo) {
        try {
            JVP.traceable.tracePrint("JVP.DBA.Context", 4, "activate JAVA UDR");
            DBAThreadImpl dbaThread = UDRLMInfo.getDBAThread(lminfo);
            JVP.traceable.tracePrint("JVP.JLM", 3, "activate JAVA UDR: " + dbaThread.toString() + " LMINFO " + new Long(lminfo).toString() + " T#" + dbaThread.getThreadUID());
            DBAMonitor dbaMonitor = dbaThread.dbaMonitor;
            dbaThread.setCurrentUDRContext(UDRLMInfo.getUDRContext(lminfo));
            dbaMonitor.notifyDBATask(2);
            return 199;
        }
        catch (Exception exce) {
            JVPError.unexpectedException(false, exce);
            return -199;
        }
    }

    public static int closeContext_phase1(long lminfo) {
        try {
            JVP.traceable.tracePrint("JVP.DBA.Context", 4, "Calling close context()");
            DBAThreadImpl dbaThread = UDRLMInfo.getDBAThread(lminfo);
            DBAMonitor dbaMonitor = dbaThread.dbaMonitor;
            dbaThread.setCurrentUDRContext(UDRLMInfo.getUDRContext(lminfo));
            if (UDRLMInfo.noShareJThread(lminfo)) {
                dbaMonitor.notifyDBATask(3);
            } else {
                dbaMonitor.notifyDBATask(4);
            }
            JVP.traceable.tracePrint("JVP.DBA.Context", 4, "Wait for destruction of " + dbaThread.getThreadUID());
        }
        catch (Exception exce) {
            JVPError.unexpectedException(false, exce);
            return -199;
        }
        return 199;
    }

    public static int closeContext_phase2(long lminfo) {
        try {
            JVP.traceable.tracePrint("JVP.DBA.Context", 4, "processing close context request");
            UDRLMInfo.close(lminfo);
        }
        catch (Exception exce) {
            JVPError.unexpectedException(false, exce);
            return -199;
        }
        return 199;
    }

    public static int stmtClose(DBAThreadImpl ToBeKilledJavaUDRThread) {
        JVP.traceable.tracePrint("JVP.DBA.Context", 2, "start statementClose");
        if (TimeEventTrace.tracing) {
            TimeEventTrace.StartEvent(24, 1);
        }
        ToBeKilledJavaUDRThread.dbaMonitor.notifyDBATask(3);
        if (TimeEventTrace.tracing) {
            TimeEventTrace.StopEvent(24, 1);
        }
        JVP.traceable.tracePrint("JVP.DBA.Context", 2, "end statementClose");
        return 199;
    }

    public static DBAMonitor getJavaListenerMonitor() {
        return javaListenerMonitor;
    }

    public static void setJavaListenerMonitor(DBAMonitor jListenMon) {
        javaListenerMonitor = jListenMon;
    }

    public static SAPIRequestFreeList getSapiFreeList() {
        return sapiFreeList;
    }

    static {
        dbaThreadPool = null;
        javaLangHandle = 0L;
        DEFAULT_LOG_FILE_NAME = "jvp.log";
        javaListenerMonitor = null;
        connKiller = null;
    }
}

