/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import informix.jvp.dbapplet.DBAManager;
import informix.jvp.dbapplet.impl.JVPClassLoader;
import informix.jvp.dbapplet.impl.JarHandler;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.util.Hashtable;

public class UDRDBAManagerImpl
implements DBAManager {
    Hashtable jarMap = new Hashtable();
    JVPClassLoader solanoLoader = new JVPClassLoader(true);
    public boolean passwordCheck = true;

    @Override
    public synchronized void loadUDRClass(String moduleName) throws ClassNotFoundException {
        this.loadClassWorkhorse(moduleName);
    }

    void loadClassWorkhorse(String moduleName) throws ClassNotFoundException {
        JVPClassLoader loader = null;
        boolean needEntry = false;
        boolean addRef = false;
        String jarName = null;
        int pos = moduleName.indexOf(":");
        jarName = moduleName.substring(0, pos);
        loader = (JVPClassLoader)this.jarMap.get(jarName);
        if (loader == null) {
            addRef = true;
        }
        if (loader == null || this.unloadUDRClasses(jarName)) {
            loader = new JVPClassLoader(jarName);
            needEntry = true;
        }
        loader.loadClass(moduleName, true);
        if (needEntry) {
            System.out.println("ADDING TO JARMAP: " + jarName + " + " + loader);
            this.jarMap.put(jarName, loader);
        }
        if (!JarHandler.thisOS.startsWith(JarHandler.WINOS) && addRef && UDRLMInfo.addJarReferenceToList(jarName, UDRDBAContextImpl.javaLangHandle, UDRDBAContextImpl.vpid) == -1) {
            throw new ClassNotFoundException("Error adding jar " + jarName + " reference to global JVP list");
        }
    }

    @Override
    public synchronized boolean unloadUDRClasses(String jarName) {
        if (JarHandler.thisOS.startsWith(JarHandler.WINOS)) {
            return false;
        }
        if (jarName != null && UDRLMInfo.getJarRemoveFlag(UDRDBAContextImpl.javaLangHandle, UDRDBAContextImpl.vpid, jarName)) {
            this.jarMap.remove(jarName);
            return true;
        }
        return false;
    }

    @Override
    public Class getLoadedClass(String name) throws ClassNotFoundException {
        int pos = name.indexOf(":");
        String clsName = name.substring(pos + 1);
        if (pos != -1) {
            String jarName = name.substring(0, pos);
            JVPClassLoader loader = (JVPClassLoader)this.jarMap.get(jarName);
            return loader.getClass(clsName);
        }
        Class<?> ClassObj = Class.forName(clsName);
        return ClassObj;
    }

    public JVPClassLoader getsolanoLoader() {
        return this.solanoLoader;
    }

    private native void addJarToList(String var1);
}

