/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.dbapplet.impl;

import com.informix.udr.UDREnv;
import com.informix.udr.UDRLog;
import com.informix.udr.UDRTraceable;
import informix.jvp.JVP;
import informix.jvp.JVPProperties;
import informix.jvp.dbapplet.impl.UDRLMInfo;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class UDREnvImpl
implements UDREnv {
    public static int IDENTSIZE = 255;
    private Object udrState;
    public long lminfo;
    private String name;
    private String[] paramTypeName;
    private String returnTypeName;
    private Connection jdbcConn = null;
    private String client_locale = null;
    private String db_locale = null;

    public UDREnvImpl(long lm) {
        this.lminfo = lm;
    }

    public static native int copyCString(long var0, byte[] var2);

    public static native void copyCStringWithLen(long var0, byte[] var2, int var3);

    @Override
    public synchronized String getName() {
        if (this.name == null) {
            byte[] buf = new byte[IDENTSIZE + 1];
            int len = UDREnvImpl.copyCString(UDRLMInfo.getSQLName(this.lminfo), buf);
            this.name = new String(buf, 0, len);
        }
        return this.name;
    }

    @Override
    public String getClientLocale() {
        if (this.client_locale == null) {
            byte[] buf = new byte[IDENTSIZE + 1];
            int len = UDREnvImpl.copyCString(UDRLMInfo.getClientLocale(this.lminfo), buf);
            this.client_locale = new String(buf, 0, len);
        }
        return this.client_locale;
    }

    @Override
    public String getDBLocale() {
        if (this.db_locale == null) {
            byte[] buf = new byte[IDENTSIZE + 1];
            int len = UDREnvImpl.copyCString(UDRLMInfo.getDBLocale(this.lminfo), buf);
            this.db_locale = new String(buf, 0, len);
        }
        return this.db_locale;
    }

    @Override
    public synchronized String[] getParamTypeName() {
        if (this.paramTypeName == null) {
            int num = UDRLMInfo.getTotalParams(this.lminfo);
            byte[] buf = new byte[IDENTSIZE + 1];
            this.paramTypeName = new String[num];
            for (int i = 0; i < num; ++i) {
                int len = UDREnvImpl.copyCString(UDRLMInfo.getParamTypeName(this.lminfo, i), buf);
                this.paramTypeName[i] = new String(buf, 0, len);
            }
        }
        return this.paramTypeName;
    }

    @Override
    public synchronized String getReturnTypeName() {
        if (this.returnTypeName == null) {
            byte[] buf = new byte[IDENTSIZE + 1];
            int len = UDREnvImpl.copyCString(UDRLMInfo.getReturnTypeName(this.lminfo), buf);
            this.returnTypeName = new String(buf, 0, len);
        }
        return this.returnTypeName;
    }

    @Override
    public synchronized void setUDRState(Object state) {
        this.udrState = state;
    }

    @Override
    public synchronized Object getUDRState() {
        return this.udrState;
    }

    @Override
    public synchronized int getSetIterationState() {
        return UDRLMInfo.getSetIterationState(this.lminfo);
    }

    @Override
    public synchronized void setSetIterationIsDone(boolean done) {
        if (done) {
            UDRLMInfo.setSetIterationIsDone(this.lminfo, 1);
        } else {
            UDRLMInfo.setSetIterationIsDone(this.lminfo, 0);
        }
    }

    @Override
    public UDRTraceable getTraceable() {
        return JVP.traceable;
    }

    @Override
    public UDRLog getLog() {
        return JVP.log;
    }

    @Override
    public JVPProperties getProperties() {
        return JVP.properties;
    }

    public Connection getJdbcConn() throws SQLException {
        if (this.jdbcConn == null) {
            String url = "jdbc:informix-direct::";
            if (JVP.traceable.traceLevel("JVP") > 0) {
                url = url + "tracefile=/tmp/jdbc.out;trace=200;";
            }
            if (JVP.properties.getEnableTypeCache()) {
                url = url + "enable_type_cache=true";
            }
            this.jdbcConn = DriverManager.getConnection(url);
        }
        return this.jdbcConn;
    }
}

