/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.impl;

import informix.jvp.JVP;
import informix.jvp.JVPError;
import informix.jvp.JVPProperties;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Properties;

public class JVPPropertiesImpl
extends Properties
implements JVPProperties {
    private String propertyFile;
    private boolean enable_type_cache = true;
    private boolean got_enable_type_cache = false;

    public JVPPropertiesImpl() {
        this.loadDefaults("JVP.properties.sourcefile:.jvpprops\nJVP.name:anonymous\nJVP.libs.native:lib/jvpnatives.so\nJVP.setuid.id:root\nJVP.RemoteAccess:false\nJVP.RemotePortNo:3333\nJVP.remote.logging.on:false\nJVP.dbapplet.interface.class:informix.dbapplet.DBApplet\nJVP.version.build:BETA version / development 0.2\nJVP.date.build:1998/1/21\n");
    }

    private void loadDefaults(String defaultVals) {
        try {
            byte[] defaults = defaultVals.getBytes();
            this.load(new ByteArrayInputStream(defaults));
        }
        catch (Throwable thr) {
            JVPError.panic(thr);
        }
    }

    @Override
    public void loadFromFile(String fileName) throws SQLException {
        try {
            this.load(new FileInputStream(fileName));
        }
        catch (IOException ioexc) {
            this.propertyFile = null;
            return;
        }
        this.propertyFile = fileName;
    }

    @Override
    public String getProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            try {
                if (this.propertyFile != null) {
                    this.load(new FileInputStream(this.propertyFile));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            value = super.getProperty(key);
        }
        return value;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value == null) {
            try {
                if (this.propertyFile != null) {
                    this.load(new FileInputStream(this.propertyFile));
                }
            }
            catch (IOException ioexc) {
                // empty catch block
            }
            value = super.getProperty(key, defaultValue);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public int getInteger(String key, int defaultVal) {
        if (key == null) {
            JVP.traceable.tracePrint("JVP.Properties", 4, "Null key value");
            return defaultVal;
        }
        String value = this.getProperty(key);
        if (value != null) {
            try {
                if (value.startsWith("0x") || value.startsWith("0X")) {
                    return Integer.parseInt(value.substring(2), 16);
                }
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfexc) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public boolean getSwitch(String key) {
        String value = this.getProperty(key);
        return value != null && (value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true"));
    }

    @Override
    public Object setProperty(String key, String value) {
        this.remove(key);
        return (String)this.put(key, value);
    }

    @Override
    public String getAbsolutePath(String name) {
        String path = null;
        path = name.charAt(0) == '/' || name.charAt(1) == ':' ? name : ((path = this.getProperty("JVP.home.dir")) != null ? path + name : "/vobs/tristarm/jvp/" + name);
        return path;
    }

    @Override
    public void list(PrintWriter out) {
        System.getProperties().list(out);
        super.list(out);
    }

    @Override
    public int getJVPControlPort() {
        try {
            String pnum = this.getProperty("JVP.monitor.port");
            if (pnum == null) {
                return 0;
            }
            int res = new Integer(pnum);
            return res + UDRDBAContextImpl.vpid;
        }
        catch (Throwable tb) {
            return 0;
        }
    }

    @Override
    public int getSplitLog() {
        try {
            String num = this.getProperty("JVP.splitLog");
            if (num == null) {
                return 0;
            }
            int res = new Integer(num);
            return res;
        }
        catch (Throwable tb) {
            System.out.println("Cannot obtain splitLog size");
            tb.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean getEnableTypeCache() {
        if (!this.got_enable_type_cache) {
            String enableString = this.getProperty("JVP.enable_type_cache");
            this.got_enable_type_cache = true;
            this.enable_type_cache = enableString == null ? true : enableString.equalsIgnoreCase("on") || enableString.equalsIgnoreCase("true");
        }
        return this.enable_type_cache;
    }
}

