/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.impl;

import informix.jvp.JVP;
import informix.jvp.JVPService;
import informix.jvp.JVPServiceQueue;
import informix.jvp.impl.StringQueue;
import java.util.Vector;

public class JVPServiceImpl
extends Thread
implements JVPService {
    private String serviceName = null;
    private Object service = null;
    private StringQueue strqueue = null;
    private Vector clients = null;
    private String zone = "JVP.DBA.JVPService";

    public JVPServiceImpl(Object service, String name) {
        this.setDaemon(true);
        this.service = service;
        this.serviceName = name;
        this.strqueue = JVPServiceImpl.newQueue();
        this.clients = new Vector(3, 3);
    }

    static StringQueue newQueue() {
        StringQueue queue;
        try {
            queue = new StringQueue();
        }
        catch (Exception e) {
            JVP.log.log("JVPServiceImpl constructor: remote exception: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        return queue;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public synchronized void addToQueue(String message) {
        try {
            this.strqueue.addToQueue(message);
        }
        catch (Exception e) {
            JVP.log.log("JVPService.addToQueue remote exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        JVP.traceable.tracePrint(this.zone, 5, "JVPServiceImpl run " + this.getServiceName() + " JVPService");
        while (true) {
            String message;
            if ((message = (String)this.strqueue.getNext()) == null) {
                continue;
            }
            this.addToClientQueues(message);
        }
    }

    @Override
    public JVPServiceQueue getQueue() {
        return this.strqueue;
    }

    @Override
    public JVPServiceQueue register() {
        StringQueue queue = JVPServiceImpl.newQueue();
        this.clients.addElement(queue);
        return queue;
    }

    @Override
    public void unregister(JVPServiceQueue queue) {
        if (!this.clients.contains(queue)) {
            return;
        }
        int index = this.clients.indexOf(queue);
        if (index < 0) {
            return;
        }
        this.clients.removeElementAt(index);
    }

    private void addToClientQueues(String message) {
        int index = 0;
        StringQueue queue = null;
        if (this.clients.size() <= 0) {
            return;
        }
        index = 0;
        while (index < this.clients.size()) {
            queue = (StringQueue)this.clients.elementAt(index++);
            try {
                queue.addToQueue(message);
            }
            catch (Exception e) {
                JVP.log.log("addToClientQueues : remote exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

