/*
 * Decompiled with CFR 0.152.
 */
package informix.jvp.impl;

import informix.jvp.JVP;
import informix.jvp.JVPError;
import informix.jvp.JVPService;
import informix.jvp.Logger;
import informix.jvp.dbapplet.DBAThread;
import informix.jvp.dbapplet.impl.DBALogImpl;
import informix.jvp.dbapplet.impl.UDRDBAContextImpl;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoggerImpl
implements Logger {
    private static PrintWriter logStream = null;
    private static JVPService logService = null;
    private static boolean verbose = true;
    private static SimpleDateFormat formatter = null;
    private static final String DEFAULT_FMT = "yyyy/MM/dd HH:mm:ss.SSS";
    private String ts_format;

    public LoggerImpl(PrintStream logStream) {
        if (logStream == null) {
            JVP.exit(2);
        }
        LoggerImpl.logStream = new PrintWriter(logStream);
        formatter = new SimpleDateFormat(DEFAULT_FMT);
    }

    @Override
    public void setVerbose(boolean verby) {
        verbose = verby;
    }

    @Override
    public void setTimeStampFormat(String format) {
        this.ts_format = format;
        if (format == null || format.length() == 0) {
            formatter = null;
            return;
        }
        try {
            formatter = new SimpleDateFormat(format);
        }
        catch (Exception e) {
            logStream.println("Bad timestamp format " + format);
            this.ts_format = DEFAULT_FMT;
            formatter = new SimpleDateFormat(DEFAULT_FMT);
        }
    }

    @Override
    public synchronized void log(String mess) {
        Thread tthread;
        String message = null;
        String tid = "";
        if (verbose && (tthread = Thread.currentThread()) instanceof DBAThread) {
            tid = "T#" + ((DBAThread)((Object)tthread)).getThreadUID() + " ";
        }
        Date currentTime = new Date();
        String dateStr = null;
        try {
            if (formatter != null) {
                dateStr = formatter.format(currentTime);
            }
        }
        catch (Exception e) {
            logStream.println("Bad timestamp format " + this.ts_format);
            this.setTimeStampFormat(DEFAULT_FMT);
            dateStr = formatter.format(currentTime);
        }
        message = dateStr != null ? tid + dateStr + " JVP#" + UDRDBAContextImpl.vpid + ": " + mess : tid + "JVP#" + UDRDBAContextImpl.vpid + ": " + mess;
        logStream.println(message);
        if (logStream.checkError()) {
            JVPError.errorExit(6, "I/O Error on log file");
        }
        if (JVP.dbaLog != null) {
            ((DBALogImpl)JVP.dbaLog).checkLog();
        }
        if (logService == null) {
            return;
        }
        logService.addToQueue(message);
    }

    @Override
    public void setService(JVPService logS) {
        logService = logS;
    }

    @Override
    public void log(Throwable thr) {
        thr.printStackTrace(logStream);
    }

    @Override
    public synchronized void logStatus(String mess) {
        this.log("Status: " + mess);
    }

    public synchronized void logTrace(String mess) {
        this.log("Trace: " + mess);
    }

    @Override
    public PrintWriter outStream() {
        return logStream;
    }
}

